# Makefile include to build cint[7]/inc/configcint.h (aka $@)

# Set these variables now for the current value of $(G__CFG_CONF).
# They might be changed (by cint/Module.mk or cint7/Module.mk) later
$(G__CFG_CONF): G__CFG_CXXFLAGS := $(CINTCXXFLAGS)
$(G__CFG_CONF): G__CFG_CFLAGS   := $(CINTCFLAGS)
$(G__CFG_CONF): G__CFG_DIR      := $(CINTDIR)
$(G__CFG_CONF): G__CFG_CONF     := $(CINTCONF)
$(G__CFG_CONF): G__CFG_CONFMK   := $(CINTCONFMK)

$(G__CFG_CONF): config/Makefile.$(ARCH) config/Makefile.comp $(G__CFG_CONFMK)
	@-rm -f $@__
	@echo '/* Generated by cint/Module.mk */' > $@__
	@( case $(ARCH) in \
	  win32) \
	    if [ $(VC_MAJOR) -ge 14 ]; then \
	       echo '#define G__CFG_ARCH "msvc8"' >> $@__; \
	    else \
	       echo '#define G__CFG_ARCH "msvc7"' >> $@__; \
	    fi && \
	    echo '#define G__CFG_LDOUT "-out:"' >> $@__ && \
	    echo '#define G__CFG_LIBL "lib@imp@"' >> $@__ && \
	    echo '#define G__CFG_LIBEXT ".lib"' >> $@__ && \
	    echo '#define G__CFG_IMPLIBEXT ".lib"' >> $@__ && \
	    echo '#define G__CFG_MANGLEPATHS "cygpath -m "' >> $@__ && \
	    echo '#define G__CFG_PLATFORMO "v6_winnt"' >> $@__ && \
	    echo '#define G__CFG_AR "lib /OUT:"' >> $@__ ;;\
	  *) case $(ARCH) in \
	     macosx*) \
	       echo '#define G__CFG_ARCH "$(ARCH)"' >> $@__ && \
	       echo '#define G__CFG_IMPLIBEXT ".dylib"' >> $@__ ;; \
	     win32gcc) \
	       echo '#define G__CFG_ARCH "cygwin"' >> $@__ && \
	       echo '#define G__CFG_IMPLIBEXT ".a"' >> $@__ ;; \
	     *)	\
	       echo '#define G__CFG_ARCH "$(ARCH)"' >> $@__ && \
	       echo '#define G__CFG_IMPLIBEXT ".a"' >> $@__ ;; \
	    esac && \
	    echo '#define G__CFG_LDOUT "-o "' >> $@__ && \
	    echo '#define G__CFG_LIBL "-l@imp@"' >> $@__ && \
	    echo '#define G__CFG_LIBEXT ".a"' >> $@__ && \
	    echo '#define G__CFG_MANGLEPATHS "echo "' >> $@__ && \
	    echo '#define G__CFG_PLATFORMO ""' >> $@__ && \
	    echo '#define G__CFG_AR "ar qcs"' >> $@__ ;; \
	esac && \
	echo '#define G__CFG_COREVERSION "$(patsubst cint/%/inc/,%,$(dir $@))"' >> $@__ && \
	echo '#define G__CFG_CC "$(CC)"' >> $@__ && \
	echo '#define G__CFG_CFLAGS "$(G__CFG_CFLAGS)"' >> $@__ && \
	echo '#define G__CFG_CMACROS "$(filter -D%,$(G__CFG_CFLAGS))"' >> $@__ && \
	echo '#define G__CFG_COMP "-c "' >> $@__ && \
	echo '#define G__CFG_CPP "$(CPPPREP)"' >> $@__ && \
	echo '#define G__CFG_COUT "$(CXXOUT)"' >> $@__ && \
	echo '#define G__CFG_COUTEXE "$(CXXOUT)"' >> $@__ && \
	echo '#define G__CFG_INCP "-I"' >> $@__ && \
	echo '#define G__CFG_CXX "$(CXX)"' >> $@__ && \
	echo '#define G__CFG_CXXFLAGS "$(G__CFG_CXXFLAGS)"' >> $@__ && \
	echo '#define G__CFG_CXXMACROS "$(filter -D%,$(G__CFG_CXXFLAGS))"' >> $@__ && \
	echo '#define G__CFG_LD "$(LD)"' >> $@__ && \
	echo '#define G__CFG_LDFLAGS "$(LDFLAGS)"' >> $@__ && \
	echo '#define G__CFG_LIBP "-L"' >> $@__ && \
	echo '#define G__CFG_SOFLAGS "$(SOFLAGS)"' >> $@__ && \
	echo '#define G__CFG_SOOUT G__CFG_LDOUT' >> $@__ && \
	echo '#define G__CFG_OBJEXT ".o"' >> $@__ && \
	echo '#define G__CFG_EXEEXT "$(EXEEXT)"' >> $@__ && \
	echo '#define G__CFG_SOEXT ".$(SOEXT)"' >> $@__ && \
	echo '#define G__CFG_DEBUG "$(DEBUG)"' >> $@__ && \
	echo '#define G__CFG_DEFAULTLIBS "$(SYSLIBS)"' >> $@__ && \
	echo '#define G__CFG_DEFAULTLIBS "$(SYSLIBS)"' >> $@__ && \
	echo '#define G__CFG_STREAMDIR "$(patsubst $(MODDIRS)/%strm.cxx,%,$(filter $(MODDIRS)/%strm.cxx, $(CINTS2)))"' >> $@__ && \
	echo '#define G__CFG_EXPLLINK "$(EXPLICITLINK)"' >> $@__ && \
	echo '#define G__CFG_BUILDREADLINE ""' >> $@__ && \
	echo '#define G__CFG_READLINELIBDIR ""' >> $@__ && \
	echo '#define G__CFG_READLINEINCDIR ""' >> $@__ && \
	echo '#define G__CFG_NEEDCURSES ""' >> $@__ && \
	echo '#define G__CFG_RM "rm -f"' >> $@__ && \
	echo '#define G__CFG_MV "mv -f"' >> $@__ && \
	echo '#define G__CFG_INPUTMODE "root"' >> $@__ && \
	echo '#define G__CFG_INPUTMODELOCK "off"' >> $@__ && \
	echo '#define G__CFG_MAKEIMPLIB ""' >> $@__ && \
	echo '#define G__CFG_CINTSYSDIR "$(PWD)"' >> $@__ && \
	echo '#define G__CFG_HAVE_CONFIG "1"' >> $@__ && \
	echo '#define CINTSYSDIR "$(PWD)"' >> $@__ && \
	echo '#define G__CFG_MAKEIMPLIB ""' >> $@__ && \
	echo '#define G__CFG_HAVE_CONFIG "1"' >> $@__ \
	)
	@(if [ -r $@ ]; then \
	   diff $@__ $@ > /dev/null; status=$$?; \
	   if [ "$$status" -ne 0 ]; then \
	      echo "Running cint/configcint.mk"; \
	      echo "Changing $@"; \
	      mv $@__ $@; \
	   else \
	      rm -f $@__; \
	   fi \
	else \
	   echo "Running cint/configcint.mk"; \
	   echo "Making $@"; \
	   mv $@__ $@; \
	fi \
	)
