# - Try to find LADSPA header
# Once done this will define:
#
#  LADSPA_FOUND - system has LADSPA
#  LADSPA_INCLUDE_DIR - LADSPA header path

IF(LADSPA_INCLUDE_DIR)
   SET(LADSPA_FIND_QUIETLY TRUE)
ENDIF(LADSPA_INCLUDE_DIR)
   
FIND_PATH(LADSPA_INCLUDE_DIR "ladspa.h"
   /usr/include
   /usr/local/include
)

IF(LADSPA_INCLUDE_DIR)
   SET(LADSPA_FOUND TRUE)
ELSE(LADSPA_INCLUDE_DIR)
   SET(LADSPA_FOUND FALSE)
   SET(LADSPA_INCLUDE_DIR "")
ENDIF(LADSPA_INCLUDE_DIR)

IF(LADSPA_FOUND)
    IF(NOT LADSPA_FIND_QUIETLY)
        MESSAGE(STATUS "Found LADSPA: ${LADSPA_INCLUDE_DIR}")
    ENDIF(NOT LADSPA_FIND_QUIETLY)
ELSE(LADSPA_FOUND)
    IF(LADSPA_FIND_REQUIRED)
        MESSAGE(FATAL_ERROR "Could not find LADSPA")
    ENDIF(LADSPA_FIND_REQUIRED)
ENDIF(LADSPA_FOUND)

MARK_AS_ADVANCED(LADSPA_INCLUDE_DIR)
