# This -*- perl -*- script writes the Makefile for rat/ncat
# $Id: Makefile-nosnarf.PL,v 1.4 2002/03/21 17:24:18 gmj Exp $

require 5.004;
#use strict;


#--- Configuration section ---

#my @programs_to_install = qw(ncat ncat_report ncat_config rat snarf);
my @programs_to_install = qw(ncat ncat_report ncat_config rat);
my @request_aliases = ();

#--- End Configuration - You should not have to change anything below this line


# Allow us to suppress all program installation with the -n (library only)
# option.  This is for those that don't want to mess with the configuration
# section of this file.
use Getopt::Std;
use vars qw($opt_n);
unless (getopts("n")) {
    die "Usage: $0 [-n]\n";
}
@programs_to_install = () if $opt_n || grep /^LIB=/, @ARGV;


# Check for non-standard modules that are used by this library.
$| = 1;
my $missing_modules = 0;

#print "Checking for Net::Telnet...........";
#eval {
#    require Net::Telnet;
#    #Net::Telnet->VERSION(3.0);
#};
#if ($@) {
#    print " failed\n";
#    $missing_modules++;
#    print <<EOT;
#$@
#The snarf program requires Net::Telnet and Net::Telnet::Cisco.  Please
#get both from your local CPAN site...
#EOT
#    sleep(2);  # Don't hurry too much
#} else {
#    print " ok\n";
#}
#print "Checking for Net::Telnet::Cisco....";
#eval {
#    require Net::Telnet::Cisco;
#    Net::Telnet::Cisco->VERSION(1.03);
#};
#if ($@) {
#    print " failed\n";
#    $missing_modules++;
#    print <<EOT;
#$@
#The snarf program requires Net::Telnet and Net::Telnet::Cisco.  Please
#get both from your local CPAN site...
#EOT
#    sleep(2);  # Don't hurry too much
#} else {
#    print " ok\n";
#}

print "Checking for File::stat............";
eval {
    require File::stat
    #File::stat->VERSION('2.00');
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
File::stat is required from the base libraries to check config locations

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Getopt::Long..........";
eval {
    require Getopt::Long;
    Getopt::Long->VERSION('2.00');
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
Getopt::Long is a base Perl module; something may be amiss with your
installation as this is needed to handle the options passed on the
command line

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

# Ok, now it is time to really generate the Makefile
use ExtUtils::MakeMaker;
use ExtUtils::Manifest qw(maniread);


my @ppd;

if ($] >= 5.00503) {
  @ppd = (
	  AUTHOR    => {
		  NAME      => 'George Jones <gmj@users.sourceforge.net>',
		  CPANID    => 'AUTHOR',
		  WEBSITE   => 'http://www.cisecurity.org/',
		  },
	  ABSTRACT  => 'Router Auditing Tool',
	  );
}


sub MY::processPL {
    my($self) = shift;


    #
    # This is probabably not the right place or way to check for this
    # but we have to detect/prevent attempts to use "." as the install
    # directory because it will overwrite the distribtion directories.
    # It would probabably be better to reorg the install directories
    # to allow this
    #

    my($dev1,$dev2,$inode1,$inode2);

    ($dev1,$inode1) = stat($self->{PREFIX});
    ($dev2,$inode2) = stat(".");

    die "PREFIX '$self->{PREFIX}' is the same as the unpacking directory.
This would overwrite and delete distribution files.
Please choose another PREFIX directory"
	if ($dev1 == $dev2 and $inode1 == $inode2);

    # We now return you to your regularly scheduled Makefile.PL
    
    return "" unless $self->{PL_FILES};
    my(@m, $plfile);
    foreach $plfile (sort keys %{$self->{PL_FILES}}) {
        my $list = ref($self->{PL_FILES}->{$plfile})
                ? $self->{PL_FILES}->{$plfile}
                : [$self->{PL_FILES}->{$plfile}];
        my $target;
        foreach $target (@$list) {
        push @m, "
all :: $target
	$self->{NOECHO}\$(NOOP)

$target :: $plfile
	PREFIX=$self->{PREFIX} INSTALLSITELIB=$self->{INSTALLSITELIB} \$\(PERL\) -I\$\(INST_ARCHLIB\) -I\$\(INST_LIB\) -I\$\(PERL_ARCHLIB\) -I\$\(PERL_LIB\) $plfile $target
";
        }
    }
    join "", @m;
}



WriteMakefile(
   NAME          => 'rat',
   VERSION_FROM  => 'lib/NCAT.pm',
   INSTALLARCHLIB => '$(PREFIX)/lib' ,
   INSTALLSITELIB => '$(PREFIX)/lib' ,
   INSTALLMAN1DIR => '$(PREFIX)/man/man1' ,
   INSTALLMAN3DIR => '$(PREFIX)/man/man3' ,
   PL_FILES      => { map {("bin/$_.PL" => "bin/$_")} @programs_to_install },
   EXE_FILES     => [ map {"bin/$_"} @programs_to_install ],

   PREREQ_PM     => { 'Net::Telnet'         => "3.0",
                      'Net::Telnet::Cisco'  => "1.03",
                     },
   'clean'       => { FILES => '$(EXE_FILES)' },
   'dist'        => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
   @ppd,
);


package MY;

sub postamble
{
    my ($self) = @_;

    my @m;

    push @m, "install ::\n";
    push @m, "\t\$(FULLPERL) -e 'use Config; use File::Copy;' \\\n";
    push @m, <<'EOT';
	-e 'mkdir "$(PREFIX)/doc", 0755; ' \
	-e 'copy("rscg.pdf", "$(PREFIX)/doc/rscg.pdf"); ' \
	-e 'mkdir "$(PREFIX)/etc", 0755; ' \
	-e 'rename ("$(PREFIX)/etc/ncat.conf.MASTER", "$(PREFIX)/etc/ncat.conf.MASTER.old") if (-f "$(PREFIX)/etc/ncat.conf.MASTER"); '\
	-e 'copy("etc/ncat.conf.MASTER", "$(PREFIX)/etc/ncat.conf.MASTER"); '\
	-e 'rename ("$(PREFIX)/etc/ncat.conf", "$(PREFIX)/etc/ncat.conf.old") if (-f "$(PREFIX)/etc/ncat.conf"); '\
	-e 'copy("etc/ncat.conf", "$(PREFIX)/etc/ncat.conf") && exit(0); '
EOT

    join "", @m;
}


# Determine things that should *not* be installed
sub libscan
{
    my($self, $path) = @_;
    return '' if $path =~ m/.(pl|dtd|sgml)$/;
    return '' if $path =~ m:\bCVS/:;
    return '' if $path =~ m/~$/;
    $path;
}

# Pass rat version number to pod2man
sub manifypods
{
    my $self = shift;
    my $ver = $self->{VERSION} || "";
    local($_) = $self->SUPER::manifypods(@_);
    s/pod2man\s*$/pod2man --release rat-$ver/m;
    $_;
}
