/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000,2001 James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000,2001 Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: linux-nit.c,v 1.5 2001/11/01 15:26:29 root Exp $";

/* 
 * $Log: linux-nit.c,v $
 * Revision 1.5  2001/11/01 15:26:29  root
 * #
 *
 * Revision 1.4  2001/11/01 15:24:26  root
 * #
 *
 * Revision 1.3  2001/11/01 15:23:59  root
 * #
 *
 * Revision 1.2  2000/09/26 03:48:23  root
 * #
 *
 * Revision 1.1  2000/09/26 03:44:29  root
 * #
 *
 * Revision 1.8  2000/07/16 14:24:16  root
 * #
 *
 * Revision 1.7  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.6  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.5  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.4  1999/09/11 16:52:15  root
 * \#
 *
 * Revision 1.3  1999/09/11 16:34:50  root
 * \#
 *
 * Revision 1.2  1999/09/10 22:06:43  root
 * \#
 *
 * Revision 1.1  1999/09/10 17:32:26  root
 * \#
 *
 * Revision 1.1  1999/05/17 21:53:33  root
 * Initial revision
 *
 */

/*
 * CAUTION THIS CODE COMES WITH NO WARARNTY IT IS COPYRIGHT 1999 BY
 * James McKenzie All rights reserved. GPL applies
 */


#include "project.h"
#include "nit.h"

#include <sys/socket.h>
#include <linux/if_ether.h>
#include <linux/if_arp.h>
#include <linux/if_packet.h>
#include <sys/ioctl.h>
#include <sys/uio.h>

#if 0
/* Dire libc5 hack */
#undef __GLIBC__
#include <linux/socket.h>
#include <linux/if_ether.h>
#include <linux/if_arp.h>
#include <linux/if_packet.h>
#include <asm/socket.h>
#define __GLIBC__
#endif

struct nit
{
  int fd;
  int index;
  unsigned char mac[ETH_ALEN];
  char *name;
};


static void
get_hwaddr (unsigned char *name, unsigned char *addr)
{
  struct ifreq ifr;
  int fd = socket (AF_INET, SOCK_DGRAM, 0);

  if (fd < 0)
    {
      syslog (LOG_ERR, "socket:%m");
      return;
    }
  bcopy (name, &ifr.ifr_name, sizeof (ifr.ifr_name));


  /* find my own hardware address */
  if (ioctl (fd, SIOCGIFHWADDR, &ifr) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "ioctl(SIOCGIFHWADDR):%m");
      exit (-1);
    }
  close (fd);

  bcopy (&ifr.ifr_hwaddr.sa_data, addr, ETH_ALEN);

}

void
nit_close (struct nit *n)
{
  if (!n)
    return;

  if (n->name)
    free (n->name);
  close (n->fd);

/*FIXME: we should demulticast at this point but we need to have some 
 *mechanism for detecting if anyone else wants it
 */

  free (n);
}

struct nit *
nit_open (char *name)
{
  struct nit *n;
  struct sockaddr_ll sll;
  struct ifreq ifr;
  int fd;

  syslog (LOG_ERR, "RPLD 802.2 LINUX-NIT support %s", rcsid);

  fd = socket (PF_PACKET, SOCK_DGRAM, 0);

  if (fd < 0)
    {
      syslog (LOG_ERR, "socket:%m");
      return (NULL);
    }

  ifr.ifr_ifindex = 0;
  if (name)
    {

      strcpy (ifr.ifr_name, name);

      if (ioctl (fd, SIOCGIFINDEX, &ifr) < 0)
        {
          syslog (LOG_ERR, "SIOCGIFINDEX on %s: %m\n", name);
          close (fd);
          return NULL;
        }

    }



  bzero (&sll, sizeof (sll));
  sll.sll_family = AF_PACKET;
  sll.sll_protocol = htons (ETH_P_802_2);
  sll.sll_ifindex = ifr.ifr_ifindex;

  if (bind (fd, (struct sockaddr *) &sll, sizeof (sll)) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "bind:%m");
      return (NULL);
    }


  n = (struct nit *) malloc (sizeof (struct nit));

  n->index = ifr.ifr_ifindex;

  n->fd = fd;

  get_hwaddr (name, n->mac);

  if (name)
    {
      n->name = strdup (name);
    }
  else
    {
      n->name = NULL;
    }

  return (n);
}

unsigned char *
nit_mac (struct nit *n)
{
  return (n->mac);
}

int
nit_send (struct nit *n, unsigned char *frame, int len, unsigned char *to)
{
  struct sockaddr_ll sll;
  struct msghdr msg;
  struct iovec iov;

  bzero (&msg, sizeof (msg));
  bzero (&sll, sizeof (sll));


  sll.sll_family = AF_PACKET;
/* This is the most horrible hack you are ever likely to see*/
/* if you don't understand what's happening in the line below*/
/* be very very happy */
  sll.sll_protocol = htons (len);
  sll.sll_ifindex = n->index;
  sll.sll_hatype = ARPHRD_ETHER;
  sll.sll_pkttype = PACKET_OUTGOING;
  sll.sll_halen = ETH_ALEN;
  bcopy (to, &sll.sll_addr[0], ETH_ALEN);

  if (sendto (n->fd, frame, len, 0, (struct sockaddr *) &sll, sizeof (sll)) <
      0)
    {
      syslog (LOG_ERR, "sendto: %m");
      return -1;
    }

  return len;

}


int
nit_multicast (struct nit *n, unsigned char *mcaddr)
{
  struct ifreq ifr;
  int fd = socket (AF_INET, SOCK_DGRAM, 0);

  strncpy (ifr.ifr_name, n->name, sizeof (ifr.ifr_name));

  ifr.ifr_hwaddr.sa_family = AF_UNSPEC;

  bcopy (mcaddr, ifr.ifr_hwaddr.sa_data, ETH_ALEN);

  if (ioctl (fd, SIOCADDMULTI, &ifr) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "ioctl(SIOCADDMULTI):%m");
      return -1;
    }

  return 0;
}

int
nit_recv (struct nit *n, unsigned char *buf, int len, unsigned char *ufrom,
          struct timeval *tv)
{
  fd_set rfds;
  int ret;
  struct sockaddr_ll from;
  int fromlen = sizeof (from);


  FD_ZERO (&rfds);
  FD_SET (n->fd, &rfds);

  ret = select ((n->fd) + 1, &rfds, NULL, NULL, tv);

  if (ret < 0)
    return (ret);

  if (FD_ISSET ((n->fd), &rfds))
    {
      ret =
        recvfrom (n->fd, buf, len, 0, (struct sockaddr *) &from, &fromlen);
      if (ufrom)
        bcopy (from.sll_addr, ufrom, ETH_ALEN);

      return (ret);
    }
  else
    {
      return (0);
    }

}
