/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000,2001 James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2001 Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */

static char rcsid[] =
  "$Id: linux-old-nit.c,v 1.3 2001/11/01 15:24:26 root Exp $";

/* 
 * $Log: linux-old-nit.c,v $
 * Revision 1.3  2001/11/01 15:24:26  root
 * #
 *
 * Revision 1.2  2000/09/26 03:48:23  root
 * #
 *
 * Revision 1.1  2000/09/26 03:45:34  root
 * #
 *
 *
 */

/*
 * CAUTION THIS CODE COMES WITH NO WARARNTY IT IS COPYRIGHT 1999 BY
 * James McKenzie All rights reserved. GPL applies
 */



#include "project.h"
#include "nit.h"

#undef __GLIBC__
#include <linux/socket.h>
#include <linux/if_ether.h>
#include <linux/if_arp.h>
#include <linux/if_packet.h>
#include <linux/route.h>
#define __GLIBC__



#define NIT_MAX_NAME_LEN 1024

struct nit
{
  int fd;
  char *name;
  unsigned char mac[6];
};

struct machdr
{
  unsigned char h_dest[ETH_ALEN];
  unsigned char h_source[ETH_ALEN];
  short h_len;
};



static void
get_hwaddr (unsigned char *name, unsigned char *addr)
{
  struct ifreq ifr;
  int fd = socket (AF_INET, SOCK_DGRAM, 0);

  if (fd < 0)
    {
      syslog (LOG_ERR, "socket:%m");
      return;
    }
  bcopy (name, &ifr.ifr_name, sizeof (ifr.ifr_name));


  /* find my own hardware address */
  if (ioctl (fd, SIOCGIFHWADDR, &ifr) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "ioctl(SIOCGIFHWADDR):%m");
      exit (-1);
    }
  close (fd);


  bcopy (&ifr.ifr_hwaddr.sa_data, addr, ETH_ALEN);

}

unsigned char *
nit_mac (struct nit *n)
{
  return n->mac;
}

void
nit_close (struct nit *n)
{
  if (!n)
    return;

  close (n->fd);
  free (n->name);

/*FIXME: we should demulticast at this point but we need to have some 
 *mechanism for detecting if anyone else wants it
 */

  free (n);
}

struct nit *
nit_open (char *name)
{
  struct nit *n;
  struct sockaddr sa;
  int fd;

  syslog (LOG_ERR, "RPLD OLD LINUX-NIT support %s", rcsid);

  if (!name)
    name = "eth0";

#ifdef PF_PACKET
  fd = socket (PF_PACKET, SOCK_PACKET, htons (ETH_P_ALL));

  if (fd < 0)
#endif
    fd = socket (AF_INET, SOCK_PACKET, htons (ETH_P_ALL));

  if (fd < 0)
    {
      syslog (LOG_ERR, "socket:%m");
      return (NULL);
    }

  bzero (&sa, sizeof (sa));
  sa.sa_family = AF_INET;
  memcpy (&sa.sa_data, name, sizeof (sa.sa_data));

  if (bind (fd, &sa, sizeof (sa)) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "bind:%m");
      return (NULL);
    }


  n = (struct nit *) malloc (sizeof (struct nit));

  n->fd = fd;
  n->name = (char *) malloc (NIT_MAX_NAME_LEN);
  bzero (n->name, NIT_MAX_NAME_LEN);

  strcpy (n->name, name);
  get_hwaddr (n->name, n->mac);

  return (n);
}

int
nit_send (struct nit *n, unsigned char *frame, int len, unsigned char *to)
{
  struct sockaddr sa;
  int mylen;
  unsigned char *myframe = malloc (len + sizeof (struct machdr));
  struct machdr *mh = (struct machdr *) myframe;

  bcopy (to, mh->h_dest, ETH_ALEN);
  bcopy (n->mac, mh->h_source, ETH_ALEN);
  mh->h_len = htons (len);

  bcopy (frame, myframe + sizeof (struct machdr), len);
  mylen = len + sizeof (struct machdr);

  bzero (&sa, sizeof (sa));
  sa.sa_family = AF_INET;
  strncpy (sa.sa_data, n->name, sizeof (sa.sa_data));

#ifdef DEBUG
//  hexdump("out",myframe,mylen);
#endif

  if (sendto (n->fd, myframe, mylen, 0, &sa, sizeof (sa)) < 0)
    syslog (LOG_ERR, "sendto: %m");



  free (myframe);


  return len;

}


int
nit_multicast (struct nit *n, unsigned char *mcaddr)
{
  struct ifreq ifr;
  int fd = socket (AF_INET, SOCK_DGRAM, 0);

  strncpy (ifr.ifr_name, n->name, sizeof (ifr.ifr_name));

  ifr.ifr_hwaddr.sa_family = AF_UNSPEC;

  bcopy (mcaddr, ifr.ifr_hwaddr.sa_data, ETH_ALEN);

  if (ioctl (fd, SIOCADDMULTI, &ifr) < 0)
    {
      close (fd);
      syslog (LOG_ERR, "ioctl(SIOCADDMULTI):%m");
      return -1;
    }
  return 0;
}

int
nit_recv (struct nit *n, unsigned char *buf, int len, unsigned char *from,
          struct timeval *tv)
{
  fd_set rfds;
  int ret;

  struct machdr *mh;


  buf -= sizeof (struct machdr);
  mh = (struct machdr *) buf;

  FD_ZERO (&rfds);
  FD_SET (n->fd, &rfds);


  ret = select ((n->fd) + 1, &rfds, NULL, NULL, tv);

  if (ret < 0)
    return (ret);

  if (FD_ISSET ((n->fd), &rfds))
    {

      ret = read (n->fd, buf, len);

      if (ret > sizeof (struct machdr))
        {

          if (from)
            bcopy (mh->h_source, from, ETH_ALEN);
          ret = htons (mh->h_len);

          if (ret > len)
            {
              ret = len;
            }

          return (ret);
        }
      else
        {
          return 0;
        }

    }
  else
    {
      return (0);
    }

}
