import collections
import sys
import re
from rrutil import *

arch = get_exe_arch()

ArchInfo = collections.namedtuple('ArchInfo', ['syscall', 'ip_name'])
regex_info = {
    'i386': ArchInfo('getgid32', 'eip'),
    'i386:x86-64': ArchInfo('getgid', 'rip'),
}

syscall_re = re.compile("`SYSCALL: %s' \\(state:1\\)" % regex_info[arch].syscall)
sched_re = re.compile("`SCHED'")
eip_re = re.compile("%s:(0x[a-f0-9]+)" % regex_info[arch].ip_name)

sched_enabled = False
eip_enabled = False
eip = None
while True:
    line = sys.stdin.readline()
    if not line:
        break
    if syscall_re.search(line):
        sched_enabled = True
    if sched_enabled and sched_re.search(line):
        eip_enabled = True
    if eip_enabled:
        m = eip_re.search(line)
        if m:
            eip = m.group(1)
            break

if eip is None:
    failed('%s not found' % regex_info[arch].ip_name)

send_gdb('b *%s\n'%eip)
expect_gdb('Breakpoint 1')

send_gdb('c\n')
expect_gdb('Breakpoint 1')
expect_gdb('(gdb)')

send_gdb('p/x *(char*)$pc\n')
expect_gdb('0x([a-f0-9]+)')

if last_match().group(1) is 'cc':
    failed('saw breakpoint at current instruction')

ok()
