#!/bin/sh

# RRDWeather
# Copyright (c) 2005-2006 Sebastien Wains <seb@wains.be>
# Released under the GNU General Public License
# http://www.wains.be/projects/rrdweather/

PATH=/usr/bin:/bin

#######################################################################################
### EDIT THE LINE BELOW TO MATCH YOUR CONFIGURATION ###################################
#######################################################################################

RRDDIR="/usr/local/rrdweather"	# This should be the same as RRDDIR in db_update.sh

#######################################################################################
### YOU SHOULD NOT HAVE TO EDIT ANYTHING BELOW THIS LINE ##############################
#######################################################################################

clear

echo ""
echo "RRDWeather : database builder"
echo "-----------------------------"
echo "Hello, thanks for your interest in RRDWeather !"
echo ""
echo "Let's start !"
echo "Please note you should run this script for every city you want to monitor"
echo ""
echo -n "Please input your ZIP code or internal code : "
read CITY 
echo -n "Are you updating an existing version of RRDweather (y/n) ? "
read UPDATE
echo -n "Will you use metric (m) or english (e) units ? "
read UNIT
echo ""
echo "Thanks !"
echo ""
echo "Now, are you sure you want to create the database files ?"
echo -n "IT WILL OVERWRITE EXISTING DATA (y/n) " 
read ANSWER
echo ""

if [ ${UPDATE} = "y" ]
	then
	echo "You should not run db_builder.sh when updating RRDweather !"
	echo "Please read UPGRADE for more info"
	exit 1
fi 

if [ ${ANSWER} = "n" ]
then
	echo " "
	echo "Okay then.."
	echo "Exiting..."
	echo " "
	exit 0

elif [ ${ANSWER} = "y" ]
then
	cd

	if [ ! -d ${RRDDIR}/${CITY} ]
	then
		mkdir ${RRDDIR}/${CITY} -p
	fi

	rrdtool create ${RRDDIR}/${CITY}/real.rrd \
	--start 1127253600 \
	DS:real:GAUGE:600:-50:150 \
	RRA:AVERAGE:0.5:1:600 \
	RRA:AVERAGE:0.5:6:700 \
	RRA:AVERAGE:0.5:24:775 \
	RRA:AVERAGE:0.5:288:797 \
	RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
	RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	rrdtool create ${RRDDIR}/${CITY}/felt.rrd \
        --start 1127253600 \
        DS:felt:GAUGE:600:-50:150 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	rrdtool create ${RRDDIR}/${CITY}/dew.rrd \
        --start 1127253600 \
        DS:dew:GAUGE:600:-50:150 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	rrdtool create ${RRDDIR}/${CITY}/humidity.rrd \
        --start 1127253600 \
        DS:humidity:GAUGE:600:0:100 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	rrdtool create ${RRDDIR}/${CITY}/wind.rrd \
        --start 1127253600 \
        DS:wind:GAUGE:600:0:150 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797

	if [ $UNIT = "m" ]
	then

		rrdtool create ${RRDDIR}/${CITY}/pressure.rrd \
        	--start 1127253600 \
        	DS:pressure:GAUGE:600:950:1050 \
        	RRA:AVERAGE:0.5:1:600 \
        	RRA:AVERAGE:0.5:6:700 \
        	RRA:AVERAGE:0.5:24:775 \
        	RRA:AVERAGE:0.5:288:797 \
        	RRA:MIN:0.5:1:600 \
        	RRA:MIN:0.5:6:700 \
        	RRA:MIN:0.5:24:775 \
        	RRA:MIN:0.5:288:797 \
        	RRA:MAX:0.5:1:600 \
        	RRA:MAX:0.5:6:700 \
        	RRA:MAX:0.5:24:775 \
        	RRA:MAX:0.5:288:797

	else

		rrdtool create ${RRDDIR}/${CITY}/pressure.rrd \
        	--start 1127253600 \
        	DS:pressure:GAUGE:600:28:31 \
        	RRA:AVERAGE:0.5:1:600 \
        	RRA:AVERAGE:0.5:6:700 \
        	RRA:AVERAGE:0.5:24:775 \
        	RRA:AVERAGE:0.5:288:797 \
        	RRA:MIN:0.5:1:600 \
        	RRA:MIN:0.5:6:700 \
        	RRA:MIN:0.5:24:775 \
        	RRA:MIN:0.5:288:797 \
        	RRA:MAX:0.5:1:600 \
        	RRA:MAX:0.5:6:700 \
        	RRA:MAX:0.5:24:775 \
        	RRA:MAX:0.5:288:797

	fi

	rrdtool create ${RRDDIR}/${CITY}/uv.rrd \
        --start 1127253600 \
        DS:uv:GAUGE:600:0:15 \
        RRA:AVERAGE:0.5:1:600 \
        RRA:AVERAGE:0.5:6:700 \
        RRA:AVERAGE:0.5:24:775 \
        RRA:AVERAGE:0.5:288:797 \
        RRA:MIN:0.5:1:600 \
        RRA:MIN:0.5:6:700 \
        RRA:MIN:0.5:24:775 \
        RRA:MIN:0.5:288:797 \
        RRA:MAX:0.5:1:600 \
        RRA:MAX:0.5:6:700 \
        RRA:MAX:0.5:24:775 \
        RRA:MAX:0.5:288:797
	
	echo ""	
	echo "Database files (hopefully) successfully built..."
	echo ""
	echo "Listing database files created under ${RRDDIR}/${CITY} :"
	ls -lh ${RRDDIR}/${CITY}
	echo ""
	echo "Now, you can setup the db_update.sh script and set up a cron to run it every 5 minutes"

else

	echo " "
	echo "It said y or n !"
	echo "Exiting.. You deserved it ! :p"
	echo ""
	exit 1

fi
