#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include <rsbac/aci_data_structures.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

const char   set_prog[] = "attr_set_file_dir";
enum rsbac_attribute_t attr_list[RSBAC_DEV_NR_ATTRIBUTES] = RSBAC_DEV_ATTR_LIST;
int recurse = 0;
int verbose = 0;
FILE * tfile;
char * filename = NULL;

__s64 def_attr[RSBAC_DEV_NR_ATTRIBUTES] = {
      SL_unclassified, /* sec_level */
      RSBAC_MAC_DEF_CAT_VECTOR, /* mac_categories */
      RSBAC_FC_OC_ROOT_DEF, /* object_category */
      RSBAC_SIM_DT_ROOT_DEF, /* data_type */
      FALSE, /* mac_check */
      PO_none, /* pm_object_type */
      0, /* pm_object_class */
      RSBAC_RC_GENERAL_TYPE /* rc_type */
  };

int process(char * name)
  {
    int res = 0;
    char tmp1[RSBAC_MAXNAMELEN];
    char tmp2[RSBAC_MAXNAMELEN];
    int j;
    union rsbac_attribute_value_t value;
    struct stat buf;

    if(verbose)
      printf(gettext("Processing DEV '%s'\n"), name);
    for (j=0;j < RSBAC_DEV_NR_ATTRIBUTES;j++)
      {
        value.dummy = -1;
        res = rsbac_get_attr_n(get_attr_module(attr_list[j]), T_DEV, name, attr_list[j], &value, 0);
        if(res)
          {
            if(   (res != -RSBAC_EINVALIDMODULE)
               && (   verbose
                   || (res != -RSBAC_EINVALIDTARGET)
                  )
              )
              {
                get_error_name(tmp1,res);
                fprintf(stderr, "%s (%s): %s\n",
                        name,
                        get_attribute_name(tmp2,attr_list[j]),
                        tmp1);
              }
          }
        else
          switch(attr_list[j])
            {
              case A_log_array_low:
              case A_log_array_high:
                if (value.log_array_low != -1)
                  fprintf(tfile,
                          "%s -V %u DEV \"%s\" %s %s\n",
                          set_prog,
                          RSBAC_VERSION_NR,
                          name,
                          get_attribute_name(tmp1,attr_list[j]),
                          u64tostrlog(tmp2,value.log_array_low));
                break;
              case A_security_level:
              case A_object_category:
              case A_data_type:
              case A_pm_object_type:
                if(value.security_level != def_attr[j])
                  fprintf(tfile,
                          "%s -V %u DEV \"%s\" %s %u\n",
                          set_prog,
                          RSBAC_VERSION_NR,
                          name,
                          get_attribute_name(tmp1,attr_list[j]),
                          value.security_level);
                break;
              case A_rc_type:
                if(value.rc_type != def_attr[j])
                  fprintf(tfile,
                          "%s -V %u DEV \"%s\" %s %u\n",
                          set_prog,
                          RSBAC_VERSION_NR,
                          name,
                          get_attribute_name(tmp1,attr_list[j]),
                          value.rc_type);
                break;
              default:
                if(value.dummy != def_attr[j])
                  fprintf(tfile,
                          "%s -V %u DEV \"%s\" %s %i\n",
                          set_prog,
                          RSBAC_VERSION_NR,
                          name,
                          get_attribute_name(tmp1,attr_list[j]),
                          value.dummy);
            }
      }
    if(   recurse
       && !lstat(name,&buf)
       && S_ISDIR(buf.st_mode))
      {
        DIR * dir_stream_p;
        struct dirent * dirent_p;
        char name2[PATH_MAX];

        if(S_ISLNK(buf.st_mode))
          return(0);
        if(!(dir_stream_p = opendir(name)))
          {
            fprintf(stderr, gettext("opendir for dir %s returned error: %s\n"),
                   name,
                   strerror(errno));
            return(-2);
          }
        while((dirent_p = readdir(dir_stream_p)))
          {
            if(   (strcmp(".",dirent_p->d_name))
               && (strcmp("..",dirent_p->d_name)) )
              {
                strcpy(name2,name);
                strcat(name2,"/");
                strcat(name2,dirent_p->d_name);
                process(name2);
              }
          }
        closedir(dir_stream_p);
      }
    return(res);
  }

int main(int argc, char ** argv)
{
  int res = 0;
  char tmp1[RSBAC_MAXNAMELEN],tmp2[RSBAC_MAXNAMELEN],tmp3[RSBAC_MAXNAMELEN];
  int i,j;
  char * progname;

  locale_init();

  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'r':
                recurse=1;
                break;
              case 'o':
                if(argc > 2)
                  {
                    filename = argv[2];
                    argv++;
                    argc--;
                  }
                else
                  fprintf(stderr, gettext("%s: missing filename for parameter o\n"), progname);
                break;
              case 'a':
                printf(gettext("Attributes and values in backup = see following list:\n"));
                for (j=0;j<RSBAC_DEV_NR_ATTRIBUTES;j++)
                  {
                    get_switch_target_name(tmp1, get_attr_module(attr_list[j]));
                    get_attribute_name(tmp2,attr_list[j]);
                    get_attribute_param(tmp3,attr_list[j]);
                    printf("[%-4s] %s\n\t%s\n",tmp1,tmp2,tmp3);
                  }
                exit(0);
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if (argc > 1)
    {
      if(!filename)
        tfile = stdout;
      else
        {
          if (!(tfile=fopen(filename,"w")))
            {
              fprintf(stderr, gettext("opening target file returned error: %s\n"),
                              strerror(errno));
            }
        }
      if(verbose)
        printf(gettext("%s: %i targets\n"), progname, argc - 1);
      for (i=1;i < argc;i++)
        {
          process(argv[i]);
        }
      if(tfile != stdout)
        fclose(tfile);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), argv[0], VERSION);
      printf(gettext("Use: %s [-v] [-o target-file] file/dirname(s)\n"), progname);  
      printf(gettext("- should be called by root with all rsbac modules switched off,\n"));
      printf(gettext("- -r = recurse in subdirs, -v = verbose, no symlinks followed,\n"));
      printf(gettext("- -o target-file = write to file, not stdout,\n"));
      printf(gettext("- -a = list attributes and values\n"));
    }
  return (res);
}

