#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <rsbac/types.h>
#include <rsbac/aci_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int verbose=0;
int recurse=0;
union rsbac_attribute_value_t value;
enum rsbac_target_t target;
enum rsbac_attribute_t attr;
char * progname;
char * target_n;

int process(char * name)
  {
    int res = 0;
    char tmp1[RSBAC_MAXNAMELEN];
    struct stat buf;

    if(verbose)
      printf(gettext("Processing '%s'\n"),
             name);
    res = rsbac_remove_target_n(target, name);
    if(res)
      {
        get_error_name(tmp1,res);
        if(   verbose
           || (res != -RSBAC_EINVALIDTARGET)
          )
          fprintf(stderr, gettext("%s: error: %s\n"), name, tmp1);
      }

do_recurse:
    if(   !lstat(name,&buf)
       && S_ISDIR(buf.st_mode)
       && recurse)
      {
        DIR * dir_stream_p;
        struct dirent * dirent_p;
        char name2[PATH_MAX];

        if(S_ISLNK(buf.st_mode))
          return(0);
        if(!(dir_stream_p = opendir(name)))
          {
            fprintf(stderr, gettext("opendir for dir %s returned error: %s\n"),
                   name,
                   strerror(errno));
            return(-2);
          }
        while((dirent_p = readdir(dir_stream_p)))
          {
            if(   (strcmp(".",dirent_p->d_name))
               && (strcmp("..",dirent_p->d_name)) )
              {
                strcpy(name2,name);
                strcat(name2,"/");
                strcat(name2,dirent_p->d_name);
                process(name2);
              }
          }
        closedir(dir_stream_p);
      }
    return(0);
  }

int main(int argc, char ** argv)
{
  int res = 0;
  int i;

  locale_init();

  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'r':
                recurse=1;
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if (argc > 2)
    {
      if(verbose)
        printf(gettext("%s: %i targets\n\n"), progname, argc - 4);
      target = get_target_nr(argv[1]);
      if(   (target != T_DIR)
         && (target != T_FILE)
         && (target != T_FIFO)
         && (target != T_SYMLINK)
         && (target != T_DEV)
         && (target != T_FD)
        )
        {
          fprintf(stderr, gettext("%s: Invalid target type %s\n"), progname, argv[1]);
          exit(1);
        }
      for (i=1;i < (argc-1);i++)
        {
          process(argv[i+1]);
        }
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [-v] [-r] target-type file/dirname(s)\n"), progname);  
      printf(gettext("- -v = verbose, -r = recurse into subdirs,\n"));
      printf(gettext("- target-type = FILE, DIR, FIFO, SYMLINK, DEV or FD\n"));
      printf(gettext("  (FD: let %s decide between FILE, DIR, FIFO and SYMLINK, no DEV),\n"), progname);
    }
  return (res);
}

