#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define MAXNUM 200

int main(int argc, char ** argv)
{
  int res = 0;
  rsbac_pid_t pid=0;
  struct rsbac_auth_cap_range_t cap_range;
  enum rsbac_target_t target;
  char * progname;
  struct passwd * user_info_p;
  boolean remove = FALSE;
  int verbose = 0;
  rsbac_version_t version=RSBAC_VERSION_NR;
  rsbac_time_t ttl = RSBAC_LIST_TTL_KEEP;
  int maxnum = MAXNUM;
  enum rsbac_auth_cap_type_t cap_type = ACT_real;
  struct rsbac_auth_cap_range_t * caplist;
  rsbac_time_t * ttllist;
  int i;

  locale_init();

  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'e':
                cap_type = ACT_eff;
                break;
              case 'f':
                cap_type = ACT_fs;
                break;
              case 'm':
                if(argc > 2)
                  {
                    maxnum = strtoul(argv[2], 0, 10);
                    argc--;
                    argv++;
                  }
                else
                  fprintf(stderr, gettext("%s: missing maxnum value for parameter %c\n"), progname, *pos);
                break;
              case 't':
                if(argc > 2)
                  {
                    ttl = strtoul(argv[2], 0, 10);
                    argc--;
                    argv++;
                  }
                else
                  fprintf(stderr, gettext("%s: missing ttl value for parameter %c\n"), progname, *pos);
                break;
              case 'D':
                if(argc > 2)
                  {
                    ttl = 86400 * strtoul(argv[2], 0, 10);
                    argc--;
                    argv++;
                  }
                else
                  fprintf(stderr, gettext("%s: missing ttl value for parameter %c\n"), progname, *pos);
                break;
              case 'T':
                if(argc > 2)
                  {
                    rsbac_time_t now = time(NULL);
                    ttl = strtoul(argv[2], 0, 10);
                    if(ttl > now)
                      {
                        ttl -= now;
                        argc--;
                        argv++;
                      }
                    else
                      {
                        fprintf(stderr,
                                gettext("%s: ttl value for parameter %c is in the past, exiting\n"), progname, *pos);
                        exit(1);
                      }
                  }
                else
                  fprintf(stderr, gettext("%s: missing ttl value for parameter %c\n"), progname, *pos);
                break;
              case 'V':
                if(argc < 2)
                  {
                    fprintf(stderr, gettext("%s: no version number for switch V\n"), progname);
                    exit(1);
                  }
                version = strtol(argv[2],0,10);
                argv++;
                argc--;
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  switch(argc)
    {
      case 5:
      case 6:
        target = get_target_nr(argv[1]);
        if(   (target != T_PROCESS)
           && (target != T_FILE))
          {
            fprintf(stderr, gettext("%s: Invalid Target %s!\n"), progname, argv[1]);
            exit(1);
          }
        if(!strcmp(argv[2],"remove"))
          remove = TRUE;
        else
          if(strcmp(argv[2],"add"))
            {
              fprintf(stderr, gettext("%s: Invalid command %s!\n\n"), progname, argv[2]);
              exit(1);
            }
        if(target == T_PROCESS)
          pid=strtol(argv[3],0,10);
        if(   (!(user_info_p = getpwnam(argv[4])))
           && (   (!(user_info_p = getpwuid(strtoul(argv[4],0,10))))
               || (!(user_info_p->pw_uid) && strcmp("0",argv[4])) )
          )
          {
/*            fprintf(stderr, gettext("%s: Warning: Unknown user %s, trying number!\n\n"), progname, argv[4]); */
            cap_range.first = strtoul(argv[4],0,10);
            if(!cap_range.first)
              {
                fprintf(stderr, gettext("%s: Warning: user %s invalid, exiting!\n\n"), progname, argv[4]);
                exit(1);
              }
          }
        else
          {
            cap_range.first = user_info_p->pw_uid;
          }
        if(argc == 6)
          {
            if(   (!(user_info_p = getpwnam(argv[5])))
               && (   (!(user_info_p = getpwuid(strtoul(argv[5],0,10))))
                   || (!(user_info_p->pw_uid) && strcmp("0",argv[5])) )
              )
              {
                cap_range.last = strtoul(argv[5],0,10);
                if(!cap_range.last)
                  {
                    fprintf(stderr, gettext("%s: Warning: user %s invalid, exiting!\n\n"),
                            progname, argv[5]);
                    exit(1);
                  }
                if(cap_range.last < cap_range.first)
                  {
                    fprintf(stderr, gettext("%s: Warning: first user %u after last user %u, exiting!\n\n"),
                            progname, cap_range.first, cap_range.last);
                    exit(2);
                  }
                if(cap_range.last > RSBAC_AUTH_MAX_RANGE_UID)
                  {
                    fprintf(stderr, gettext("%s: Warning: last user %u is special user ID, exiting!\n\n"),
                            progname, cap_range.first);
                    exit(2);
                  }
              }
            else
              {
                cap_range.last = user_info_p->pw_uid;
              }
          }
        else
          { /* no last_user given */
            cap_range.last = cap_range.first;
          }
        if(target == T_PROCESS)
          {
            if(remove)
              res = rsbac_auth_remove_p_cap(pid, cap_type, cap_range);
            else
              res = rsbac_auth_add_p_cap(pid, cap_type, cap_range, ttl);
          }
        else
          {
            if(remove)
              res = rsbac_auth_remove_f_cap(argv[3], cap_type, cap_range);
            else
              res = rsbac_auth_add_f_cap(argv[3], cap_type, cap_range, ttl);
          }
        if(res < 0)
          error_exit(res);
        break;

      case 4:
        target = get_target_nr(argv[1]);
        if(target != T_FILE)
          {
            fprintf(stderr, gettext("%s: Invalid Target %s!\n"), progname, argv[1]);
            exit(1);
          }
        if(strcmp(argv[2],"get"))
          {
            fprintf(stderr, gettext("%s: Invalid command %s!\n\n"), progname, argv[2]);
            exit(1);
          }
        caplist = malloc(sizeof(*caplist) * maxnum);
        ttllist = malloc(sizeof(*ttllist) * maxnum);
        if(!caplist || !ttllist)
          error_exit(-ENOMEM);
        res = rsbac_auth_get_f_caplist(argv[3], cap_type, caplist, ttllist, maxnum);
        if(res < 0)
          {
            if(res == -RSBAC_ENOTFOUND)
              exit(0);
            else
              error_exit(res);
          }
        for(i=0; i<res; i++)
          if(ttllist[i])
            {
              if(caplist[i].first != caplist[i].last)
                printf("%u:%u(ttl:%us) ", caplist[i].first, caplist[i].last, ttllist[i]);
              else
                printf("%u(ttl:%us) ", caplist[i].first, ttllist[i]);
            }
          else
            {
              if(caplist[i].first != caplist[i].last)
                printf("%u:%u ", caplist[i].first, caplist[i].last);
              else
                printf("%u ", caplist[i].first);
            }
        printf("\n");
        break;

      default:
        printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
        printf(gettext("Use: %s [switches] TYPE add/remove target first_user [last_user]\n"), progname);
        printf(gettext("Use: %s [switches] FILE get filename\n"), progname);
        printf(gettext("     TYPE = PROCESS or FILE,\n"));
        printf(gettext("     target = pid or filename\n"));
        printf(gettext("     last_user: range from first_user to last_user\n"));
        printf(gettext("  -m = set maximum length of cap entry list per file, default is %u\n"), MAXNUM);
        printf(gettext("  -t = set relative time-to-live for this cap entry in seconds (add only)\n"));
        printf(gettext("  -T = set absolute time-to-live for this cap entry in seconds (add only)\n"));
        printf(gettext("  -D = set relative time-to-live for this cap entry in days (add only)\n"));
        printf(gettext("  -V version = supply RSBAC integer version number for upgrading\n"));
    }
  exit(res);
}
