#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include <rsbac/net_getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"

#define GROUP_PROG "net_temp"
#define MAX_ENTRIES 200

char * get_temp_name(rsbac_net_temp_id_t temp, char * name)
  {
    union  rsbac_net_temp_syscall_data_t data;

    if(!rsbac_net_temp(NTS_get_name, temp, &data))
      {
        strcpy(name, data.name);
      }
    else
      {
        strcpy(name, gettext("*unknown*"));
      }
    return name;
  }

int main(int argc, char ** argv)
{
  int res = 0;
  int i;
  enum  rsbac_net_temp_syscall_t call;
  int verbose=0;
  int global=0;
  int backup=0;
  int scripting=0;
  int numerical=0;
  char * progname;
  union rsbac_acl_group_syscall_arg_t arg;

  locale_init();
  
  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 'v':
                verbose++;
                break;
              case 'b':
                backup=1;
                break;
              case 'n':
                numerical=1;
                break;
              case 's':
                scripting=1;
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  if(   (argc > 1)
     && ((call = get_net_temp_syscall_nr(argv[1])) != NTS_none)
    )
    {
      switch(call)
        {
          default:
            break;
        }
      exit(0);
    }
  else
  if(!strcmp(argv[1], "get_list"))
    )
    {
      struct rsbac_acl_group_entry_t entry;
      char tmp[80];

      arg.get_group_entry.id = strtol(argv[2],0,10);
      arg.get_group_entry.entry_p = &entry;
      res = rsbac_acl_group(ACLGS_get_group_entry, &arg);
      error_exit(res);
      switch(argv[1][10])
        {
          case 't':
            if(entry.type == ACLG_PRIVATE)
              printf("PRIVATE\n");
            else
              printf("GLOBAL\n");
            break;

          case 'o':
            if(numerical)
              printf("%u\n",
                     entry.owner);
            else
              printf("%s\n",
                     get_user_name(entry.owner, tmp));
            break;

          case 'n':
            printf("%s\n", entry.name);
            break;

          default:
            break;
        }
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [switches] function params\n"), progname);  
      printf(gettext("- -v = verbose, -g = also list global groups of other users,\n"));
      printf(gettext("- -b = backup mode, -n = use numerical values,\n"));
      printf(gettext("- -s = scripting mode\n"));
      printf(gettext("- function and params = one of\n"));
      printf(gettext("  add_group P[RIVATE]|G[LOBAL] name [id]\n"));
      printf(gettext("  change_group group-id new-owner P[RIVATE]|G[LOBAL] name\n"));
      printf(gettext("  remove_group group-id\n"));
      printf(gettext("  get_group_entry group-id\n"));
      printf(gettext("  get_group_name group-id\n"));
      printf(gettext("  get_group_type group-id\n"));
      printf(gettext("  get_group_owner group-id\n"));
      printf(gettext("  list_groups\n"));
      printf(gettext("  add_member group-id user1 ...\n"));
      printf(gettext("  remove_member group-id user1 ...\n"));
      printf(gettext("  get_user_groups [user]\n"));
      printf(gettext("  get_group_members group-id\n"));
    }
  exit(0);
}

