#include <stdio.h>
#include <stdlib.h>
#include <linux/kdev_t.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/getname.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

int main(int argc, char ** argv)
{
  int res = 0;
  int i;
  int module,value;
  int softmode = 0;
  int verbose = 0;
  char name[80];
  char * progname;

  locale_init();

  progname = argv[0];
  
  while((argc > 1) && (argv[1][0] == '-'))
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case 's':
                softmode = 2;
                break;
              case 'v':
                verbose++;
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  
  if (argc == 3)
    {
      module=get_switch_target_nr(argv[1]);
      if(module == SW_NONE)
        {
          printf(gettext("%s: Invalid switch target %s\n"), progname, argv[1]);
          exit(1);
        }
      value=strtol(argv[2],0,10);
      if(verbose)
        {
          if(softmode)
            printf(gettext("%s: switching Module %s softmode to %i\n"), progname,argv[1],value);
          else
            printf(gettext("%s: switching Module %s to %i\n"), progname,argv[1],value);
        }
      res = rsbac_switch(module,value + softmode);
      error_exit(res);
      exit(0);
    }
  else
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [-s] module value\n"), progname);
      printf(gettext("  -s: switch module's individual softmode, not the whole module\n"));
      printf(gettext("module = module name, value = [01]\n\n"));
      printf(gettext("Possible module names are:\n"));
      for (i=0;i<SW_NONE;i++)
        {
          get_switch_target_name(name,i);
          printf("%s\n",name);
        }
    }
  exit(1);
}
