/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve.protocol;

import java.io.InputStream;
import java.io.OutputStream;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.protocol.REXPFactory;
import org.rosuda.REngine.Rserve.protocol.RPacket;

public class RTalk {
    public static final int DT_INT = 1;
    public static final int DT_CHAR = 2;
    public static final int DT_DOUBLE = 3;
    public static final int DT_STRING = 4;
    public static final int DT_BYTESTREAM = 5;
    public static final int DT_SEXP = 10;
    public static final int DT_ARRAY = 11;
    public static final int DT_LARGE = 64;
    public static final int CMD_login = 1;
    public static final int CMD_voidEval = 2;
    public static final int CMD_eval = 3;
    public static final int CMD_shutdown = 4;
    public static final int CMD_OCcall = 15;
    public static final int CMD_OCinit = 1129280338;
    public static final int CMD_openFile = 16;
    public static final int CMD_createFile = 17;
    public static final int CMD_closeFile = 18;
    public static final int CMD_readFile = 19;
    public static final int CMD_writeFile = 20;
    public static final int CMD_removeFile = 21;
    public static final int CMD_setSEXP = 32;
    public static final int CMD_assignSEXP = 33;
    public static final int CMD_setBufferSize = 129;
    public static final int CMD_setEncoding = 130;
    public static final int CMD_detachSession = 48;
    public static final int CMD_detachedVoidEval = 49;
    public static final int CMD_attachSession = 50;
    public static final int CMD_ctrlEval = 66;
    public static final int CMD_ctrlSource = 69;
    public static final int CMD_ctrlShutdown = 68;
    public static final int ERR_auth_failed = 65;
    public static final int ERR_conn_broken = 66;
    public static final int ERR_inv_cmd = 67;
    public static final int ERR_inv_par = 68;
    public static final int ERR_Rerror = 69;
    public static final int ERR_IOerror = 70;
    public static final int ERR_not_open = 71;
    public static final int ERR_access_denied = 72;
    public static final int ERR_unsupported_cmd = 73;
    public static final int ERR_unknown_cmd = 74;
    public static final int ERR_data_overflow = 75;
    public static final int ERR_object_too_big = 76;
    public static final int ERR_out_of_mem = 77;
    public static final int ERR_ctrl_closed = 78;
    public static final int ERR_session_busy = 80;
    public static final int ERR_detach_failed = 81;
    public static final int ERR_disabled = 97;
    public static final int ERR_unavailable = 98;
    public static final int ERR_cryptError = 99;
    public static final int ERR_securityClose = 100;
    public static final int CMD_RESP = 65536;
    public static final int RESP_OK = 65537;
    public static final int RESP_ERR = 65538;
    public static final int CMD_OOB = 131072;
    public static final int OOB_SEND = 135168;
    public static final int OOB_MSG = 139264;
    InputStream is;
    OutputStream os;

    public RTalk(InputStream inputStream, OutputStream outputStream) {
        this.is = inputStream;
        this.os = outputStream;
    }

    public static void setInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[++n2] = (byte)((n & 0xFF00) >> 8);
        byArray[++n2] = (byte)((n & 0xFF0000) >> 16);
        byArray[++n2] = (byte)((n & 0xFF000000) >> 24);
    }

    public static int setHdr(int n, int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n & 0xFF | (n2 > 0xFFFFF0 ? 64 : 0));
        byArray[++n3] = (byte)(n2 & 0xFF);
        byArray[++n3] = (byte)((n2 & 0xFF00) >> 8);
        byArray[++n3] = (byte)((n2 & 0xFF0000) >> 16);
        ++n3;
        if (n2 > 0xFFFFF0) {
            byArray[n3] = (byte)((n2 & 0xFF000000) >> 24);
            byArray[++n3] = 0;
            byArray[++n3] = 0;
            byArray[++n3] = 0;
            ++n3;
        }
        return n3;
    }

    public static byte[] newHdr(int n, int n2) {
        byte[] byArray = new byte[n2 > 0xFFFFF0 ? 8 : 4];
        RTalk.setHdr(n, n2, byArray, 0);
        return byArray;
    }

    public static int getInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    public static int getLen(byte[] byArray, int n) {
        return (byArray[n] & 0x40) > 0 ? byArray[n + 1] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 3] & 0xFF) << 16 | (byArray[n + 4] & 0xFF) << 24 : byArray[n + 1] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 3] & 0xFF) << 16;
    }

    public static long getLong(byte[] byArray, int n) {
        long l = (long)RTalk.getInt(byArray, n) & 0xFFFFFFFFL;
        long l2 = (long)RTalk.getInt(byArray, n + 4) & 0xFFFFFFFFL;
        l2 <<= 32;
        return l2 |= l;
    }

    public static void setLong(long l, byte[] byArray, int n) {
        RTalk.setInt((int)(l & 0xFFFFFFFFL), byArray, n);
        RTalk.setInt((int)(l >> 32), byArray, n + 4);
    }

    public RPacket request(int n) {
        byte[] byArray = new byte[]{};
        return this.request(n, byArray);
    }

    public RPacket request(int n, byte[] byArray) {
        return this.request(n, null, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public RPacket response() {
        return this.response(null);
    }

    public RPacket response(byte[] byArray) {
        try {
            int n;
            if (byArray == null && (n = this.is.read(byArray = new byte[16])) != 16) {
                return null;
            }
            n = RTalk.getInt(byArray, 0);
            int n2 = RTalk.getInt(byArray, 4);
            if (n2 > 0) {
                byte[] byArray2 = new byte[n2];
                int n3 = 0;
                if (byArray.length > 16) {
                    n3 = byArray.length - 16;
                    System.arraycopy(byArray, 16, byArray2, 0, n3);
                }
                while (n3 < n2) {
                    int n4 = this.is.read(byArray2, n3, n2 - n3);
                    n3 += n4;
                }
                return new RPacket(n, byArray2);
            }
            return new RPacket(n, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public RPacket request(int n, byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4;
        if (byArray2 != null) {
            if (n2 >= byArray2.length) {
                byArray2 = null;
                n3 = 0;
            } else if (n3 > byArray2.length - n2) {
                n3 = byArray2.length - n2;
            }
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n5 = n4 = byArray2 == null ? 0 : n3;
        if (byArray != null && byArray.length > 0) {
            n4 += byArray.length;
        }
        byte[] byArray3 = new byte[16];
        RTalk.setInt(n, byArray3, 0);
        RTalk.setInt(n4, byArray3, 4);
        for (int i = 8; i < 16; ++i) {
            byArray3[i] = 0;
        }
        try {
            if (n != -1) {
                this.os.write(byArray3);
                if (byArray != null && byArray.length > 0) {
                    this.os.write(byArray);
                }
                if (byArray2 != null && byArray2.length > 0) {
                    this.os.write(byArray2, n2, n3);
                }
            }
            return this.response();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public RPacket request(int n, String string) {
        try {
            int n2;
            byte[] byArray = string.getBytes(RConnection.transferCharset);
            int n3 = byArray.length + 1;
            if ((n3 & 3) > 0) {
                n3 = (n3 & 0xFFFFFC) + 4;
            }
            byte[] byArray2 = new byte[n3 + 5];
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray2[n2 + 4] = byArray[n2];
            }
            while (n2 < n3) {
                byArray2[n2 + 4] = 0;
                ++n2;
            }
            RTalk.setHdr(4, n3, byArray2, 0);
            return this.request(n, byArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public RPacket request(int n, REXP rEXP) {
        try {
            REXPFactory rEXPFactory = new REXPFactory(rEXP);
            int n2 = rEXPFactory.getBinaryLength();
            byte[] byArray = new byte[n2 + (n2 > 0xFFFFF0 ? 8 : 4)];
            RTalk.setHdr(10, n2, byArray, 0);
            rEXPFactory.getBinaryRepresentation(byArray, n2 > 0xFFFFF0 ? 8 : 4);
            return this.request(n, byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public RPacket request(int n, int n2) {
        try {
            byte[] byArray = new byte[8];
            RTalk.setInt(n2, byArray, 4);
            RTalk.setHdr(1, 4, byArray, 0);
            return this.request(n, byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

