/*===========================================================================*/
/*                                                                           */
/* This file is part of the SYMPHONY MILP Solver Framework.                  */
/*                                                                           */
/* SYMPHONY was jointly developed by Ted Ralphs (tkralphs@lehigh.edu) and    */
/* Laci Ladanyi (ladanyi@us.ibm.com).                                        */
/*                                                                           */
/* (c) Copyright 2000-2008 Ted Ralphs. All Rights Reserved.                  */
/*                                                                           */
/* This software is licensed under the Common Public License. Please see     */
/* accompanying file for terms.                                              */
/*                                                                           */
/*===========================================================================*/

#include "CoinSort.hpp"

/*===========================================================================*/
/*===========================================================================*/

static int cmpint(const void *p1, const void *p2){
   return (*((int *)p1) - *((int *)p2));
}

/*===========================================================================*/
/*===========================================================================*/

void qsort_i(int *bot, int nmemb)
{
  qsort (bot, nmemb, sizeof(int), cmpint);
}

/*===========================================================================*/
/*===========================================================================*/

void qsort_id(int *bot, double *botd, int nmemb)
{
   CoinSort_2(bot, bot+nmemb, botd);
}

/*===========================================================================*/
/*===========================================================================*/

void qsort_ic(int *bot, char *botc, int nmemb)
{
   CoinSort_2(bot, bot+nmemb, botc);
}

/*===========================================================================*/
/*===========================================================================*/

void qsort_ii(int *bot, int *bota, int nmemb)
{
   CoinSort_2(bot, bot+nmemb, bota);
}

/*===========================================================================*/
/*===========================================================================*/

void qsort_di(double *botd, int *boti, int nmemb)
{
   CoinSort_2(botd, botd+nmemb, boti);
}

/*===========================================================================*/
/*===========================================================================*/

