/*
*  program name: Rubrica <http://digilander.iol.it/nfragale/download.html>
*  file: account.c
*  
*  Copyright (C) 2000-2001 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <config.h>
#include <gnome.h>

#include "account.h"
#include "dialog.h"
#include "rubrica_type.h"


GArray *accounts = NULL;
GtkWidget *tree_view;

/**
 * rubrica_account_interface_creation
 *
 * create the interface for account's window. 
 *
 */ 
GtkWidget *rubrica_account_interface_creation(GtkTreeModel *model,
					      RubricaInfoChild *info)
{
  GtkWidget *scrollwin;

  scrollwin = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrollwin), 
				      GTK_SHADOW_ETCHED_IN);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwin),
				 GTK_POLICY_AUTOMATIC, 
				 GTK_POLICY_AUTOMATIC);

  /*     create a new view using the model
  */
  tree_view = gtk_tree_view_new_with_model(model);
  info->child = tree_view;

  g_object_unref(G_OBJECT(model));
  
  gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(tree_view), TRUE);
  gtk_tree_view_set_reorderable (GTK_TREE_VIEW (tree_view), TRUE);
  gtk_tree_selection_set_mode(gtk_tree_view_get_selection
			      (GTK_TREE_VIEW(tree_view)), 
			      GTK_SELECTION_SINGLE);

  rubrica_account_add_columns(GTK_TREE_VIEW(tree_view));
  gtk_container_add(GTK_CONTAINER(scrollwin), tree_view);

  gtk_widget_show(tree_view);

  return scrollwin;
}


GtkTreeModel *rubrica_account_create_model(void)
{
  GtkListStore *model;

  accounts = g_array_sized_new(FALSE, FALSE, sizeof(RubricaAccount), 1);
 
  /*      create list store 
   */
  model = gtk_list_store_new(N_COLUMNS, 
			     G_TYPE_BOOLEAN,        /* show secret */
			     G_TYPE_STRING,         /* site name   */
			     G_TYPE_STRING,         /* web url     */
			     G_TYPE_STRING,         /* email       */
			     G_TYPE_STRING,         /* login       */
			     G_TYPE_STRING,         /* password    */
			     G_TYPE_STRING);        /* description */

  return GTK_TREE_MODEL(model);
}

GtkWidget *rubrica_account_get_tree(void)
{
  return (GtkWidget *) tree_view; 
}

void rubrica_account_add_columns(GtkTreeView *view)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  GtkTreeModel *model;
  gint pos;

  model = gtk_tree_view_get_model(view);

  /*     Create the first column (editable) of list
  */
  renderer = gtk_cell_renderer_toggle_new();
  g_signal_connect(G_OBJECT(renderer), "toggled", 
		   G_CALLBACK(rubrica_account_cell_toggled), model);
  g_object_set_data(G_OBJECT(renderer), "column", (gint *) EDITABLE_COLUMN);

  /*      Create a column, associating the "active" attribute of the
	  cell_renderer to the first column of the model 
  */	      
  pos = gtk_tree_view_insert_column_with_attributes(view, -1, _("Secret"),
						    renderer, "active",   
						    EDITABLE_COLUMN, NULL);
  column = gtk_tree_view_get_column(view, pos-1);
					       
  /*      Add the column to the view. 
   */
  g_object_set_data(G_OBJECT(view), "edit", column);

  /*    second
   */
  renderer = gtk_cell_renderer_text_new();
  g_signal_connect(G_OBJECT(renderer), "edited", 
		   G_CALLBACK(rubrica_account_cell_edited), model);
  g_object_set_data(G_OBJECT(renderer), "column", (gint *) ACCOUNT_COLUMN);

  pos = gtk_tree_view_insert_column_with_attributes (view, -1, _("Account"), 
						     renderer, "text", 
						     ACCOUNT_COLUMN, 
						     "editable",
						     EDITABLE_COLUMN,	     
						     NULL);
  column = gtk_tree_view_get_column(view, pos-1);
  g_object_set_data(G_OBJECT(view), "name", column);
 

  /*     Third
   */
  renderer = gtk_cell_renderer_text_new();
  g_signal_connect(G_OBJECT(renderer), "edited", 
		   G_CALLBACK(rubrica_account_cell_edited), model);
  g_object_set_data(G_OBJECT(renderer), "column", (gint *) WEB_COLUMN);

  pos = gtk_tree_view_insert_column_with_attributes (view, -1, _("Web"), 
						     renderer,
						     "text", WEB_COLUMN,
						     "editable", 
						     EDITABLE_COLUMN,	     
						     NULL);
  column = gtk_tree_view_get_column(view, pos-1);
  g_object_set_data(G_OBJECT(view), "web", column);
 
  /*    fourth
   */
  renderer = gtk_cell_renderer_text_new();
  g_signal_connect(G_OBJECT(renderer), "edited", 
		   G_CALLBACK(rubrica_account_cell_edited), model);
  g_object_set_data(G_OBJECT(renderer), "column", (gint *) EMAIL_COLUMN);

  pos = gtk_tree_view_insert_column_with_attributes (view, -1, _("Email"), 
						     renderer,
						     "text", EMAIL_COLUMN,
						     "editable", 
						     EDITABLE_COLUMN,	     
						     NULL);
  column = gtk_tree_view_get_column(view, pos-1);
  g_object_set_data(G_OBJECT(view), "email", column);

  /*    fifth 
  */
  renderer = gtk_cell_renderer_text_new();
  g_signal_connect(G_OBJECT(renderer), "edited", 
		   G_CALLBACK(rubrica_account_cell_edited), model);
  g_object_set_data(G_OBJECT(renderer), "column", (gint *) LOGIN_COLUMN);
  pos = gtk_tree_view_insert_column_with_attributes (view, -1, _("Login"), 
						     renderer,
						     "text", LOGIN_COLUMN,
						     "editable", 
						     EDITABLE_COLUMN,	     
						     NULL);
  column = gtk_tree_view_get_column(view, pos-1);
  g_object_set_data(G_OBJECT(view), "login", column);

  /*    sixth
  */
  renderer = gtk_cell_renderer_text_new();
  g_signal_connect(G_OBJECT(renderer), "edited", 
		   G_CALLBACK(rubrica_account_cell_edited), model);
  g_object_set_data(G_OBJECT(renderer), "column", (gint *) PASSWORD_COLUMN);

  pos = gtk_tree_view_insert_column_with_attributes (view, -1, _("Password"), 
						     renderer,
						     "text", PASSWORD_COLUMN,
						     "editable", 
						     EDITABLE_COLUMN,	     
						     NULL);
  column = gtk_tree_view_get_column(view, pos-1);
  g_object_set_data(G_OBJECT(view), "password", column);

  /*     seventh 
  */
  renderer = gtk_cell_renderer_text_new();
  g_signal_connect(G_OBJECT(renderer), "edited", 
		   G_CALLBACK(rubrica_account_cell_edited), model);
  g_object_set_data(G_OBJECT(renderer), "column", (gint *) DESCRIPTION_COLUMN);

  pos = gtk_tree_view_insert_column_with_attributes (view, -1, 
						     _("Description"), 
						     renderer, "text", 
						     DESCRIPTION_COLUMN,
						     "editable", 
						     EDITABLE_COLUMN,	     
						     NULL);
  column = gtk_tree_view_get_column(view, pos-1);
  g_object_set_data(G_OBJECT(view), "info", column);
}


void rubrica_account_add_item(GtkWidget *button, gpointer data)
{
  RubricaAccount item;
  GtkTreeIter iter;
  GtkTreeView *view = (GtkTreeView *) data;
  GtkTreeModel *model;

  g_array_append_vals(accounts, &item, 1);
  
  model = gtk_tree_view_get_model(GTK_TREE_VIEW(view));

  gtk_list_store_append(GTK_LIST_STORE(model), &iter);
  gtk_list_store_set(GTK_LIST_STORE(model), &iter,  
		     EDITABLE_COLUMN, item.editable, 
		     ACCOUNT_COLUMN, item.name, 
		     WEB_COLUMN, item.web,
		     EMAIL_COLUMN,item.email,
		     LOGIN_COLUMN, item.login,
		     PASSWORD_COLUMN, item.password,
		     DESCRIPTION_COLUMN, item.description, 
		     -1);
}

void rubrica_account_delete_item(GtkWidget *button, gpointer data)
{
  GtkTreeIter iter;
  GtkTreeView *view = (GtkTreeView *) data;
  GtkTreeModel *model;
  GtkTreeSelection *selection;

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(view));
  selection = gtk_tree_view_get_selection(view); 
 
  if (gtk_tree_selection_get_selected(selection, NULL, &iter))
    {
      gint i;
      GtkTreePath *path;

      path = gtk_tree_model_get_path(model, &iter);

      i = gtk_tree_path_get_indices(path)[0];
      gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
      
      g_array_remove_index(accounts, i);
      
      gtk_tree_path_free(path);      	
    }
}

void rubrica_account_cell_toggled(GtkCellRendererToggle *cell, 
				  const gchar *path_string,
				  gpointer data)
{
  GtkTreeModel *model = (GtkTreeModel *) data;
  GtkTreeViewColumn *editing;
  GtkTreePath *path  = gtk_tree_path_new_from_string(path_string);
  GtkTreeIter iter;

  gint *column;
  gboolean bool;

  column  = g_object_get_data(G_OBJECT(cell), "column");
  editing = g_object_get_data(G_OBJECT(tree_view), "edit");

  gtk_tree_model_get_iter(model, &iter, path);
  gtk_tree_model_get(model, &iter, (gint) column, &bool, -1);

  bool ^= 1;
  gtk_list_store_set(GTK_LIST_STORE(model), &iter, (gint) column, bool, -1);
  
  gtk_tree_path_free(path);
}

void rubrica_account_cell_edited(GtkCellRendererText *cell, 
				 const gchar *path_string,
				 const gchar *new_text, gpointer data)
{
  GtkTreeModel *model = (GtkTreeModel *) data;
  GtkTreePath  *path  = gtk_tree_path_new_from_string(path_string);
  GtkTreeIter iter;

  gint *column;
  gint i;
  gchar *old_text;

  column  = g_object_get_data(G_OBJECT(cell), "column");

  gtk_tree_model_get_iter(model, &iter, path);

  gtk_tree_model_get(model, &iter, column, &old_text, -1);
  g_free (old_text);
  
  i = gtk_tree_path_get_indices(path)[0];
  
  switch((gint) column)
    {
    case ACCOUNT_COLUMN:
      g_free(g_array_index(accounts, RubricaAccount, i).name);
      g_array_index(accounts, RubricaAccount, i).name = g_strdup(new_text);

      gtk_list_store_set(GTK_LIST_STORE(model), &iter, column, 
			 g_array_index(accounts, RubricaAccount, i).name, -1);
	
      break;

    case WEB_COLUMN:
      g_free(g_array_index(accounts, RubricaAccount, i).web);
      g_array_index(accounts, RubricaAccount, i).web = g_strdup(new_text);

      gtk_list_store_set(GTK_LIST_STORE(model), &iter, column, 
			 g_array_index(accounts, RubricaAccount, i).web, -1);
      break;

    case EMAIL_COLUMN:
      g_free(g_array_index(accounts, RubricaAccount, i).email);
      g_array_index(accounts, RubricaAccount, i).email = g_strdup(new_text);

      gtk_list_store_set(GTK_LIST_STORE(model), &iter, column, 
			 g_array_index(accounts, RubricaAccount, i).email, -1);
      break;

    case LOGIN_COLUMN:
      g_free(g_array_index(accounts, RubricaAccount, i).login);
      g_array_index(accounts, RubricaAccount, i).login = g_strdup(new_text);

      gtk_list_store_set(GTK_LIST_STORE(model), &iter, column, 
			 g_array_index(accounts, RubricaAccount, i).login, -1);
      break;

    case PASSWORD_COLUMN:
      g_free(g_array_index(accounts, RubricaAccount, i).password);
      g_array_index(accounts, RubricaAccount, i).password = g_strdup(new_text);

      gtk_list_store_set(GTK_LIST_STORE(model), &iter, column, 
			 g_array_index(accounts, RubricaAccount, i).password,
			 -1);
      break;

    case DESCRIPTION_COLUMN:
      g_free(g_array_index(accounts, RubricaAccount, i).description);
      g_array_index(accounts, RubricaAccount, i).description = g_strdup(new_text);

      gtk_list_store_set(GTK_LIST_STORE(model), &iter, column, 
			 g_array_index(accounts, RubricaAccount, i).description, -1);
      break;
    }
}

