/*
*  Rubrica
*  file: ui.h
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __RUBRICA_UI_H
#define __RUBRICA_UI_H

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "rubrica_type.h"
#include "menu.h"

/* contenitori
*/
void rubrica_ui_set_default_icon(GtkWidget *app);
GtkWidget *rubrica_ui_default_box_new(RubricaBoxType type); 
GtkWidget *rubrica_ui_box_new(RubricaBoxType type, gboolean homogeneous, 
			       gint spacing, guint border_width);   

GtkWidget *rubrica_ui_frame_new(gchar *str);
GtkWidget *rubrica_ui_popup_image_new(gchar *pixfile);
GtkWidget *rubrica_ui_image_new(gchar *pixfile);   
GdkPixbuf *rubrica_ui_pixbuf_new(gchar *filename);
GtkWidget *rubrica_ui_label_new(gchar *str);
GtkWidget *rubrica_ui_entry_new(void);
GtkWidget *rubrica_ui_check_button_new(gchar *str);
GtkWidget *rubrica_ui_buttonbox_new(RubricaBoxType type);
GtkWidget *rubrica_ui_scrolled_window_new(void); 
GtkWidget *rubrica_ui_option_menu_new(RubricaOptionType *option_list);
GtkWidget *rubrica_ui_popup_menu_new(RubricaMenu *rubrica_menu);
GtkWidget *rubrica_ui_pixbutton_new(gchar *str, gchar *pixfile);
GtkWidget *rubrica_ui_table_new(gint row, gint column, gboolean homogeneous, 
				guint border, guint row_spacing,
				guint col_spacing);    

GtkWidget *rubrica_ui_pack_in_box_new_frame(GtkWidget *box, gchar *str, 
					    gboolean packstart);
GtkWidget *rubrica_ui_pack_in_box_check_button_new(GtkWidget *box, gchar *str);
GtkWidget *rubrica_ui_pack_in_box_image_new(GtkWidget *box, gchar *pixfile, 
					    gboolean packstart);

GtkWidget *rubrica_ui_pack_in_frame_new_box(GtkWidget *frame, 
					    RubricaBoxType type,   
					    gboolean homogeneous, 
					    gint spacing, guint border);

GtkWidget *
rubrica_ui_pack_in_box_boxed_label_entry_pix_new(GtkWidget *box, 
						 RubricaBoxType type,
						 gboolean homogeneous,
						 gchar *str, gchar *pixfile, 
						 gboolean first,
						 gboolean packstart);     

GtkWidget *
rubrica_ui_pack_in_box_boxed_label_option_menu_new(GtkWidget *container, 
						   gchar *str, 
						   RubricaOptionType *option_list,
						   RubricaBoxType type,
						   gboolean packstart); 


GtkWidget *rubrica_ui_pack_in_box_table_new(GtkWidget *box, 
					     gint row, gint column, 
					     gboolean homogeneous, 
					     guint border, 
					     guint row_spacing, 
					     guint col_spacing);  

void rubrica_ui_tabled_widget(GtkWidget *container, GtkWidget *child, 
			      guint left_attach, guint right_attach, 
			      guint top_attach,  guint bottom_attach);  

GtkWidget *rubrica_ui_tabled_label_new(GtkWidget *container, gchar *str, 
				       guint left_attach, guint right_attach, 
				       guint top_attach, guint bottom_attach);

GtkWidget *rubrica_ui_tabled_entry_new(GtkWidget *container, 
				       guint left_attach, guint right_attach, 
				       guint top_attach, guint bottom_attach);

GtkWidget *rubrica_ui_tabled_check_new(GtkWidget *container, gchar *str, 
				       guint left_attach, guint right_attach, 
				       guint top_attach, guint bottom_attach);

GtkWidget *rubrica_ui_tabled_date_new(GtkWidget *container, 
				      guint left_attach, guint right_attach, 
				      guint top_attach, guint bottom_attach); 

GtkWidget *rubrica_ui_tabled_radio_new(GtkWidget *container, GSList *group, 
				       gchar *str,  
				       guint left_attach, guint right_attach,
				       guint top_attach, guint bottom_attach);

GtkWidget *rubrica_ui_tabled_pixmap_new(GtkWidget *container, gchar *pixfile,  
					guint left_attach, guint right_attach,
					guint top_attach, guint bottom_attach);

/*  text view
*/
GtkWidget *rubrica_ui_text_view_new(void);
void rubrica_ui_set_text_in_view(GtkWidget *text_view, gchar *buffer);
void rubrica_ui_clean_text_view(GtkWidget *text_view);
GtkWidget *rubrica_ui_tabled_text_view(GtkWidget *table, GtkWidget *text_view,
				       guint left_attach, guint right_attach, 
				       guint top_attach, guint bottom_attach);

/*   tree view
*/
GtkWidget *
rubrica_ui_pack_in_frame_tree_view_new_with_model(GtkWidget *frame, 
						  GtkTreeModel* model); 
GtkWidget *
rubrica_ui_pack_in_box_tree_view_new_with_model(GtkWidget *container,
						GtkTreeModel* model);
void rubrica_ui_add_columns(GtkTreeView *view, RubricaColumnsType type);


void rubrica_ui_update_popup_item(GConfClient *client, guint cnxn_id, 
				  GConfEntry *entry, gpointer data);
#endif
