# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::DevTestLabs
  #
  # The DevTest Labs Client.
  #
  class Labs
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Labs class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [DevTestLabsClient] reference to the DevTestLabsClient
    attr_reader :client

    #
    # List labs in a subscription.
    #
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Lab>] operation results.
    #
    def list_by_subscription(expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      first_page = list_by_subscription_as_lazy(expand, filter, top, orderby, custom_headers)
      first_page.get_all_items
    end

    #
    # List labs in a subscription.
    #
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_subscription_with_http_info(expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      list_by_subscription_async(expand, filter, top, orderby, custom_headers).value!
    end

    #
    # List labs in a subscription.
    #
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_subscription_async(expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.DevTestLab/labs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'$expand' => expand,'$filter' => filter,'$top' => top,'$orderby' => orderby,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::ResponseWithContinuationLab.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List labs in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Lab>] operation results.
    #
    def list_by_resource_group(resource_group_name, expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, expand, filter, top, orderby, custom_headers)
      first_page.get_all_items
    end

    #
    # List labs in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, expand, filter, top, orderby, custom_headers).value!
    end

    #
    # List labs in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name},
          query_params: {'$expand' => expand,'$filter' => filter,'$top' => top,'$orderby' => orderby,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::ResponseWithContinuationLab.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get lab.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Lab] operation results.
    #
    def get(resource_group_name, name, expand = nil, custom_headers = nil)
      response = get_async(resource_group_name, name, expand, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get lab.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, name, expand = nil, custom_headers = nil)
      get_async(resource_group_name, name, expand, custom_headers).value!
    end

    #
    # Get lab.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, name, expand = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'name' => name},
          query_params: {'$expand' => expand,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::Lab.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or replace an existing lab. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab [Lab] A lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Lab] operation results.
    #
    def create_or_update(resource_group_name, name, lab, custom_headers = nil)
      response = create_or_update_async(resource_group_name, name, lab, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab [Lab] A lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, name, lab, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, name, lab, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::DevTestLabs::Models::Lab.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Delete lab. This operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, name, custom_headers = nil)
      response = delete_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Modify properties of labs.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab [LabFragment] A lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Lab] operation results.
    #
    def update(resource_group_name, name, lab, custom_headers = nil)
      response = update_async(resource_group_name, name, lab, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Modify properties of labs.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab [LabFragment] A lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(resource_group_name, name, lab, custom_headers = nil)
      update_async(resource_group_name, name, lab, custom_headers).value!
    end

    #
    # Modify properties of labs.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab [LabFragment] A lab.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(resource_group_name, name, lab, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'lab is nil' if lab.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DevTestLabs::Models::LabFragment.mapper()
      request_content = @client.serialize(request_mapper,  lab)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::Lab.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Claim a random claimable virtual machine in the lab. This operation can take
    # a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def claim_any_vm(resource_group_name, name, custom_headers = nil)
      response = claim_any_vm_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def claim_any_vm_async(resource_group_name, name, custom_headers = nil)
      # Send request
      promise = begin_claim_any_vm_async(resource_group_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Create virtual machines in a lab. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab_virtual_machine_creation_parameter
    # [LabVirtualMachineCreationParameter] Properties for creating a virtual
    # machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def create_environment(resource_group_name, name, lab_virtual_machine_creation_parameter, custom_headers = nil)
      response = create_environment_async(resource_group_name, name, lab_virtual_machine_creation_parameter, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab_virtual_machine_creation_parameter
    # [LabVirtualMachineCreationParameter] Properties for creating a virtual
    # machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_environment_async(resource_group_name, name, lab_virtual_machine_creation_parameter, custom_headers = nil)
      # Send request
      promise = begin_create_environment_async(resource_group_name, name, lab_virtual_machine_creation_parameter, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Exports the lab resource usage into a storage account This operation can take
    # a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param export_resource_usage_parameters [ExportResourceUsageParameters] The
    # parameters of the export operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def export_resource_usage(resource_group_name, name, export_resource_usage_parameters, custom_headers = nil)
      response = export_resource_usage_async(resource_group_name, name, export_resource_usage_parameters, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param export_resource_usage_parameters [ExportResourceUsageParameters] The
    # parameters of the export operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def export_resource_usage_async(resource_group_name, name, export_resource_usage_parameters, custom_headers = nil)
      # Send request
      promise = begin_export_resource_usage_async(resource_group_name, name, export_resource_usage_parameters, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Generate a URI for uploading custom disk images to a Lab.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param generate_upload_uri_parameter [GenerateUploadUriParameter] Properties
    # for generating an upload URI.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GenerateUploadUriResponse] operation results.
    #
    def generate_upload_uri(resource_group_name, name, generate_upload_uri_parameter, custom_headers = nil)
      response = generate_upload_uri_async(resource_group_name, name, generate_upload_uri_parameter, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Generate a URI for uploading custom disk images to a Lab.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param generate_upload_uri_parameter [GenerateUploadUriParameter] Properties
    # for generating an upload URI.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def generate_upload_uri_with_http_info(resource_group_name, name, generate_upload_uri_parameter, custom_headers = nil)
      generate_upload_uri_async(resource_group_name, name, generate_upload_uri_parameter, custom_headers).value!
    end

    #
    # Generate a URI for uploading custom disk images to a Lab.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param generate_upload_uri_parameter [GenerateUploadUriParameter] Properties
    # for generating an upload URI.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def generate_upload_uri_async(resource_group_name, name, generate_upload_uri_parameter, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'generate_upload_uri_parameter is nil' if generate_upload_uri_parameter.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DevTestLabs::Models::GenerateUploadUriParameter.mapper()
      request_content = @client.serialize(request_mapper,  generate_upload_uri_parameter)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/generateUploadUri'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::GenerateUploadUriResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List disk images available for custom image creation.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<LabVhd>] operation results.
    #
    def list_vhds(resource_group_name, name, custom_headers = nil)
      first_page = list_vhds_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # List disk images available for custom image creation.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_vhds_with_http_info(resource_group_name, name, custom_headers = nil)
      list_vhds_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List disk images available for custom image creation.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_vhds_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/listVhds'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::ResponseWithContinuationLabVhd.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or replace an existing lab. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab [Lab] A lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Lab] operation results.
    #
    def begin_create_or_update(resource_group_name, name, lab, custom_headers = nil)
      response = begin_create_or_update_async(resource_group_name, name, lab, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or replace an existing lab. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab [Lab] A lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, name, lab, custom_headers = nil)
      begin_create_or_update_async(resource_group_name, name, lab, custom_headers).value!
    end

    #
    # Create or replace an existing lab. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab [Lab] A lab.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, name, lab, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'lab is nil' if lab.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DevTestLabs::Models::Lab.mapper()
      request_content = @client.serialize(request_mapper,  lab)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::Lab.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::Lab.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete lab. This operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Delete lab. This operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, name, custom_headers = nil)
      begin_delete_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Delete lab. This operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Claim a random claimable virtual machine in the lab. This operation can take
    # a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_claim_any_vm(resource_group_name, name, custom_headers = nil)
      response = begin_claim_any_vm_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Claim a random claimable virtual machine in the lab. This operation can take
    # a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_claim_any_vm_with_http_info(resource_group_name, name, custom_headers = nil)
      begin_claim_any_vm_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Claim a random claimable virtual machine in the lab. This operation can take
    # a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_claim_any_vm_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/claimAnyVm'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Create virtual machines in a lab. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab_virtual_machine_creation_parameter
    # [LabVirtualMachineCreationParameter] Properties for creating a virtual
    # machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_create_environment(resource_group_name, name, lab_virtual_machine_creation_parameter, custom_headers = nil)
      response = begin_create_environment_async(resource_group_name, name, lab_virtual_machine_creation_parameter, custom_headers).value!
      nil
    end

    #
    # Create virtual machines in a lab. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab_virtual_machine_creation_parameter
    # [LabVirtualMachineCreationParameter] Properties for creating a virtual
    # machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_environment_with_http_info(resource_group_name, name, lab_virtual_machine_creation_parameter, custom_headers = nil)
      begin_create_environment_async(resource_group_name, name, lab_virtual_machine_creation_parameter, custom_headers).value!
    end

    #
    # Create virtual machines in a lab. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param lab_virtual_machine_creation_parameter
    # [LabVirtualMachineCreationParameter] Properties for creating a virtual
    # machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_environment_async(resource_group_name, name, lab_virtual_machine_creation_parameter, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'lab_virtual_machine_creation_parameter is nil' if lab_virtual_machine_creation_parameter.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DevTestLabs::Models::LabVirtualMachineCreationParameter.mapper()
      request_content = @client.serialize(request_mapper,  lab_virtual_machine_creation_parameter)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/createEnvironment'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Exports the lab resource usage into a storage account This operation can take
    # a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param export_resource_usage_parameters [ExportResourceUsageParameters] The
    # parameters of the export operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_export_resource_usage(resource_group_name, name, export_resource_usage_parameters, custom_headers = nil)
      response = begin_export_resource_usage_async(resource_group_name, name, export_resource_usage_parameters, custom_headers).value!
      nil
    end

    #
    # Exports the lab resource usage into a storage account This operation can take
    # a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param export_resource_usage_parameters [ExportResourceUsageParameters] The
    # parameters of the export operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_export_resource_usage_with_http_info(resource_group_name, name, export_resource_usage_parameters, custom_headers = nil)
      begin_export_resource_usage_async(resource_group_name, name, export_resource_usage_parameters, custom_headers).value!
    end

    #
    # Exports the lab resource usage into a storage account This operation can take
    # a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param export_resource_usage_parameters [ExportResourceUsageParameters] The
    # parameters of the export operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_export_resource_usage_async(resource_group_name, name, export_resource_usage_parameters, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'export_resource_usage_parameters is nil' if export_resource_usage_parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DevTestLabs::Models::ExportResourceUsageParameters.mapper()
      request_content = @client.serialize(request_mapper,  export_resource_usage_parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}/exportResourceUsage'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # List labs in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResponseWithContinuationLab] operation results.
    #
    def list_by_subscription_next(next_page_link, custom_headers = nil)
      response = list_by_subscription_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List labs in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_subscription_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_subscription_next_async(next_page_link, custom_headers).value!
    end

    #
    # List labs in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_subscription_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::ResponseWithContinuationLab.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List labs in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResponseWithContinuationLab] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers = nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List labs in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # List labs in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::ResponseWithContinuationLab.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List disk images available for custom image creation.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResponseWithContinuationLabVhd] operation results.
    #
    def list_vhds_next(next_page_link, custom_headers = nil)
      response = list_vhds_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List disk images available for custom image creation.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_vhds_next_with_http_info(next_page_link, custom_headers = nil)
      list_vhds_next_async(next_page_link, custom_headers).value!
    end

    #
    # List disk images available for custom image creation.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_vhds_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::ResponseWithContinuationLabVhd.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List labs in a subscription.
    #
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResponseWithContinuationLab] which provide lazy access to pages of
    # the response.
    #
    def list_by_subscription_as_lazy(expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      response = list_by_subscription_async(expand, filter, top, orderby, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_subscription_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # List labs in a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=defaultStorageAccount)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResponseWithContinuationLab] which provide lazy access to pages of
    # the response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, expand, filter, top, orderby, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_resource_group_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # List disk images available for custom image creation.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param name [String] The name of the lab.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResponseWithContinuationLabVhd] which provide lazy access to pages
    # of the response.
    #
    def list_vhds_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_vhds_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_vhds_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
