# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Network
  #
  # The Microsoft Azure Network management API provides a RESTful set of web
  # services that interact with Microsoft Azure Networks service to manage
  # your network resources. The API has entities that capture the
  # relationship between an end user and the Microsoft Azure Networks service.
  #
  class NetworkInterfaces
    include Azure::ARM::Network::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the NetworkInterfaces class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [NetworkManagementClient] reference to the NetworkManagementClient
    attr_reader :client

    #
    # The delete netwokInterface operation deletes the specified netwokInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, network_interface_name, custom_headers = nil)
      response = delete_async(resource_group_name, network_interface_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, network_interface_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, network_interface_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The delete netwokInterface operation deletes the specified netwokInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, network_interface_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, network_interface_name, custom_headers).value!
      nil
    end

    #
    # The delete netwokInterface operation deletes the specified netwokInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, network_interface_name, custom_headers = nil)
      begin_delete_async(resource_group_name, network_interface_name, custom_headers).value!
    end

    #
    # The delete netwokInterface operation deletes the specified netwokInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, network_interface_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_interface_name is nil' if network_interface_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkInterfaceName' => network_interface_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :delete, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # The Get network interface operation retrieves information about the
    # specified network interface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param expand [String] expand references resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterface] operation results.
    #
    def get(resource_group_name, network_interface_name, expand = nil, custom_headers = nil)
      response = get_async(resource_group_name, network_interface_name, expand, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The Get network interface operation retrieves information about the
    # specified network interface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param expand [String] expand references resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, network_interface_name, expand = nil, custom_headers = nil)
      get_async(resource_group_name, network_interface_name, expand, custom_headers).value!
    end

    #
    # The Get network interface operation retrieves information about the
    # specified network interface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param expand [String] expand references resources.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, network_interface_name, expand = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_interface_name is nil' if network_interface_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkInterfaceName' => network_interface_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version,'$expand' => expand},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterface.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The Put NetworkInterface operation creates/updates a networkInterface
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param parameters [NetworkInterface] Parameters supplied to the
    # create/update NetworkInterface operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterface] operation results.
    #
    def create_or_update(resource_group_name, network_interface_name, parameters, custom_headers = nil)
      response = create_or_update_async(resource_group_name, network_interface_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param parameters [NetworkInterface] Parameters supplied to the
    # create/update NetworkInterface operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, network_interface_name, parameters, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, network_interface_name, parameters, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = NetworkInterface.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The Put NetworkInterface operation creates/updates a networkInterface
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param parameters [NetworkInterface] Parameters supplied to the
    # create/update NetworkInterface operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterface] operation results.
    #
    def begin_create_or_update(resource_group_name, network_interface_name, parameters, custom_headers = nil)
      response = begin_create_or_update_async(resource_group_name, network_interface_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The Put NetworkInterface operation creates/updates a networkInterface
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param parameters [NetworkInterface] Parameters supplied to the
    # create/update NetworkInterface operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, network_interface_name, parameters, custom_headers = nil)
      begin_create_or_update_async(resource_group_name, network_interface_name, parameters, custom_headers).value!
    end

    #
    # The Put NetworkInterface operation creates/updates a networkInterface
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param parameters [NetworkInterface] Parameters supplied to the
    # create/update NetworkInterface operation
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, network_interface_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_interface_name is nil' if network_interface_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = NetworkInterface.mapper()
      request_content = @client.serialize(request_mapper,  parameters, 'parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkInterfaceName' => network_interface_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :put, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterface.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterface.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine from a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param virtualmachine_index [String] The virtual machine index.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterfaceListResult] which provide lazy access to pages of
    # the response.
    #
    def list_virtual_machine_scale_set_vmnetwork_interfaces_as_lazy(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, custom_headers = nil)
      response = list_virtual_machine_scale_set_vmnetwork_interfaces_async(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_virtual_machine_scale_set_vmnetwork_interfaces_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine from a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param virtualmachine_index [String] The virtual machine index.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<NetworkInterface>] operation results.
    #
    def list_virtual_machine_scale_set_vmnetwork_interfaces(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, custom_headers = nil)
      first_page = list_virtual_machine_scale_set_vmnetwork_interfaces_as_lazy(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, custom_headers)
      first_page.get_all_items
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine from a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param virtualmachine_index [String] The virtual machine index.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_virtual_machine_scale_set_vmnetwork_interfaces_with_http_info(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, custom_headers = nil)
      list_virtual_machine_scale_set_vmnetwork_interfaces_async(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, custom_headers).value!
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine from a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param virtualmachine_index [String] The virtual machine index.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_virtual_machine_scale_set_vmnetwork_interfaces_async(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_machine_scale_set_name is nil' if virtual_machine_scale_set_name.nil?
      fail ArgumentError, 'virtualmachine_index is nil' if virtualmachine_index.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualMachineScaleSetName' => virtual_machine_scale_set_name,'virtualmachineIndex' => virtualmachine_index,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterfaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterfaceListResult] which provide lazy access to pages of
    # the response.
    #
    def list_virtual_machine_scale_set_network_interfaces_as_lazy(resource_group_name, virtual_machine_scale_set_name, custom_headers = nil)
      response = list_virtual_machine_scale_set_network_interfaces_async(resource_group_name, virtual_machine_scale_set_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_virtual_machine_scale_set_network_interfaces_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<NetworkInterface>] operation results.
    #
    def list_virtual_machine_scale_set_network_interfaces(resource_group_name, virtual_machine_scale_set_name, custom_headers = nil)
      first_page = list_virtual_machine_scale_set_network_interfaces_as_lazy(resource_group_name, virtual_machine_scale_set_name, custom_headers)
      first_page.get_all_items
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_virtual_machine_scale_set_network_interfaces_with_http_info(resource_group_name, virtual_machine_scale_set_name, custom_headers = nil)
      list_virtual_machine_scale_set_network_interfaces_async(resource_group_name, virtual_machine_scale_set_name, custom_headers).value!
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_virtual_machine_scale_set_network_interfaces_async(resource_group_name, virtual_machine_scale_set_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_machine_scale_set_name is nil' if virtual_machine_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/networkInterfaces'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualMachineScaleSetName' => virtual_machine_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterfaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The Get network interface operation retrieves information about the
    # specified network interface in a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param virtualmachine_index [String] The virtual machine index.
    # @param network_interface_name [String] The name of the network interface.
    # @param expand [String] expand references resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterface] operation results.
    #
    def get_virtual_machine_scale_set_network_interface(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, network_interface_name, expand = nil, custom_headers = nil)
      response = get_virtual_machine_scale_set_network_interface_async(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, network_interface_name, expand, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The Get network interface operation retrieves information about the
    # specified network interface in a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param virtualmachine_index [String] The virtual machine index.
    # @param network_interface_name [String] The name of the network interface.
    # @param expand [String] expand references resources.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_virtual_machine_scale_set_network_interface_with_http_info(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, network_interface_name, expand = nil, custom_headers = nil)
      get_virtual_machine_scale_set_network_interface_async(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, network_interface_name, expand, custom_headers).value!
    end

    #
    # The Get network interface operation retrieves information about the
    # specified network interface in a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the virtual
    # machine scale set.
    # @param virtualmachine_index [String] The virtual machine index.
    # @param network_interface_name [String] The name of the network interface.
    # @param expand [String] expand references resources.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_virtual_machine_scale_set_network_interface_async(resource_group_name, virtual_machine_scale_set_name, virtualmachine_index, network_interface_name, expand = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_machine_scale_set_name is nil' if virtual_machine_scale_set_name.nil?
      fail ArgumentError, 'virtualmachine_index is nil' if virtualmachine_index.nil?
      fail ArgumentError, 'network_interface_name is nil' if network_interface_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines/{virtualmachineIndex}/networkInterfaces/{networkInterfaceName}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualMachineScaleSetName' => virtual_machine_scale_set_name,'virtualmachineIndex' => virtualmachine_index,'networkInterfaceName' => network_interface_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version,'$expand' => expand},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterface.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterfaceListResult] which provide lazy access to pages of
    # the response.
    #
    def list_all_as_lazy(custom_headers = nil)
      response = list_all_async(custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_all_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<NetworkInterface>] operation results.
    #
    def list_all(custom_headers = nil)
      first_page = list_all_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_with_http_info(custom_headers = nil)
      list_all_async(custom_headers).value!
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a subscription.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_async(custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/providers/Microsoft.Network/networkInterfaces'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterfaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterfaceListResult] which provide lazy access to pages of
    # the response.
    #
    def list_as_lazy(resource_group_name, custom_headers = nil)
      response = list_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_link|
          list_next_async(next_link, custom_headers)
        end
        page
      end
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<NetworkInterface>] operation results.
    #
    def list(resource_group_name, custom_headers = nil)
      first_page = list_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, custom_headers = nil)
      list_async(resource_group_name, custom_headers).value!
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterfaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The get effective routetable operation retrieves all the route tables
    # applied on a networkInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EffectiveRouteListResult] operation results.
    #
    def get_effective_route_table(resource_group_name, network_interface_name, custom_headers = nil)
      response = get_effective_route_table_async(resource_group_name, network_interface_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_effective_route_table_async(resource_group_name, network_interface_name, custom_headers = nil)
      # Send request
      promise = begin_get_effective_route_table_async(resource_group_name, network_interface_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = EffectiveRouteListResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The get effective routetable operation retrieves all the route tables
    # applied on a networkInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EffectiveRouteListResult] operation results.
    #
    def begin_get_effective_route_table(resource_group_name, network_interface_name, custom_headers = nil)
      response = begin_get_effective_route_table_async(resource_group_name, network_interface_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The get effective routetable operation retrieves all the route tables
    # applied on a networkInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_effective_route_table_with_http_info(resource_group_name, network_interface_name, custom_headers = nil)
      begin_get_effective_route_table_async(resource_group_name, network_interface_name, custom_headers).value!
    end

    #
    # The get effective routetable operation retrieves all the route tables
    # applied on a networkInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_effective_route_table_async(resource_group_name, network_interface_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_interface_name is nil' if network_interface_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/effectiveRouteTable'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkInterfaceName' => network_interface_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = EffectiveRouteListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The list effective network security group operation retrieves all the
    # network security groups applied on a networkInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EffectiveNetworkSecurityGroupListResult] operation results.
    #
    def list_effective_network_security_groups(resource_group_name, network_interface_name, custom_headers = nil)
      response = list_effective_network_security_groups_async(resource_group_name, network_interface_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_effective_network_security_groups_async(resource_group_name, network_interface_name, custom_headers = nil)
      # Send request
      promise = begin_list_effective_network_security_groups_async(resource_group_name, network_interface_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = EffectiveNetworkSecurityGroupListResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The list effective network security group operation retrieves all the
    # network security groups applied on a networkInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EffectiveNetworkSecurityGroupListResult] operation results.
    #
    def begin_list_effective_network_security_groups(resource_group_name, network_interface_name, custom_headers = nil)
      response = begin_list_effective_network_security_groups_async(resource_group_name, network_interface_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The list effective network security group operation retrieves all the
    # network security groups applied on a networkInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_list_effective_network_security_groups_with_http_info(resource_group_name, network_interface_name, custom_headers = nil)
      begin_list_effective_network_security_groups_async(resource_group_name, network_interface_name, custom_headers).value!
    end

    #
    # The list effective network security group operation retrieves all the
    # network security groups applied on a networkInterface.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_interface_name [String] The name of the network interface.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_list_effective_network_security_groups_async(resource_group_name, network_interface_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_interface_name is nil' if network_interface_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/effectiveNetworkSecurityGroups'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkInterfaceName' => network_interface_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :post, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = EffectiveNetworkSecurityGroupListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine from a virtual machine scale set.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterfaceListResult] operation results.
    #
    def list_virtual_machine_scale_set_vmnetwork_interfaces_next(next_page_link, custom_headers = nil)
      response = list_virtual_machine_scale_set_vmnetwork_interfaces_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine from a virtual machine scale set.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_virtual_machine_scale_set_vmnetwork_interfaces_next_with_http_info(next_page_link, custom_headers = nil)
      list_virtual_machine_scale_set_vmnetwork_interfaces_next_async(next_page_link, custom_headers).value!
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine from a virtual machine scale set.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_virtual_machine_scale_set_vmnetwork_interfaces_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterfaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine scale set.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterfaceListResult] operation results.
    #
    def list_virtual_machine_scale_set_network_interfaces_next(next_page_link, custom_headers = nil)
      response = list_virtual_machine_scale_set_network_interfaces_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine scale set.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_virtual_machine_scale_set_network_interfaces_next_with_http_info(next_page_link, custom_headers = nil)
      list_virtual_machine_scale_set_network_interfaces_next_async(next_page_link, custom_headers).value!
    end

    #
    # The list network interface operation retrieves information about all network
    # interfaces in a virtual machine scale set.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_virtual_machine_scale_set_network_interfaces_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterfaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterfaceListResult] operation results.
    #
    def list_all_next(next_page_link, custom_headers = nil)
      response = list_all_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_next_with_http_info(next_page_link, custom_headers = nil)
      list_all_next_async(next_page_link, custom_headers).value!
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterfaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkInterfaceListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # The List networkInterfaces operation retrieves all the networkInterfaces in
    # a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'
      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {})
      }

      request_url = @base_url || @client.base_url

      request = MsRest::HttpOperationRequest.new(request_url, path_template, :get, options)
      promise = request.run_promise do |req|
        @client.credentials.sign_request(req) unless @client.credentials.nil?
      end

      promise = promise.then do |http_response|
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(request, http_response, error_model)
        end

        # Create Result
        result = MsRestAzure::AzureOperationResponse.new(request, http_response)
        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkInterfaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
