# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::IotHub
  module Models
    #
    # The properties describing a Job Response.
    #
    class JobResponse

      include MsRestAzure

      # @return [String] The job identifier.
      attr_accessor :job_id

      # @return [DateTime] Start time of the Job.
      attr_accessor :start_time_utc

      # @return [DateTime] Represents the time the job stopped processing.
      attr_accessor :end_time_utc

      # @return [JobType] The type of job to execute. Possible values include:
      # 'unknown', 'export', 'import', 'backup', 'readDeviceProperties',
      # 'writeDeviceProperties', 'updateDeviceConfiguration', 'rebootDevice',
      # 'factoryResetDevice', 'firmwareUpdate'
      attr_accessor :type

      # @return [JobStatus] Status of the Job. Possible values include:
      # 'unknown', 'enqueued', 'running', 'completed', 'failed', 'cancelled'
      attr_accessor :status

      # @return [String] If status == failure, this represents a string
      # containing the reason.
      attr_accessor :failure_reason

      # @return [String] The status message for the job.
      attr_accessor :status_message

      # @return [String] The deviceId related to this response.
      attr_accessor :device_id

      # @return [String] The jobId of the parent job, if any.
      attr_accessor :parent_job_id


      #
      # Mapper for JobResponse class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'JobResponse',
          type: {
            name: 'Composite',
            class_name: 'JobResponse',
            model_properties: {
              job_id: {
                required: false,
                serialized_name: 'jobId',
                type: {
                  name: 'String'
                }
              },
              start_time_utc: {
                required: false,
                serialized_name: 'startTimeUtc',
                type: {
                  name: 'DateTime'
                }
              },
              end_time_utc: {
                required: false,
                serialized_name: 'endTimeUtc',
                type: {
                  name: 'DateTime'
                }
              },
              type: {
                required: false,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              status: {
                required: false,
                serialized_name: 'status',
                type: {
                  name: 'Enum',
                  module: 'JobStatus'
                }
              },
              failure_reason: {
                required: false,
                serialized_name: 'failureReason',
                type: {
                  name: 'String'
                }
              },
              status_message: {
                required: false,
                serialized_name: 'statusMessage',
                type: {
                  name: 'String'
                }
              },
              device_id: {
                required: false,
                serialized_name: 'deviceId',
                type: {
                  name: 'String'
                }
              },
              parent_job_id: {
                required: false,
                serialized_name: 'parentJobId',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
