# frozen_string_literal: true

module Gitlab
  class Experiment
    module Caching
      def cache_variant(specified = nil, &block)
        cache = Configuration.cache
        return (specified.presence || yield) unless cache

        key, migrations = cache_strategy
        result = migrated_cache(cache, migrations || [], key) || cache.fetch(key, &block)
        return result unless specified.present?

        cache.write(cache_key, specified) if result != specified
        specified
      end

      def cache_key(key = nil)
        "#{name}:#{key || context.signature[:key]}"
      end

      private

      def cache_strategy
        [cache_key, context.signature[:migration_keys]&.map { |key| cache_key(key) }]
      end

      def migrated_cache(cache, migrations, new_key)
        migrations.find do |old_key|
          next unless (value = cache.read(old_key))

          cache.write(new_key, value)
          cache.delete(old_key)
          break value
        end
      end
    end
  end
end
