require 'fileutils'

gemspec = File.join(File.dirname(__FILE__), 'rails-assets-jquery.gemspec')

spec = Gem::Specification.load(gemspec)
version = spec.version

dir = 'debian/ruby-jquery-rails/usr/share/rubygems-integration/all/specifications'
file = ['rails-assets-jquery-', spec.version, '.gemspec'].join

# filter out debian/ files
spec.files.reject! { |f| f =~ /^debian/ }

FileUtils.mkdir_p dir

File.open(File.join(dir, file), 'w') do |f|
  f.puts spec.to_ruby
end
