/*
 *
 *   magick.h - Ruby interface for ImageMagick
 *
 *   Copyright (C) 2001 Ryuichi Tamura(tam@kais.kyoto-u.ac.jp)
 *
 *   $Date: 2001/08/02 19:14:02 $
 *   $Revision: 1.14 $
 *
 */


#ifndef __MAGICK_H
#define __MAGICK_H

#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include "magick/magick.h"
#include "magick/api.h"
#include "ruby.h"
#include "rubyio.h"

#ifndef TransparentOpacity
#define TransparentOpacity MaxRGB
#endif

/* magick.c */
EXTERN VALUE mMagick;
EXTERN VALUE cImage;

/* magick_private.c */
EXTERN VALUE mPrivate;
EXTERN VALUE cDrawInfo;
EXTERN VALUE cMontageInfo;
EXTERN VALUE cDrawInfo;

/*
 *
 *    MgkImage struct (for Magick::Magick_c_Image)
 *
 */

struct _ImageRef
{
    Image *image;
    ImageInfo *image_info;
};

typedef struct _ImageRef ImageRef;


struct _MgkImage{
    Image *ptr;      /* pointer to the current image of interest */
    ImageRef *ref;
};

typedef struct _MgkImage MgkImage;


#define Get_MgkImage(obj, ptr) {                                \
    Data_Get_Struct(obj, MgkImage, ptr);                        \
    if (!ptr)                                                   \
        rb_raise(rb_eRuntimeError, "released object");          \
}

#define GetInfoStruct(mgk, ptr) {                       \
    ptr = mgk->ref->image_info;                         \
    if (!ptr)                                           \
        rb_raise(rb_eRuntimeError, "empty image_info"); \
}

#define Get_FontMetrics(obj, ptr) {                     \
    Data_Get_Struct(obj, FontMetrics, ptr);             \
    if (!ptr)                                           \
        rb_raise(rb_eRuntimeError, "released object");  \
}

#define Get_DrawInfo(obj, ptr) {                        \
    Data_Get_Struct(obj, DrawInfo, ptr);                \
    if (!ptr)                                           \
        rb_raise(rb_eRuntimeError, "released object");  \
}

#define Get_MontageInfo(obj, ptr) {                             \
    Data_Get_Struct(obj, MontageInfo, ptr);                     \
    if (!ptr)                                                   \
        rb_raise(rb_eRuntimeError, "released object");          \
}

#define Get_QuantizeInfo(obj, ptr) {                             \
    Data_Get_Struct(obj, QuantizeInfo, ptr);                     \
    if (!ptr)                                                    \
        rb_raise(rb_eRuntimeError, "released object");           \
}

#define IsKindOf(obj, klass) {                                   \
    if ( !rb_obj_is_kind_of(obj, klass) ){                       \
        char *name;                                              \
        name = rb_class2name(klass);                             \
        rb_raise(eImageError,                                    \
                 "wrong type of argument(expected %s)", name);   \
    }                                                            \
}



/* magick.c */

EXTERN void mgk_warn _((const ExceptionType, const char*, const char*));
EXTERN void mgk_raise _((const ExceptionType, const char*, const char*));
EXTERN void check_exception _((Image*, ExceptionInfo*));

/* magick_attr.c */

EXTERN void mgk_set_attr _((MgkImage*, const VALUE));
EXTERN VALUE mgk_get_attr _((MgkImage*, const VALUE));

/* magick_enums.c */

EXTERN VALUE mClassType;
EXTERN VALUE mColorspaceType;
EXTERN VALUE mCompositeOp;
EXTERN VALUE mCompressionType;
EXTERN VALUE mDecorationType;
EXTERN VALUE mFilterTypes;
EXTERN VALUE mGravityType;
/* EXTERN VALUE mImageType; */
EXTERN VALUE mInterlaceType;
EXTERN VALUE mNoiseType;
EXTERN VALUE mPaintMethod;
EXTERN VALUE mPreviewType;
/* EXTERN VALUE mQuantumType; */
EXTERN VALUE mRenderingIntent;
EXTERN VALUE mResolutionType;

/* magick_private.c */

EXTERN VALUE mgk_do_get_font_metrics _((VALUE, VALUE));

#endif /* __MAGICK_H */
