// Copyright 2012-2018 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs, non_upper_case_globals, non_snake_case)]

/// The version of [Unicode](http://www.unicode.org/)
/// that this version of unicode-segmentation is based on.
pub const UNICODE_VERSION: (u64, u64, u64) = (12, 0, 0);

use core::convert::TryFrom;
#[derive(Clone, Copy, PartialEq, Eq, Debug, Hash)]
#[non_exhaustive]
#[allow(non_camel_case_types)]
/// A value of the Script property
pub enum Script {
    /// Unknown script
    Unknown,
    /// Tang
    Tangut,
    /// Thaa
    Thaana,
    /// Adlm
    Adlam,
    /// Telu
    Telugu,
    /// Cyrl
    Cyrillic,
    /// Zanb
    Zanabazar_Square,
    /// Hang
    Hangul,
    /// Hmnp
    Nyiakeng_Puachue_Hmong,
    /// Sarb
    Old_South_Arabian,
    /// Ethi
    Ethiopic,
    /// Zinh
    Inherited,
    /// Merc
    Meroitic_Cursive,
    /// Bhks
    Bhaiksuki,
    /// Ahom
    Ahom,
    /// Hani
    Han,
    /// Narb
    Old_North_Arabian,
    /// Armn
    Armenian,
    /// Taml
    Tamil,
    /// Bopo
    Bopomofo,
    /// Bass
    Bassa_Vah,
    /// Sund
    Sundanese,
    /// Osge
    Osage,
    /// Sogo
    Old_Sogdian,
    /// Tglg
    Tagalog,
    /// Mlym
    Malayalam,
    /// Marc
    Marchen,
    /// Cari
    Carian,
    /// Hira
    Hiragana,
    /// Tagb
    Tagbanwa,
    /// Mtei
    Meetei_Mayek,
    /// Rohg
    Hanifi_Rohingya,
    /// Hmng
    Pahawh_Hmong,
    /// Tale
    Tai_Le,
    /// Kali
    Kayah_Li,
    /// Bugi
    Buginese,
    /// Khar
    Kharoshthi,
    /// Lana
    Tai_Tham,
    /// Ital
    Old_Italic,
    /// Xpeo
    Old_Persian,
    /// Wara
    Warang_Citi,
    /// Latn
    Latin,
    /// Saur
    Saurashtra,
    /// Shaw
    Shavian,
    /// Geor
    Georgian,
    /// Gran
    Grantha,
    /// Dupl
    Duployan,
    /// Batk
    Batak,
    /// Deva
    Devanagari,
    /// Thai
    Thai,
    /// Tibt
    Tibetan,
    /// Tfng
    Tifinagh,
    /// Elym
    Elymaic,
    /// Ugar
    Ugaritic,
    /// Brai
    Braille,
    /// Hluw
    Anatolian_Hieroglyphs,
    /// Grek
    Greek,
    /// Lyci
    Lycian,
    /// Mend
    Mende_Kikakui,
    /// Tavt
    Tai_Viet,
    /// Vaii
    Vai,
    /// Ogam
    Ogham,
    /// Prti
    Inscriptional_Parthian,
    /// Cham
    Cham,
    /// Syrc
    Syriac,
    /// Runr
    Runic,
    /// Goth
    Gothic,
    /// Mahj
    Mahajani,
    /// Kana
    Katakana,
    /// Osma
    Osmanya,
    /// Talu
    New_Tai_Lue,
    /// Olck
    Ol_Chiki,
    /// Newa
    Newa,
    /// Limb
    Limbu,
    /// Pauc
    Pau_Cin_Hau,
    /// Cher
    Cherokee,
    /// Plrd
    Miao,
    /// Orya
    Oriya,
    /// Medf
    Medefaidrin,
    /// Shrd
    Sharada,
    /// Gujr
    Gujarati,
    /// Nshu
    Nushu,
    /// Modi
    Modi,
    /// Gong
    Gunjala_Gondi,
    /// Phli
    Inscriptional_Pahlavi,
    /// Mani
    Manichaean,
    /// Khmr
    Khmer,
    /// Xsux
    Cuneiform,
    /// Sind
    Khudawadi,
    /// Mand
    Mandaic,
    /// Hatr
    Hatran,
    /// Sylo
    Syloti_Nagri,
    /// Nkoo
    Nko,
    /// Cans
    Canadian_Aboriginal,
    /// Mero
    Meroitic_Hieroglyphs,
    /// Phnx
    Phoenician,
    /// Nbat
    Nabataean,
    /// Wcho
    Wancho,
    /// Beng
    Bengali,
    /// Kthi
    Kaithi,
    /// Glag
    Glagolitic,
    /// Armi
    Imperial_Aramaic,
    /// Sora
    Sora_Sompeng,
    /// Guru
    Gurmukhi,
    /// Java
    Javanese,
    /// Perm
    Old_Permic,
    /// Phag
    Phags_Pa,
    /// Cprt
    Cypriot,
    /// Knda
    Kannada,
    /// Khoj
    Khojki,
    /// Mong
    Mongolian,
    /// Sinh
    Sinhala,
    /// Brah
    Brahmi,
    /// Elba
    Elbasan,
    /// Dsrt
    Deseret,
    /// Rjng
    Rejang,
    /// Sgnw
    SignWriting,
    /// Mult
    Multani,
    /// Yiii
    Yi,
    /// Bali
    Balinese,
    /// Laoo
    Lao,
    /// Hano
    Hanunoo,
    /// Gonm
    Masaram_Gondi,
    /// Linb
    Linear_B,
    /// Lina
    Linear_A,
    /// Dogr
    Dogra,
    /// Orkh
    Old_Turkic,
    /// Lepc
    Lepcha,
    /// Lydi
    Lydian,
    /// Egyp
    Egyptian_Hieroglyphs,
    /// Sogd
    Sogdian,
    /// Aghb
    Caucasian_Albanian,
    /// Nand
    Nandinagari,
    /// Maka
    Makasar,
    /// Hung
    Old_Hungarian,
    /// Samr
    Samaritan,
    /// Lisu
    Lisu,
    /// Buhd
    Buhid,
    /// Palm
    Palmyrene,
    /// Tirh
    Tirhuta,
    /// Mroo
    Mro,
    /// Zyyy
    Common,
    /// Copt
    Coptic,
    /// Cakm
    Chakma,
    /// Arab
    Arabic,
    /// Bamu
    Bamum,
    /// Mymr
    Myanmar,
    /// Sidd
    Siddham,
    /// Soyo
    Soyombo,
    /// Avst
    Avestan,
    /// Hebr
    Hebrew,
    /// Phlp
    Psalter_Pahlavi,
    /// Takr
    Takri,
}
#[derive(Clone, Copy, PartialEq, Eq, Debug, Hash)]
#[non_exhaustive]
/// A value for the Script_Extension property
///
/// Script_Extension is one or more Script
/// This is essentially an optimized version of Vec<Script>,
/// optimized by script sets actually present in Unicode.
pub enum ScriptExtension {
    /// A single script
    Single(Script),
    /// Devanagari, Grantha
    DevaGran,
    /// Cypriot, Linear_A, Linear_B
    CprtLinaLinb,
    /// Arabic, Thaana
    ArabThaa,
    /// Han, Hiragana, Katakana
    HaniHiraKana,
    /// Bengali, Devanagari, Dogra, Gunjala_Gondi, Masaram_Gondi, Grantha, Gujarati, Gurmukhi, Kannada, Mahajani, Malayalam, Nandinagari, Oriya, Khudawadi, Sinhala, Syloti_Nagri, Takri, Tamil, Telugu, Tirhuta
    BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh,
    /// Armenian, Georgian
    ArmnGeor,
    /// Bengali, Devanagari, Grantha, Gujarati, Gurmukhi, Kannada, Latin, Malayalam, Oriya, Sharada, Tamil, Telugu, Tirhuta
    BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh,
    /// Cyrillic, Latin
    CyrlLatn,
    /// Devanagari, Dogra, Gujarati, Gurmukhi, Khojki, Kannada, Kaithi, Mahajani, Malayalam, Modi, Nandinagari, Khudawadi, Takri, Tirhuta
    DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh,
    /// Arabic, Hanifi_Rohingya
    ArabRohg,
    /// Devanagari, Dogra, Gujarati, Gurmukhi, Khojki, Kaithi, Mahajani, Modi, Khudawadi, Takri, Tirhuta
    DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh,
    /// Buginese, Javanese
    BugiJava,
    /// Georgian, Latin
    GeorLatn,
    /// Arabic, Hanifi_Rohingya, Syriac, Thaana
    ArabRohgSyrcThaa,
    /// Devanagari, Dogra, Kaithi, Mahajani
    DevaDogrKthiMahj,
    /// Adlam, Arabic, Mandaic, Manichaean, Psalter_Pahlavi, Hanifi_Rohingya, Sogdian, Syriac
    AdlmArabMandManiPhlpRohgSogdSyrc,
    /// Kayah_Li, Latin, Myanmar
    KaliLatnMymr,
    /// Bengali, Devanagari, Grantha, Kannada
    BengDevaGranKnda,
    /// Devanagari, Tamil
    DevaTaml,
    /// Kannada, Nandinagari
    KndaNand,
    /// Bopomofo, Hangul, Han, Hiragana, Katakana
    BopoHangHaniHiraKana,
    /// Arabic, Syriac, Thaana
    ArabSyrcThaa,
    /// Devanagari, Grantha, Kannada
    DevaGranKnda,
    /// Bengali, Chakma, Syloti_Nagri
    BengCakmSylo,
    /// Gurmukhi, Multani
    GuruMult,
    /// Devanagari, Kannada, Malayalam, Oriya, Tamil, Telugu
    DevaKndaMlymOryaTamlTelu,
    /// Gujarati, Khojki
    GujrKhoj,
    /// Cyrillic, Old_Permic
    CyrlPerm,
    /// Devanagari, Dogra, Gujarati, Gurmukhi, Khojki, Kannada, Kaithi, Mahajani, Modi, Nandinagari, Khudawadi, Takri, Tirhuta
    DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh,
    /// Hiragana, Katakana
    HiraKana,
    /// Devanagari, Nandinagari
    DevaNand,
    /// Cypriot, Linear_B
    CprtLinb,
    /// Devanagari, Grantha, Latin
    DevaGranLatn,
    /// Buhid, Hanunoo, Tagbanwa, Tagalog
    BuhdHanoTagbTglg,
    /// Bengali, Devanagari, Dogra, Gunjala_Gondi, Masaram_Gondi, Grantha, Gujarati, Gurmukhi, Kannada, Limbu, Mahajani, Malayalam, Nandinagari, Oriya, Khudawadi, Sinhala, Syloti_Nagri, Takri, Tamil, Telugu, Tirhuta
    BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh,
    /// Arabic, Syriac
    ArabSyrc,
    /// Grantha, Tamil
    GranTaml,
    /// Bopomofo, Hangul, Han, Hiragana, Katakana, Yi
    BopoHangHaniHiraKanaYiii,
    /// Chakma, Myanmar, Tai_Le
    CakmMymrTale,
    /// Bengali, Devanagari
    BengDeva,
    /// Bengali, Devanagari, Grantha, Kannada, Nandinagari, Oriya, Telugu, Tirhuta
    BengDevaGranKndaNandOryaTeluTirh,
    /// Latin, Mongolian
    LatnMong,
    /// Bengali, Devanagari, Grantha, Gujarati, Gurmukhi, Kannada, Latin, Malayalam, Oriya, Tamil, Telugu, Tirhuta
    BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh,
    /// Bopomofo, Han
    BopoHani,
    /// Arabic, Coptic
    ArabCopt,
    /// Devanagari, Sharada
    DevaShrd,
    /// Mongolian, Phags_Pa
    MongPhag,
    /// Cyrillic, Glagolitic
    CyrlGlag,
    /// Devanagari, Kannada, Tirhuta
    DevaKndaTirh,
    /// Bengali, Devanagari, Grantha, Gujarati, Gurmukhi, Kannada, Malayalam, Oriya, Tamil, Telugu, Tirhuta
    BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
    /// Devanagari, Dogra, Gujarati, Gurmukhi, Kannada, Mahajani, Malayalam, Nandinagari, Khudawadi, Takri, Tirhuta
    DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
    /// Devanagari, Dogra, Gujarati, Gurmukhi, Mahajani, Khudawadi, Takri, Tirhuta
    DevaDogrGujrGuruMahjSindTakrTirh,
    /// Devanagari, Dogra, Mahajani
    DevaDogrMahj,
    /// Bengali, Syloti_Nagri
    BengSylo,
    /// Devanagari, Dogra, Gujarati, Gurmukhi, Kannada, Mahajani, Nandinagari, Khudawadi, Takri, Tirhuta
    DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
    /// Devanagari, Gujarati, Gurmukhi, Kannada, Malayalam, Tirhuta
    DevaGujrGuruKndaMlymTirh,
    /// Devanagari, Gujarati, Gurmukhi, Tirhuta
    DevaGujrGuruTirh,
    /// Devanagari, Gujarati, Gurmukhi, Kannada, Tirhuta
    DevaGujrGuruKndaTirh,
    /// Bengali, Devanagari, Grantha, Kannada, Oriya, Telugu, Tirhuta
    BengDevaGranKndaOryaTeluTirh,
    /// Devanagari, Kannada
    DevaKnda,
    /// Devanagari, Kannada, Malayalam
    DevaKndaMlym,
    /// Devanagari, Kannada, Nandinagari, Tirhuta
    DevaKndaNandTirh,
    /// Devanagari, Tirhuta
    DevaTirh,
    /// Arabic, Hanifi_Rohingya, Syriac
    ArabRohgSyrc,
    /// Devanagari, Kannada, Oriya, Telugu
    DevaKndaOryaTelu,
}

impl From<Script> for ScriptExtension {
    fn from(script: Script) -> Self {
        ScriptExtension::Single(script)
    }
}

impl TryFrom<ScriptExtension> for Script {
    type Error = ();
    fn try_from(ext: ScriptExtension) -> Result<Self, ()> {
        match ext {
            ScriptExtension::Single(s) => Ok(s),
            _ => Err(())
        }
    }
}

impl Script {
    pub(crate) fn inner_full_name(self) -> &'static str {
        match self {
            Script::Unknown => "Unknown",
            Script::Tangut => "Tangut",
            Script::Thaana => "Thaana",
            Script::Adlam => "Adlam",
            Script::Telugu => "Telugu",
            Script::Cyrillic => "Cyrillic",
            Script::Zanabazar_Square => "Zanabazar_Square",
            Script::Hangul => "Hangul",
            Script::Nyiakeng_Puachue_Hmong => "Nyiakeng_Puachue_Hmong",
            Script::Old_South_Arabian => "Old_South_Arabian",
            Script::Ethiopic => "Ethiopic",
            Script::Inherited => "Inherited",
            Script::Meroitic_Cursive => "Meroitic_Cursive",
            Script::Bhaiksuki => "Bhaiksuki",
            Script::Ahom => "Ahom",
            Script::Han => "Han",
            Script::Old_North_Arabian => "Old_North_Arabian",
            Script::Armenian => "Armenian",
            Script::Tamil => "Tamil",
            Script::Bopomofo => "Bopomofo",
            Script::Bassa_Vah => "Bassa_Vah",
            Script::Sundanese => "Sundanese",
            Script::Osage => "Osage",
            Script::Old_Sogdian => "Old_Sogdian",
            Script::Tagalog => "Tagalog",
            Script::Malayalam => "Malayalam",
            Script::Marchen => "Marchen",
            Script::Carian => "Carian",
            Script::Hiragana => "Hiragana",
            Script::Tagbanwa => "Tagbanwa",
            Script::Meetei_Mayek => "Meetei_Mayek",
            Script::Hanifi_Rohingya => "Hanifi_Rohingya",
            Script::Pahawh_Hmong => "Pahawh_Hmong",
            Script::Tai_Le => "Tai_Le",
            Script::Kayah_Li => "Kayah_Li",
            Script::Buginese => "Buginese",
            Script::Kharoshthi => "Kharoshthi",
            Script::Tai_Tham => "Tai_Tham",
            Script::Old_Italic => "Old_Italic",
            Script::Old_Persian => "Old_Persian",
            Script::Warang_Citi => "Warang_Citi",
            Script::Latin => "Latin",
            Script::Saurashtra => "Saurashtra",
            Script::Shavian => "Shavian",
            Script::Georgian => "Georgian",
            Script::Grantha => "Grantha",
            Script::Duployan => "Duployan",
            Script::Batak => "Batak",
            Script::Devanagari => "Devanagari",
            Script::Thai => "Thai",
            Script::Tibetan => "Tibetan",
            Script::Tifinagh => "Tifinagh",
            Script::Elymaic => "Elymaic",
            Script::Ugaritic => "Ugaritic",
            Script::Braille => "Braille",
            Script::Anatolian_Hieroglyphs => "Anatolian_Hieroglyphs",
            Script::Greek => "Greek",
            Script::Lycian => "Lycian",
            Script::Mende_Kikakui => "Mende_Kikakui",
            Script::Tai_Viet => "Tai_Viet",
            Script::Vai => "Vai",
            Script::Ogham => "Ogham",
            Script::Inscriptional_Parthian => "Inscriptional_Parthian",
            Script::Cham => "Cham",
            Script::Syriac => "Syriac",
            Script::Runic => "Runic",
            Script::Gothic => "Gothic",
            Script::Mahajani => "Mahajani",
            Script::Katakana => "Katakana",
            Script::Osmanya => "Osmanya",
            Script::New_Tai_Lue => "New_Tai_Lue",
            Script::Ol_Chiki => "Ol_Chiki",
            Script::Newa => "Newa",
            Script::Limbu => "Limbu",
            Script::Pau_Cin_Hau => "Pau_Cin_Hau",
            Script::Cherokee => "Cherokee",
            Script::Miao => "Miao",
            Script::Oriya => "Oriya",
            Script::Medefaidrin => "Medefaidrin",
            Script::Sharada => "Sharada",
            Script::Gujarati => "Gujarati",
            Script::Nushu => "Nushu",
            Script::Modi => "Modi",
            Script::Gunjala_Gondi => "Gunjala_Gondi",
            Script::Inscriptional_Pahlavi => "Inscriptional_Pahlavi",
            Script::Manichaean => "Manichaean",
            Script::Khmer => "Khmer",
            Script::Cuneiform => "Cuneiform",
            Script::Khudawadi => "Khudawadi",
            Script::Mandaic => "Mandaic",
            Script::Hatran => "Hatran",
            Script::Syloti_Nagri => "Syloti_Nagri",
            Script::Nko => "Nko",
            Script::Canadian_Aboriginal => "Canadian_Aboriginal",
            Script::Meroitic_Hieroglyphs => "Meroitic_Hieroglyphs",
            Script::Phoenician => "Phoenician",
            Script::Nabataean => "Nabataean",
            Script::Wancho => "Wancho",
            Script::Bengali => "Bengali",
            Script::Kaithi => "Kaithi",
            Script::Glagolitic => "Glagolitic",
            Script::Imperial_Aramaic => "Imperial_Aramaic",
            Script::Sora_Sompeng => "Sora_Sompeng",
            Script::Gurmukhi => "Gurmukhi",
            Script::Javanese => "Javanese",
            Script::Old_Permic => "Old_Permic",
            Script::Phags_Pa => "Phags_Pa",
            Script::Cypriot => "Cypriot",
            Script::Kannada => "Kannada",
            Script::Khojki => "Khojki",
            Script::Mongolian => "Mongolian",
            Script::Sinhala => "Sinhala",
            Script::Brahmi => "Brahmi",
            Script::Elbasan => "Elbasan",
            Script::Deseret => "Deseret",
            Script::Rejang => "Rejang",
            Script::SignWriting => "SignWriting",
            Script::Multani => "Multani",
            Script::Yi => "Yi",
            Script::Balinese => "Balinese",
            Script::Lao => "Lao",
            Script::Hanunoo => "Hanunoo",
            Script::Masaram_Gondi => "Masaram_Gondi",
            Script::Linear_B => "Linear_B",
            Script::Linear_A => "Linear_A",
            Script::Dogra => "Dogra",
            Script::Old_Turkic => "Old_Turkic",
            Script::Lepcha => "Lepcha",
            Script::Lydian => "Lydian",
            Script::Egyptian_Hieroglyphs => "Egyptian_Hieroglyphs",
            Script::Sogdian => "Sogdian",
            Script::Caucasian_Albanian => "Caucasian_Albanian",
            Script::Nandinagari => "Nandinagari",
            Script::Makasar => "Makasar",
            Script::Old_Hungarian => "Old_Hungarian",
            Script::Samaritan => "Samaritan",
            Script::Lisu => "Lisu",
            Script::Buhid => "Buhid",
            Script::Palmyrene => "Palmyrene",
            Script::Tirhuta => "Tirhuta",
            Script::Mro => "Mro",
            Script::Common => "Common",
            Script::Coptic => "Coptic",
            Script::Chakma => "Chakma",
            Script::Arabic => "Arabic",
            Script::Bamum => "Bamum",
            Script::Myanmar => "Myanmar",
            Script::Siddham => "Siddham",
            Script::Soyombo => "Soyombo",
            Script::Avestan => "Avestan",
            Script::Hebrew => "Hebrew",
            Script::Psalter_Pahlavi => "Psalter_Pahlavi",
            Script::Takri => "Takri",
        }
    }

    pub(crate) fn inner_short_name(self) -> &'static str {
        match self {
            Script::Unknown => "",
            Script::Tangut => "Tang",
            Script::Thaana => "Thaa",
            Script::Adlam => "Adlm",
            Script::Telugu => "Telu",
            Script::Cyrillic => "Cyrl",
            Script::Zanabazar_Square => "Zanb",
            Script::Hangul => "Hang",
            Script::Nyiakeng_Puachue_Hmong => "Hmnp",
            Script::Old_South_Arabian => "Sarb",
            Script::Ethiopic => "Ethi",
            Script::Inherited => "Zinh",
            Script::Meroitic_Cursive => "Merc",
            Script::Bhaiksuki => "Bhks",
            Script::Ahom => "Ahom",
            Script::Han => "Hani",
            Script::Old_North_Arabian => "Narb",
            Script::Armenian => "Armn",
            Script::Tamil => "Taml",
            Script::Bopomofo => "Bopo",
            Script::Bassa_Vah => "Bass",
            Script::Sundanese => "Sund",
            Script::Osage => "Osge",
            Script::Old_Sogdian => "Sogo",
            Script::Tagalog => "Tglg",
            Script::Malayalam => "Mlym",
            Script::Marchen => "Marc",
            Script::Carian => "Cari",
            Script::Hiragana => "Hira",
            Script::Tagbanwa => "Tagb",
            Script::Meetei_Mayek => "Mtei",
            Script::Hanifi_Rohingya => "Rohg",
            Script::Pahawh_Hmong => "Hmng",
            Script::Tai_Le => "Tale",
            Script::Kayah_Li => "Kali",
            Script::Buginese => "Bugi",
            Script::Kharoshthi => "Khar",
            Script::Tai_Tham => "Lana",
            Script::Old_Italic => "Ital",
            Script::Old_Persian => "Xpeo",
            Script::Warang_Citi => "Wara",
            Script::Latin => "Latn",
            Script::Saurashtra => "Saur",
            Script::Shavian => "Shaw",
            Script::Georgian => "Geor",
            Script::Grantha => "Gran",
            Script::Duployan => "Dupl",
            Script::Batak => "Batk",
            Script::Devanagari => "Deva",
            Script::Thai => "Thai",
            Script::Tibetan => "Tibt",
            Script::Tifinagh => "Tfng",
            Script::Elymaic => "Elym",
            Script::Ugaritic => "Ugar",
            Script::Braille => "Brai",
            Script::Anatolian_Hieroglyphs => "Hluw",
            Script::Greek => "Grek",
            Script::Lycian => "Lyci",
            Script::Mende_Kikakui => "Mend",
            Script::Tai_Viet => "Tavt",
            Script::Vai => "Vaii",
            Script::Ogham => "Ogam",
            Script::Inscriptional_Parthian => "Prti",
            Script::Cham => "Cham",
            Script::Syriac => "Syrc",
            Script::Runic => "Runr",
            Script::Gothic => "Goth",
            Script::Mahajani => "Mahj",
            Script::Katakana => "Kana",
            Script::Osmanya => "Osma",
            Script::New_Tai_Lue => "Talu",
            Script::Ol_Chiki => "Olck",
            Script::Newa => "Newa",
            Script::Limbu => "Limb",
            Script::Pau_Cin_Hau => "Pauc",
            Script::Cherokee => "Cher",
            Script::Miao => "Plrd",
            Script::Oriya => "Orya",
            Script::Medefaidrin => "Medf",
            Script::Sharada => "Shrd",
            Script::Gujarati => "Gujr",
            Script::Nushu => "Nshu",
            Script::Modi => "Modi",
            Script::Gunjala_Gondi => "Gong",
            Script::Inscriptional_Pahlavi => "Phli",
            Script::Manichaean => "Mani",
            Script::Khmer => "Khmr",
            Script::Cuneiform => "Xsux",
            Script::Khudawadi => "Sind",
            Script::Mandaic => "Mand",
            Script::Hatran => "Hatr",
            Script::Syloti_Nagri => "Sylo",
            Script::Nko => "Nkoo",
            Script::Canadian_Aboriginal => "Cans",
            Script::Meroitic_Hieroglyphs => "Mero",
            Script::Phoenician => "Phnx",
            Script::Nabataean => "Nbat",
            Script::Wancho => "Wcho",
            Script::Bengali => "Beng",
            Script::Kaithi => "Kthi",
            Script::Glagolitic => "Glag",
            Script::Imperial_Aramaic => "Armi",
            Script::Sora_Sompeng => "Sora",
            Script::Gurmukhi => "Guru",
            Script::Javanese => "Java",
            Script::Old_Permic => "Perm",
            Script::Phags_Pa => "Phag",
            Script::Cypriot => "Cprt",
            Script::Kannada => "Knda",
            Script::Khojki => "Khoj",
            Script::Mongolian => "Mong",
            Script::Sinhala => "Sinh",
            Script::Brahmi => "Brah",
            Script::Elbasan => "Elba",
            Script::Deseret => "Dsrt",
            Script::Rejang => "Rjng",
            Script::SignWriting => "Sgnw",
            Script::Multani => "Mult",
            Script::Yi => "Yiii",
            Script::Balinese => "Bali",
            Script::Lao => "Laoo",
            Script::Hanunoo => "Hano",
            Script::Masaram_Gondi => "Gonm",
            Script::Linear_B => "Linb",
            Script::Linear_A => "Lina",
            Script::Dogra => "Dogr",
            Script::Old_Turkic => "Orkh",
            Script::Lepcha => "Lepc",
            Script::Lydian => "Lydi",
            Script::Egyptian_Hieroglyphs => "Egyp",
            Script::Sogdian => "Sogd",
            Script::Caucasian_Albanian => "Aghb",
            Script::Nandinagari => "Nand",
            Script::Makasar => "Maka",
            Script::Old_Hungarian => "Hung",
            Script::Samaritan => "Samr",
            Script::Lisu => "Lisu",
            Script::Buhid => "Buhd",
            Script::Palmyrene => "Palm",
            Script::Tirhuta => "Tirh",
            Script::Mro => "Mroo",
            Script::Common => "Zyyy",
            Script::Coptic => "Copt",
            Script::Chakma => "Cakm",
            Script::Arabic => "Arab",
            Script::Bamum => "Bamu",
            Script::Myanmar => "Mymr",
            Script::Siddham => "Sidd",
            Script::Soyombo => "Soyo",
            Script::Avestan => "Avst",
            Script::Hebrew => "Hebr",
            Script::Psalter_Pahlavi => "Phlp",
            Script::Takri => "Takr",
        }
    }
}

impl ScriptExtension {
    #[inline]
    #[cfg(feature = "with_std")]
    pub(crate) fn inner_scripts(self) -> Vec<Script> {
        match self {
            ScriptExtension::Single(s) => vec![s],
            ScriptExtension::DevaGran => vec![Script::Devanagari, Script::Grantha],
            ScriptExtension::CprtLinaLinb => vec![Script::Cypriot, Script::Linear_A, Script::Linear_B],
            ScriptExtension::ArabThaa => vec![Script::Arabic, Script::Thaana],
            ScriptExtension::HaniHiraKana => vec![Script::Han, Script::Hiragana, Script::Katakana],
            ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh => vec![Script::Bengali, Script::Devanagari, Script::Dogra, Script::Gunjala_Gondi, Script::Masaram_Gondi, Script::Grantha, Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Mahajani, Script::Malayalam, Script::Nandinagari, Script::Oriya, Script::Khudawadi, Script::Sinhala, Script::Syloti_Nagri, Script::Takri, Script::Tamil, Script::Telugu, Script::Tirhuta],
            ScriptExtension::ArmnGeor => vec![Script::Armenian, Script::Georgian],
            ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh => vec![Script::Bengali, Script::Devanagari, Script::Grantha, Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Latin, Script::Malayalam, Script::Oriya, Script::Sharada, Script::Tamil, Script::Telugu, Script::Tirhuta],
            ScriptExtension::CyrlLatn => vec![Script::Cyrillic, Script::Latin],
            ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh => vec![Script::Devanagari, Script::Dogra, Script::Gujarati, Script::Gurmukhi, Script::Khojki, Script::Kannada, Script::Kaithi, Script::Mahajani, Script::Malayalam, Script::Modi, Script::Nandinagari, Script::Khudawadi, Script::Takri, Script::Tirhuta],
            ScriptExtension::ArabRohg => vec![Script::Arabic, Script::Hanifi_Rohingya],
            ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh => vec![Script::Devanagari, Script::Dogra, Script::Gujarati, Script::Gurmukhi, Script::Khojki, Script::Kaithi, Script::Mahajani, Script::Modi, Script::Khudawadi, Script::Takri, Script::Tirhuta],
            ScriptExtension::BugiJava => vec![Script::Buginese, Script::Javanese],
            ScriptExtension::GeorLatn => vec![Script::Georgian, Script::Latin],
            ScriptExtension::ArabRohgSyrcThaa => vec![Script::Arabic, Script::Hanifi_Rohingya, Script::Syriac, Script::Thaana],
            ScriptExtension::DevaDogrKthiMahj => vec![Script::Devanagari, Script::Dogra, Script::Kaithi, Script::Mahajani],
            ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc => vec![Script::Adlam, Script::Arabic, Script::Mandaic, Script::Manichaean, Script::Psalter_Pahlavi, Script::Hanifi_Rohingya, Script::Sogdian, Script::Syriac],
            ScriptExtension::KaliLatnMymr => vec![Script::Kayah_Li, Script::Latin, Script::Myanmar],
            ScriptExtension::BengDevaGranKnda => vec![Script::Bengali, Script::Devanagari, Script::Grantha, Script::Kannada],
            ScriptExtension::DevaTaml => vec![Script::Devanagari, Script::Tamil],
            ScriptExtension::KndaNand => vec![Script::Kannada, Script::Nandinagari],
            ScriptExtension::BopoHangHaniHiraKana => vec![Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana],
            ScriptExtension::ArabSyrcThaa => vec![Script::Arabic, Script::Syriac, Script::Thaana],
            ScriptExtension::DevaGranKnda => vec![Script::Devanagari, Script::Grantha, Script::Kannada],
            ScriptExtension::BengCakmSylo => vec![Script::Bengali, Script::Chakma, Script::Syloti_Nagri],
            ScriptExtension::GuruMult => vec![Script::Gurmukhi, Script::Multani],
            ScriptExtension::DevaKndaMlymOryaTamlTelu => vec![Script::Devanagari, Script::Kannada, Script::Malayalam, Script::Oriya, Script::Tamil, Script::Telugu],
            ScriptExtension::GujrKhoj => vec![Script::Gujarati, Script::Khojki],
            ScriptExtension::CyrlPerm => vec![Script::Cyrillic, Script::Old_Permic],
            ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh => vec![Script::Devanagari, Script::Dogra, Script::Gujarati, Script::Gurmukhi, Script::Khojki, Script::Kannada, Script::Kaithi, Script::Mahajani, Script::Modi, Script::Nandinagari, Script::Khudawadi, Script::Takri, Script::Tirhuta],
            ScriptExtension::HiraKana => vec![Script::Hiragana, Script::Katakana],
            ScriptExtension::DevaNand => vec![Script::Devanagari, Script::Nandinagari],
            ScriptExtension::CprtLinb => vec![Script::Cypriot, Script::Linear_B],
            ScriptExtension::DevaGranLatn => vec![Script::Devanagari, Script::Grantha, Script::Latin],
            ScriptExtension::BuhdHanoTagbTglg => vec![Script::Buhid, Script::Hanunoo, Script::Tagbanwa, Script::Tagalog],
            ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh => vec![Script::Bengali, Script::Devanagari, Script::Dogra, Script::Gunjala_Gondi, Script::Masaram_Gondi, Script::Grantha, Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Limbu, Script::Mahajani, Script::Malayalam, Script::Nandinagari, Script::Oriya, Script::Khudawadi, Script::Sinhala, Script::Syloti_Nagri, Script::Takri, Script::Tamil, Script::Telugu, Script::Tirhuta],
            ScriptExtension::ArabSyrc => vec![Script::Arabic, Script::Syriac],
            ScriptExtension::GranTaml => vec![Script::Grantha, Script::Tamil],
            ScriptExtension::BopoHangHaniHiraKanaYiii => vec![Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi],
            ScriptExtension::CakmMymrTale => vec![Script::Chakma, Script::Myanmar, Script::Tai_Le],
            ScriptExtension::BengDeva => vec![Script::Bengali, Script::Devanagari],
            ScriptExtension::BengDevaGranKndaNandOryaTeluTirh => vec![Script::Bengali, Script::Devanagari, Script::Grantha, Script::Kannada, Script::Nandinagari, Script::Oriya, Script::Telugu, Script::Tirhuta],
            ScriptExtension::LatnMong => vec![Script::Latin, Script::Mongolian],
            ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh => vec![Script::Bengali, Script::Devanagari, Script::Grantha, Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Latin, Script::Malayalam, Script::Oriya, Script::Tamil, Script::Telugu, Script::Tirhuta],
            ScriptExtension::BopoHani => vec![Script::Bopomofo, Script::Han],
            ScriptExtension::ArabCopt => vec![Script::Arabic, Script::Coptic],
            ScriptExtension::DevaShrd => vec![Script::Devanagari, Script::Sharada],
            ScriptExtension::MongPhag => vec![Script::Mongolian, Script::Phags_Pa],
            ScriptExtension::CyrlGlag => vec![Script::Cyrillic, Script::Glagolitic],
            ScriptExtension::DevaKndaTirh => vec![Script::Devanagari, Script::Kannada, Script::Tirhuta],
            ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh => vec![Script::Bengali, Script::Devanagari, Script::Grantha, Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Malayalam, Script::Oriya, Script::Tamil, Script::Telugu, Script::Tirhuta],
            ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh => vec![Script::Devanagari, Script::Dogra, Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Mahajani, Script::Malayalam, Script::Nandinagari, Script::Khudawadi, Script::Takri, Script::Tirhuta],
            ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh => vec![Script::Devanagari, Script::Dogra, Script::Gujarati, Script::Gurmukhi, Script::Mahajani, Script::Khudawadi, Script::Takri, Script::Tirhuta],
            ScriptExtension::DevaDogrMahj => vec![Script::Devanagari, Script::Dogra, Script::Mahajani],
            ScriptExtension::BengSylo => vec![Script::Bengali, Script::Syloti_Nagri],
            ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh => vec![Script::Devanagari, Script::Dogra, Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Mahajani, Script::Nandinagari, Script::Khudawadi, Script::Takri, Script::Tirhuta],
            ScriptExtension::DevaGujrGuruKndaMlymTirh => vec![Script::Devanagari, Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Malayalam, Script::Tirhuta],
            ScriptExtension::DevaGujrGuruTirh => vec![Script::Devanagari, Script::Gujarati, Script::Gurmukhi, Script::Tirhuta],
            ScriptExtension::DevaGujrGuruKndaTirh => vec![Script::Devanagari, Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Tirhuta],
            ScriptExtension::BengDevaGranKndaOryaTeluTirh => vec![Script::Bengali, Script::Devanagari, Script::Grantha, Script::Kannada, Script::Oriya, Script::Telugu, Script::Tirhuta],
            ScriptExtension::DevaKnda => vec![Script::Devanagari, Script::Kannada],
            ScriptExtension::DevaKndaMlym => vec![Script::Devanagari, Script::Kannada, Script::Malayalam],
            ScriptExtension::DevaKndaNandTirh => vec![Script::Devanagari, Script::Kannada, Script::Nandinagari, Script::Tirhuta],
            ScriptExtension::DevaTirh => vec![Script::Devanagari, Script::Tirhuta],
            ScriptExtension::ArabRohgSyrc => vec![Script::Arabic, Script::Hanifi_Rohingya, Script::Syriac],
            ScriptExtension::DevaKndaOryaTelu => vec![Script::Devanagari, Script::Kannada, Script::Oriya, Script::Telugu],
            _ => unreachable!()
        }
    }

    #[inline]
    pub(crate) fn inner_contains_script(self, other: Script) -> bool {
        match self {
            ScriptExtension::Single(s) => s == other,
            ScriptExtension::DevaGran => other == Script::Devanagari || other == Script::Grantha,
            ScriptExtension::CprtLinaLinb => other == Script::Cypriot || other == Script::Linear_A || other == Script::Linear_B,
            ScriptExtension::ArabThaa => other == Script::Arabic || other == Script::Thaana,
            ScriptExtension::HaniHiraKana => other == Script::Han || other == Script::Hiragana || other == Script::Katakana,
            ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh => other == Script::Bengali || other == Script::Devanagari || other == Script::Dogra || other == Script::Gunjala_Gondi || other == Script::Masaram_Gondi || other == Script::Grantha || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Kannada || other == Script::Mahajani || other == Script::Malayalam || other == Script::Nandinagari || other == Script::Oriya || other == Script::Khudawadi || other == Script::Sinhala || other == Script::Syloti_Nagri || other == Script::Takri || other == Script::Tamil || other == Script::Telugu || other == Script::Tirhuta,
            ScriptExtension::ArmnGeor => other == Script::Armenian || other == Script::Georgian,
            ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh => other == Script::Bengali || other == Script::Devanagari || other == Script::Grantha || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Kannada || other == Script::Latin || other == Script::Malayalam || other == Script::Oriya || other == Script::Sharada || other == Script::Tamil || other == Script::Telugu || other == Script::Tirhuta,
            ScriptExtension::CyrlLatn => other == Script::Cyrillic || other == Script::Latin,
            ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh => other == Script::Devanagari || other == Script::Dogra || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Khojki || other == Script::Kannada || other == Script::Kaithi || other == Script::Mahajani || other == Script::Malayalam || other == Script::Modi || other == Script::Nandinagari || other == Script::Khudawadi || other == Script::Takri || other == Script::Tirhuta,
            ScriptExtension::ArabRohg => other == Script::Arabic || other == Script::Hanifi_Rohingya,
            ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh => other == Script::Devanagari || other == Script::Dogra || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Khojki || other == Script::Kaithi || other == Script::Mahajani || other == Script::Modi || other == Script::Khudawadi || other == Script::Takri || other == Script::Tirhuta,
            ScriptExtension::BugiJava => other == Script::Buginese || other == Script::Javanese,
            ScriptExtension::GeorLatn => other == Script::Georgian || other == Script::Latin,
            ScriptExtension::ArabRohgSyrcThaa => other == Script::Arabic || other == Script::Hanifi_Rohingya || other == Script::Syriac || other == Script::Thaana,
            ScriptExtension::DevaDogrKthiMahj => other == Script::Devanagari || other == Script::Dogra || other == Script::Kaithi || other == Script::Mahajani,
            ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc => other == Script::Adlam || other == Script::Arabic || other == Script::Mandaic || other == Script::Manichaean || other == Script::Psalter_Pahlavi || other == Script::Hanifi_Rohingya || other == Script::Sogdian || other == Script::Syriac,
            ScriptExtension::KaliLatnMymr => other == Script::Kayah_Li || other == Script::Latin || other == Script::Myanmar,
            ScriptExtension::BengDevaGranKnda => other == Script::Bengali || other == Script::Devanagari || other == Script::Grantha || other == Script::Kannada,
            ScriptExtension::DevaTaml => other == Script::Devanagari || other == Script::Tamil,
            ScriptExtension::KndaNand => other == Script::Kannada || other == Script::Nandinagari,
            ScriptExtension::BopoHangHaniHiraKana => other == Script::Bopomofo || other == Script::Hangul || other == Script::Han || other == Script::Hiragana || other == Script::Katakana,
            ScriptExtension::ArabSyrcThaa => other == Script::Arabic || other == Script::Syriac || other == Script::Thaana,
            ScriptExtension::DevaGranKnda => other == Script::Devanagari || other == Script::Grantha || other == Script::Kannada,
            ScriptExtension::BengCakmSylo => other == Script::Bengali || other == Script::Chakma || other == Script::Syloti_Nagri,
            ScriptExtension::GuruMult => other == Script::Gurmukhi || other == Script::Multani,
            ScriptExtension::DevaKndaMlymOryaTamlTelu => other == Script::Devanagari || other == Script::Kannada || other == Script::Malayalam || other == Script::Oriya || other == Script::Tamil || other == Script::Telugu,
            ScriptExtension::GujrKhoj => other == Script::Gujarati || other == Script::Khojki,
            ScriptExtension::CyrlPerm => other == Script::Cyrillic || other == Script::Old_Permic,
            ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh => other == Script::Devanagari || other == Script::Dogra || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Khojki || other == Script::Kannada || other == Script::Kaithi || other == Script::Mahajani || other == Script::Modi || other == Script::Nandinagari || other == Script::Khudawadi || other == Script::Takri || other == Script::Tirhuta,
            ScriptExtension::HiraKana => other == Script::Hiragana || other == Script::Katakana,
            ScriptExtension::DevaNand => other == Script::Devanagari || other == Script::Nandinagari,
            ScriptExtension::CprtLinb => other == Script::Cypriot || other == Script::Linear_B,
            ScriptExtension::DevaGranLatn => other == Script::Devanagari || other == Script::Grantha || other == Script::Latin,
            ScriptExtension::BuhdHanoTagbTglg => other == Script::Buhid || other == Script::Hanunoo || other == Script::Tagbanwa || other == Script::Tagalog,
            ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh => other == Script::Bengali || other == Script::Devanagari || other == Script::Dogra || other == Script::Gunjala_Gondi || other == Script::Masaram_Gondi || other == Script::Grantha || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Kannada || other == Script::Limbu || other == Script::Mahajani || other == Script::Malayalam || other == Script::Nandinagari || other == Script::Oriya || other == Script::Khudawadi || other == Script::Sinhala || other == Script::Syloti_Nagri || other == Script::Takri || other == Script::Tamil || other == Script::Telugu || other == Script::Tirhuta,
            ScriptExtension::ArabSyrc => other == Script::Arabic || other == Script::Syriac,
            ScriptExtension::GranTaml => other == Script::Grantha || other == Script::Tamil,
            ScriptExtension::BopoHangHaniHiraKanaYiii => other == Script::Bopomofo || other == Script::Hangul || other == Script::Han || other == Script::Hiragana || other == Script::Katakana || other == Script::Yi,
            ScriptExtension::CakmMymrTale => other == Script::Chakma || other == Script::Myanmar || other == Script::Tai_Le,
            ScriptExtension::BengDeva => other == Script::Bengali || other == Script::Devanagari,
            ScriptExtension::BengDevaGranKndaNandOryaTeluTirh => other == Script::Bengali || other == Script::Devanagari || other == Script::Grantha || other == Script::Kannada || other == Script::Nandinagari || other == Script::Oriya || other == Script::Telugu || other == Script::Tirhuta,
            ScriptExtension::LatnMong => other == Script::Latin || other == Script::Mongolian,
            ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh => other == Script::Bengali || other == Script::Devanagari || other == Script::Grantha || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Kannada || other == Script::Latin || other == Script::Malayalam || other == Script::Oriya || other == Script::Tamil || other == Script::Telugu || other == Script::Tirhuta,
            ScriptExtension::BopoHani => other == Script::Bopomofo || other == Script::Han,
            ScriptExtension::ArabCopt => other == Script::Arabic || other == Script::Coptic,
            ScriptExtension::DevaShrd => other == Script::Devanagari || other == Script::Sharada,
            ScriptExtension::MongPhag => other == Script::Mongolian || other == Script::Phags_Pa,
            ScriptExtension::CyrlGlag => other == Script::Cyrillic || other == Script::Glagolitic,
            ScriptExtension::DevaKndaTirh => other == Script::Devanagari || other == Script::Kannada || other == Script::Tirhuta,
            ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh => other == Script::Bengali || other == Script::Devanagari || other == Script::Grantha || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Kannada || other == Script::Malayalam || other == Script::Oriya || other == Script::Tamil || other == Script::Telugu || other == Script::Tirhuta,
            ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh => other == Script::Devanagari || other == Script::Dogra || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Kannada || other == Script::Mahajani || other == Script::Malayalam || other == Script::Nandinagari || other == Script::Khudawadi || other == Script::Takri || other == Script::Tirhuta,
            ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh => other == Script::Devanagari || other == Script::Dogra || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Mahajani || other == Script::Khudawadi || other == Script::Takri || other == Script::Tirhuta,
            ScriptExtension::DevaDogrMahj => other == Script::Devanagari || other == Script::Dogra || other == Script::Mahajani,
            ScriptExtension::BengSylo => other == Script::Bengali || other == Script::Syloti_Nagri,
            ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh => other == Script::Devanagari || other == Script::Dogra || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Kannada || other == Script::Mahajani || other == Script::Nandinagari || other == Script::Khudawadi || other == Script::Takri || other == Script::Tirhuta,
            ScriptExtension::DevaGujrGuruKndaMlymTirh => other == Script::Devanagari || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Kannada || other == Script::Malayalam || other == Script::Tirhuta,
            ScriptExtension::DevaGujrGuruTirh => other == Script::Devanagari || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Tirhuta,
            ScriptExtension::DevaGujrGuruKndaTirh => other == Script::Devanagari || other == Script::Gujarati || other == Script::Gurmukhi || other == Script::Kannada || other == Script::Tirhuta,
            ScriptExtension::BengDevaGranKndaOryaTeluTirh => other == Script::Bengali || other == Script::Devanagari || other == Script::Grantha || other == Script::Kannada || other == Script::Oriya || other == Script::Telugu || other == Script::Tirhuta,
            ScriptExtension::DevaKnda => other == Script::Devanagari || other == Script::Kannada,
            ScriptExtension::DevaKndaMlym => other == Script::Devanagari || other == Script::Kannada || other == Script::Malayalam,
            ScriptExtension::DevaKndaNandTirh => other == Script::Devanagari || other == Script::Kannada || other == Script::Nandinagari || other == Script::Tirhuta,
            ScriptExtension::DevaTirh => other == Script::Devanagari || other == Script::Tirhuta,
            ScriptExtension::ArabRohgSyrc => other == Script::Arabic || other == Script::Hanifi_Rohingya || other == Script::Syriac,
            ScriptExtension::DevaKndaOryaTelu => other == Script::Devanagari || other == Script::Kannada || other == Script::Oriya || other == Script::Telugu,
        }
    }

    #[inline]
    pub(crate) fn inner_intersect(self, other: Self) -> Self {
        match (self, other) {
            (ScriptExtension::Single(Script::Unknown), _) |
            (_, ScriptExtension::Single(Script::Unknown)) => ScriptExtension::Single(Script::Unknown),
            (a, b) if a == b => a,
            (ScriptExtension::Single(Script::Common), a) |
            (ScriptExtension::Single(Script::Inherited), a) |
            (a, ScriptExtension::Single(Script::Common)) |
            (a, ScriptExtension::Single(Script::Inherited)) => a,
            (ScriptExtension::Single(s), o) | (o, ScriptExtension::Single(s)) if o.inner_contains_script(s) => ScriptExtension::Single(s),
            (ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc, ScriptExtension::ArabCopt) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc, ScriptExtension::ArabRohg) => ScriptExtension::ArabRohg,
            (ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc, ScriptExtension::ArabRohgSyrc) => ScriptExtension::ArabRohgSyrc,
            (ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc, ScriptExtension::ArabRohgSyrcThaa) => ScriptExtension::ArabRohgSyrc,
            (ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc, ScriptExtension::ArabSyrc) => ScriptExtension::ArabSyrc,
            (ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc, ScriptExtension::ArabSyrcThaa) => ScriptExtension::ArabSyrc,
            (ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc, ScriptExtension::ArabThaa) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabCopt, ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabCopt, ScriptExtension::ArabRohg) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabCopt, ScriptExtension::ArabRohgSyrc) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabCopt, ScriptExtension::ArabRohgSyrcThaa) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabCopt, ScriptExtension::ArabSyrc) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabCopt, ScriptExtension::ArabSyrcThaa) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabCopt, ScriptExtension::ArabThaa) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabRohg, ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc) => ScriptExtension::ArabRohg,
            (ScriptExtension::ArabRohg, ScriptExtension::ArabCopt) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabRohg, ScriptExtension::ArabRohgSyrc) => ScriptExtension::ArabRohg,
            (ScriptExtension::ArabRohg, ScriptExtension::ArabRohgSyrcThaa) => ScriptExtension::ArabRohg,
            (ScriptExtension::ArabRohg, ScriptExtension::ArabSyrc) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabRohg, ScriptExtension::ArabSyrcThaa) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabRohg, ScriptExtension::ArabThaa) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabRohgSyrc, ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc) => ScriptExtension::ArabRohgSyrc,
            (ScriptExtension::ArabRohgSyrc, ScriptExtension::ArabCopt) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabRohgSyrc, ScriptExtension::ArabRohg) => ScriptExtension::ArabRohg,
            (ScriptExtension::ArabRohgSyrc, ScriptExtension::ArabRohgSyrcThaa) => ScriptExtension::ArabRohgSyrc,
            (ScriptExtension::ArabRohgSyrc, ScriptExtension::ArabSyrc) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabRohgSyrc, ScriptExtension::ArabSyrcThaa) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabRohgSyrc, ScriptExtension::ArabThaa) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabRohgSyrcThaa, ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc) => ScriptExtension::ArabRohgSyrc,
            (ScriptExtension::ArabRohgSyrcThaa, ScriptExtension::ArabCopt) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabRohgSyrcThaa, ScriptExtension::ArabRohg) => ScriptExtension::ArabRohg,
            (ScriptExtension::ArabRohgSyrcThaa, ScriptExtension::ArabRohgSyrc) => ScriptExtension::ArabRohgSyrc,
            (ScriptExtension::ArabRohgSyrcThaa, ScriptExtension::ArabSyrc) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabRohgSyrcThaa, ScriptExtension::ArabSyrcThaa) => ScriptExtension::ArabSyrcThaa,
            (ScriptExtension::ArabRohgSyrcThaa, ScriptExtension::ArabThaa) => ScriptExtension::ArabThaa,
            (ScriptExtension::ArabSyrc, ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabSyrc, ScriptExtension::ArabCopt) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabSyrc, ScriptExtension::ArabRohg) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabSyrc, ScriptExtension::ArabRohgSyrc) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabSyrc, ScriptExtension::ArabRohgSyrcThaa) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabSyrc, ScriptExtension::ArabSyrcThaa) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabSyrc, ScriptExtension::ArabThaa) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabSyrcThaa, ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabSyrcThaa, ScriptExtension::ArabCopt) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabSyrcThaa, ScriptExtension::ArabRohg) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabSyrcThaa, ScriptExtension::ArabRohgSyrc) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabSyrcThaa, ScriptExtension::ArabRohgSyrcThaa) => ScriptExtension::ArabSyrcThaa,
            (ScriptExtension::ArabSyrcThaa, ScriptExtension::ArabSyrc) => ScriptExtension::ArabSyrc,
            (ScriptExtension::ArabSyrcThaa, ScriptExtension::ArabThaa) => ScriptExtension::ArabThaa,
            (ScriptExtension::ArabThaa, ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabThaa, ScriptExtension::ArabCopt) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabThaa, ScriptExtension::ArabRohg) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabThaa, ScriptExtension::ArabRohgSyrc) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabThaa, ScriptExtension::ArabRohgSyrcThaa) => ScriptExtension::ArabThaa,
            (ScriptExtension::ArabThaa, ScriptExtension::ArabSyrc) => ScriptExtension::Single(Script::Arabic),
            (ScriptExtension::ArabThaa, ScriptExtension::ArabSyrcThaa) => ScriptExtension::ArabThaa,
            (ScriptExtension::ArmnGeor, ScriptExtension::GeorLatn) => ScriptExtension::Single(Script::Georgian),
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengSylo,
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengSylo,
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengCakmSylo, ScriptExtension::BengSylo) => ScriptExtension::BengSylo,
            (ScriptExtension::BengCakmSylo, ScriptExtension::CakmMymrTale) => ScriptExtension::Single(Script::Chakma),
            (ScriptExtension::BengDeva, ScriptExtension::BengCakmSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDeva, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDeva, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDeva, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDeva, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDeva, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDeva, ScriptExtension::BengDevaGranKnda) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDeva, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDeva, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDeva, ScriptExtension::BengSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDeva, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDeva, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengCakmSylo) => ScriptExtension::BengSylo,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDeva) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::BengDevaGranKndaNandOryaTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengSylo) => ScriptExtension::BengSylo,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaNand) => ScriptExtension::DevaNand,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaTaml) => ScriptExtension::DevaTaml,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::GranTaml) => ScriptExtension::GranTaml,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::KndaNand) => ScriptExtension::KndaNand,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengCakmSylo) => ScriptExtension::BengSylo,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDeva) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::BengDevaGranKndaNandOryaTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::BengSylo) => ScriptExtension::BengSylo,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaNand) => ScriptExtension::DevaNand,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaTaml) => ScriptExtension::DevaTaml,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::GranTaml) => ScriptExtension::GranTaml,
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh, ScriptExtension::KndaNand) => ScriptExtension::KndaNand,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengCakmSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengDeva) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::BengSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::CyrlLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGranLatn,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaShrd) => ScriptExtension::DevaShrd,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaTaml) => ScriptExtension::DevaTaml,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::GeorLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::GranTaml) => ScriptExtension::GranTaml,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::KaliLatnMymr) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh, ScriptExtension::LatnMong) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengCakmSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengDeva) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::BengSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::CyrlLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGranLatn,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaTaml) => ScriptExtension::DevaTaml,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::GeorLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::GranTaml) => ScriptExtension::GranTaml,
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::KaliLatnMymr) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh, ScriptExtension::LatnMong) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengCakmSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengDeva) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::BengSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaTaml) => ScriptExtension::DevaTaml,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::GranTaml) => ScriptExtension::GranTaml,
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengCakmSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengDeva) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::BengSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::GranTaml) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::BengDevaGranKnda, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengCakmSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengDeva) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranKndaNandOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranKndaNandOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::BengSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaNand) => ScriptExtension::DevaNand,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::GranTaml) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::BengDevaGranKndaNandOryaTeluTirh, ScriptExtension::KndaNand) => ScriptExtension::KndaNand,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengCakmSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengDeva) => ScriptExtension::BengDeva,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::BengDevaGranKnda,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::BengDevaGranKndaOryaTeluTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::BengSylo) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGran,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::GranTaml) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::BengDevaGranKndaOryaTeluTirh, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::BengSylo, ScriptExtension::BengCakmSylo) => ScriptExtension::BengSylo,
            (ScriptExtension::BengSylo, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengSylo, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengSylo,
            (ScriptExtension::BengSylo, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::BengSylo,
            (ScriptExtension::BengSylo, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengSylo, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengSylo, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengSylo, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengSylo, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BengSylo, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::Single(Script::Bengali),
            (ScriptExtension::BopoHangHaniHiraKana, ScriptExtension::BopoHangHaniHiraKanaYiii) => ScriptExtension::BopoHangHaniHiraKana,
            (ScriptExtension::BopoHangHaniHiraKana, ScriptExtension::BopoHani) => ScriptExtension::BopoHani,
            (ScriptExtension::BopoHangHaniHiraKana, ScriptExtension::HaniHiraKana) => ScriptExtension::HaniHiraKana,
            (ScriptExtension::BopoHangHaniHiraKana, ScriptExtension::HiraKana) => ScriptExtension::HiraKana,
            (ScriptExtension::BopoHangHaniHiraKanaYiii, ScriptExtension::BopoHangHaniHiraKana) => ScriptExtension::BopoHangHaniHiraKana,
            (ScriptExtension::BopoHangHaniHiraKanaYiii, ScriptExtension::BopoHani) => ScriptExtension::BopoHani,
            (ScriptExtension::BopoHangHaniHiraKanaYiii, ScriptExtension::HaniHiraKana) => ScriptExtension::HaniHiraKana,
            (ScriptExtension::BopoHangHaniHiraKanaYiii, ScriptExtension::HiraKana) => ScriptExtension::HiraKana,
            (ScriptExtension::BopoHani, ScriptExtension::BopoHangHaniHiraKana) => ScriptExtension::BopoHani,
            (ScriptExtension::BopoHani, ScriptExtension::BopoHangHaniHiraKanaYiii) => ScriptExtension::BopoHani,
            (ScriptExtension::BopoHani, ScriptExtension::HaniHiraKana) => ScriptExtension::Single(Script::Han),
            (ScriptExtension::CakmMymrTale, ScriptExtension::BengCakmSylo) => ScriptExtension::Single(Script::Chakma),
            (ScriptExtension::CakmMymrTale, ScriptExtension::KaliLatnMymr) => ScriptExtension::Single(Script::Myanmar),
            (ScriptExtension::CprtLinaLinb, ScriptExtension::CprtLinb) => ScriptExtension::CprtLinb,
            (ScriptExtension::CprtLinb, ScriptExtension::CprtLinaLinb) => ScriptExtension::CprtLinb,
            (ScriptExtension::CyrlGlag, ScriptExtension::CyrlLatn) => ScriptExtension::Single(Script::Cyrillic),
            (ScriptExtension::CyrlGlag, ScriptExtension::CyrlPerm) => ScriptExtension::Single(Script::Cyrillic),
            (ScriptExtension::CyrlLatn, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::CyrlLatn, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::CyrlLatn, ScriptExtension::CyrlGlag) => ScriptExtension::Single(Script::Cyrillic),
            (ScriptExtension::CyrlLatn, ScriptExtension::CyrlPerm) => ScriptExtension::Single(Script::Cyrillic),
            (ScriptExtension::CyrlLatn, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::CyrlLatn, ScriptExtension::GeorLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::CyrlLatn, ScriptExtension::KaliLatnMymr) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::CyrlLatn, ScriptExtension::LatnMong) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::CyrlPerm, ScriptExtension::CyrlGlag) => ScriptExtension::Single(Script::Cyrillic),
            (ScriptExtension::CyrlPerm, ScriptExtension::CyrlLatn) => ScriptExtension::Single(Script::Cyrillic),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::DevaDogrKthiMahj,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaNand) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::GujrKhoj) => ScriptExtension::GujrKhoj,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh, ScriptExtension::KndaNand) => ScriptExtension::KndaNand,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::DevaDogrKthiMahj,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaNand) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::GujrKhoj) => ScriptExtension::GujrKhoj,
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh, ScriptExtension::KndaNand) => ScriptExtension::KndaNand,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::DevaDogrKthiMahj,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::GujrKhoj) => ScriptExtension::GujrKhoj,
            (ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaNand) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh, ScriptExtension::KndaNand) => ScriptExtension::KndaNand,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaNand) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh, ScriptExtension::KndaNand) => ScriptExtension::KndaNand,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaDogrKthiMahj,
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaDogrKthiMahj,
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaDogrKthiMahj,
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaDogrMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrKthiMahj, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrMahj, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrMahj, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::DevaDogrMahj,
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaDogrMahj, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGran, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGran, ScriptExtension::GranTaml) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::DevaGranKnda, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaGranKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaGranLatn) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranKnda, ScriptExtension::GranTaml) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::DevaGranKnda, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::DevaGranLatn, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranLatn, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranLatn, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGranLatn,
            (ScriptExtension::DevaGranLatn, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGranLatn,
            (ScriptExtension::DevaGranLatn, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranLatn, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranLatn, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranLatn, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranLatn, ScriptExtension::CyrlLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaGran) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaGran,
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGranLatn, ScriptExtension::GeorLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::DevaGranLatn, ScriptExtension::GranTaml) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::DevaGranLatn, ScriptExtension::KaliLatnMymr) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::DevaGranLatn, ScriptExtension::LatnMong) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaMlymTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::DevaGujrGuruKndaMlymTirh, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::DevaGujrGuruKndaTirh, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaGujrGuruTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::GujrKhoj) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::DevaGujrGuruTirh, ScriptExtension::GuruMult) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::DevaKnda, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKnda, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKnda, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlym, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaMlymOryaTamlTelu,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKndaMlym,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaTaml) => ScriptExtension::DevaTaml,
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::GranTaml) => ScriptExtension::Single(Script::Tamil),
            (ScriptExtension::DevaKndaMlymOryaTamlTelu, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKndaNandTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaNand) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaKndaNandTirh, ScriptExtension::KndaNand) => ScriptExtension::KndaNand,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKndaOryaTelu,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaOryaTelu, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::DevaKndaTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaKnda) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaKndaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::DevaKnda,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaKndaTirh, ScriptExtension::DevaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaKndaTirh, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::DevaNand, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaNand, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaNand, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaNand, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaNand, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaNand, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaNand, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaNand, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaNand,
            (ScriptExtension::DevaNand, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaNand, ScriptExtension::KndaNand) => ScriptExtension::Single(Script::Nandinagari),
            (ScriptExtension::DevaShrd, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaShrd,
            (ScriptExtension::DevaShrd, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaShrd, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaTaml,
            (ScriptExtension::DevaTaml, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaTaml,
            (ScriptExtension::DevaTaml, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaTaml,
            (ScriptExtension::DevaTaml, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaTaml,
            (ScriptExtension::DevaTaml, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaTaml,
            (ScriptExtension::DevaTaml, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::DevaTaml,
            (ScriptExtension::DevaTaml, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaKndaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::DevaTirh) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTaml, ScriptExtension::GranTaml) => ScriptExtension::Single(Script::Tamil),
            (ScriptExtension::DevaTirh, ScriptExtension::BengDeva) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaDogrKthiMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaDogrMahj) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaKndaTirh) => ScriptExtension::DevaTirh,
            (ScriptExtension::DevaTirh, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaShrd) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::DevaTirh, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Devanagari),
            (ScriptExtension::GeorLatn, ScriptExtension::ArmnGeor) => ScriptExtension::Single(Script::Georgian),
            (ScriptExtension::GeorLatn, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::GeorLatn, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::GeorLatn, ScriptExtension::CyrlLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::GeorLatn, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::GeorLatn, ScriptExtension::KaliLatnMymr) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::GeorLatn, ScriptExtension::LatnMong) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::GranTaml, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::GranTaml,
            (ScriptExtension::GranTaml, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::GranTaml,
            (ScriptExtension::GranTaml, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::GranTaml,
            (ScriptExtension::GranTaml, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::GranTaml,
            (ScriptExtension::GranTaml, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::GranTaml,
            (ScriptExtension::GranTaml, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::GranTaml, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::GranTaml, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::GranTaml, ScriptExtension::DevaGran) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::GranTaml, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::GranTaml, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Grantha),
            (ScriptExtension::GranTaml, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Tamil),
            (ScriptExtension::GranTaml, ScriptExtension::DevaTaml) => ScriptExtension::Single(Script::Tamil),
            (ScriptExtension::GujrKhoj, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::GujrKhoj,
            (ScriptExtension::GujrKhoj, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::GujrKhoj,
            (ScriptExtension::GujrKhoj, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::GujrKhoj,
            (ScriptExtension::GujrKhoj, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GujrKhoj, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Gujarati),
            (ScriptExtension::GuruMult, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::DevaDogrGujrGuruMahjSindTakrTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::GuruMult, ScriptExtension::DevaGujrGuruTirh) => ScriptExtension::Single(Script::Gurmukhi),
            (ScriptExtension::HaniHiraKana, ScriptExtension::BopoHangHaniHiraKana) => ScriptExtension::HaniHiraKana,
            (ScriptExtension::HaniHiraKana, ScriptExtension::BopoHangHaniHiraKanaYiii) => ScriptExtension::HaniHiraKana,
            (ScriptExtension::HaniHiraKana, ScriptExtension::BopoHani) => ScriptExtension::Single(Script::Han),
            (ScriptExtension::HaniHiraKana, ScriptExtension::HiraKana) => ScriptExtension::HiraKana,
            (ScriptExtension::HiraKana, ScriptExtension::BopoHangHaniHiraKana) => ScriptExtension::HiraKana,
            (ScriptExtension::HiraKana, ScriptExtension::BopoHangHaniHiraKanaYiii) => ScriptExtension::HiraKana,
            (ScriptExtension::HiraKana, ScriptExtension::HaniHiraKana) => ScriptExtension::HiraKana,
            (ScriptExtension::KaliLatnMymr, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::KaliLatnMymr, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::KaliLatnMymr, ScriptExtension::CakmMymrTale) => ScriptExtension::Single(Script::Myanmar),
            (ScriptExtension::KaliLatnMymr, ScriptExtension::CyrlLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::KaliLatnMymr, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::KaliLatnMymr, ScriptExtension::GeorLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::KaliLatnMymr, ScriptExtension::LatnMong) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::KndaNand, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::KndaNand,
            (ScriptExtension::KndaNand, ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh) => ScriptExtension::KndaNand,
            (ScriptExtension::KndaNand, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::BengDevaGranGujrGuruKndaMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::BengDevaGranKnda) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::BengDevaGranKndaNandOryaTeluTirh) => ScriptExtension::KndaNand,
            (ScriptExtension::KndaNand, ScriptExtension::BengDevaGranKndaOryaTeluTirh) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh) => ScriptExtension::KndaNand,
            (ScriptExtension::KndaNand, ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh) => ScriptExtension::KndaNand,
            (ScriptExtension::KndaNand, ScriptExtension::DevaDogrGujrGuruKndaMahjMlymNandSindTakrTirh) => ScriptExtension::KndaNand,
            (ScriptExtension::KndaNand, ScriptExtension::DevaDogrGujrGuruKndaMahjNandSindTakrTirh) => ScriptExtension::KndaNand,
            (ScriptExtension::KndaNand, ScriptExtension::DevaGranKnda) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::DevaGujrGuruKndaMlymTirh) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::DevaGujrGuruKndaTirh) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::DevaKnda) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::DevaKndaMlym) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::DevaKndaMlymOryaTamlTelu) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::DevaKndaNandTirh) => ScriptExtension::KndaNand,
            (ScriptExtension::KndaNand, ScriptExtension::DevaKndaOryaTelu) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::DevaKndaTirh) => ScriptExtension::Single(Script::Kannada),
            (ScriptExtension::KndaNand, ScriptExtension::DevaNand) => ScriptExtension::Single(Script::Nandinagari),
            (ScriptExtension::LatnMong, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::LatnMong, ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::LatnMong, ScriptExtension::CyrlLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::LatnMong, ScriptExtension::DevaGranLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::LatnMong, ScriptExtension::GeorLatn) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::LatnMong, ScriptExtension::KaliLatnMymr) => ScriptExtension::Single(Script::Latin),
            (ScriptExtension::LatnMong, ScriptExtension::MongPhag) => ScriptExtension::Single(Script::Mongolian),
            (ScriptExtension::MongPhag, ScriptExtension::LatnMong) => ScriptExtension::Single(Script::Mongolian),
            _ => ScriptExtension::Single(Script::Unknown),
        }
    }
}

pub fn bsearch_range_value_table<T: Copy>(c: char, r: &'static [(char, char, T)]) -> Option<T> {
    use core::cmp::Ordering::{Equal, Less, Greater};
    match r.binary_search_by(|&(lo, hi, _)| {
        if lo <= c && c <= hi { Equal }
        else if hi < c { Less }
        else { Greater }
    }) {
        Ok(idx) => {
            let (_, _, cat) = r[idx];
            Some(cat)
        }
        Err(_) => None
    }
}

#[inline]
pub fn get_script(c: char) -> Option<Script> {
    bsearch_range_value_table(c, SCRIPTS)
}

#[inline]
pub fn get_script_extension(c: char) -> Option<ScriptExtension> {
    bsearch_range_value_table(c, SCRIPT_EXTENSIONS)
}
    const SCRIPTS: &'static [(char, char, Script)] = &[
        ('\u{0}', '\u{1f}',  Script::Common), ('\u{20}', '\u{20}',  Script::Common), ('\u{21}',
        '\u{23}',  Script::Common), ('\u{24}', '\u{24}',  Script::Common), ('\u{25}', '\u{27}',
         Script::Common), ('\u{28}', '\u{28}',  Script::Common), ('\u{29}', '\u{29}',
         Script::Common), ('\u{2a}', '\u{2a}',  Script::Common), ('\u{2b}', '\u{2b}',
         Script::Common), ('\u{2c}', '\u{2c}',  Script::Common), ('\u{2d}', '\u{2d}',
         Script::Common), ('\u{2e}', '\u{2f}',  Script::Common), ('\u{30}', '\u{39}',
         Script::Common), ('\u{3a}', '\u{3b}',  Script::Common), ('\u{3c}', '\u{3e}',
         Script::Common), ('\u{3f}', '\u{40}',  Script::Common), ('\u{41}', '\u{5a}',
         Script::Latin), ('\u{5b}', '\u{5b}',  Script::Common), ('\u{5c}', '\u{5c}',
         Script::Common), ('\u{5d}', '\u{5d}',  Script::Common), ('\u{5e}', '\u{5e}',
         Script::Common), ('\u{5f}', '\u{5f}',  Script::Common), ('\u{60}', '\u{60}',
         Script::Common), ('\u{61}', '\u{7a}',  Script::Latin), ('\u{7b}', '\u{7b}',
         Script::Common), ('\u{7c}', '\u{7c}',  Script::Common), ('\u{7d}', '\u{7d}',
         Script::Common), ('\u{7e}', '\u{7e}',  Script::Common), ('\u{7f}', '\u{9f}',
         Script::Common), ('\u{a0}', '\u{a0}',  Script::Common), ('\u{a1}', '\u{a1}',
         Script::Common), ('\u{a2}', '\u{a5}',  Script::Common), ('\u{a6}', '\u{a6}',
         Script::Common), ('\u{a7}', '\u{a7}',  Script::Common), ('\u{a8}', '\u{a8}',
         Script::Common), ('\u{a9}', '\u{a9}',  Script::Common), ('\u{aa}', '\u{aa}',
         Script::Latin), ('\u{ab}', '\u{ab}',  Script::Common), ('\u{ac}', '\u{ac}',
         Script::Common), ('\u{ad}', '\u{ad}',  Script::Common), ('\u{ae}', '\u{ae}',
         Script::Common), ('\u{af}', '\u{af}',  Script::Common), ('\u{b0}', '\u{b0}',
         Script::Common), ('\u{b1}', '\u{b1}',  Script::Common), ('\u{b2}', '\u{b3}',
         Script::Common), ('\u{b4}', '\u{b4}',  Script::Common), ('\u{b5}', '\u{b5}',
         Script::Common), ('\u{b6}', '\u{b7}',  Script::Common), ('\u{b8}', '\u{b8}',
         Script::Common), ('\u{b9}', '\u{b9}',  Script::Common), ('\u{ba}', '\u{ba}',
         Script::Latin), ('\u{bb}', '\u{bb}',  Script::Common), ('\u{bc}', '\u{be}',
         Script::Common), ('\u{bf}', '\u{bf}',  Script::Common), ('\u{c0}', '\u{d6}',
         Script::Latin), ('\u{d7}', '\u{d7}',  Script::Common), ('\u{d8}', '\u{f6}',
         Script::Latin), ('\u{f7}', '\u{f7}',  Script::Common), ('\u{f8}', '\u{1ba}',
         Script::Latin), ('\u{1bb}', '\u{1bb}',  Script::Latin), ('\u{1bc}', '\u{1bf}',
         Script::Latin), ('\u{1c0}', '\u{1c3}',  Script::Latin), ('\u{1c4}', '\u{293}',
         Script::Latin), ('\u{294}', '\u{294}',  Script::Latin), ('\u{295}', '\u{2af}',
         Script::Latin), ('\u{2b0}', '\u{2b8}',  Script::Latin), ('\u{2b9}', '\u{2c1}',
         Script::Common), ('\u{2c2}', '\u{2c5}',  Script::Common), ('\u{2c6}', '\u{2d1}',
         Script::Common), ('\u{2d2}', '\u{2df}',  Script::Common), ('\u{2e0}', '\u{2e4}',
         Script::Latin), ('\u{2e5}', '\u{2e9}',  Script::Common), ('\u{2ea}', '\u{2eb}',
         Script::Bopomofo), ('\u{2ec}', '\u{2ec}',  Script::Common), ('\u{2ed}', '\u{2ed}',
         Script::Common), ('\u{2ee}', '\u{2ee}',  Script::Common), ('\u{2ef}', '\u{2ff}',
         Script::Common), ('\u{300}', '\u{36f}',  Script::Inherited), ('\u{370}', '\u{373}',
         Script::Greek), ('\u{374}', '\u{374}',  Script::Common), ('\u{375}', '\u{375}',
         Script::Greek), ('\u{376}', '\u{377}',  Script::Greek), ('\u{37a}', '\u{37a}',
         Script::Greek), ('\u{37b}', '\u{37d}',  Script::Greek), ('\u{37e}', '\u{37e}',
         Script::Common), ('\u{37f}', '\u{37f}',  Script::Greek), ('\u{384}', '\u{384}',
         Script::Greek), ('\u{385}', '\u{385}',  Script::Common), ('\u{386}', '\u{386}',
         Script::Greek), ('\u{387}', '\u{387}',  Script::Common), ('\u{388}', '\u{38a}',
         Script::Greek), ('\u{38c}', '\u{38c}',  Script::Greek), ('\u{38e}', '\u{3a1}',
         Script::Greek), ('\u{3a3}', '\u{3e1}',  Script::Greek), ('\u{3e2}', '\u{3ef}',
         Script::Coptic), ('\u{3f0}', '\u{3f5}',  Script::Greek), ('\u{3f6}', '\u{3f6}',
         Script::Greek), ('\u{3f7}', '\u{3ff}',  Script::Greek), ('\u{400}', '\u{481}',
         Script::Cyrillic), ('\u{482}', '\u{482}',  Script::Cyrillic), ('\u{483}', '\u{484}',
         Script::Cyrillic), ('\u{485}', '\u{486}',  Script::Inherited), ('\u{487}', '\u{487}',
         Script::Cyrillic), ('\u{488}', '\u{489}',  Script::Cyrillic), ('\u{48a}', '\u{52f}',
         Script::Cyrillic), ('\u{531}', '\u{556}',  Script::Armenian), ('\u{559}', '\u{559}',
         Script::Armenian), ('\u{55a}', '\u{55f}',  Script::Armenian), ('\u{560}', '\u{588}',
         Script::Armenian), ('\u{589}', '\u{589}',  Script::Common), ('\u{58a}', '\u{58a}',
         Script::Armenian), ('\u{58d}', '\u{58e}',  Script::Armenian), ('\u{58f}', '\u{58f}',
         Script::Armenian), ('\u{591}', '\u{5bd}',  Script::Hebrew), ('\u{5be}', '\u{5be}',
         Script::Hebrew), ('\u{5bf}', '\u{5bf}',  Script::Hebrew), ('\u{5c0}', '\u{5c0}',
         Script::Hebrew), ('\u{5c1}', '\u{5c2}',  Script::Hebrew), ('\u{5c3}', '\u{5c3}',
         Script::Hebrew), ('\u{5c4}', '\u{5c5}',  Script::Hebrew), ('\u{5c6}', '\u{5c6}',
         Script::Hebrew), ('\u{5c7}', '\u{5c7}',  Script::Hebrew), ('\u{5d0}', '\u{5ea}',
         Script::Hebrew), ('\u{5ef}', '\u{5f2}',  Script::Hebrew), ('\u{5f3}', '\u{5f4}',
         Script::Hebrew), ('\u{600}', '\u{604}',  Script::Arabic), ('\u{605}', '\u{605}',
         Script::Common), ('\u{606}', '\u{608}',  Script::Arabic), ('\u{609}', '\u{60a}',
         Script::Arabic), ('\u{60b}', '\u{60b}',  Script::Arabic), ('\u{60c}', '\u{60c}',
         Script::Common), ('\u{60d}', '\u{60d}',  Script::Arabic), ('\u{60e}', '\u{60f}',
         Script::Arabic), ('\u{610}', '\u{61a}',  Script::Arabic), ('\u{61b}', '\u{61b}',
         Script::Common), ('\u{61c}', '\u{61c}',  Script::Arabic), ('\u{61e}', '\u{61e}',
         Script::Arabic), ('\u{61f}', '\u{61f}',  Script::Common), ('\u{620}', '\u{63f}',
         Script::Arabic), ('\u{640}', '\u{640}',  Script::Common), ('\u{641}', '\u{64a}',
         Script::Arabic), ('\u{64b}', '\u{655}',  Script::Inherited), ('\u{656}', '\u{65f}',
         Script::Arabic), ('\u{660}', '\u{669}',  Script::Arabic), ('\u{66a}', '\u{66d}',
         Script::Arabic), ('\u{66e}', '\u{66f}',  Script::Arabic), ('\u{670}', '\u{670}',
         Script::Inherited), ('\u{671}', '\u{6d3}',  Script::Arabic), ('\u{6d4}', '\u{6d4}',
         Script::Arabic), ('\u{6d5}', '\u{6d5}',  Script::Arabic), ('\u{6d6}', '\u{6dc}',
         Script::Arabic), ('\u{6dd}', '\u{6dd}',  Script::Common), ('\u{6de}', '\u{6de}',
         Script::Arabic), ('\u{6df}', '\u{6e4}',  Script::Arabic), ('\u{6e5}', '\u{6e6}',
         Script::Arabic), ('\u{6e7}', '\u{6e8}',  Script::Arabic), ('\u{6e9}', '\u{6e9}',
         Script::Arabic), ('\u{6ea}', '\u{6ed}',  Script::Arabic), ('\u{6ee}', '\u{6ef}',
         Script::Arabic), ('\u{6f0}', '\u{6f9}',  Script::Arabic), ('\u{6fa}', '\u{6fc}',
         Script::Arabic), ('\u{6fd}', '\u{6fe}',  Script::Arabic), ('\u{6ff}', '\u{6ff}',
         Script::Arabic), ('\u{700}', '\u{70d}',  Script::Syriac), ('\u{70f}', '\u{70f}',
         Script::Syriac), ('\u{710}', '\u{710}',  Script::Syriac), ('\u{711}', '\u{711}',
         Script::Syriac), ('\u{712}', '\u{72f}',  Script::Syriac), ('\u{730}', '\u{74a}',
         Script::Syriac), ('\u{74d}', '\u{74f}',  Script::Syriac), ('\u{750}', '\u{77f}',
         Script::Arabic), ('\u{780}', '\u{7a5}',  Script::Thaana), ('\u{7a6}', '\u{7b0}',
         Script::Thaana), ('\u{7b1}', '\u{7b1}',  Script::Thaana), ('\u{7c0}', '\u{7c9}',
         Script::Nko), ('\u{7ca}', '\u{7ea}',  Script::Nko), ('\u{7eb}', '\u{7f3}',  Script::Nko),
        ('\u{7f4}', '\u{7f5}',  Script::Nko), ('\u{7f6}', '\u{7f6}',  Script::Nko), ('\u{7f7}',
        '\u{7f9}',  Script::Nko), ('\u{7fa}', '\u{7fa}',  Script::Nko), ('\u{7fd}', '\u{7fd}',
         Script::Nko), ('\u{7fe}', '\u{7ff}',  Script::Nko), ('\u{800}', '\u{815}',
         Script::Samaritan), ('\u{816}', '\u{819}',  Script::Samaritan), ('\u{81a}', '\u{81a}',
         Script::Samaritan), ('\u{81b}', '\u{823}',  Script::Samaritan), ('\u{824}', '\u{824}',
         Script::Samaritan), ('\u{825}', '\u{827}',  Script::Samaritan), ('\u{828}', '\u{828}',
         Script::Samaritan), ('\u{829}', '\u{82d}',  Script::Samaritan), ('\u{830}', '\u{83e}',
         Script::Samaritan), ('\u{840}', '\u{858}',  Script::Mandaic), ('\u{859}', '\u{85b}',
         Script::Mandaic), ('\u{85e}', '\u{85e}',  Script::Mandaic), ('\u{860}', '\u{86a}',
         Script::Syriac), ('\u{8a0}', '\u{8b4}',  Script::Arabic), ('\u{8b6}', '\u{8bd}',
         Script::Arabic), ('\u{8d3}', '\u{8e1}',  Script::Arabic), ('\u{8e2}', '\u{8e2}',
         Script::Common), ('\u{8e3}', '\u{8ff}',  Script::Arabic), ('\u{900}', '\u{902}',
         Script::Devanagari), ('\u{903}', '\u{903}',  Script::Devanagari), ('\u{904}', '\u{939}',
         Script::Devanagari), ('\u{93a}', '\u{93a}',  Script::Devanagari), ('\u{93b}', '\u{93b}',
         Script::Devanagari), ('\u{93c}', '\u{93c}',  Script::Devanagari), ('\u{93d}', '\u{93d}',
         Script::Devanagari), ('\u{93e}', '\u{940}',  Script::Devanagari), ('\u{941}', '\u{948}',
         Script::Devanagari), ('\u{949}', '\u{94c}',  Script::Devanagari), ('\u{94d}', '\u{94d}',
         Script::Devanagari), ('\u{94e}', '\u{94f}',  Script::Devanagari), ('\u{950}', '\u{950}',
         Script::Devanagari), ('\u{951}', '\u{954}',  Script::Inherited), ('\u{955}', '\u{957}',
         Script::Devanagari), ('\u{958}', '\u{961}',  Script::Devanagari), ('\u{962}', '\u{963}',
         Script::Devanagari), ('\u{964}', '\u{965}',  Script::Common), ('\u{966}', '\u{96f}',
         Script::Devanagari), ('\u{970}', '\u{970}',  Script::Devanagari), ('\u{971}', '\u{971}',
         Script::Devanagari), ('\u{972}', '\u{97f}',  Script::Devanagari), ('\u{980}', '\u{980}',
         Script::Bengali), ('\u{981}', '\u{981}',  Script::Bengali), ('\u{982}', '\u{983}',
         Script::Bengali), ('\u{985}', '\u{98c}',  Script::Bengali), ('\u{98f}', '\u{990}',
         Script::Bengali), ('\u{993}', '\u{9a8}',  Script::Bengali), ('\u{9aa}', '\u{9b0}',
         Script::Bengali), ('\u{9b2}', '\u{9b2}',  Script::Bengali), ('\u{9b6}', '\u{9b9}',
         Script::Bengali), ('\u{9bc}', '\u{9bc}',  Script::Bengali), ('\u{9bd}', '\u{9bd}',
         Script::Bengali), ('\u{9be}', '\u{9c0}',  Script::Bengali), ('\u{9c1}', '\u{9c4}',
         Script::Bengali), ('\u{9c7}', '\u{9c8}',  Script::Bengali), ('\u{9cb}', '\u{9cc}',
         Script::Bengali), ('\u{9cd}', '\u{9cd}',  Script::Bengali), ('\u{9ce}', '\u{9ce}',
         Script::Bengali), ('\u{9d7}', '\u{9d7}',  Script::Bengali), ('\u{9dc}', '\u{9dd}',
         Script::Bengali), ('\u{9df}', '\u{9e1}',  Script::Bengali), ('\u{9e2}', '\u{9e3}',
         Script::Bengali), ('\u{9e6}', '\u{9ef}',  Script::Bengali), ('\u{9f0}', '\u{9f1}',
         Script::Bengali), ('\u{9f2}', '\u{9f3}',  Script::Bengali), ('\u{9f4}', '\u{9f9}',
         Script::Bengali), ('\u{9fa}', '\u{9fa}',  Script::Bengali), ('\u{9fb}', '\u{9fb}',
         Script::Bengali), ('\u{9fc}', '\u{9fc}',  Script::Bengali), ('\u{9fd}', '\u{9fd}',
         Script::Bengali), ('\u{9fe}', '\u{9fe}',  Script::Bengali), ('\u{a01}', '\u{a02}',
         Script::Gurmukhi), ('\u{a03}', '\u{a03}',  Script::Gurmukhi), ('\u{a05}', '\u{a0a}',
         Script::Gurmukhi), ('\u{a0f}', '\u{a10}',  Script::Gurmukhi), ('\u{a13}', '\u{a28}',
         Script::Gurmukhi), ('\u{a2a}', '\u{a30}',  Script::Gurmukhi), ('\u{a32}', '\u{a33}',
         Script::Gurmukhi), ('\u{a35}', '\u{a36}',  Script::Gurmukhi), ('\u{a38}', '\u{a39}',
         Script::Gurmukhi), ('\u{a3c}', '\u{a3c}',  Script::Gurmukhi), ('\u{a3e}', '\u{a40}',
         Script::Gurmukhi), ('\u{a41}', '\u{a42}',  Script::Gurmukhi), ('\u{a47}', '\u{a48}',
         Script::Gurmukhi), ('\u{a4b}', '\u{a4d}',  Script::Gurmukhi), ('\u{a51}', '\u{a51}',
         Script::Gurmukhi), ('\u{a59}', '\u{a5c}',  Script::Gurmukhi), ('\u{a5e}', '\u{a5e}',
         Script::Gurmukhi), ('\u{a66}', '\u{a6f}',  Script::Gurmukhi), ('\u{a70}', '\u{a71}',
         Script::Gurmukhi), ('\u{a72}', '\u{a74}',  Script::Gurmukhi), ('\u{a75}', '\u{a75}',
         Script::Gurmukhi), ('\u{a76}', '\u{a76}',  Script::Gurmukhi), ('\u{a81}', '\u{a82}',
         Script::Gujarati), ('\u{a83}', '\u{a83}',  Script::Gujarati), ('\u{a85}', '\u{a8d}',
         Script::Gujarati), ('\u{a8f}', '\u{a91}',  Script::Gujarati), ('\u{a93}', '\u{aa8}',
         Script::Gujarati), ('\u{aaa}', '\u{ab0}',  Script::Gujarati), ('\u{ab2}', '\u{ab3}',
         Script::Gujarati), ('\u{ab5}', '\u{ab9}',  Script::Gujarati), ('\u{abc}', '\u{abc}',
         Script::Gujarati), ('\u{abd}', '\u{abd}',  Script::Gujarati), ('\u{abe}', '\u{ac0}',
         Script::Gujarati), ('\u{ac1}', '\u{ac5}',  Script::Gujarati), ('\u{ac7}', '\u{ac8}',
         Script::Gujarati), ('\u{ac9}', '\u{ac9}',  Script::Gujarati), ('\u{acb}', '\u{acc}',
         Script::Gujarati), ('\u{acd}', '\u{acd}',  Script::Gujarati), ('\u{ad0}', '\u{ad0}',
         Script::Gujarati), ('\u{ae0}', '\u{ae1}',  Script::Gujarati), ('\u{ae2}', '\u{ae3}',
         Script::Gujarati), ('\u{ae6}', '\u{aef}',  Script::Gujarati), ('\u{af0}', '\u{af0}',
         Script::Gujarati), ('\u{af1}', '\u{af1}',  Script::Gujarati), ('\u{af9}', '\u{af9}',
         Script::Gujarati), ('\u{afa}', '\u{aff}',  Script::Gujarati), ('\u{b01}', '\u{b01}',
         Script::Oriya), ('\u{b02}', '\u{b03}',  Script::Oriya), ('\u{b05}', '\u{b0c}',
         Script::Oriya), ('\u{b0f}', '\u{b10}',  Script::Oriya), ('\u{b13}', '\u{b28}',
         Script::Oriya), ('\u{b2a}', '\u{b30}',  Script::Oriya), ('\u{b32}', '\u{b33}',
         Script::Oriya), ('\u{b35}', '\u{b39}',  Script::Oriya), ('\u{b3c}', '\u{b3c}',
         Script::Oriya), ('\u{b3d}', '\u{b3d}',  Script::Oriya), ('\u{b3e}', '\u{b3e}',
         Script::Oriya), ('\u{b3f}', '\u{b3f}',  Script::Oriya), ('\u{b40}', '\u{b40}',
         Script::Oriya), ('\u{b41}', '\u{b44}',  Script::Oriya), ('\u{b47}', '\u{b48}',
         Script::Oriya), ('\u{b4b}', '\u{b4c}',  Script::Oriya), ('\u{b4d}', '\u{b4d}',
         Script::Oriya), ('\u{b56}', '\u{b56}',  Script::Oriya), ('\u{b57}', '\u{b57}',
         Script::Oriya), ('\u{b5c}', '\u{b5d}',  Script::Oriya), ('\u{b5f}', '\u{b61}',
         Script::Oriya), ('\u{b62}', '\u{b63}',  Script::Oriya), ('\u{b66}', '\u{b6f}',
         Script::Oriya), ('\u{b70}', '\u{b70}',  Script::Oriya), ('\u{b71}', '\u{b71}',
         Script::Oriya), ('\u{b72}', '\u{b77}',  Script::Oriya), ('\u{b82}', '\u{b82}',
         Script::Tamil), ('\u{b83}', '\u{b83}',  Script::Tamil), ('\u{b85}', '\u{b8a}',
         Script::Tamil), ('\u{b8e}', '\u{b90}',  Script::Tamil), ('\u{b92}', '\u{b95}',
         Script::Tamil), ('\u{b99}', '\u{b9a}',  Script::Tamil), ('\u{b9c}', '\u{b9c}',
         Script::Tamil), ('\u{b9e}', '\u{b9f}',  Script::Tamil), ('\u{ba3}', '\u{ba4}',
         Script::Tamil), ('\u{ba8}', '\u{baa}',  Script::Tamil), ('\u{bae}', '\u{bb9}',
         Script::Tamil), ('\u{bbe}', '\u{bbf}',  Script::Tamil), ('\u{bc0}', '\u{bc0}',
         Script::Tamil), ('\u{bc1}', '\u{bc2}',  Script::Tamil), ('\u{bc6}', '\u{bc8}',
         Script::Tamil), ('\u{bca}', '\u{bcc}',  Script::Tamil), ('\u{bcd}', '\u{bcd}',
         Script::Tamil), ('\u{bd0}', '\u{bd0}',  Script::Tamil), ('\u{bd7}', '\u{bd7}',
         Script::Tamil), ('\u{be6}', '\u{bef}',  Script::Tamil), ('\u{bf0}', '\u{bf2}',
         Script::Tamil), ('\u{bf3}', '\u{bf8}',  Script::Tamil), ('\u{bf9}', '\u{bf9}',
         Script::Tamil), ('\u{bfa}', '\u{bfa}',  Script::Tamil), ('\u{c00}', '\u{c00}',
         Script::Telugu), ('\u{c01}', '\u{c03}',  Script::Telugu), ('\u{c04}', '\u{c04}',
         Script::Telugu), ('\u{c05}', '\u{c0c}',  Script::Telugu), ('\u{c0e}', '\u{c10}',
         Script::Telugu), ('\u{c12}', '\u{c28}',  Script::Telugu), ('\u{c2a}', '\u{c39}',
         Script::Telugu), ('\u{c3d}', '\u{c3d}',  Script::Telugu), ('\u{c3e}', '\u{c40}',
         Script::Telugu), ('\u{c41}', '\u{c44}',  Script::Telugu), ('\u{c46}', '\u{c48}',
         Script::Telugu), ('\u{c4a}', '\u{c4d}',  Script::Telugu), ('\u{c55}', '\u{c56}',
         Script::Telugu), ('\u{c58}', '\u{c5a}',  Script::Telugu), ('\u{c60}', '\u{c61}',
         Script::Telugu), ('\u{c62}', '\u{c63}',  Script::Telugu), ('\u{c66}', '\u{c6f}',
         Script::Telugu), ('\u{c77}', '\u{c77}',  Script::Telugu), ('\u{c78}', '\u{c7e}',
         Script::Telugu), ('\u{c7f}', '\u{c7f}',  Script::Telugu), ('\u{c80}', '\u{c80}',
         Script::Kannada), ('\u{c81}', '\u{c81}',  Script::Kannada), ('\u{c82}', '\u{c83}',
         Script::Kannada), ('\u{c84}', '\u{c84}',  Script::Kannada), ('\u{c85}', '\u{c8c}',
         Script::Kannada), ('\u{c8e}', '\u{c90}',  Script::Kannada), ('\u{c92}', '\u{ca8}',
         Script::Kannada), ('\u{caa}', '\u{cb3}',  Script::Kannada), ('\u{cb5}', '\u{cb9}',
         Script::Kannada), ('\u{cbc}', '\u{cbc}',  Script::Kannada), ('\u{cbd}', '\u{cbd}',
         Script::Kannada), ('\u{cbe}', '\u{cbe}',  Script::Kannada), ('\u{cbf}', '\u{cbf}',
         Script::Kannada), ('\u{cc0}', '\u{cc4}',  Script::Kannada), ('\u{cc6}', '\u{cc6}',
         Script::Kannada), ('\u{cc7}', '\u{cc8}',  Script::Kannada), ('\u{cca}', '\u{ccb}',
         Script::Kannada), ('\u{ccc}', '\u{ccd}',  Script::Kannada), ('\u{cd5}', '\u{cd6}',
         Script::Kannada), ('\u{cde}', '\u{cde}',  Script::Kannada), ('\u{ce0}', '\u{ce1}',
         Script::Kannada), ('\u{ce2}', '\u{ce3}',  Script::Kannada), ('\u{ce6}', '\u{cef}',
         Script::Kannada), ('\u{cf1}', '\u{cf2}',  Script::Kannada), ('\u{d00}', '\u{d01}',
         Script::Malayalam), ('\u{d02}', '\u{d03}',  Script::Malayalam), ('\u{d05}', '\u{d0c}',
         Script::Malayalam), ('\u{d0e}', '\u{d10}',  Script::Malayalam), ('\u{d12}', '\u{d3a}',
         Script::Malayalam), ('\u{d3b}', '\u{d3c}',  Script::Malayalam), ('\u{d3d}', '\u{d3d}',
         Script::Malayalam), ('\u{d3e}', '\u{d40}',  Script::Malayalam), ('\u{d41}', '\u{d44}',
         Script::Malayalam), ('\u{d46}', '\u{d48}',  Script::Malayalam), ('\u{d4a}', '\u{d4c}',
         Script::Malayalam), ('\u{d4d}', '\u{d4d}',  Script::Malayalam), ('\u{d4e}', '\u{d4e}',
         Script::Malayalam), ('\u{d4f}', '\u{d4f}',  Script::Malayalam), ('\u{d54}', '\u{d56}',
         Script::Malayalam), ('\u{d57}', '\u{d57}',  Script::Malayalam), ('\u{d58}', '\u{d5e}',
         Script::Malayalam), ('\u{d5f}', '\u{d61}',  Script::Malayalam), ('\u{d62}', '\u{d63}',
         Script::Malayalam), ('\u{d66}', '\u{d6f}',  Script::Malayalam), ('\u{d70}', '\u{d78}',
         Script::Malayalam), ('\u{d79}', '\u{d79}',  Script::Malayalam), ('\u{d7a}', '\u{d7f}',
         Script::Malayalam), ('\u{d82}', '\u{d83}',  Script::Sinhala), ('\u{d85}', '\u{d96}',
         Script::Sinhala), ('\u{d9a}', '\u{db1}',  Script::Sinhala), ('\u{db3}', '\u{dbb}',
         Script::Sinhala), ('\u{dbd}', '\u{dbd}',  Script::Sinhala), ('\u{dc0}', '\u{dc6}',
         Script::Sinhala), ('\u{dca}', '\u{dca}',  Script::Sinhala), ('\u{dcf}', '\u{dd1}',
         Script::Sinhala), ('\u{dd2}', '\u{dd4}',  Script::Sinhala), ('\u{dd6}', '\u{dd6}',
         Script::Sinhala), ('\u{dd8}', '\u{ddf}',  Script::Sinhala), ('\u{de6}', '\u{def}',
         Script::Sinhala), ('\u{df2}', '\u{df3}',  Script::Sinhala), ('\u{df4}', '\u{df4}',
         Script::Sinhala), ('\u{e01}', '\u{e30}',  Script::Thai), ('\u{e31}', '\u{e31}',
         Script::Thai), ('\u{e32}', '\u{e33}',  Script::Thai), ('\u{e34}', '\u{e3a}',
         Script::Thai), ('\u{e3f}', '\u{e3f}',  Script::Common), ('\u{e40}', '\u{e45}',
         Script::Thai), ('\u{e46}', '\u{e46}',  Script::Thai), ('\u{e47}', '\u{e4e}',
         Script::Thai), ('\u{e4f}', '\u{e4f}',  Script::Thai), ('\u{e50}', '\u{e59}',
         Script::Thai), ('\u{e5a}', '\u{e5b}',  Script::Thai), ('\u{e81}', '\u{e82}',  Script::Lao),
        ('\u{e84}', '\u{e84}',  Script::Lao), ('\u{e86}', '\u{e8a}',  Script::Lao), ('\u{e8c}',
        '\u{ea3}',  Script::Lao), ('\u{ea5}', '\u{ea5}',  Script::Lao), ('\u{ea7}', '\u{eb0}',
         Script::Lao), ('\u{eb1}', '\u{eb1}',  Script::Lao), ('\u{eb2}', '\u{eb3}',  Script::Lao),
        ('\u{eb4}', '\u{ebc}',  Script::Lao), ('\u{ebd}', '\u{ebd}',  Script::Lao), ('\u{ec0}',
        '\u{ec4}',  Script::Lao), ('\u{ec6}', '\u{ec6}',  Script::Lao), ('\u{ec8}', '\u{ecd}',
         Script::Lao), ('\u{ed0}', '\u{ed9}',  Script::Lao), ('\u{edc}', '\u{edf}',  Script::Lao),
        ('\u{f00}', '\u{f00}',  Script::Tibetan), ('\u{f01}', '\u{f03}',  Script::Tibetan),
        ('\u{f04}', '\u{f12}',  Script::Tibetan), ('\u{f13}', '\u{f13}',  Script::Tibetan),
        ('\u{f14}', '\u{f14}',  Script::Tibetan), ('\u{f15}', '\u{f17}',  Script::Tibetan),
        ('\u{f18}', '\u{f19}',  Script::Tibetan), ('\u{f1a}', '\u{f1f}',  Script::Tibetan),
        ('\u{f20}', '\u{f29}',  Script::Tibetan), ('\u{f2a}', '\u{f33}',  Script::Tibetan),
        ('\u{f34}', '\u{f34}',  Script::Tibetan), ('\u{f35}', '\u{f35}',  Script::Tibetan),
        ('\u{f36}', '\u{f36}',  Script::Tibetan), ('\u{f37}', '\u{f37}',  Script::Tibetan),
        ('\u{f38}', '\u{f38}',  Script::Tibetan), ('\u{f39}', '\u{f39}',  Script::Tibetan),
        ('\u{f3a}', '\u{f3a}',  Script::Tibetan), ('\u{f3b}', '\u{f3b}',  Script::Tibetan),
        ('\u{f3c}', '\u{f3c}',  Script::Tibetan), ('\u{f3d}', '\u{f3d}',  Script::Tibetan),
        ('\u{f3e}', '\u{f3f}',  Script::Tibetan), ('\u{f40}', '\u{f47}',  Script::Tibetan),
        ('\u{f49}', '\u{f6c}',  Script::Tibetan), ('\u{f71}', '\u{f7e}',  Script::Tibetan),
        ('\u{f7f}', '\u{f7f}',  Script::Tibetan), ('\u{f80}', '\u{f84}',  Script::Tibetan),
        ('\u{f85}', '\u{f85}',  Script::Tibetan), ('\u{f86}', '\u{f87}',  Script::Tibetan),
        ('\u{f88}', '\u{f8c}',  Script::Tibetan), ('\u{f8d}', '\u{f97}',  Script::Tibetan),
        ('\u{f99}', '\u{fbc}',  Script::Tibetan), ('\u{fbe}', '\u{fc5}',  Script::Tibetan),
        ('\u{fc6}', '\u{fc6}',  Script::Tibetan), ('\u{fc7}', '\u{fcc}',  Script::Tibetan),
        ('\u{fce}', '\u{fcf}',  Script::Tibetan), ('\u{fd0}', '\u{fd4}',  Script::Tibetan),
        ('\u{fd5}', '\u{fd8}',  Script::Common), ('\u{fd9}', '\u{fda}',  Script::Tibetan),
        ('\u{1000}', '\u{102a}',  Script::Myanmar), ('\u{102b}', '\u{102c}',  Script::Myanmar),
        ('\u{102d}', '\u{1030}',  Script::Myanmar), ('\u{1031}', '\u{1031}',  Script::Myanmar),
        ('\u{1032}', '\u{1037}',  Script::Myanmar), ('\u{1038}', '\u{1038}',  Script::Myanmar),
        ('\u{1039}', '\u{103a}',  Script::Myanmar), ('\u{103b}', '\u{103c}',  Script::Myanmar),
        ('\u{103d}', '\u{103e}',  Script::Myanmar), ('\u{103f}', '\u{103f}',  Script::Myanmar),
        ('\u{1040}', '\u{1049}',  Script::Myanmar), ('\u{104a}', '\u{104f}',  Script::Myanmar),
        ('\u{1050}', '\u{1055}',  Script::Myanmar), ('\u{1056}', '\u{1057}',  Script::Myanmar),
        ('\u{1058}', '\u{1059}',  Script::Myanmar), ('\u{105a}', '\u{105d}',  Script::Myanmar),
        ('\u{105e}', '\u{1060}',  Script::Myanmar), ('\u{1061}', '\u{1061}',  Script::Myanmar),
        ('\u{1062}', '\u{1064}',  Script::Myanmar), ('\u{1065}', '\u{1066}',  Script::Myanmar),
        ('\u{1067}', '\u{106d}',  Script::Myanmar), ('\u{106e}', '\u{1070}',  Script::Myanmar),
        ('\u{1071}', '\u{1074}',  Script::Myanmar), ('\u{1075}', '\u{1081}',  Script::Myanmar),
        ('\u{1082}', '\u{1082}',  Script::Myanmar), ('\u{1083}', '\u{1084}',  Script::Myanmar),
        ('\u{1085}', '\u{1086}',  Script::Myanmar), ('\u{1087}', '\u{108c}',  Script::Myanmar),
        ('\u{108d}', '\u{108d}',  Script::Myanmar), ('\u{108e}', '\u{108e}',  Script::Myanmar),
        ('\u{108f}', '\u{108f}',  Script::Myanmar), ('\u{1090}', '\u{1099}',  Script::Myanmar),
        ('\u{109a}', '\u{109c}',  Script::Myanmar), ('\u{109d}', '\u{109d}',  Script::Myanmar),
        ('\u{109e}', '\u{109f}',  Script::Myanmar), ('\u{10a0}', '\u{10c5}',  Script::Georgian),
        ('\u{10c7}', '\u{10c7}',  Script::Georgian), ('\u{10cd}', '\u{10cd}',  Script::Georgian),
        ('\u{10d0}', '\u{10fa}',  Script::Georgian), ('\u{10fb}', '\u{10fb}',  Script::Common),
        ('\u{10fc}', '\u{10fc}',  Script::Georgian), ('\u{10fd}', '\u{10ff}',  Script::Georgian),
        ('\u{1100}', '\u{11ff}',  Script::Hangul), ('\u{1200}', '\u{1248}',  Script::Ethiopic),
        ('\u{124a}', '\u{124d}',  Script::Ethiopic), ('\u{1250}', '\u{1256}',  Script::Ethiopic),
        ('\u{1258}', '\u{1258}',  Script::Ethiopic), ('\u{125a}', '\u{125d}',  Script::Ethiopic),
        ('\u{1260}', '\u{1288}',  Script::Ethiopic), ('\u{128a}', '\u{128d}',  Script::Ethiopic),
        ('\u{1290}', '\u{12b0}',  Script::Ethiopic), ('\u{12b2}', '\u{12b5}',  Script::Ethiopic),
        ('\u{12b8}', '\u{12be}',  Script::Ethiopic), ('\u{12c0}', '\u{12c0}',  Script::Ethiopic),
        ('\u{12c2}', '\u{12c5}',  Script::Ethiopic), ('\u{12c8}', '\u{12d6}',  Script::Ethiopic),
        ('\u{12d8}', '\u{1310}',  Script::Ethiopic), ('\u{1312}', '\u{1315}',  Script::Ethiopic),
        ('\u{1318}', '\u{135a}',  Script::Ethiopic), ('\u{135d}', '\u{135f}',  Script::Ethiopic),
        ('\u{1360}', '\u{1368}',  Script::Ethiopic), ('\u{1369}', '\u{137c}',  Script::Ethiopic),
        ('\u{1380}', '\u{138f}',  Script::Ethiopic), ('\u{1390}', '\u{1399}',  Script::Ethiopic),
        ('\u{13a0}', '\u{13f5}',  Script::Cherokee), ('\u{13f8}', '\u{13fd}',  Script::Cherokee),
        ('\u{1400}', '\u{1400}',  Script::Canadian_Aboriginal), ('\u{1401}', '\u{166c}',
         Script::Canadian_Aboriginal), ('\u{166d}', '\u{166d}',  Script::Canadian_Aboriginal),
        ('\u{166e}', '\u{166e}',  Script::Canadian_Aboriginal), ('\u{166f}', '\u{167f}',
         Script::Canadian_Aboriginal), ('\u{1680}', '\u{1680}',  Script::Ogham), ('\u{1681}',
        '\u{169a}',  Script::Ogham), ('\u{169b}', '\u{169b}',  Script::Ogham), ('\u{169c}',
        '\u{169c}',  Script::Ogham), ('\u{16a0}', '\u{16ea}',  Script::Runic), ('\u{16eb}',
        '\u{16ed}',  Script::Common), ('\u{16ee}', '\u{16f0}',  Script::Runic), ('\u{16f1}',
        '\u{16f8}',  Script::Runic), ('\u{1700}', '\u{170c}',  Script::Tagalog), ('\u{170e}',
        '\u{1711}',  Script::Tagalog), ('\u{1712}', '\u{1714}',  Script::Tagalog), ('\u{1720}',
        '\u{1731}',  Script::Hanunoo), ('\u{1732}', '\u{1734}',  Script::Hanunoo), ('\u{1735}',
        '\u{1736}',  Script::Common), ('\u{1740}', '\u{1751}',  Script::Buhid), ('\u{1752}',
        '\u{1753}',  Script::Buhid), ('\u{1760}', '\u{176c}',  Script::Tagbanwa), ('\u{176e}',
        '\u{1770}',  Script::Tagbanwa), ('\u{1772}', '\u{1773}',  Script::Tagbanwa), ('\u{1780}',
        '\u{17b3}',  Script::Khmer), ('\u{17b4}', '\u{17b5}',  Script::Khmer), ('\u{17b6}',
        '\u{17b6}',  Script::Khmer), ('\u{17b7}', '\u{17bd}',  Script::Khmer), ('\u{17be}',
        '\u{17c5}',  Script::Khmer), ('\u{17c6}', '\u{17c6}',  Script::Khmer), ('\u{17c7}',
        '\u{17c8}',  Script::Khmer), ('\u{17c9}', '\u{17d3}',  Script::Khmer), ('\u{17d4}',
        '\u{17d6}',  Script::Khmer), ('\u{17d7}', '\u{17d7}',  Script::Khmer), ('\u{17d8}',
        '\u{17da}',  Script::Khmer), ('\u{17db}', '\u{17db}',  Script::Khmer), ('\u{17dc}',
        '\u{17dc}',  Script::Khmer), ('\u{17dd}', '\u{17dd}',  Script::Khmer), ('\u{17e0}',
        '\u{17e9}',  Script::Khmer), ('\u{17f0}', '\u{17f9}',  Script::Khmer), ('\u{1800}',
        '\u{1801}',  Script::Mongolian), ('\u{1802}', '\u{1803}',  Script::Common), ('\u{1804}',
        '\u{1804}',  Script::Mongolian), ('\u{1805}', '\u{1805}',  Script::Common), ('\u{1806}',
        '\u{1806}',  Script::Mongolian), ('\u{1807}', '\u{180a}',  Script::Mongolian), ('\u{180b}',
        '\u{180d}',  Script::Mongolian), ('\u{180e}', '\u{180e}',  Script::Mongolian), ('\u{1810}',
        '\u{1819}',  Script::Mongolian), ('\u{1820}', '\u{1842}',  Script::Mongolian), ('\u{1843}',
        '\u{1843}',  Script::Mongolian), ('\u{1844}', '\u{1878}',  Script::Mongolian), ('\u{1880}',
        '\u{1884}',  Script::Mongolian), ('\u{1885}', '\u{1886}',  Script::Mongolian), ('\u{1887}',
        '\u{18a8}',  Script::Mongolian), ('\u{18a9}', '\u{18a9}',  Script::Mongolian), ('\u{18aa}',
        '\u{18aa}',  Script::Mongolian), ('\u{18b0}', '\u{18f5}',  Script::Canadian_Aboriginal),
        ('\u{1900}', '\u{191e}',  Script::Limbu), ('\u{1920}', '\u{1922}',  Script::Limbu),
        ('\u{1923}', '\u{1926}',  Script::Limbu), ('\u{1927}', '\u{1928}',  Script::Limbu),
        ('\u{1929}', '\u{192b}',  Script::Limbu), ('\u{1930}', '\u{1931}',  Script::Limbu),
        ('\u{1932}', '\u{1932}',  Script::Limbu), ('\u{1933}', '\u{1938}',  Script::Limbu),
        ('\u{1939}', '\u{193b}',  Script::Limbu), ('\u{1940}', '\u{1940}',  Script::Limbu),
        ('\u{1944}', '\u{1945}',  Script::Limbu), ('\u{1946}', '\u{194f}',  Script::Limbu),
        ('\u{1950}', '\u{196d}',  Script::Tai_Le), ('\u{1970}', '\u{1974}',  Script::Tai_Le),
        ('\u{1980}', '\u{19ab}',  Script::New_Tai_Lue), ('\u{19b0}', '\u{19c9}',
         Script::New_Tai_Lue), ('\u{19d0}', '\u{19d9}',  Script::New_Tai_Lue), ('\u{19da}',
        '\u{19da}',  Script::New_Tai_Lue), ('\u{19de}', '\u{19df}',  Script::New_Tai_Lue),
        ('\u{19e0}', '\u{19ff}',  Script::Khmer), ('\u{1a00}', '\u{1a16}',  Script::Buginese),
        ('\u{1a17}', '\u{1a18}',  Script::Buginese), ('\u{1a19}', '\u{1a1a}',  Script::Buginese),
        ('\u{1a1b}', '\u{1a1b}',  Script::Buginese), ('\u{1a1e}', '\u{1a1f}',  Script::Buginese),
        ('\u{1a20}', '\u{1a54}',  Script::Tai_Tham), ('\u{1a55}', '\u{1a55}',  Script::Tai_Tham),
        ('\u{1a56}', '\u{1a56}',  Script::Tai_Tham), ('\u{1a57}', '\u{1a57}',  Script::Tai_Tham),
        ('\u{1a58}', '\u{1a5e}',  Script::Tai_Tham), ('\u{1a60}', '\u{1a60}',  Script::Tai_Tham),
        ('\u{1a61}', '\u{1a61}',  Script::Tai_Tham), ('\u{1a62}', '\u{1a62}',  Script::Tai_Tham),
        ('\u{1a63}', '\u{1a64}',  Script::Tai_Tham), ('\u{1a65}', '\u{1a6c}',  Script::Tai_Tham),
        ('\u{1a6d}', '\u{1a72}',  Script::Tai_Tham), ('\u{1a73}', '\u{1a7c}',  Script::Tai_Tham),
        ('\u{1a7f}', '\u{1a7f}',  Script::Tai_Tham), ('\u{1a80}', '\u{1a89}',  Script::Tai_Tham),
        ('\u{1a90}', '\u{1a99}',  Script::Tai_Tham), ('\u{1aa0}', '\u{1aa6}',  Script::Tai_Tham),
        ('\u{1aa7}', '\u{1aa7}',  Script::Tai_Tham), ('\u{1aa8}', '\u{1aad}',  Script::Tai_Tham),
        ('\u{1ab0}', '\u{1abd}',  Script::Inherited), ('\u{1abe}', '\u{1abe}',  Script::Inherited),
        ('\u{1b00}', '\u{1b03}',  Script::Balinese), ('\u{1b04}', '\u{1b04}',  Script::Balinese),
        ('\u{1b05}', '\u{1b33}',  Script::Balinese), ('\u{1b34}', '\u{1b34}',  Script::Balinese),
        ('\u{1b35}', '\u{1b35}',  Script::Balinese), ('\u{1b36}', '\u{1b3a}',  Script::Balinese),
        ('\u{1b3b}', '\u{1b3b}',  Script::Balinese), ('\u{1b3c}', '\u{1b3c}',  Script::Balinese),
        ('\u{1b3d}', '\u{1b41}',  Script::Balinese), ('\u{1b42}', '\u{1b42}',  Script::Balinese),
        ('\u{1b43}', '\u{1b44}',  Script::Balinese), ('\u{1b45}', '\u{1b4b}',  Script::Balinese),
        ('\u{1b50}', '\u{1b59}',  Script::Balinese), ('\u{1b5a}', '\u{1b60}',  Script::Balinese),
        ('\u{1b61}', '\u{1b6a}',  Script::Balinese), ('\u{1b6b}', '\u{1b73}',  Script::Balinese),
        ('\u{1b74}', '\u{1b7c}',  Script::Balinese), ('\u{1b80}', '\u{1b81}',  Script::Sundanese),
        ('\u{1b82}', '\u{1b82}',  Script::Sundanese), ('\u{1b83}', '\u{1ba0}',  Script::Sundanese),
        ('\u{1ba1}', '\u{1ba1}',  Script::Sundanese), ('\u{1ba2}', '\u{1ba5}',  Script::Sundanese),
        ('\u{1ba6}', '\u{1ba7}',  Script::Sundanese), ('\u{1ba8}', '\u{1ba9}',  Script::Sundanese),
        ('\u{1baa}', '\u{1baa}',  Script::Sundanese), ('\u{1bab}', '\u{1bad}',  Script::Sundanese),
        ('\u{1bae}', '\u{1baf}',  Script::Sundanese), ('\u{1bb0}', '\u{1bb9}',  Script::Sundanese),
        ('\u{1bba}', '\u{1bbf}',  Script::Sundanese), ('\u{1bc0}', '\u{1be5}',  Script::Batak),
        ('\u{1be6}', '\u{1be6}',  Script::Batak), ('\u{1be7}', '\u{1be7}',  Script::Batak),
        ('\u{1be8}', '\u{1be9}',  Script::Batak), ('\u{1bea}', '\u{1bec}',  Script::Batak),
        ('\u{1bed}', '\u{1bed}',  Script::Batak), ('\u{1bee}', '\u{1bee}',  Script::Batak),
        ('\u{1bef}', '\u{1bf1}',  Script::Batak), ('\u{1bf2}', '\u{1bf3}',  Script::Batak),
        ('\u{1bfc}', '\u{1bff}',  Script::Batak), ('\u{1c00}', '\u{1c23}',  Script::Lepcha),
        ('\u{1c24}', '\u{1c2b}',  Script::Lepcha), ('\u{1c2c}', '\u{1c33}',  Script::Lepcha),
        ('\u{1c34}', '\u{1c35}',  Script::Lepcha), ('\u{1c36}', '\u{1c37}',  Script::Lepcha),
        ('\u{1c3b}', '\u{1c3f}',  Script::Lepcha), ('\u{1c40}', '\u{1c49}',  Script::Lepcha),
        ('\u{1c4d}', '\u{1c4f}',  Script::Lepcha), ('\u{1c50}', '\u{1c59}',  Script::Ol_Chiki),
        ('\u{1c5a}', '\u{1c77}',  Script::Ol_Chiki), ('\u{1c78}', '\u{1c7d}',  Script::Ol_Chiki),
        ('\u{1c7e}', '\u{1c7f}',  Script::Ol_Chiki), ('\u{1c80}', '\u{1c88}',  Script::Cyrillic),
        ('\u{1c90}', '\u{1cba}',  Script::Georgian), ('\u{1cbd}', '\u{1cbf}',  Script::Georgian),
        ('\u{1cc0}', '\u{1cc7}',  Script::Sundanese), ('\u{1cd0}', '\u{1cd2}',  Script::Inherited),
        ('\u{1cd3}', '\u{1cd3}',  Script::Common), ('\u{1cd4}', '\u{1ce0}',  Script::Inherited),
        ('\u{1ce1}', '\u{1ce1}',  Script::Common), ('\u{1ce2}', '\u{1ce8}',  Script::Inherited),
        ('\u{1ce9}', '\u{1cec}',  Script::Common), ('\u{1ced}', '\u{1ced}',  Script::Inherited),
        ('\u{1cee}', '\u{1cf3}',  Script::Common), ('\u{1cf4}', '\u{1cf4}',  Script::Inherited),
        ('\u{1cf5}', '\u{1cf6}',  Script::Common), ('\u{1cf7}', '\u{1cf7}',  Script::Common),
        ('\u{1cf8}', '\u{1cf9}',  Script::Inherited), ('\u{1cfa}', '\u{1cfa}',  Script::Common),
        ('\u{1d00}', '\u{1d25}',  Script::Latin), ('\u{1d26}', '\u{1d2a}',  Script::Greek),
        ('\u{1d2b}', '\u{1d2b}',  Script::Cyrillic), ('\u{1d2c}', '\u{1d5c}',  Script::Latin),
        ('\u{1d5d}', '\u{1d61}',  Script::Greek), ('\u{1d62}', '\u{1d65}',  Script::Latin),
        ('\u{1d66}', '\u{1d6a}',  Script::Greek), ('\u{1d6b}', '\u{1d77}',  Script::Latin),
        ('\u{1d78}', '\u{1d78}',  Script::Cyrillic), ('\u{1d79}', '\u{1d9a}',  Script::Latin),
        ('\u{1d9b}', '\u{1dbe}',  Script::Latin), ('\u{1dbf}', '\u{1dbf}',  Script::Greek),
        ('\u{1dc0}', '\u{1df9}',  Script::Inherited), ('\u{1dfb}', '\u{1dff}',  Script::Inherited),
        ('\u{1e00}', '\u{1eff}',  Script::Latin), ('\u{1f00}', '\u{1f15}',  Script::Greek),
        ('\u{1f18}', '\u{1f1d}',  Script::Greek), ('\u{1f20}', '\u{1f45}',  Script::Greek),
        ('\u{1f48}', '\u{1f4d}',  Script::Greek), ('\u{1f50}', '\u{1f57}',  Script::Greek),
        ('\u{1f59}', '\u{1f59}',  Script::Greek), ('\u{1f5b}', '\u{1f5b}',  Script::Greek),
        ('\u{1f5d}', '\u{1f5d}',  Script::Greek), ('\u{1f5f}', '\u{1f7d}',  Script::Greek),
        ('\u{1f80}', '\u{1fb4}',  Script::Greek), ('\u{1fb6}', '\u{1fbc}',  Script::Greek),
        ('\u{1fbd}', '\u{1fbd}',  Script::Greek), ('\u{1fbe}', '\u{1fbe}',  Script::Greek),
        ('\u{1fbf}', '\u{1fc1}',  Script::Greek), ('\u{1fc2}', '\u{1fc4}',  Script::Greek),
        ('\u{1fc6}', '\u{1fcc}',  Script::Greek), ('\u{1fcd}', '\u{1fcf}',  Script::Greek),
        ('\u{1fd0}', '\u{1fd3}',  Script::Greek), ('\u{1fd6}', '\u{1fdb}',  Script::Greek),
        ('\u{1fdd}', '\u{1fdf}',  Script::Greek), ('\u{1fe0}', '\u{1fec}',  Script::Greek),
        ('\u{1fed}', '\u{1fef}',  Script::Greek), ('\u{1ff2}', '\u{1ff4}',  Script::Greek),
        ('\u{1ff6}', '\u{1ffc}',  Script::Greek), ('\u{1ffd}', '\u{1ffe}',  Script::Greek),
        ('\u{2000}', '\u{200a}',  Script::Common), ('\u{200b}', '\u{200b}',  Script::Common),
        ('\u{200c}', '\u{200d}',  Script::Inherited), ('\u{200e}', '\u{200f}',  Script::Common),
        ('\u{2010}', '\u{2015}',  Script::Common), ('\u{2016}', '\u{2017}',  Script::Common),
        ('\u{2018}', '\u{2018}',  Script::Common), ('\u{2019}', '\u{2019}',  Script::Common),
        ('\u{201a}', '\u{201a}',  Script::Common), ('\u{201b}', '\u{201c}',  Script::Common),
        ('\u{201d}', '\u{201d}',  Script::Common), ('\u{201e}', '\u{201e}',  Script::Common),
        ('\u{201f}', '\u{201f}',  Script::Common), ('\u{2020}', '\u{2027}',  Script::Common),
        ('\u{2028}', '\u{2028}',  Script::Common), ('\u{2029}', '\u{2029}',  Script::Common),
        ('\u{202a}', '\u{202e}',  Script::Common), ('\u{202f}', '\u{202f}',  Script::Common),
        ('\u{2030}', '\u{2038}',  Script::Common), ('\u{2039}', '\u{2039}',  Script::Common),
        ('\u{203a}', '\u{203a}',  Script::Common), ('\u{203b}', '\u{203e}',  Script::Common),
        ('\u{203f}', '\u{2040}',  Script::Common), ('\u{2041}', '\u{2043}',  Script::Common),
        ('\u{2044}', '\u{2044}',  Script::Common), ('\u{2045}', '\u{2045}',  Script::Common),
        ('\u{2046}', '\u{2046}',  Script::Common), ('\u{2047}', '\u{2051}',  Script::Common),
        ('\u{2052}', '\u{2052}',  Script::Common), ('\u{2053}', '\u{2053}',  Script::Common),
        ('\u{2054}', '\u{2054}',  Script::Common), ('\u{2055}', '\u{205e}',  Script::Common),
        ('\u{205f}', '\u{205f}',  Script::Common), ('\u{2060}', '\u{2064}',  Script::Common),
        ('\u{2066}', '\u{206f}',  Script::Common), ('\u{2070}', '\u{2070}',  Script::Common),
        ('\u{2071}', '\u{2071}',  Script::Latin), ('\u{2074}', '\u{2079}',  Script::Common),
        ('\u{207a}', '\u{207c}',  Script::Common), ('\u{207d}', '\u{207d}',  Script::Common),
        ('\u{207e}', '\u{207e}',  Script::Common), ('\u{207f}', '\u{207f}',  Script::Latin),
        ('\u{2080}', '\u{2089}',  Script::Common), ('\u{208a}', '\u{208c}',  Script::Common),
        ('\u{208d}', '\u{208d}',  Script::Common), ('\u{208e}', '\u{208e}',  Script::Common),
        ('\u{2090}', '\u{209c}',  Script::Latin), ('\u{20a0}', '\u{20bf}',  Script::Common),
        ('\u{20d0}', '\u{20dc}',  Script::Inherited), ('\u{20dd}', '\u{20e0}',  Script::Inherited),
        ('\u{20e1}', '\u{20e1}',  Script::Inherited), ('\u{20e2}', '\u{20e4}',  Script::Inherited),
        ('\u{20e5}', '\u{20f0}',  Script::Inherited), ('\u{2100}', '\u{2101}',  Script::Common),
        ('\u{2102}', '\u{2102}',  Script::Common), ('\u{2103}', '\u{2106}',  Script::Common),
        ('\u{2107}', '\u{2107}',  Script::Common), ('\u{2108}', '\u{2109}',  Script::Common),
        ('\u{210a}', '\u{2113}',  Script::Common), ('\u{2114}', '\u{2114}',  Script::Common),
        ('\u{2115}', '\u{2115}',  Script::Common), ('\u{2116}', '\u{2117}',  Script::Common),
        ('\u{2118}', '\u{2118}',  Script::Common), ('\u{2119}', '\u{211d}',  Script::Common),
        ('\u{211e}', '\u{2123}',  Script::Common), ('\u{2124}', '\u{2124}',  Script::Common),
        ('\u{2125}', '\u{2125}',  Script::Common), ('\u{2126}', '\u{2126}',  Script::Greek),
        ('\u{2127}', '\u{2127}',  Script::Common), ('\u{2128}', '\u{2128}',  Script::Common),
        ('\u{2129}', '\u{2129}',  Script::Common), ('\u{212a}', '\u{212b}',  Script::Latin),
        ('\u{212c}', '\u{212d}',  Script::Common), ('\u{212e}', '\u{212e}',  Script::Common),
        ('\u{212f}', '\u{2131}',  Script::Common), ('\u{2132}', '\u{2132}',  Script::Latin),
        ('\u{2133}', '\u{2134}',  Script::Common), ('\u{2135}', '\u{2138}',  Script::Common),
        ('\u{2139}', '\u{2139}',  Script::Common), ('\u{213a}', '\u{213b}',  Script::Common),
        ('\u{213c}', '\u{213f}',  Script::Common), ('\u{2140}', '\u{2144}',  Script::Common),
        ('\u{2145}', '\u{2149}',  Script::Common), ('\u{214a}', '\u{214a}',  Script::Common),
        ('\u{214b}', '\u{214b}',  Script::Common), ('\u{214c}', '\u{214d}',  Script::Common),
        ('\u{214e}', '\u{214e}',  Script::Latin), ('\u{214f}', '\u{214f}',  Script::Common),
        ('\u{2150}', '\u{215f}',  Script::Common), ('\u{2160}', '\u{2182}',  Script::Latin),
        ('\u{2183}', '\u{2184}',  Script::Latin), ('\u{2185}', '\u{2188}',  Script::Latin),
        ('\u{2189}', '\u{2189}',  Script::Common), ('\u{218a}', '\u{218b}',  Script::Common),
        ('\u{2190}', '\u{2194}',  Script::Common), ('\u{2195}', '\u{2199}',  Script::Common),
        ('\u{219a}', '\u{219b}',  Script::Common), ('\u{219c}', '\u{219f}',  Script::Common),
        ('\u{21a0}', '\u{21a0}',  Script::Common), ('\u{21a1}', '\u{21a2}',  Script::Common),
        ('\u{21a3}', '\u{21a3}',  Script::Common), ('\u{21a4}', '\u{21a5}',  Script::Common),
        ('\u{21a6}', '\u{21a6}',  Script::Common), ('\u{21a7}', '\u{21ad}',  Script::Common),
        ('\u{21ae}', '\u{21ae}',  Script::Common), ('\u{21af}', '\u{21cd}',  Script::Common),
        ('\u{21ce}', '\u{21cf}',  Script::Common), ('\u{21d0}', '\u{21d1}',  Script::Common),
        ('\u{21d2}', '\u{21d2}',  Script::Common), ('\u{21d3}', '\u{21d3}',  Script::Common),
        ('\u{21d4}', '\u{21d4}',  Script::Common), ('\u{21d5}', '\u{21f3}',  Script::Common),
        ('\u{21f4}', '\u{22ff}',  Script::Common), ('\u{2300}', '\u{2307}',  Script::Common),
        ('\u{2308}', '\u{2308}',  Script::Common), ('\u{2309}', '\u{2309}',  Script::Common),
        ('\u{230a}', '\u{230a}',  Script::Common), ('\u{230b}', '\u{230b}',  Script::Common),
        ('\u{230c}', '\u{231f}',  Script::Common), ('\u{2320}', '\u{2321}',  Script::Common),
        ('\u{2322}', '\u{2328}',  Script::Common), ('\u{2329}', '\u{2329}',  Script::Common),
        ('\u{232a}', '\u{232a}',  Script::Common), ('\u{232b}', '\u{237b}',  Script::Common),
        ('\u{237c}', '\u{237c}',  Script::Common), ('\u{237d}', '\u{239a}',  Script::Common),
        ('\u{239b}', '\u{23b3}',  Script::Common), ('\u{23b4}', '\u{23db}',  Script::Common),
        ('\u{23dc}', '\u{23e1}',  Script::Common), ('\u{23e2}', '\u{2426}',  Script::Common),
        ('\u{2440}', '\u{244a}',  Script::Common), ('\u{2460}', '\u{249b}',  Script::Common),
        ('\u{249c}', '\u{24e9}',  Script::Common), ('\u{24ea}', '\u{24ff}',  Script::Common),
        ('\u{2500}', '\u{25b6}',  Script::Common), ('\u{25b7}', '\u{25b7}',  Script::Common),
        ('\u{25b8}', '\u{25c0}',  Script::Common), ('\u{25c1}', '\u{25c1}',  Script::Common),
        ('\u{25c2}', '\u{25f7}',  Script::Common), ('\u{25f8}', '\u{25ff}',  Script::Common),
        ('\u{2600}', '\u{266e}',  Script::Common), ('\u{266f}', '\u{266f}',  Script::Common),
        ('\u{2670}', '\u{2767}',  Script::Common), ('\u{2768}', '\u{2768}',  Script::Common),
        ('\u{2769}', '\u{2769}',  Script::Common), ('\u{276a}', '\u{276a}',  Script::Common),
        ('\u{276b}', '\u{276b}',  Script::Common), ('\u{276c}', '\u{276c}',  Script::Common),
        ('\u{276d}', '\u{276d}',  Script::Common), ('\u{276e}', '\u{276e}',  Script::Common),
        ('\u{276f}', '\u{276f}',  Script::Common), ('\u{2770}', '\u{2770}',  Script::Common),
        ('\u{2771}', '\u{2771}',  Script::Common), ('\u{2772}', '\u{2772}',  Script::Common),
        ('\u{2773}', '\u{2773}',  Script::Common), ('\u{2774}', '\u{2774}',  Script::Common),
        ('\u{2775}', '\u{2775}',  Script::Common), ('\u{2776}', '\u{2793}',  Script::Common),
        ('\u{2794}', '\u{27bf}',  Script::Common), ('\u{27c0}', '\u{27c4}',  Script::Common),
        ('\u{27c5}', '\u{27c5}',  Script::Common), ('\u{27c6}', '\u{27c6}',  Script::Common),
        ('\u{27c7}', '\u{27e5}',  Script::Common), ('\u{27e6}', '\u{27e6}',  Script::Common),
        ('\u{27e7}', '\u{27e7}',  Script::Common), ('\u{27e8}', '\u{27e8}',  Script::Common),
        ('\u{27e9}', '\u{27e9}',  Script::Common), ('\u{27ea}', '\u{27ea}',  Script::Common),
        ('\u{27eb}', '\u{27eb}',  Script::Common), ('\u{27ec}', '\u{27ec}',  Script::Common),
        ('\u{27ed}', '\u{27ed}',  Script::Common), ('\u{27ee}', '\u{27ee}',  Script::Common),
        ('\u{27ef}', '\u{27ef}',  Script::Common), ('\u{27f0}', '\u{27ff}',  Script::Common),
        ('\u{2800}', '\u{28ff}',  Script::Braille), ('\u{2900}', '\u{2982}',  Script::Common),
        ('\u{2983}', '\u{2983}',  Script::Common), ('\u{2984}', '\u{2984}',  Script::Common),
        ('\u{2985}', '\u{2985}',  Script::Common), ('\u{2986}', '\u{2986}',  Script::Common),
        ('\u{2987}', '\u{2987}',  Script::Common), ('\u{2988}', '\u{2988}',  Script::Common),
        ('\u{2989}', '\u{2989}',  Script::Common), ('\u{298a}', '\u{298a}',  Script::Common),
        ('\u{298b}', '\u{298b}',  Script::Common), ('\u{298c}', '\u{298c}',  Script::Common),
        ('\u{298d}', '\u{298d}',  Script::Common), ('\u{298e}', '\u{298e}',  Script::Common),
        ('\u{298f}', '\u{298f}',  Script::Common), ('\u{2990}', '\u{2990}',  Script::Common),
        ('\u{2991}', '\u{2991}',  Script::Common), ('\u{2992}', '\u{2992}',  Script::Common),
        ('\u{2993}', '\u{2993}',  Script::Common), ('\u{2994}', '\u{2994}',  Script::Common),
        ('\u{2995}', '\u{2995}',  Script::Common), ('\u{2996}', '\u{2996}',  Script::Common),
        ('\u{2997}', '\u{2997}',  Script::Common), ('\u{2998}', '\u{2998}',  Script::Common),
        ('\u{2999}', '\u{29d7}',  Script::Common), ('\u{29d8}', '\u{29d8}',  Script::Common),
        ('\u{29d9}', '\u{29d9}',  Script::Common), ('\u{29da}', '\u{29da}',  Script::Common),
        ('\u{29db}', '\u{29db}',  Script::Common), ('\u{29dc}', '\u{29fb}',  Script::Common),
        ('\u{29fc}', '\u{29fc}',  Script::Common), ('\u{29fd}', '\u{29fd}',  Script::Common),
        ('\u{29fe}', '\u{2aff}',  Script::Common), ('\u{2b00}', '\u{2b2f}',  Script::Common),
        ('\u{2b30}', '\u{2b44}',  Script::Common), ('\u{2b45}', '\u{2b46}',  Script::Common),
        ('\u{2b47}', '\u{2b4c}',  Script::Common), ('\u{2b4d}', '\u{2b73}',  Script::Common),
        ('\u{2b76}', '\u{2b95}',  Script::Common), ('\u{2b98}', '\u{2bff}',  Script::Common),
        ('\u{2c00}', '\u{2c2e}',  Script::Glagolitic), ('\u{2c30}', '\u{2c5e}',
         Script::Glagolitic), ('\u{2c60}', '\u{2c7b}',  Script::Latin), ('\u{2c7c}', '\u{2c7d}',
         Script::Latin), ('\u{2c7e}', '\u{2c7f}',  Script::Latin), ('\u{2c80}', '\u{2ce4}',
         Script::Coptic), ('\u{2ce5}', '\u{2cea}',  Script::Coptic), ('\u{2ceb}', '\u{2cee}',
         Script::Coptic), ('\u{2cef}', '\u{2cf1}',  Script::Coptic), ('\u{2cf2}', '\u{2cf3}',
         Script::Coptic), ('\u{2cf9}', '\u{2cfc}',  Script::Coptic), ('\u{2cfd}', '\u{2cfd}',
         Script::Coptic), ('\u{2cfe}', '\u{2cff}',  Script::Coptic), ('\u{2d00}', '\u{2d25}',
         Script::Georgian), ('\u{2d27}', '\u{2d27}',  Script::Georgian), ('\u{2d2d}', '\u{2d2d}',
         Script::Georgian), ('\u{2d30}', '\u{2d67}',  Script::Tifinagh), ('\u{2d6f}', '\u{2d6f}',
         Script::Tifinagh), ('\u{2d70}', '\u{2d70}',  Script::Tifinagh), ('\u{2d7f}', '\u{2d7f}',
         Script::Tifinagh), ('\u{2d80}', '\u{2d96}',  Script::Ethiopic), ('\u{2da0}', '\u{2da6}',
         Script::Ethiopic), ('\u{2da8}', '\u{2dae}',  Script::Ethiopic), ('\u{2db0}', '\u{2db6}',
         Script::Ethiopic), ('\u{2db8}', '\u{2dbe}',  Script::Ethiopic), ('\u{2dc0}', '\u{2dc6}',
         Script::Ethiopic), ('\u{2dc8}', '\u{2dce}',  Script::Ethiopic), ('\u{2dd0}', '\u{2dd6}',
         Script::Ethiopic), ('\u{2dd8}', '\u{2dde}',  Script::Ethiopic), ('\u{2de0}', '\u{2dff}',
         Script::Cyrillic), ('\u{2e00}', '\u{2e01}',  Script::Common), ('\u{2e02}', '\u{2e02}',
         Script::Common), ('\u{2e03}', '\u{2e03}',  Script::Common), ('\u{2e04}', '\u{2e04}',
         Script::Common), ('\u{2e05}', '\u{2e05}',  Script::Common), ('\u{2e06}', '\u{2e08}',
         Script::Common), ('\u{2e09}', '\u{2e09}',  Script::Common), ('\u{2e0a}', '\u{2e0a}',
         Script::Common), ('\u{2e0b}', '\u{2e0b}',  Script::Common), ('\u{2e0c}', '\u{2e0c}',
         Script::Common), ('\u{2e0d}', '\u{2e0d}',  Script::Common), ('\u{2e0e}', '\u{2e16}',
         Script::Common), ('\u{2e17}', '\u{2e17}',  Script::Common), ('\u{2e18}', '\u{2e19}',
         Script::Common), ('\u{2e1a}', '\u{2e1a}',  Script::Common), ('\u{2e1b}', '\u{2e1b}',
         Script::Common), ('\u{2e1c}', '\u{2e1c}',  Script::Common), ('\u{2e1d}', '\u{2e1d}',
         Script::Common), ('\u{2e1e}', '\u{2e1f}',  Script::Common), ('\u{2e20}', '\u{2e20}',
         Script::Common), ('\u{2e21}', '\u{2e21}',  Script::Common), ('\u{2e22}', '\u{2e22}',
         Script::Common), ('\u{2e23}', '\u{2e23}',  Script::Common), ('\u{2e24}', '\u{2e24}',
         Script::Common), ('\u{2e25}', '\u{2e25}',  Script::Common), ('\u{2e26}', '\u{2e26}',
         Script::Common), ('\u{2e27}', '\u{2e27}',  Script::Common), ('\u{2e28}', '\u{2e28}',
         Script::Common), ('\u{2e29}', '\u{2e29}',  Script::Common), ('\u{2e2a}', '\u{2e2e}',
         Script::Common), ('\u{2e2f}', '\u{2e2f}',  Script::Common), ('\u{2e30}', '\u{2e39}',
         Script::Common), ('\u{2e3a}', '\u{2e3b}',  Script::Common), ('\u{2e3c}', '\u{2e3f}',
         Script::Common), ('\u{2e40}', '\u{2e40}',  Script::Common), ('\u{2e41}', '\u{2e41}',
         Script::Common), ('\u{2e42}', '\u{2e42}',  Script::Common), ('\u{2e43}', '\u{2e4f}',
         Script::Common), ('\u{2e80}', '\u{2e99}',  Script::Han), ('\u{2e9b}', '\u{2ef3}',
         Script::Han), ('\u{2f00}', '\u{2fd5}',  Script::Han), ('\u{2ff0}', '\u{2ffb}',
         Script::Common), ('\u{3000}', '\u{3000}',  Script::Common), ('\u{3001}', '\u{3003}',
         Script::Common), ('\u{3004}', '\u{3004}',  Script::Common), ('\u{3005}', '\u{3005}',
         Script::Han), ('\u{3006}', '\u{3006}',  Script::Common), ('\u{3007}', '\u{3007}',
         Script::Han), ('\u{3008}', '\u{3008}',  Script::Common), ('\u{3009}', '\u{3009}',
         Script::Common), ('\u{300a}', '\u{300a}',  Script::Common), ('\u{300b}', '\u{300b}',
         Script::Common), ('\u{300c}', '\u{300c}',  Script::Common), ('\u{300d}', '\u{300d}',
         Script::Common), ('\u{300e}', '\u{300e}',  Script::Common), ('\u{300f}', '\u{300f}',
         Script::Common), ('\u{3010}', '\u{3010}',  Script::Common), ('\u{3011}', '\u{3011}',
         Script::Common), ('\u{3012}', '\u{3013}',  Script::Common), ('\u{3014}', '\u{3014}',
         Script::Common), ('\u{3015}', '\u{3015}',  Script::Common), ('\u{3016}', '\u{3016}',
         Script::Common), ('\u{3017}', '\u{3017}',  Script::Common), ('\u{3018}', '\u{3018}',
         Script::Common), ('\u{3019}', '\u{3019}',  Script::Common), ('\u{301a}', '\u{301a}',
         Script::Common), ('\u{301b}', '\u{301b}',  Script::Common), ('\u{301c}', '\u{301c}',
         Script::Common), ('\u{301d}', '\u{301d}',  Script::Common), ('\u{301e}', '\u{301f}',
         Script::Common), ('\u{3020}', '\u{3020}',  Script::Common), ('\u{3021}', '\u{3029}',
         Script::Han), ('\u{302a}', '\u{302d}',  Script::Inherited), ('\u{302e}', '\u{302f}',
         Script::Hangul), ('\u{3030}', '\u{3030}',  Script::Common), ('\u{3031}', '\u{3035}',
         Script::Common), ('\u{3036}', '\u{3037}',  Script::Common), ('\u{3038}', '\u{303a}',
         Script::Han), ('\u{303b}', '\u{303b}',  Script::Han), ('\u{303c}', '\u{303c}',
         Script::Common), ('\u{303d}', '\u{303d}',  Script::Common), ('\u{303e}', '\u{303f}',
         Script::Common), ('\u{3041}', '\u{3096}',  Script::Hiragana), ('\u{3099}', '\u{309a}',
         Script::Inherited), ('\u{309b}', '\u{309c}',  Script::Common), ('\u{309d}', '\u{309e}',
         Script::Hiragana), ('\u{309f}', '\u{309f}',  Script::Hiragana), ('\u{30a0}', '\u{30a0}',
         Script::Common), ('\u{30a1}', '\u{30fa}',  Script::Katakana), ('\u{30fb}', '\u{30fb}',
         Script::Common), ('\u{30fc}', '\u{30fc}',  Script::Common), ('\u{30fd}', '\u{30fe}',
         Script::Katakana), ('\u{30ff}', '\u{30ff}',  Script::Katakana), ('\u{3105}', '\u{312f}',
         Script::Bopomofo), ('\u{3131}', '\u{318e}',  Script::Hangul), ('\u{3190}', '\u{3191}',
         Script::Common), ('\u{3192}', '\u{3195}',  Script::Common), ('\u{3196}', '\u{319f}',
         Script::Common), ('\u{31a0}', '\u{31ba}',  Script::Bopomofo), ('\u{31c0}', '\u{31e3}',
         Script::Common), ('\u{31f0}', '\u{31ff}',  Script::Katakana), ('\u{3200}', '\u{321e}',
         Script::Hangul), ('\u{3220}', '\u{3229}',  Script::Common), ('\u{322a}', '\u{3247}',
         Script::Common), ('\u{3248}', '\u{324f}',  Script::Common), ('\u{3250}', '\u{3250}',
         Script::Common), ('\u{3251}', '\u{325f}',  Script::Common), ('\u{3260}', '\u{327e}',
         Script::Hangul), ('\u{327f}', '\u{327f}',  Script::Common), ('\u{3280}', '\u{3289}',
         Script::Common), ('\u{328a}', '\u{32b0}',  Script::Common), ('\u{32b1}', '\u{32bf}',
         Script::Common), ('\u{32c0}', '\u{32cf}',  Script::Common), ('\u{32d0}', '\u{32fe}',
         Script::Katakana), ('\u{3300}', '\u{3357}',  Script::Katakana), ('\u{3358}', '\u{33ff}',
         Script::Common), ('\u{3400}', '\u{4db5}',  Script::Han), ('\u{4dc0}', '\u{4dff}',
         Script::Common), ('\u{4e00}', '\u{9fef}',  Script::Han), ('\u{a000}', '\u{a014}',
         Script::Yi), ('\u{a015}', '\u{a015}',  Script::Yi), ('\u{a016}', '\u{a48c}',  Script::Yi),
        ('\u{a490}', '\u{a4c6}',  Script::Yi), ('\u{a4d0}', '\u{a4f7}',  Script::Lisu), ('\u{a4f8}',
        '\u{a4fd}',  Script::Lisu), ('\u{a4fe}', '\u{a4ff}',  Script::Lisu), ('\u{a500}',
        '\u{a60b}',  Script::Vai), ('\u{a60c}', '\u{a60c}',  Script::Vai), ('\u{a60d}', '\u{a60f}',
         Script::Vai), ('\u{a610}', '\u{a61f}',  Script::Vai), ('\u{a620}', '\u{a629}',
         Script::Vai), ('\u{a62a}', '\u{a62b}',  Script::Vai), ('\u{a640}', '\u{a66d}',
         Script::Cyrillic), ('\u{a66e}', '\u{a66e}',  Script::Cyrillic), ('\u{a66f}', '\u{a66f}',
         Script::Cyrillic), ('\u{a670}', '\u{a672}',  Script::Cyrillic), ('\u{a673}', '\u{a673}',
         Script::Cyrillic), ('\u{a674}', '\u{a67d}',  Script::Cyrillic), ('\u{a67e}', '\u{a67e}',
         Script::Cyrillic), ('\u{a67f}', '\u{a67f}',  Script::Cyrillic), ('\u{a680}', '\u{a69b}',
         Script::Cyrillic), ('\u{a69c}', '\u{a69d}',  Script::Cyrillic), ('\u{a69e}', '\u{a69f}',
         Script::Cyrillic), ('\u{a6a0}', '\u{a6e5}',  Script::Bamum), ('\u{a6e6}', '\u{a6ef}',
         Script::Bamum), ('\u{a6f0}', '\u{a6f1}',  Script::Bamum), ('\u{a6f2}', '\u{a6f7}',
         Script::Bamum), ('\u{a700}', '\u{a716}',  Script::Common), ('\u{a717}', '\u{a71f}',
         Script::Common), ('\u{a720}', '\u{a721}',  Script::Common), ('\u{a722}', '\u{a76f}',
         Script::Latin), ('\u{a770}', '\u{a770}',  Script::Latin), ('\u{a771}', '\u{a787}',
         Script::Latin), ('\u{a788}', '\u{a788}',  Script::Common), ('\u{a789}', '\u{a78a}',
         Script::Common), ('\u{a78b}', '\u{a78e}',  Script::Latin), ('\u{a78f}', '\u{a78f}',
         Script::Latin), ('\u{a790}', '\u{a7bf}',  Script::Latin), ('\u{a7c2}', '\u{a7c6}',
         Script::Latin), ('\u{a7f7}', '\u{a7f7}',  Script::Latin), ('\u{a7f8}', '\u{a7f9}',
         Script::Latin), ('\u{a7fa}', '\u{a7fa}',  Script::Latin), ('\u{a7fb}', '\u{a7ff}',
         Script::Latin), ('\u{a800}', '\u{a801}',  Script::Syloti_Nagri), ('\u{a802}', '\u{a802}',
         Script::Syloti_Nagri), ('\u{a803}', '\u{a805}',  Script::Syloti_Nagri), ('\u{a806}',
        '\u{a806}',  Script::Syloti_Nagri), ('\u{a807}', '\u{a80a}',  Script::Syloti_Nagri),
        ('\u{a80b}', '\u{a80b}',  Script::Syloti_Nagri), ('\u{a80c}', '\u{a822}',
         Script::Syloti_Nagri), ('\u{a823}', '\u{a824}',  Script::Syloti_Nagri), ('\u{a825}',
        '\u{a826}',  Script::Syloti_Nagri), ('\u{a827}', '\u{a827}',  Script::Syloti_Nagri),
        ('\u{a828}', '\u{a82b}',  Script::Syloti_Nagri), ('\u{a830}', '\u{a835}',  Script::Common),
        ('\u{a836}', '\u{a837}',  Script::Common), ('\u{a838}', '\u{a838}',  Script::Common),
        ('\u{a839}', '\u{a839}',  Script::Common), ('\u{a840}', '\u{a873}',  Script::Phags_Pa),
        ('\u{a874}', '\u{a877}',  Script::Phags_Pa), ('\u{a880}', '\u{a881}',  Script::Saurashtra),
        ('\u{a882}', '\u{a8b3}',  Script::Saurashtra), ('\u{a8b4}', '\u{a8c3}',
         Script::Saurashtra), ('\u{a8c4}', '\u{a8c5}',  Script::Saurashtra), ('\u{a8ce}',
        '\u{a8cf}',  Script::Saurashtra), ('\u{a8d0}', '\u{a8d9}',  Script::Saurashtra),
        ('\u{a8e0}', '\u{a8f1}',  Script::Devanagari), ('\u{a8f2}', '\u{a8f7}',
         Script::Devanagari), ('\u{a8f8}', '\u{a8fa}',  Script::Devanagari), ('\u{a8fb}',
        '\u{a8fb}',  Script::Devanagari), ('\u{a8fc}', '\u{a8fc}',  Script::Devanagari),
        ('\u{a8fd}', '\u{a8fe}',  Script::Devanagari), ('\u{a8ff}', '\u{a8ff}',
         Script::Devanagari), ('\u{a900}', '\u{a909}',  Script::Kayah_Li), ('\u{a90a}', '\u{a925}',
         Script::Kayah_Li), ('\u{a926}', '\u{a92d}',  Script::Kayah_Li), ('\u{a92e}', '\u{a92e}',
         Script::Common), ('\u{a92f}', '\u{a92f}',  Script::Kayah_Li), ('\u{a930}', '\u{a946}',
         Script::Rejang), ('\u{a947}', '\u{a951}',  Script::Rejang), ('\u{a952}', '\u{a953}',
         Script::Rejang), ('\u{a95f}', '\u{a95f}',  Script::Rejang), ('\u{a960}', '\u{a97c}',
         Script::Hangul), ('\u{a980}', '\u{a982}',  Script::Javanese), ('\u{a983}', '\u{a983}',
         Script::Javanese), ('\u{a984}', '\u{a9b2}',  Script::Javanese), ('\u{a9b3}', '\u{a9b3}',
         Script::Javanese), ('\u{a9b4}', '\u{a9b5}',  Script::Javanese), ('\u{a9b6}', '\u{a9b9}',
         Script::Javanese), ('\u{a9ba}', '\u{a9bb}',  Script::Javanese), ('\u{a9bc}', '\u{a9bd}',
         Script::Javanese), ('\u{a9be}', '\u{a9c0}',  Script::Javanese), ('\u{a9c1}', '\u{a9cd}',
         Script::Javanese), ('\u{a9cf}', '\u{a9cf}',  Script::Common), ('\u{a9d0}', '\u{a9d9}',
         Script::Javanese), ('\u{a9de}', '\u{a9df}',  Script::Javanese), ('\u{a9e0}', '\u{a9e4}',
         Script::Myanmar), ('\u{a9e5}', '\u{a9e5}',  Script::Myanmar), ('\u{a9e6}', '\u{a9e6}',
         Script::Myanmar), ('\u{a9e7}', '\u{a9ef}',  Script::Myanmar), ('\u{a9f0}', '\u{a9f9}',
         Script::Myanmar), ('\u{a9fa}', '\u{a9fe}',  Script::Myanmar), ('\u{aa00}', '\u{aa28}',
         Script::Cham), ('\u{aa29}', '\u{aa2e}',  Script::Cham), ('\u{aa2f}', '\u{aa30}',
         Script::Cham), ('\u{aa31}', '\u{aa32}',  Script::Cham), ('\u{aa33}', '\u{aa34}',
         Script::Cham), ('\u{aa35}', '\u{aa36}',  Script::Cham), ('\u{aa40}', '\u{aa42}',
         Script::Cham), ('\u{aa43}', '\u{aa43}',  Script::Cham), ('\u{aa44}', '\u{aa4b}',
         Script::Cham), ('\u{aa4c}', '\u{aa4c}',  Script::Cham), ('\u{aa4d}', '\u{aa4d}',
         Script::Cham), ('\u{aa50}', '\u{aa59}',  Script::Cham), ('\u{aa5c}', '\u{aa5f}',
         Script::Cham), ('\u{aa60}', '\u{aa6f}',  Script::Myanmar), ('\u{aa70}', '\u{aa70}',
         Script::Myanmar), ('\u{aa71}', '\u{aa76}',  Script::Myanmar), ('\u{aa77}', '\u{aa79}',
         Script::Myanmar), ('\u{aa7a}', '\u{aa7a}',  Script::Myanmar), ('\u{aa7b}', '\u{aa7b}',
         Script::Myanmar), ('\u{aa7c}', '\u{aa7c}',  Script::Myanmar), ('\u{aa7d}', '\u{aa7d}',
         Script::Myanmar), ('\u{aa7e}', '\u{aa7f}',  Script::Myanmar), ('\u{aa80}', '\u{aaaf}',
         Script::Tai_Viet), ('\u{aab0}', '\u{aab0}',  Script::Tai_Viet), ('\u{aab1}', '\u{aab1}',
         Script::Tai_Viet), ('\u{aab2}', '\u{aab4}',  Script::Tai_Viet), ('\u{aab5}', '\u{aab6}',
         Script::Tai_Viet), ('\u{aab7}', '\u{aab8}',  Script::Tai_Viet), ('\u{aab9}', '\u{aabd}',
         Script::Tai_Viet), ('\u{aabe}', '\u{aabf}',  Script::Tai_Viet), ('\u{aac0}', '\u{aac0}',
         Script::Tai_Viet), ('\u{aac1}', '\u{aac1}',  Script::Tai_Viet), ('\u{aac2}', '\u{aac2}',
         Script::Tai_Viet), ('\u{aadb}', '\u{aadc}',  Script::Tai_Viet), ('\u{aadd}', '\u{aadd}',
         Script::Tai_Viet), ('\u{aade}', '\u{aadf}',  Script::Tai_Viet), ('\u{aae0}', '\u{aaea}',
         Script::Meetei_Mayek), ('\u{aaeb}', '\u{aaeb}',  Script::Meetei_Mayek), ('\u{aaec}',
        '\u{aaed}',  Script::Meetei_Mayek), ('\u{aaee}', '\u{aaef}',  Script::Meetei_Mayek),
        ('\u{aaf0}', '\u{aaf1}',  Script::Meetei_Mayek), ('\u{aaf2}', '\u{aaf2}',
         Script::Meetei_Mayek), ('\u{aaf3}', '\u{aaf4}',  Script::Meetei_Mayek), ('\u{aaf5}',
        '\u{aaf5}',  Script::Meetei_Mayek), ('\u{aaf6}', '\u{aaf6}',  Script::Meetei_Mayek),
        ('\u{ab01}', '\u{ab06}',  Script::Ethiopic), ('\u{ab09}', '\u{ab0e}',  Script::Ethiopic),
        ('\u{ab11}', '\u{ab16}',  Script::Ethiopic), ('\u{ab20}', '\u{ab26}',  Script::Ethiopic),
        ('\u{ab28}', '\u{ab2e}',  Script::Ethiopic), ('\u{ab30}', '\u{ab5a}',  Script::Latin),
        ('\u{ab5b}', '\u{ab5b}',  Script::Common), ('\u{ab5c}', '\u{ab5f}',  Script::Latin),
        ('\u{ab60}', '\u{ab64}',  Script::Latin), ('\u{ab65}', '\u{ab65}',  Script::Greek),
        ('\u{ab66}', '\u{ab67}',  Script::Latin), ('\u{ab70}', '\u{abbf}',  Script::Cherokee),
        ('\u{abc0}', '\u{abe2}',  Script::Meetei_Mayek), ('\u{abe3}', '\u{abe4}',
         Script::Meetei_Mayek), ('\u{abe5}', '\u{abe5}',  Script::Meetei_Mayek), ('\u{abe6}',
        '\u{abe7}',  Script::Meetei_Mayek), ('\u{abe8}', '\u{abe8}',  Script::Meetei_Mayek),
        ('\u{abe9}', '\u{abea}',  Script::Meetei_Mayek), ('\u{abeb}', '\u{abeb}',
         Script::Meetei_Mayek), ('\u{abec}', '\u{abec}',  Script::Meetei_Mayek), ('\u{abed}',
        '\u{abed}',  Script::Meetei_Mayek), ('\u{abf0}', '\u{abf9}',  Script::Meetei_Mayek),
        ('\u{ac00}', '\u{d7a3}',  Script::Hangul), ('\u{d7b0}', '\u{d7c6}',  Script::Hangul),
        ('\u{d7cb}', '\u{d7fb}',  Script::Hangul), ('\u{f900}', '\u{fa6d}',  Script::Han),
        ('\u{fa70}', '\u{fad9}',  Script::Han), ('\u{fb00}', '\u{fb06}',  Script::Latin),
        ('\u{fb13}', '\u{fb17}',  Script::Armenian), ('\u{fb1d}', '\u{fb1d}',  Script::Hebrew),
        ('\u{fb1e}', '\u{fb1e}',  Script::Hebrew), ('\u{fb1f}', '\u{fb28}',  Script::Hebrew),
        ('\u{fb29}', '\u{fb29}',  Script::Hebrew), ('\u{fb2a}', '\u{fb36}',  Script::Hebrew),
        ('\u{fb38}', '\u{fb3c}',  Script::Hebrew), ('\u{fb3e}', '\u{fb3e}',  Script::Hebrew),
        ('\u{fb40}', '\u{fb41}',  Script::Hebrew), ('\u{fb43}', '\u{fb44}',  Script::Hebrew),
        ('\u{fb46}', '\u{fb4f}',  Script::Hebrew), ('\u{fb50}', '\u{fbb1}',  Script::Arabic),
        ('\u{fbb2}', '\u{fbc1}',  Script::Arabic), ('\u{fbd3}', '\u{fd3d}',  Script::Arabic),
        ('\u{fd3e}', '\u{fd3e}',  Script::Common), ('\u{fd3f}', '\u{fd3f}',  Script::Common),
        ('\u{fd50}', '\u{fd8f}',  Script::Arabic), ('\u{fd92}', '\u{fdc7}',  Script::Arabic),
        ('\u{fdf0}', '\u{fdfb}',  Script::Arabic), ('\u{fdfc}', '\u{fdfc}',  Script::Arabic),
        ('\u{fdfd}', '\u{fdfd}',  Script::Arabic), ('\u{fe00}', '\u{fe0f}',  Script::Inherited),
        ('\u{fe10}', '\u{fe16}',  Script::Common), ('\u{fe17}', '\u{fe17}',  Script::Common),
        ('\u{fe18}', '\u{fe18}',  Script::Common), ('\u{fe19}', '\u{fe19}',  Script::Common),
        ('\u{fe20}', '\u{fe2d}',  Script::Inherited), ('\u{fe2e}', '\u{fe2f}',  Script::Cyrillic),
        ('\u{fe30}', '\u{fe30}',  Script::Common), ('\u{fe31}', '\u{fe32}',  Script::Common),
        ('\u{fe33}', '\u{fe34}',  Script::Common), ('\u{fe35}', '\u{fe35}',  Script::Common),
        ('\u{fe36}', '\u{fe36}',  Script::Common), ('\u{fe37}', '\u{fe37}',  Script::Common),
        ('\u{fe38}', '\u{fe38}',  Script::Common), ('\u{fe39}', '\u{fe39}',  Script::Common),
        ('\u{fe3a}', '\u{fe3a}',  Script::Common), ('\u{fe3b}', '\u{fe3b}',  Script::Common),
        ('\u{fe3c}', '\u{fe3c}',  Script::Common), ('\u{fe3d}', '\u{fe3d}',  Script::Common),
        ('\u{fe3e}', '\u{fe3e}',  Script::Common), ('\u{fe3f}', '\u{fe3f}',  Script::Common),
        ('\u{fe40}', '\u{fe40}',  Script::Common), ('\u{fe41}', '\u{fe41}',  Script::Common),
        ('\u{fe42}', '\u{fe42}',  Script::Common), ('\u{fe43}', '\u{fe43}',  Script::Common),
        ('\u{fe44}', '\u{fe44}',  Script::Common), ('\u{fe45}', '\u{fe46}',  Script::Common),
        ('\u{fe47}', '\u{fe47}',  Script::Common), ('\u{fe48}', '\u{fe48}',  Script::Common),
        ('\u{fe49}', '\u{fe4c}',  Script::Common), ('\u{fe4d}', '\u{fe4f}',  Script::Common),
        ('\u{fe50}', '\u{fe52}',  Script::Common), ('\u{fe54}', '\u{fe57}',  Script::Common),
        ('\u{fe58}', '\u{fe58}',  Script::Common), ('\u{fe59}', '\u{fe59}',  Script::Common),
        ('\u{fe5a}', '\u{fe5a}',  Script::Common), ('\u{fe5b}', '\u{fe5b}',  Script::Common),
        ('\u{fe5c}', '\u{fe5c}',  Script::Common), ('\u{fe5d}', '\u{fe5d}',  Script::Common),
        ('\u{fe5e}', '\u{fe5e}',  Script::Common), ('\u{fe5f}', '\u{fe61}',  Script::Common),
        ('\u{fe62}', '\u{fe62}',  Script::Common), ('\u{fe63}', '\u{fe63}',  Script::Common),
        ('\u{fe64}', '\u{fe66}',  Script::Common), ('\u{fe68}', '\u{fe68}',  Script::Common),
        ('\u{fe69}', '\u{fe69}',  Script::Common), ('\u{fe6a}', '\u{fe6b}',  Script::Common),
        ('\u{fe70}', '\u{fe74}',  Script::Arabic), ('\u{fe76}', '\u{fefc}',  Script::Arabic),
        ('\u{feff}', '\u{feff}',  Script::Common), ('\u{ff01}', '\u{ff03}',  Script::Common),
        ('\u{ff04}', '\u{ff04}',  Script::Common), ('\u{ff05}', '\u{ff07}',  Script::Common),
        ('\u{ff08}', '\u{ff08}',  Script::Common), ('\u{ff09}', '\u{ff09}',  Script::Common),
        ('\u{ff0a}', '\u{ff0a}',  Script::Common), ('\u{ff0b}', '\u{ff0b}',  Script::Common),
        ('\u{ff0c}', '\u{ff0c}',  Script::Common), ('\u{ff0d}', '\u{ff0d}',  Script::Common),
        ('\u{ff0e}', '\u{ff0f}',  Script::Common), ('\u{ff10}', '\u{ff19}',  Script::Common),
        ('\u{ff1a}', '\u{ff1b}',  Script::Common), ('\u{ff1c}', '\u{ff1e}',  Script::Common),
        ('\u{ff1f}', '\u{ff20}',  Script::Common), ('\u{ff21}', '\u{ff3a}',  Script::Latin),
        ('\u{ff3b}', '\u{ff3b}',  Script::Common), ('\u{ff3c}', '\u{ff3c}',  Script::Common),
        ('\u{ff3d}', '\u{ff3d}',  Script::Common), ('\u{ff3e}', '\u{ff3e}',  Script::Common),
        ('\u{ff3f}', '\u{ff3f}',  Script::Common), ('\u{ff40}', '\u{ff40}',  Script::Common),
        ('\u{ff41}', '\u{ff5a}',  Script::Latin), ('\u{ff5b}', '\u{ff5b}',  Script::Common),
        ('\u{ff5c}', '\u{ff5c}',  Script::Common), ('\u{ff5d}', '\u{ff5d}',  Script::Common),
        ('\u{ff5e}', '\u{ff5e}',  Script::Common), ('\u{ff5f}', '\u{ff5f}',  Script::Common),
        ('\u{ff60}', '\u{ff60}',  Script::Common), ('\u{ff61}', '\u{ff61}',  Script::Common),
        ('\u{ff62}', '\u{ff62}',  Script::Common), ('\u{ff63}', '\u{ff63}',  Script::Common),
        ('\u{ff64}', '\u{ff65}',  Script::Common), ('\u{ff66}', '\u{ff6f}',  Script::Katakana),
        ('\u{ff70}', '\u{ff70}',  Script::Common), ('\u{ff71}', '\u{ff9d}',  Script::Katakana),
        ('\u{ff9e}', '\u{ff9f}',  Script::Common), ('\u{ffa0}', '\u{ffbe}',  Script::Hangul),
        ('\u{ffc2}', '\u{ffc7}',  Script::Hangul), ('\u{ffca}', '\u{ffcf}',  Script::Hangul),
        ('\u{ffd2}', '\u{ffd7}',  Script::Hangul), ('\u{ffda}', '\u{ffdc}',  Script::Hangul),
        ('\u{ffe0}', '\u{ffe1}',  Script::Common), ('\u{ffe2}', '\u{ffe2}',  Script::Common),
        ('\u{ffe3}', '\u{ffe3}',  Script::Common), ('\u{ffe4}', '\u{ffe4}',  Script::Common),
        ('\u{ffe5}', '\u{ffe6}',  Script::Common), ('\u{ffe8}', '\u{ffe8}',  Script::Common),
        ('\u{ffe9}', '\u{ffec}',  Script::Common), ('\u{ffed}', '\u{ffee}',  Script::Common),
        ('\u{fff9}', '\u{fffb}',  Script::Common), ('\u{fffc}', '\u{fffd}',  Script::Common),
        ('\u{10000}', '\u{1000b}',  Script::Linear_B), ('\u{1000d}', '\u{10026}',
         Script::Linear_B), ('\u{10028}', '\u{1003a}',  Script::Linear_B), ('\u{1003c}',
        '\u{1003d}',  Script::Linear_B), ('\u{1003f}', '\u{1004d}',  Script::Linear_B),
        ('\u{10050}', '\u{1005d}',  Script::Linear_B), ('\u{10080}', '\u{100fa}',
         Script::Linear_B), ('\u{10100}', '\u{10102}',  Script::Common), ('\u{10107}', '\u{10133}',
         Script::Common), ('\u{10137}', '\u{1013f}',  Script::Common), ('\u{10140}', '\u{10174}',
         Script::Greek), ('\u{10175}', '\u{10178}',  Script::Greek), ('\u{10179}', '\u{10189}',
         Script::Greek), ('\u{1018a}', '\u{1018b}',  Script::Greek), ('\u{1018c}', '\u{1018e}',
         Script::Greek), ('\u{10190}', '\u{1019b}',  Script::Common), ('\u{101a0}', '\u{101a0}',
         Script::Greek), ('\u{101d0}', '\u{101fc}',  Script::Common), ('\u{101fd}', '\u{101fd}',
         Script::Inherited), ('\u{10280}', '\u{1029c}',  Script::Lycian), ('\u{102a0}', '\u{102d0}',
         Script::Carian), ('\u{102e0}', '\u{102e0}',  Script::Inherited), ('\u{102e1}', '\u{102fb}',
         Script::Common), ('\u{10300}', '\u{1031f}',  Script::Old_Italic), ('\u{10320}',
        '\u{10323}',  Script::Old_Italic), ('\u{1032d}', '\u{1032f}',  Script::Old_Italic),
        ('\u{10330}', '\u{10340}',  Script::Gothic), ('\u{10341}', '\u{10341}',  Script::Gothic),
        ('\u{10342}', '\u{10349}',  Script::Gothic), ('\u{1034a}', '\u{1034a}',  Script::Gothic),
        ('\u{10350}', '\u{10375}',  Script::Old_Permic), ('\u{10376}', '\u{1037a}',
         Script::Old_Permic), ('\u{10380}', '\u{1039d}',  Script::Ugaritic), ('\u{1039f}',
        '\u{1039f}',  Script::Ugaritic), ('\u{103a0}', '\u{103c3}',  Script::Old_Persian),
        ('\u{103c8}', '\u{103cf}',  Script::Old_Persian), ('\u{103d0}', '\u{103d0}',
         Script::Old_Persian), ('\u{103d1}', '\u{103d5}',  Script::Old_Persian), ('\u{10400}',
        '\u{1044f}',  Script::Deseret), ('\u{10450}', '\u{1047f}',  Script::Shavian), ('\u{10480}',
        '\u{1049d}',  Script::Osmanya), ('\u{104a0}', '\u{104a9}',  Script::Osmanya), ('\u{104b0}',
        '\u{104d3}',  Script::Osage), ('\u{104d8}', '\u{104fb}',  Script::Osage), ('\u{10500}',
        '\u{10527}',  Script::Elbasan), ('\u{10530}', '\u{10563}',  Script::Caucasian_Albanian),
        ('\u{1056f}', '\u{1056f}',  Script::Caucasian_Albanian), ('\u{10600}', '\u{10736}',
         Script::Linear_A), ('\u{10740}', '\u{10755}',  Script::Linear_A), ('\u{10760}',
        '\u{10767}',  Script::Linear_A), ('\u{10800}', '\u{10805}',  Script::Cypriot), ('\u{10808}',
        '\u{10808}',  Script::Cypriot), ('\u{1080a}', '\u{10835}',  Script::Cypriot), ('\u{10837}',
        '\u{10838}',  Script::Cypriot), ('\u{1083c}', '\u{1083c}',  Script::Cypriot), ('\u{1083f}',
        '\u{1083f}',  Script::Cypriot), ('\u{10840}', '\u{10855}',  Script::Imperial_Aramaic),
        ('\u{10857}', '\u{10857}',  Script::Imperial_Aramaic), ('\u{10858}', '\u{1085f}',
         Script::Imperial_Aramaic), ('\u{10860}', '\u{10876}',  Script::Palmyrene), ('\u{10877}',
        '\u{10878}',  Script::Palmyrene), ('\u{10879}', '\u{1087f}',  Script::Palmyrene),
        ('\u{10880}', '\u{1089e}',  Script::Nabataean), ('\u{108a7}', '\u{108af}',
         Script::Nabataean), ('\u{108e0}', '\u{108f2}',  Script::Hatran), ('\u{108f4}', '\u{108f5}',
         Script::Hatran), ('\u{108fb}', '\u{108ff}',  Script::Hatran), ('\u{10900}', '\u{10915}',
         Script::Phoenician), ('\u{10916}', '\u{1091b}',  Script::Phoenician), ('\u{1091f}',
        '\u{1091f}',  Script::Phoenician), ('\u{10920}', '\u{10939}',  Script::Lydian),
        ('\u{1093f}', '\u{1093f}',  Script::Lydian), ('\u{10980}', '\u{1099f}',
         Script::Meroitic_Hieroglyphs), ('\u{109a0}', '\u{109b7}',  Script::Meroitic_Cursive),
        ('\u{109bc}', '\u{109bd}',  Script::Meroitic_Cursive), ('\u{109be}', '\u{109bf}',
         Script::Meroitic_Cursive), ('\u{109c0}', '\u{109cf}',  Script::Meroitic_Cursive),
        ('\u{109d2}', '\u{109ff}',  Script::Meroitic_Cursive), ('\u{10a00}', '\u{10a00}',
         Script::Kharoshthi), ('\u{10a01}', '\u{10a03}',  Script::Kharoshthi), ('\u{10a05}',
        '\u{10a06}',  Script::Kharoshthi), ('\u{10a0c}', '\u{10a0f}',  Script::Kharoshthi),
        ('\u{10a10}', '\u{10a13}',  Script::Kharoshthi), ('\u{10a15}', '\u{10a17}',
         Script::Kharoshthi), ('\u{10a19}', '\u{10a35}',  Script::Kharoshthi), ('\u{10a38}',
        '\u{10a3a}',  Script::Kharoshthi), ('\u{10a3f}', '\u{10a3f}',  Script::Kharoshthi),
        ('\u{10a40}', '\u{10a48}',  Script::Kharoshthi), ('\u{10a50}', '\u{10a58}',
         Script::Kharoshthi), ('\u{10a60}', '\u{10a7c}',  Script::Old_South_Arabian), ('\u{10a7d}',
        '\u{10a7e}',  Script::Old_South_Arabian), ('\u{10a7f}', '\u{10a7f}',
         Script::Old_South_Arabian), ('\u{10a80}', '\u{10a9c}',  Script::Old_North_Arabian),
        ('\u{10a9d}', '\u{10a9f}',  Script::Old_North_Arabian), ('\u{10ac0}', '\u{10ac7}',
         Script::Manichaean), ('\u{10ac8}', '\u{10ac8}',  Script::Manichaean), ('\u{10ac9}',
        '\u{10ae4}',  Script::Manichaean), ('\u{10ae5}', '\u{10ae6}',  Script::Manichaean),
        ('\u{10aeb}', '\u{10aef}',  Script::Manichaean), ('\u{10af0}', '\u{10af6}',
         Script::Manichaean), ('\u{10b00}', '\u{10b35}',  Script::Avestan), ('\u{10b39}',
        '\u{10b3f}',  Script::Avestan), ('\u{10b40}', '\u{10b55}',  Script::Inscriptional_Parthian),
        ('\u{10b58}', '\u{10b5f}',  Script::Inscriptional_Parthian), ('\u{10b60}', '\u{10b72}',
         Script::Inscriptional_Pahlavi), ('\u{10b78}', '\u{10b7f}',  Script::Inscriptional_Pahlavi),
        ('\u{10b80}', '\u{10b91}',  Script::Psalter_Pahlavi), ('\u{10b99}', '\u{10b9c}',
         Script::Psalter_Pahlavi), ('\u{10ba9}', '\u{10baf}',  Script::Psalter_Pahlavi),
        ('\u{10c00}', '\u{10c48}',  Script::Old_Turkic), ('\u{10c80}', '\u{10cb2}',
         Script::Old_Hungarian), ('\u{10cc0}', '\u{10cf2}',  Script::Old_Hungarian), ('\u{10cfa}',
        '\u{10cff}',  Script::Old_Hungarian), ('\u{10d00}', '\u{10d23}',  Script::Hanifi_Rohingya),
        ('\u{10d24}', '\u{10d27}',  Script::Hanifi_Rohingya), ('\u{10d30}', '\u{10d39}',
         Script::Hanifi_Rohingya), ('\u{10e60}', '\u{10e7e}',  Script::Arabic), ('\u{10f00}',
        '\u{10f1c}',  Script::Old_Sogdian), ('\u{10f1d}', '\u{10f26}',  Script::Old_Sogdian),
        ('\u{10f27}', '\u{10f27}',  Script::Old_Sogdian), ('\u{10f30}', '\u{10f45}',
         Script::Sogdian), ('\u{10f46}', '\u{10f50}',  Script::Sogdian), ('\u{10f51}', '\u{10f54}',
         Script::Sogdian), ('\u{10f55}', '\u{10f59}',  Script::Sogdian), ('\u{10fe0}', '\u{10ff6}',
         Script::Elymaic), ('\u{11000}', '\u{11000}',  Script::Brahmi), ('\u{11001}', '\u{11001}',
         Script::Brahmi), ('\u{11002}', '\u{11002}',  Script::Brahmi), ('\u{11003}', '\u{11037}',
         Script::Brahmi), ('\u{11038}', '\u{11046}',  Script::Brahmi), ('\u{11047}', '\u{1104d}',
         Script::Brahmi), ('\u{11052}', '\u{11065}',  Script::Brahmi), ('\u{11066}', '\u{1106f}',
         Script::Brahmi), ('\u{1107f}', '\u{1107f}',  Script::Brahmi), ('\u{11080}', '\u{11081}',
         Script::Kaithi), ('\u{11082}', '\u{11082}',  Script::Kaithi), ('\u{11083}', '\u{110af}',
         Script::Kaithi), ('\u{110b0}', '\u{110b2}',  Script::Kaithi), ('\u{110b3}', '\u{110b6}',
         Script::Kaithi), ('\u{110b7}', '\u{110b8}',  Script::Kaithi), ('\u{110b9}', '\u{110ba}',
         Script::Kaithi), ('\u{110bb}', '\u{110bc}',  Script::Kaithi), ('\u{110bd}', '\u{110bd}',
         Script::Kaithi), ('\u{110be}', '\u{110c1}',  Script::Kaithi), ('\u{110cd}', '\u{110cd}',
         Script::Kaithi), ('\u{110d0}', '\u{110e8}',  Script::Sora_Sompeng), ('\u{110f0}',
        '\u{110f9}',  Script::Sora_Sompeng), ('\u{11100}', '\u{11102}',  Script::Chakma),
        ('\u{11103}', '\u{11126}',  Script::Chakma), ('\u{11127}', '\u{1112b}',  Script::Chakma),
        ('\u{1112c}', '\u{1112c}',  Script::Chakma), ('\u{1112d}', '\u{11134}',  Script::Chakma),
        ('\u{11136}', '\u{1113f}',  Script::Chakma), ('\u{11140}', '\u{11143}',  Script::Chakma),
        ('\u{11144}', '\u{11144}',  Script::Chakma), ('\u{11145}', '\u{11146}',  Script::Chakma),
        ('\u{11150}', '\u{11172}',  Script::Mahajani), ('\u{11173}', '\u{11173}',
         Script::Mahajani), ('\u{11174}', '\u{11175}',  Script::Mahajani), ('\u{11176}',
        '\u{11176}',  Script::Mahajani), ('\u{11180}', '\u{11181}',  Script::Sharada), ('\u{11182}',
        '\u{11182}',  Script::Sharada), ('\u{11183}', '\u{111b2}',  Script::Sharada), ('\u{111b3}',
        '\u{111b5}',  Script::Sharada), ('\u{111b6}', '\u{111be}',  Script::Sharada), ('\u{111bf}',
        '\u{111c0}',  Script::Sharada), ('\u{111c1}', '\u{111c4}',  Script::Sharada), ('\u{111c5}',
        '\u{111c8}',  Script::Sharada), ('\u{111c9}', '\u{111cc}',  Script::Sharada), ('\u{111cd}',
        '\u{111cd}',  Script::Sharada), ('\u{111d0}', '\u{111d9}',  Script::Sharada), ('\u{111da}',
        '\u{111da}',  Script::Sharada), ('\u{111db}', '\u{111db}',  Script::Sharada), ('\u{111dc}',
        '\u{111dc}',  Script::Sharada), ('\u{111dd}', '\u{111df}',  Script::Sharada), ('\u{111e1}',
        '\u{111f4}',  Script::Sinhala), ('\u{11200}', '\u{11211}',  Script::Khojki), ('\u{11213}',
        '\u{1122b}',  Script::Khojki), ('\u{1122c}', '\u{1122e}',  Script::Khojki), ('\u{1122f}',
        '\u{11231}',  Script::Khojki), ('\u{11232}', '\u{11233}',  Script::Khojki), ('\u{11234}',
        '\u{11234}',  Script::Khojki), ('\u{11235}', '\u{11235}',  Script::Khojki), ('\u{11236}',
        '\u{11237}',  Script::Khojki), ('\u{11238}', '\u{1123d}',  Script::Khojki), ('\u{1123e}',
        '\u{1123e}',  Script::Khojki), ('\u{11280}', '\u{11286}',  Script::Multani), ('\u{11288}',
        '\u{11288}',  Script::Multani), ('\u{1128a}', '\u{1128d}',  Script::Multani), ('\u{1128f}',
        '\u{1129d}',  Script::Multani), ('\u{1129f}', '\u{112a8}',  Script::Multani), ('\u{112a9}',
        '\u{112a9}',  Script::Multani), ('\u{112b0}', '\u{112de}',  Script::Khudawadi),
        ('\u{112df}', '\u{112df}',  Script::Khudawadi), ('\u{112e0}', '\u{112e2}',
         Script::Khudawadi), ('\u{112e3}', '\u{112ea}',  Script::Khudawadi), ('\u{112f0}',
        '\u{112f9}',  Script::Khudawadi), ('\u{11300}', '\u{11301}',  Script::Grantha),
        ('\u{11302}', '\u{11303}',  Script::Grantha), ('\u{11305}', '\u{1130c}',  Script::Grantha),
        ('\u{1130f}', '\u{11310}',  Script::Grantha), ('\u{11313}', '\u{11328}',  Script::Grantha),
        ('\u{1132a}', '\u{11330}',  Script::Grantha), ('\u{11332}', '\u{11333}',  Script::Grantha),
        ('\u{11335}', '\u{11339}',  Script::Grantha), ('\u{1133b}', '\u{1133b}',
         Script::Inherited), ('\u{1133c}', '\u{1133c}',  Script::Grantha), ('\u{1133d}',
        '\u{1133d}',  Script::Grantha), ('\u{1133e}', '\u{1133f}',  Script::Grantha), ('\u{11340}',
        '\u{11340}',  Script::Grantha), ('\u{11341}', '\u{11344}',  Script::Grantha), ('\u{11347}',
        '\u{11348}',  Script::Grantha), ('\u{1134b}', '\u{1134d}',  Script::Grantha), ('\u{11350}',
        '\u{11350}',  Script::Grantha), ('\u{11357}', '\u{11357}',  Script::Grantha), ('\u{1135d}',
        '\u{11361}',  Script::Grantha), ('\u{11362}', '\u{11363}',  Script::Grantha), ('\u{11366}',
        '\u{1136c}',  Script::Grantha), ('\u{11370}', '\u{11374}',  Script::Grantha), ('\u{11400}',
        '\u{11434}',  Script::Newa), ('\u{11435}', '\u{11437}',  Script::Newa), ('\u{11438}',
        '\u{1143f}',  Script::Newa), ('\u{11440}', '\u{11441}',  Script::Newa), ('\u{11442}',
        '\u{11444}',  Script::Newa), ('\u{11445}', '\u{11445}',  Script::Newa), ('\u{11446}',
        '\u{11446}',  Script::Newa), ('\u{11447}', '\u{1144a}',  Script::Newa), ('\u{1144b}',
        '\u{1144f}',  Script::Newa), ('\u{11450}', '\u{11459}',  Script::Newa), ('\u{1145b}',
        '\u{1145b}',  Script::Newa), ('\u{1145d}', '\u{1145d}',  Script::Newa), ('\u{1145e}',
        '\u{1145e}',  Script::Newa), ('\u{1145f}', '\u{1145f}',  Script::Newa), ('\u{11480}',
        '\u{114af}',  Script::Tirhuta), ('\u{114b0}', '\u{114b2}',  Script::Tirhuta), ('\u{114b3}',
        '\u{114b8}',  Script::Tirhuta), ('\u{114b9}', '\u{114b9}',  Script::Tirhuta), ('\u{114ba}',
        '\u{114ba}',  Script::Tirhuta), ('\u{114bb}', '\u{114be}',  Script::Tirhuta), ('\u{114bf}',
        '\u{114c0}',  Script::Tirhuta), ('\u{114c1}', '\u{114c1}',  Script::Tirhuta), ('\u{114c2}',
        '\u{114c3}',  Script::Tirhuta), ('\u{114c4}', '\u{114c5}',  Script::Tirhuta), ('\u{114c6}',
        '\u{114c6}',  Script::Tirhuta), ('\u{114c7}', '\u{114c7}',  Script::Tirhuta), ('\u{114d0}',
        '\u{114d9}',  Script::Tirhuta), ('\u{11580}', '\u{115ae}',  Script::Siddham), ('\u{115af}',
        '\u{115b1}',  Script::Siddham), ('\u{115b2}', '\u{115b5}',  Script::Siddham), ('\u{115b8}',
        '\u{115bb}',  Script::Siddham), ('\u{115bc}', '\u{115bd}',  Script::Siddham), ('\u{115be}',
        '\u{115be}',  Script::Siddham), ('\u{115bf}', '\u{115c0}',  Script::Siddham), ('\u{115c1}',
        '\u{115d7}',  Script::Siddham), ('\u{115d8}', '\u{115db}',  Script::Siddham), ('\u{115dc}',
        '\u{115dd}',  Script::Siddham), ('\u{11600}', '\u{1162f}',  Script::Modi), ('\u{11630}',
        '\u{11632}',  Script::Modi), ('\u{11633}', '\u{1163a}',  Script::Modi), ('\u{1163b}',
        '\u{1163c}',  Script::Modi), ('\u{1163d}', '\u{1163d}',  Script::Modi), ('\u{1163e}',
        '\u{1163e}',  Script::Modi), ('\u{1163f}', '\u{11640}',  Script::Modi), ('\u{11641}',
        '\u{11643}',  Script::Modi), ('\u{11644}', '\u{11644}',  Script::Modi), ('\u{11650}',
        '\u{11659}',  Script::Modi), ('\u{11660}', '\u{1166c}',  Script::Mongolian), ('\u{11680}',
        '\u{116aa}',  Script::Takri), ('\u{116ab}', '\u{116ab}',  Script::Takri), ('\u{116ac}',
        '\u{116ac}',  Script::Takri), ('\u{116ad}', '\u{116ad}',  Script::Takri), ('\u{116ae}',
        '\u{116af}',  Script::Takri), ('\u{116b0}', '\u{116b5}',  Script::Takri), ('\u{116b6}',
        '\u{116b6}',  Script::Takri), ('\u{116b7}', '\u{116b7}',  Script::Takri), ('\u{116b8}',
        '\u{116b8}',  Script::Takri), ('\u{116c0}', '\u{116c9}',  Script::Takri), ('\u{11700}',
        '\u{1171a}',  Script::Ahom), ('\u{1171d}', '\u{1171f}',  Script::Ahom), ('\u{11720}',
        '\u{11721}',  Script::Ahom), ('\u{11722}', '\u{11725}',  Script::Ahom), ('\u{11726}',
        '\u{11726}',  Script::Ahom), ('\u{11727}', '\u{1172b}',  Script::Ahom), ('\u{11730}',
        '\u{11739}',  Script::Ahom), ('\u{1173a}', '\u{1173b}',  Script::Ahom), ('\u{1173c}',
        '\u{1173e}',  Script::Ahom), ('\u{1173f}', '\u{1173f}',  Script::Ahom), ('\u{11800}',
        '\u{1182b}',  Script::Dogra), ('\u{1182c}', '\u{1182e}',  Script::Dogra), ('\u{1182f}',
        '\u{11837}',  Script::Dogra), ('\u{11838}', '\u{11838}',  Script::Dogra), ('\u{11839}',
        '\u{1183a}',  Script::Dogra), ('\u{1183b}', '\u{1183b}',  Script::Dogra), ('\u{118a0}',
        '\u{118df}',  Script::Warang_Citi), ('\u{118e0}', '\u{118e9}',  Script::Warang_Citi),
        ('\u{118ea}', '\u{118f2}',  Script::Warang_Citi), ('\u{118ff}', '\u{118ff}',
         Script::Warang_Citi), ('\u{119a0}', '\u{119a7}',  Script::Nandinagari), ('\u{119aa}',
        '\u{119d0}',  Script::Nandinagari), ('\u{119d1}', '\u{119d3}',  Script::Nandinagari),
        ('\u{119d4}', '\u{119d7}',  Script::Nandinagari), ('\u{119da}', '\u{119db}',
         Script::Nandinagari), ('\u{119dc}', '\u{119df}',  Script::Nandinagari), ('\u{119e0}',
        '\u{119e0}',  Script::Nandinagari), ('\u{119e1}', '\u{119e1}',  Script::Nandinagari),
        ('\u{119e2}', '\u{119e2}',  Script::Nandinagari), ('\u{119e3}', '\u{119e3}',
         Script::Nandinagari), ('\u{119e4}', '\u{119e4}',  Script::Nandinagari), ('\u{11a00}',
        '\u{11a00}',  Script::Zanabazar_Square), ('\u{11a01}', '\u{11a0a}',
         Script::Zanabazar_Square), ('\u{11a0b}', '\u{11a32}',  Script::Zanabazar_Square),
        ('\u{11a33}', '\u{11a38}',  Script::Zanabazar_Square), ('\u{11a39}', '\u{11a39}',
         Script::Zanabazar_Square), ('\u{11a3a}', '\u{11a3a}',  Script::Zanabazar_Square),
        ('\u{11a3b}', '\u{11a3e}',  Script::Zanabazar_Square), ('\u{11a3f}', '\u{11a46}',
         Script::Zanabazar_Square), ('\u{11a47}', '\u{11a47}',  Script::Zanabazar_Square),
        ('\u{11a50}', '\u{11a50}',  Script::Soyombo), ('\u{11a51}', '\u{11a56}',  Script::Soyombo),
        ('\u{11a57}', '\u{11a58}',  Script::Soyombo), ('\u{11a59}', '\u{11a5b}',  Script::Soyombo),
        ('\u{11a5c}', '\u{11a89}',  Script::Soyombo), ('\u{11a8a}', '\u{11a96}',  Script::Soyombo),
        ('\u{11a97}', '\u{11a97}',  Script::Soyombo), ('\u{11a98}', '\u{11a99}',  Script::Soyombo),
        ('\u{11a9a}', '\u{11a9c}',  Script::Soyombo), ('\u{11a9d}', '\u{11a9d}',  Script::Soyombo),
        ('\u{11a9e}', '\u{11aa2}',  Script::Soyombo), ('\u{11ac0}', '\u{11af8}',
         Script::Pau_Cin_Hau), ('\u{11c00}', '\u{11c08}',  Script::Bhaiksuki), ('\u{11c0a}',
        '\u{11c2e}',  Script::Bhaiksuki), ('\u{11c2f}', '\u{11c2f}',  Script::Bhaiksuki),
        ('\u{11c30}', '\u{11c36}',  Script::Bhaiksuki), ('\u{11c38}', '\u{11c3d}',
         Script::Bhaiksuki), ('\u{11c3e}', '\u{11c3e}',  Script::Bhaiksuki), ('\u{11c3f}',
        '\u{11c3f}',  Script::Bhaiksuki), ('\u{11c40}', '\u{11c40}',  Script::Bhaiksuki),
        ('\u{11c41}', '\u{11c45}',  Script::Bhaiksuki), ('\u{11c50}', '\u{11c59}',
         Script::Bhaiksuki), ('\u{11c5a}', '\u{11c6c}',  Script::Bhaiksuki), ('\u{11c70}',
        '\u{11c71}',  Script::Marchen), ('\u{11c72}', '\u{11c8f}',  Script::Marchen), ('\u{11c92}',
        '\u{11ca7}',  Script::Marchen), ('\u{11ca9}', '\u{11ca9}',  Script::Marchen), ('\u{11caa}',
        '\u{11cb0}',  Script::Marchen), ('\u{11cb1}', '\u{11cb1}',  Script::Marchen), ('\u{11cb2}',
        '\u{11cb3}',  Script::Marchen), ('\u{11cb4}', '\u{11cb4}',  Script::Marchen), ('\u{11cb5}',
        '\u{11cb6}',  Script::Marchen), ('\u{11d00}', '\u{11d06}',  Script::Masaram_Gondi),
        ('\u{11d08}', '\u{11d09}',  Script::Masaram_Gondi), ('\u{11d0b}', '\u{11d30}',
         Script::Masaram_Gondi), ('\u{11d31}', '\u{11d36}',  Script::Masaram_Gondi), ('\u{11d3a}',
        '\u{11d3a}',  Script::Masaram_Gondi), ('\u{11d3c}', '\u{11d3d}',  Script::Masaram_Gondi),
        ('\u{11d3f}', '\u{11d45}',  Script::Masaram_Gondi), ('\u{11d46}', '\u{11d46}',
         Script::Masaram_Gondi), ('\u{11d47}', '\u{11d47}',  Script::Masaram_Gondi), ('\u{11d50}',
        '\u{11d59}',  Script::Masaram_Gondi), ('\u{11d60}', '\u{11d65}',  Script::Gunjala_Gondi),
        ('\u{11d67}', '\u{11d68}',  Script::Gunjala_Gondi), ('\u{11d6a}', '\u{11d89}',
         Script::Gunjala_Gondi), ('\u{11d8a}', '\u{11d8e}',  Script::Gunjala_Gondi), ('\u{11d90}',
        '\u{11d91}',  Script::Gunjala_Gondi), ('\u{11d93}', '\u{11d94}',  Script::Gunjala_Gondi),
        ('\u{11d95}', '\u{11d95}',  Script::Gunjala_Gondi), ('\u{11d96}', '\u{11d96}',
         Script::Gunjala_Gondi), ('\u{11d97}', '\u{11d97}',  Script::Gunjala_Gondi), ('\u{11d98}',
        '\u{11d98}',  Script::Gunjala_Gondi), ('\u{11da0}', '\u{11da9}',  Script::Gunjala_Gondi),
        ('\u{11ee0}', '\u{11ef2}',  Script::Makasar), ('\u{11ef3}', '\u{11ef4}',  Script::Makasar),
        ('\u{11ef5}', '\u{11ef6}',  Script::Makasar), ('\u{11ef7}', '\u{11ef8}',  Script::Makasar),
        ('\u{11fc0}', '\u{11fd4}',  Script::Tamil), ('\u{11fd5}', '\u{11fdc}',  Script::Tamil),
        ('\u{11fdd}', '\u{11fe0}',  Script::Tamil), ('\u{11fe1}', '\u{11ff1}',  Script::Tamil),
        ('\u{11fff}', '\u{11fff}',  Script::Tamil), ('\u{12000}', '\u{12399}',  Script::Cuneiform),
        ('\u{12400}', '\u{1246e}',  Script::Cuneiform), ('\u{12470}', '\u{12474}',
         Script::Cuneiform), ('\u{12480}', '\u{12543}',  Script::Cuneiform), ('\u{13000}',
        '\u{1342e}',  Script::Egyptian_Hieroglyphs), ('\u{13430}', '\u{13438}',
         Script::Egyptian_Hieroglyphs), ('\u{14400}', '\u{14646}',  Script::Anatolian_Hieroglyphs),
        ('\u{16800}', '\u{16a38}',  Script::Bamum), ('\u{16a40}', '\u{16a5e}',  Script::Mro),
        ('\u{16a60}', '\u{16a69}',  Script::Mro), ('\u{16a6e}', '\u{16a6f}',  Script::Mro),
        ('\u{16ad0}', '\u{16aed}',  Script::Bassa_Vah), ('\u{16af0}', '\u{16af4}',
         Script::Bassa_Vah), ('\u{16af5}', '\u{16af5}',  Script::Bassa_Vah), ('\u{16b00}',
        '\u{16b2f}',  Script::Pahawh_Hmong), ('\u{16b30}', '\u{16b36}',  Script::Pahawh_Hmong),
        ('\u{16b37}', '\u{16b3b}',  Script::Pahawh_Hmong), ('\u{16b3c}', '\u{16b3f}',
         Script::Pahawh_Hmong), ('\u{16b40}', '\u{16b43}',  Script::Pahawh_Hmong), ('\u{16b44}',
        '\u{16b44}',  Script::Pahawh_Hmong), ('\u{16b45}', '\u{16b45}',  Script::Pahawh_Hmong),
        ('\u{16b50}', '\u{16b59}',  Script::Pahawh_Hmong), ('\u{16b5b}', '\u{16b61}',
         Script::Pahawh_Hmong), ('\u{16b63}', '\u{16b77}',  Script::Pahawh_Hmong), ('\u{16b7d}',
        '\u{16b8f}',  Script::Pahawh_Hmong), ('\u{16e40}', '\u{16e7f}',  Script::Medefaidrin),
        ('\u{16e80}', '\u{16e96}',  Script::Medefaidrin), ('\u{16e97}', '\u{16e9a}',
         Script::Medefaidrin), ('\u{16f00}', '\u{16f4a}',  Script::Miao), ('\u{16f4f}', '\u{16f4f}',
         Script::Miao), ('\u{16f50}', '\u{16f50}',  Script::Miao), ('\u{16f51}', '\u{16f87}',
         Script::Miao), ('\u{16f8f}', '\u{16f92}',  Script::Miao), ('\u{16f93}', '\u{16f9f}',
         Script::Miao), ('\u{16fe0}', '\u{16fe0}',  Script::Tangut), ('\u{16fe1}', '\u{16fe1}',
         Script::Nushu), ('\u{16fe2}', '\u{16fe2}',  Script::Common), ('\u{16fe3}', '\u{16fe3}',
         Script::Common), ('\u{17000}', '\u{187f7}',  Script::Tangut), ('\u{18800}', '\u{18af2}',
         Script::Tangut), ('\u{1b000}', '\u{1b000}',  Script::Katakana), ('\u{1b001}', '\u{1b11e}',
         Script::Hiragana), ('\u{1b150}', '\u{1b152}',  Script::Hiragana), ('\u{1b164}',
        '\u{1b167}',  Script::Katakana), ('\u{1b170}', '\u{1b2fb}',  Script::Nushu), ('\u{1bc00}',
        '\u{1bc6a}',  Script::Duployan), ('\u{1bc70}', '\u{1bc7c}',  Script::Duployan),
        ('\u{1bc80}', '\u{1bc88}',  Script::Duployan), ('\u{1bc90}', '\u{1bc99}',
         Script::Duployan), ('\u{1bc9c}', '\u{1bc9c}',  Script::Duployan), ('\u{1bc9d}',
        '\u{1bc9e}',  Script::Duployan), ('\u{1bc9f}', '\u{1bc9f}',  Script::Duployan),
        ('\u{1bca0}', '\u{1bca3}',  Script::Common), ('\u{1d000}', '\u{1d0f5}',  Script::Common),
        ('\u{1d100}', '\u{1d126}',  Script::Common), ('\u{1d129}', '\u{1d164}',  Script::Common),
        ('\u{1d165}', '\u{1d166}',  Script::Common), ('\u{1d167}', '\u{1d169}',  Script::Inherited),
        ('\u{1d16a}', '\u{1d16c}',  Script::Common), ('\u{1d16d}', '\u{1d172}',  Script::Common),
        ('\u{1d173}', '\u{1d17a}',  Script::Common), ('\u{1d17b}', '\u{1d182}',  Script::Inherited),
        ('\u{1d183}', '\u{1d184}',  Script::Common), ('\u{1d185}', '\u{1d18b}',  Script::Inherited),
        ('\u{1d18c}', '\u{1d1a9}',  Script::Common), ('\u{1d1aa}', '\u{1d1ad}',  Script::Inherited),
        ('\u{1d1ae}', '\u{1d1e8}',  Script::Common), ('\u{1d200}', '\u{1d241}',  Script::Greek),
        ('\u{1d242}', '\u{1d244}',  Script::Greek), ('\u{1d245}', '\u{1d245}',  Script::Greek),
        ('\u{1d2e0}', '\u{1d2f3}',  Script::Common), ('\u{1d300}', '\u{1d356}',  Script::Common),
        ('\u{1d360}', '\u{1d378}',  Script::Common), ('\u{1d400}', '\u{1d454}',  Script::Common),
        ('\u{1d456}', '\u{1d49c}',  Script::Common), ('\u{1d49e}', '\u{1d49f}',  Script::Common),
        ('\u{1d4a2}', '\u{1d4a2}',  Script::Common), ('\u{1d4a5}', '\u{1d4a6}',  Script::Common),
        ('\u{1d4a9}', '\u{1d4ac}',  Script::Common), ('\u{1d4ae}', '\u{1d4b9}',  Script::Common),
        ('\u{1d4bb}', '\u{1d4bb}',  Script::Common), ('\u{1d4bd}', '\u{1d4c3}',  Script::Common),
        ('\u{1d4c5}', '\u{1d505}',  Script::Common), ('\u{1d507}', '\u{1d50a}',  Script::Common),
        ('\u{1d50d}', '\u{1d514}',  Script::Common), ('\u{1d516}', '\u{1d51c}',  Script::Common),
        ('\u{1d51e}', '\u{1d539}',  Script::Common), ('\u{1d53b}', '\u{1d53e}',  Script::Common),
        ('\u{1d540}', '\u{1d544}',  Script::Common), ('\u{1d546}', '\u{1d546}',  Script::Common),
        ('\u{1d54a}', '\u{1d550}',  Script::Common), ('\u{1d552}', '\u{1d6a5}',  Script::Common),
        ('\u{1d6a8}', '\u{1d6c0}',  Script::Common), ('\u{1d6c1}', '\u{1d6c1}',  Script::Common),
        ('\u{1d6c2}', '\u{1d6da}',  Script::Common), ('\u{1d6db}', '\u{1d6db}',  Script::Common),
        ('\u{1d6dc}', '\u{1d6fa}',  Script::Common), ('\u{1d6fb}', '\u{1d6fb}',  Script::Common),
        ('\u{1d6fc}', '\u{1d714}',  Script::Common), ('\u{1d715}', '\u{1d715}',  Script::Common),
        ('\u{1d716}', '\u{1d734}',  Script::Common), ('\u{1d735}', '\u{1d735}',  Script::Common),
        ('\u{1d736}', '\u{1d74e}',  Script::Common), ('\u{1d74f}', '\u{1d74f}',  Script::Common),
        ('\u{1d750}', '\u{1d76e}',  Script::Common), ('\u{1d76f}', '\u{1d76f}',  Script::Common),
        ('\u{1d770}', '\u{1d788}',  Script::Common), ('\u{1d789}', '\u{1d789}',  Script::Common),
        ('\u{1d78a}', '\u{1d7a8}',  Script::Common), ('\u{1d7a9}', '\u{1d7a9}',  Script::Common),
        ('\u{1d7aa}', '\u{1d7c2}',  Script::Common), ('\u{1d7c3}', '\u{1d7c3}',  Script::Common),
        ('\u{1d7c4}', '\u{1d7cb}',  Script::Common), ('\u{1d7ce}', '\u{1d7ff}',  Script::Common),
        ('\u{1d800}', '\u{1d9ff}',  Script::SignWriting), ('\u{1da00}', '\u{1da36}',
         Script::SignWriting), ('\u{1da37}', '\u{1da3a}',  Script::SignWriting), ('\u{1da3b}',
        '\u{1da6c}',  Script::SignWriting), ('\u{1da6d}', '\u{1da74}',  Script::SignWriting),
        ('\u{1da75}', '\u{1da75}',  Script::SignWriting), ('\u{1da76}', '\u{1da83}',
         Script::SignWriting), ('\u{1da84}', '\u{1da84}',  Script::SignWriting), ('\u{1da85}',
        '\u{1da86}',  Script::SignWriting), ('\u{1da87}', '\u{1da8b}',  Script::SignWriting),
        ('\u{1da9b}', '\u{1da9f}',  Script::SignWriting), ('\u{1daa1}', '\u{1daaf}',
         Script::SignWriting), ('\u{1e000}', '\u{1e006}',  Script::Glagolitic), ('\u{1e008}',
        '\u{1e018}',  Script::Glagolitic), ('\u{1e01b}', '\u{1e021}',  Script::Glagolitic),
        ('\u{1e023}', '\u{1e024}',  Script::Glagolitic), ('\u{1e026}', '\u{1e02a}',
         Script::Glagolitic), ('\u{1e100}', '\u{1e12c}',  Script::Nyiakeng_Puachue_Hmong),
        ('\u{1e130}', '\u{1e136}',  Script::Nyiakeng_Puachue_Hmong), ('\u{1e137}', '\u{1e13d}',
         Script::Nyiakeng_Puachue_Hmong), ('\u{1e140}', '\u{1e149}',
         Script::Nyiakeng_Puachue_Hmong), ('\u{1e14e}', '\u{1e14e}',
         Script::Nyiakeng_Puachue_Hmong), ('\u{1e14f}', '\u{1e14f}',
         Script::Nyiakeng_Puachue_Hmong), ('\u{1e2c0}', '\u{1e2eb}',  Script::Wancho), ('\u{1e2ec}',
        '\u{1e2ef}',  Script::Wancho), ('\u{1e2f0}', '\u{1e2f9}',  Script::Wancho), ('\u{1e2ff}',
        '\u{1e2ff}',  Script::Wancho), ('\u{1e800}', '\u{1e8c4}',  Script::Mende_Kikakui),
        ('\u{1e8c7}', '\u{1e8cf}',  Script::Mende_Kikakui), ('\u{1e8d0}', '\u{1e8d6}',
         Script::Mende_Kikakui), ('\u{1e900}', '\u{1e943}',  Script::Adlam), ('\u{1e944}',
        '\u{1e94a}',  Script::Adlam), ('\u{1e94b}', '\u{1e94b}',  Script::Adlam), ('\u{1e950}',
        '\u{1e959}',  Script::Adlam), ('\u{1e95e}', '\u{1e95f}',  Script::Adlam), ('\u{1ec71}',
        '\u{1ecab}',  Script::Common), ('\u{1ecac}', '\u{1ecac}',  Script::Common), ('\u{1ecad}',
        '\u{1ecaf}',  Script::Common), ('\u{1ecb0}', '\u{1ecb0}',  Script::Common), ('\u{1ecb1}',
        '\u{1ecb4}',  Script::Common), ('\u{1ed01}', '\u{1ed2d}',  Script::Common), ('\u{1ed2e}',
        '\u{1ed2e}',  Script::Common), ('\u{1ed2f}', '\u{1ed3d}',  Script::Common), ('\u{1ee00}',
        '\u{1ee03}',  Script::Arabic), ('\u{1ee05}', '\u{1ee1f}',  Script::Arabic), ('\u{1ee21}',
        '\u{1ee22}',  Script::Arabic), ('\u{1ee24}', '\u{1ee24}',  Script::Arabic), ('\u{1ee27}',
        '\u{1ee27}',  Script::Arabic), ('\u{1ee29}', '\u{1ee32}',  Script::Arabic), ('\u{1ee34}',
        '\u{1ee37}',  Script::Arabic), ('\u{1ee39}', '\u{1ee39}',  Script::Arabic), ('\u{1ee3b}',
        '\u{1ee3b}',  Script::Arabic), ('\u{1ee42}', '\u{1ee42}',  Script::Arabic), ('\u{1ee47}',
        '\u{1ee47}',  Script::Arabic), ('\u{1ee49}', '\u{1ee49}',  Script::Arabic), ('\u{1ee4b}',
        '\u{1ee4b}',  Script::Arabic), ('\u{1ee4d}', '\u{1ee4f}',  Script::Arabic), ('\u{1ee51}',
        '\u{1ee52}',  Script::Arabic), ('\u{1ee54}', '\u{1ee54}',  Script::Arabic), ('\u{1ee57}',
        '\u{1ee57}',  Script::Arabic), ('\u{1ee59}', '\u{1ee59}',  Script::Arabic), ('\u{1ee5b}',
        '\u{1ee5b}',  Script::Arabic), ('\u{1ee5d}', '\u{1ee5d}',  Script::Arabic), ('\u{1ee5f}',
        '\u{1ee5f}',  Script::Arabic), ('\u{1ee61}', '\u{1ee62}',  Script::Arabic), ('\u{1ee64}',
        '\u{1ee64}',  Script::Arabic), ('\u{1ee67}', '\u{1ee6a}',  Script::Arabic), ('\u{1ee6c}',
        '\u{1ee72}',  Script::Arabic), ('\u{1ee74}', '\u{1ee77}',  Script::Arabic), ('\u{1ee79}',
        '\u{1ee7c}',  Script::Arabic), ('\u{1ee7e}', '\u{1ee7e}',  Script::Arabic), ('\u{1ee80}',
        '\u{1ee89}',  Script::Arabic), ('\u{1ee8b}', '\u{1ee9b}',  Script::Arabic), ('\u{1eea1}',
        '\u{1eea3}',  Script::Arabic), ('\u{1eea5}', '\u{1eea9}',  Script::Arabic), ('\u{1eeab}',
        '\u{1eebb}',  Script::Arabic), ('\u{1eef0}', '\u{1eef1}',  Script::Arabic), ('\u{1f000}',
        '\u{1f02b}',  Script::Common), ('\u{1f030}', '\u{1f093}',  Script::Common), ('\u{1f0a0}',
        '\u{1f0ae}',  Script::Common), ('\u{1f0b1}', '\u{1f0bf}',  Script::Common), ('\u{1f0c1}',
        '\u{1f0cf}',  Script::Common), ('\u{1f0d1}', '\u{1f0f5}',  Script::Common), ('\u{1f100}',
        '\u{1f10c}',  Script::Common), ('\u{1f110}', '\u{1f16c}',  Script::Common), ('\u{1f170}',
        '\u{1f1ac}',  Script::Common), ('\u{1f1e6}', '\u{1f1ff}',  Script::Common), ('\u{1f200}',
        '\u{1f200}',  Script::Hiragana), ('\u{1f201}', '\u{1f202}',  Script::Common), ('\u{1f210}',
        '\u{1f23b}',  Script::Common), ('\u{1f240}', '\u{1f248}',  Script::Common), ('\u{1f250}',
        '\u{1f251}',  Script::Common), ('\u{1f260}', '\u{1f265}',  Script::Common), ('\u{1f300}',
        '\u{1f3fa}',  Script::Common), ('\u{1f3fb}', '\u{1f3ff}',  Script::Common), ('\u{1f400}',
        '\u{1f6d5}',  Script::Common), ('\u{1f6e0}', '\u{1f6ec}',  Script::Common), ('\u{1f6f0}',
        '\u{1f6fa}',  Script::Common), ('\u{1f700}', '\u{1f773}',  Script::Common), ('\u{1f780}',
        '\u{1f7d8}',  Script::Common), ('\u{1f7e0}', '\u{1f7eb}',  Script::Common), ('\u{1f800}',
        '\u{1f80b}',  Script::Common), ('\u{1f810}', '\u{1f847}',  Script::Common), ('\u{1f850}',
        '\u{1f859}',  Script::Common), ('\u{1f860}', '\u{1f887}',  Script::Common), ('\u{1f890}',
        '\u{1f8ad}',  Script::Common), ('\u{1f900}', '\u{1f90b}',  Script::Common), ('\u{1f90d}',
        '\u{1f971}',  Script::Common), ('\u{1f973}', '\u{1f976}',  Script::Common), ('\u{1f97a}',
        '\u{1f9a2}',  Script::Common), ('\u{1f9a5}', '\u{1f9aa}',  Script::Common), ('\u{1f9ae}',
        '\u{1f9ca}',  Script::Common), ('\u{1f9cd}', '\u{1fa53}',  Script::Common), ('\u{1fa60}',
        '\u{1fa6d}',  Script::Common), ('\u{1fa70}', '\u{1fa73}',  Script::Common), ('\u{1fa78}',
        '\u{1fa7a}',  Script::Common), ('\u{1fa80}', '\u{1fa82}',  Script::Common), ('\u{1fa90}',
        '\u{1fa95}',  Script::Common), ('\u{20000}', '\u{2a6d6}',  Script::Han), ('\u{2a700}',
        '\u{2b734}',  Script::Han), ('\u{2b740}', '\u{2b81d}',  Script::Han), ('\u{2b820}',
        '\u{2cea1}',  Script::Han), ('\u{2ceb0}', '\u{2ebe0}',  Script::Han), ('\u{2f800}',
        '\u{2fa1d}',  Script::Han), ('\u{e0001}', '\u{e0001}',  Script::Common), ('\u{e0020}',
        '\u{e007f}',  Script::Common), ('\u{e0100}', '\u{e01ef}',  Script::Inherited)
    ];

    const SCRIPT_EXTENSIONS: &'static [(char, char, ScriptExtension)] = &[
        ('\u{342}', '\u{342}', ScriptExtension::Single(Script::Greek)), ('\u{345}', '\u{345}',
        ScriptExtension::Single(Script::Greek)), ('\u{363}', '\u{36f}',
        ScriptExtension::Single(Script::Latin)), ('\u{483}', '\u{483}', ScriptExtension::CyrlPerm),
        ('\u{484}', '\u{484}', ScriptExtension::CyrlGlag), ('\u{485}', '\u{486}',
        ScriptExtension::CyrlLatn), ('\u{487}', '\u{487}', ScriptExtension::CyrlGlag), ('\u{589}',
        '\u{589}', ScriptExtension::ArmnGeor), ('\u{60c}', '\u{60c}',
        ScriptExtension::ArabRohgSyrcThaa), ('\u{61b}', '\u{61b}',
        ScriptExtension::ArabRohgSyrcThaa), ('\u{61c}', '\u{61c}', ScriptExtension::ArabSyrcThaa),
        ('\u{61f}', '\u{61f}', ScriptExtension::ArabRohgSyrcThaa), ('\u{640}', '\u{640}',
        ScriptExtension::AdlmArabMandManiPhlpRohgSogdSyrc), ('\u{64b}', '\u{655}',
        ScriptExtension::ArabSyrc), ('\u{660}', '\u{669}', ScriptExtension::ArabThaa), ('\u{670}',
        '\u{670}', ScriptExtension::ArabSyrc), ('\u{6d4}', '\u{6d4}', ScriptExtension::ArabRohg),
        ('\u{951}', '\u{951}',
        ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaShrdTamlTeluTirh), ('\u{952}',
        '\u{952}', ScriptExtension::BengDevaGranGujrGuruKndaLatnMlymOryaTamlTeluTirh), ('\u{964}',
        '\u{964}',
        ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh),
        ('\u{965}', '\u{965}',
        ScriptExtension::BengDevaDogrGongGonmGranGujrGuruKndaLimbMahjMlymNandOryaSindSinhSyloTakrTamlTeluTirh),
        ('\u{966}', '\u{96f}', ScriptExtension::DevaDogrKthiMahj), ('\u{9e6}', '\u{9ef}',
        ScriptExtension::BengCakmSylo), ('\u{a66}', '\u{a6f}', ScriptExtension::GuruMult),
        ('\u{ae6}', '\u{aef}', ScriptExtension::GujrKhoj), ('\u{be6}', '\u{bef}',
        ScriptExtension::GranTaml), ('\u{bf0}', '\u{bf2}', ScriptExtension::GranTaml), ('\u{bf3}',
        '\u{bf3}', ScriptExtension::GranTaml), ('\u{ce6}', '\u{cef}', ScriptExtension::KndaNand),
        ('\u{1040}', '\u{1049}', ScriptExtension::CakmMymrTale), ('\u{10fb}', '\u{10fb}',
        ScriptExtension::GeorLatn), ('\u{1735}', '\u{1736}', ScriptExtension::BuhdHanoTagbTglg),
        ('\u{1802}', '\u{1803}', ScriptExtension::MongPhag), ('\u{1805}', '\u{1805}',
        ScriptExtension::MongPhag), ('\u{1cd0}', '\u{1cd0}', ScriptExtension::BengDevaGranKnda),
        ('\u{1cd1}', '\u{1cd1}', ScriptExtension::Single(Script::Devanagari)), ('\u{1cd2}',
        '\u{1cd2}', ScriptExtension::BengDevaGranKnda), ('\u{1cd3}', '\u{1cd3}',
        ScriptExtension::DevaGran), ('\u{1cd4}', '\u{1cd4}',
        ScriptExtension::Single(Script::Devanagari)), ('\u{1cd5}', '\u{1cd6}',
        ScriptExtension::BengDeva), ('\u{1cd7}', '\u{1cd7}', ScriptExtension::DevaShrd),
        ('\u{1cd8}', '\u{1cd8}', ScriptExtension::BengDeva), ('\u{1cd9}', '\u{1cd9}',
        ScriptExtension::DevaShrd), ('\u{1cda}', '\u{1cda}',
        ScriptExtension::DevaKndaMlymOryaTamlTelu), ('\u{1cdb}', '\u{1cdb}',
        ScriptExtension::Single(Script::Devanagari)), ('\u{1cdc}', '\u{1cdd}',
        ScriptExtension::DevaShrd), ('\u{1cde}', '\u{1cdf}',
        ScriptExtension::Single(Script::Devanagari)), ('\u{1ce0}', '\u{1ce0}',
        ScriptExtension::DevaShrd), ('\u{1ce1}', '\u{1ce1}', ScriptExtension::BengDeva),
        ('\u{1ce2}', '\u{1ce8}', ScriptExtension::Single(Script::Devanagari)), ('\u{1ce9}',
        '\u{1ce9}', ScriptExtension::DevaNand), ('\u{1cea}', '\u{1cea}', ScriptExtension::BengDeva),
        ('\u{1ceb}', '\u{1cec}', ScriptExtension::Single(Script::Devanagari)), ('\u{1ced}',
        '\u{1ced}', ScriptExtension::BengDeva), ('\u{1cee}', '\u{1cf1}',
        ScriptExtension::Single(Script::Devanagari)), ('\u{1cf2}', '\u{1cf2}',
        ScriptExtension::BengDevaGranKndaNandOryaTeluTirh), ('\u{1cf3}', '\u{1cf3}',
        ScriptExtension::DevaGran), ('\u{1cf4}', '\u{1cf4}', ScriptExtension::DevaGranKnda),
        ('\u{1cf5}', '\u{1cf6}', ScriptExtension::BengDeva), ('\u{1cf7}', '\u{1cf7}',
        ScriptExtension::Single(Script::Bengali)), ('\u{1cf8}', '\u{1cf9}',
        ScriptExtension::DevaGran), ('\u{1cfa}', '\u{1cfa}',
        ScriptExtension::Single(Script::Nandinagari)), ('\u{1dc0}', '\u{1dc1}',
        ScriptExtension::Single(Script::Greek)), ('\u{202f}', '\u{202f}',
        ScriptExtension::LatnMong), ('\u{20f0}', '\u{20f0}', ScriptExtension::DevaGranLatn),
        ('\u{2e43}', '\u{2e43}', ScriptExtension::CyrlGlag), ('\u{3001}', '\u{3002}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3003}', '\u{3003}',
        ScriptExtension::BopoHangHaniHiraKana), ('\u{3006}', '\u{3006}',
        ScriptExtension::Single(Script::Han)), ('\u{3008}', '\u{3008}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3009}', '\u{3009}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{300a}', '\u{300a}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{300b}', '\u{300b}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{300c}', '\u{300c}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{300d}', '\u{300d}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{300e}', '\u{300e}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{300f}', '\u{300f}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3010}', '\u{3010}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3011}', '\u{3011}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3013}', '\u{3013}',
        ScriptExtension::BopoHangHaniHiraKana), ('\u{3014}', '\u{3014}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3015}', '\u{3015}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3016}', '\u{3016}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3017}', '\u{3017}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3018}', '\u{3018}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{3019}', '\u{3019}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{301a}', '\u{301a}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{301b}', '\u{301b}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{301c}', '\u{301c}',
        ScriptExtension::BopoHangHaniHiraKana), ('\u{301d}', '\u{301d}',
        ScriptExtension::BopoHangHaniHiraKana), ('\u{301e}', '\u{301f}',
        ScriptExtension::BopoHangHaniHiraKana), ('\u{302a}', '\u{302d}', ScriptExtension::BopoHani),
        ('\u{3030}', '\u{3030}', ScriptExtension::BopoHangHaniHiraKana), ('\u{3031}', '\u{3035}',
        ScriptExtension::HiraKana), ('\u{3037}', '\u{3037}', ScriptExtension::BopoHangHaniHiraKana),
        ('\u{303c}', '\u{303c}', ScriptExtension::HaniHiraKana), ('\u{303d}', '\u{303d}',
        ScriptExtension::HaniHiraKana), ('\u{303e}', '\u{303f}',
        ScriptExtension::Single(Script::Han)), ('\u{3099}', '\u{309a}', ScriptExtension::HiraKana),
        ('\u{309b}', '\u{309c}', ScriptExtension::HiraKana), ('\u{30a0}', '\u{30a0}',
        ScriptExtension::HiraKana), ('\u{30fb}', '\u{30fb}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{30fc}', '\u{30fc}',
        ScriptExtension::HiraKana), ('\u{3190}', '\u{3191}', ScriptExtension::Single(Script::Han)),
        ('\u{3192}', '\u{3195}', ScriptExtension::Single(Script::Han)), ('\u{3196}', '\u{319f}',
        ScriptExtension::Single(Script::Han)), ('\u{31c0}', '\u{31e3}',
        ScriptExtension::Single(Script::Han)), ('\u{3220}', '\u{3229}',
        ScriptExtension::Single(Script::Han)), ('\u{322a}', '\u{3247}',
        ScriptExtension::Single(Script::Han)), ('\u{3280}', '\u{3289}',
        ScriptExtension::Single(Script::Han)), ('\u{328a}', '\u{32b0}',
        ScriptExtension::Single(Script::Han)), ('\u{32c0}', '\u{32cb}',
        ScriptExtension::Single(Script::Han)), ('\u{3358}', '\u{3370}',
        ScriptExtension::Single(Script::Han)), ('\u{337b}', '\u{337f}',
        ScriptExtension::Single(Script::Han)), ('\u{33e0}', '\u{33fe}',
        ScriptExtension::Single(Script::Han)), ('\u{a66f}', '\u{a66f}', ScriptExtension::CyrlGlag),
        ('\u{a830}', '\u{a832}',
        ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjMlymModiNandSindTakrTirh), ('\u{a833}',
        '\u{a835}', ScriptExtension::DevaDogrGujrGuruKhojKndaKthiMahjModiNandSindTakrTirh),
        ('\u{a836}', '\u{a837}', ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh),
        ('\u{a838}', '\u{a838}', ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh),
        ('\u{a839}', '\u{a839}', ScriptExtension::DevaDogrGujrGuruKhojKthiMahjModiSindTakrTirh),
        ('\u{a8f1}', '\u{a8f1}', ScriptExtension::BengDeva), ('\u{a8f3}', '\u{a8f3}',
        ScriptExtension::DevaTaml), ('\u{a92e}', '\u{a92e}', ScriptExtension::KaliLatnMymr),
        ('\u{a9cf}', '\u{a9cf}', ScriptExtension::BugiJava), ('\u{fdf2}', '\u{fdf2}',
        ScriptExtension::ArabThaa), ('\u{fdfd}', '\u{fdfd}', ScriptExtension::ArabThaa),
        ('\u{fe45}', '\u{fe46}', ScriptExtension::BopoHangHaniHiraKana), ('\u{ff61}', '\u{ff61}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{ff62}', '\u{ff62}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{ff63}', '\u{ff63}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{ff64}', '\u{ff65}',
        ScriptExtension::BopoHangHaniHiraKanaYiii), ('\u{ff70}', '\u{ff70}',
        ScriptExtension::HiraKana), ('\u{ff9e}', '\u{ff9f}', ScriptExtension::HiraKana),
        ('\u{10100}', '\u{10102}', ScriptExtension::CprtLinb), ('\u{10107}', '\u{10133}',
        ScriptExtension::CprtLinaLinb), ('\u{10137}', '\u{1013f}', ScriptExtension::CprtLinb),
        ('\u{102e0}', '\u{102e0}', ScriptExtension::ArabCopt), ('\u{102e1}', '\u{102fb}',
        ScriptExtension::ArabCopt), ('\u{11301}', '\u{11301}', ScriptExtension::GranTaml),
        ('\u{11303}', '\u{11303}', ScriptExtension::GranTaml), ('\u{1133b}', '\u{1133c}',
        ScriptExtension::GranTaml), ('\u{11fd0}', '\u{11fd1}', ScriptExtension::GranTaml),
        ('\u{11fd3}', '\u{11fd3}', ScriptExtension::GranTaml), ('\u{1bca0}', '\u{1bca3}',
        ScriptExtension::Single(Script::Duployan)), ('\u{1d360}', '\u{1d371}',
        ScriptExtension::Single(Script::Han)), ('\u{1f250}', '\u{1f251}',
        ScriptExtension::Single(Script::Han))
    ];

