#!/bin/sh
#    Copyright (c) 2005 Romain BONDUE
#    This file is part of RutilT.
#
#    RutilT is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    RutilT is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with RutilT; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#
# Variables :
prefix=/usr/local/
launcher=
helper_mode=4755
makefile_target='$(RUTILT_NAME) $(HELPER_NAME)'
kernel_sources_path='/lib/modules/'`uname -r`'/build/include/'
#
#
# Parse options :
for arg_iter in $@; do
    arg=`echo $arg_iter | cut -f1 -d=`
    arg_value=`echo $arg_iter | cut -f2 -d=`
    case $arg in
        --help)
echo "This script generates RutilT's configuration and build files. It also
checks if all dependencies are fulfilled.
Used without arguments, default settings are applied. Arguments are :
    --help : Display this message and exit.
    --prefix=PATH : Set PATH as file-system root for installation.
    --kernel_sources=PATH : Use the kernel sources located into PATH.
    --launcher=built-in | disabled | nopasswd | PATH : Set how the helper is
    launched as root and therefore how the user's identity is checked :
        built-in : The default setting, use the built-in launcher, it implies
                   that the helper will be installed setuid.
        disabled : No helper, RutilT will have to be launched as root to
                   change wireless settings.
        nopasswd : Like \"built-in\", but won't ask for root password.
        PATH : The absolute path to a program able to launch another program
               as root (gksu, gksudo, kdesu etc...)"
            exit 0;;

        --prefix)
            if [ $arg_value ]; then
                prefix=$arg_value"/"
                echo "Prefix set to : $arg_value"
            else
                echo "Invalid path."
                exit 1
            fi;;

        --launcher)
            case $arg_value in
                built-in)
                    echo "Using built-in launcher.";;
                disabled)
                    launcher="#define NHELPER"
                    makefile_target='$(RUTILT_NAME)'
                    echo "No launcher : helper disabled.";;
                nopasswd)
                    launcher="#define NOROOTPASSCHECK"
                    echo "No password needed to launch the helper.";;
                *)
                    if [ $arg_value ] && [ -f $arg_value ] && [ -x $arg_value ]; then
                        launcher="#define EXTERNALLAUNCHER
#define NOROOTPASSCHECK
    const std::string HelperLauncherPath (\"$arg_value\");"
                        helper_mode=755
                        echo "Using \"$arg_value\" as launcher."
                    else
                        echo "Invalid path (or file) for launcher."
                        exit 1
                    fi;;
            esac;;

        --kernel_sources)
            if [ $arg_value ]; then
                kernel_sources_path=$arg_value'/include/'
                echo "Kernel sources path set to : $arg_value"
            else
                echo "Invalid path."
                exit 1
            fi;;

        *)
            echo "Invalid argument : $arg
Use \"./configure.sh --help\" for help."
            exit 1;;
    esac
done
#
#
# Dependencies check :
# Gtk+ :
if ! pkg-config  --print-errors --exists 'gtk+-2.0 >= 2.6.0'; then
    echo 'Please install (or upgrade to) GTK+ 2.6.0 minimum.'
    exit 1
fi
# Kernel sources :
if [ -e $kernel_sources_path/linux/wireless.h ]; then
    if [ `grep "#define WIRELESS_EXT" $kernel_sources_path/linux/wireless.h | tr -s '\t' ' ' | cut -d' ' -f3` -lt 16 ]; then
echo 'According to your kernel sources, your kernel does not have recent enough
wireless extensions.'
        exit 1
    fi
else
    echo 'Your kernel sources cannot be found.'
# Fallback on headers :
    if [ -e /usr/include/linux/wireless.h ]; then
        if [ `grep "#define WIRELESS_EXT" /usr/include/linux/wireless.h | tr -s '\t' ' ' | cut -d' ' -f3` -lt 16 ]; then
echo 'According to your kernel headers, your kernel does not have recent enough
wireless extensions.'
            exit 1
        else
            echo 'Kernel headers found...'
            if [ `grep "#define UTS_RELEASE" /usr/include/linux/version.h | tr -s '\t' ' ' | cut -d' ' -f3 | tr -d '"'` != `uname -r` ]; then
                echo 'They does not match your running kernel.'
                exit 1
            fi
        fi
    else
        echo 'Your kernel headers cannot be found.'
        exit 1
    fi
fi
#
#
# Generated constants :
rutilt_name=rutilt
rutilt_prefix=$prefix/bin/
helper_name=rutilt_helper
helper_prefix=$prefix/share/rutilt/
ip_script_name=set_ip.sh
ip_script_prefix=$prefix/share/rutilt/
user_config_name=/rutilt/
user_config_prefix=/.config/
icon_prefix=$prefix/share/rutilt/
tray_icon_disconnected_name=disconnected_tray.png
tray_icon_low_name=low_tray.png
tray_icon_medium_name=medium_tray.png
tray_icon_high_name=high_tray.png
options_name=RutilT_options.xml
icon_prefix=$prefix/share/rutilt/
icon_16x16_name=RutilT16x16.png
icon_32x32_name=RutilT32x32.png
icon_48x48_name=RutilT48x48.png
icon_64x64_name=RutilT64x64.png
icon_128x128_name=RutilT128x128.png
#
#
# Makefile_cst :
echo -n "Generating Makefile constants... "
echo "# WARNING : Auto-generated file, edit with care.
KERNEL_SOURCES_PATH = $kernel_sources_path
RUTILT_NAME = $rutilt_name
RUTILT_PREFIX = $rutilt_prefix
HELPER_NAME = $helper_name
HELPER_PREFIX = $helper_prefix
HELPER_MODE = $helper_mode
IP_SCRIPT_NAME = $ip_script_name
IP_SCRIPT_PREFIX = $ip_script_prefix
USER_CONFIG_NAME = $user_config_name
USER_CONFIG_PREFIX = $user_config_prefix
ICON_PREFIX = $icon_prefix
TRAY_ICON_DISCONNECTED_NAME = $tray_icon_disconnected_name
TRAY_ICON_LOW_NAME = $tray_icon_low_name
TRAY_ICON_MEDIUM_NAME = $tray_icon_medium_name
TRAY_ICON_HIGH_NAME = $tray_icon_high_name
ICON_16X16_NAME = $icon_16x16_name
ICON_32X32_NAME = $icon_32x32_name
ICON_48X48_NAME = $icon_48x48_name
ICON_64X64_NAME = $icon_64x64_name
ICON_128X128_NAME = $icon_128x128_name
BUILD = $makefile_target" > Makefile_cst
echo done
#
#
# include/StaticSettings.h
echo -n "Generating program constants... "
echo "/** \file StaticSettings.h
    \author Romain BONDUE
    \date 23/06/2006
    \warning Auto-generated file, edit with care. */
#ifndef __STATICSETTINGS_H__
#define __STATICSETTINGS_H__

#include <string>



namespace nsCore
{
$launcher
    const std::string UserConfigPrefix (\"$user_config_prefix\");
    const std::string UserConfigName (\"$user_config_name\");
    const std::string HelperPrefix (\"$helper_prefix\");
    const std::string HelperName (\"$helper_name\");
    const std::string DhcpScriptPrefix (\"$ip_script_prefix\");
    const std::string DhcpScriptName (\"$ip_script_name\");
    const std::string TrayIconDisconnectedPath (\"$icon_prefix$tray_icon_disconnected_name\");
    const std::string TrayIconLowPath (\"$icon_prefix$tray_icon_low_name\");
    const std::string TrayIconMediumPath (\"$icon_prefix$tray_icon_medium_name\");
    const std::string TrayIconHighPath (\"$icon_prefix$tray_icon_high_name\");
    const std::string OptionsFileName (\"$options_name\");
    const std::string Icon16Path (\"$icon_prefix$icon_16x16_name\");
    const std::string Icon32Path (\"$icon_prefix$icon_32x32_name\");
    const std::string Icon48Path (\"$icon_prefix$icon_48x48_name\");
    const std::string Icon64Path (\"$icon_prefix$icon_64x64_name\");
    const std::string Icon128Path (\"$icon_prefix$icon_128x128_name\");

} // namespace nsCore

#endif // __STATICSETTINGS_H__" > include/StaticSettings.h
echo done
