/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CWE17Module.h
    \author Romain BONDUE
    \date 21/08/2005 */
#ifndef __CWE17MODULE_H__
#define __CWE17MODULE_H__

#include <vector>
#include <string>
#include <memory> // std::auto_ptr<>

#include "Module.h"
#include "UserData.h"
#include "ProfileEditor.h"



namespace nsWireless
{
    class IDriver;
    class CWE17Driver;

} // namespace nsWireless;



namespace nsCore
{
    class CWE17Module : public IModule
    {
      public :
        CWE17Module (const std::string&, const std::string&)
                                throw (nsErrors::CException, std::bad_alloc);
        ~CWE17Module () throw (nsErrors::CException);
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();
        nsUserData::CProfile* NewProfile () throw();
        nsUserData::CProfile* NewProfile (const nsWireless::CCell&) throw();
        bool EditProfile (unsigned) throw();
        void DeleteProfile (unsigned) throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        /** \warning No bound check! */
        nsUserData::CProfile& GetProfile (unsigned) throw();
        unsigned GetNbProfile () const throw();
        void Connect (const nsWireless::CCell&)
                                throw (nsErrors::CSystemExc, std::bad_alloc);
        ::GtkWidget* GetPrivateTab () throw();
        void BecomeRoot () throw (nsErrors::CSystemExc, std::bad_alloc);


      protected :
        nsUserData::CProfile* EditNewProfile () throw();
        static const char* const NewProfileDefaultName;


      private :
        CWE17Module (const CWE17Module&);
        CWE17Module& operator = (const CWE17Module&);

        std::auto_ptr<nsWireless::CWE17Driver> m_pDriver;
        nsCore::CProfileEditor m_Editor;
        nsUserData::CProfilesFile<> m_ProfilesFile;

    }; // CWE17Module

} // namespace nsCore

#include "private/CWE17Module.hxx"

#endif // __CWE17MODULE_H__
