/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTDrivers.h
    \author Romain BONDUE
    \date 30/08/2005 */
#ifndef __RTDRIVERS_H__
#define __RTDRIVERS_H__

#include "WE17Driver.h"



namespace nsWireless
{
    class CRTDriver : public CWE17Driver
    {
      public :
        CRTDriver (const std::string&, int) throw (nsErrors::CSystemExc);


      protected :
        int GetPrivateIoctl () const throw();
        void GetScanResult (int, std::vector<CCell>&) const
                                throw (nsErrors::CException, std::bad_alloc);


      private :
        const int m_PrivateIoctl;

    }; // CRTDriver


    class CRT2400Driver : public CRTDriver
    {
      public :
        CRT2400Driver (const std::string&) throw (nsErrors::CException);
        void Scan () throw (nsErrors::CSystemExc);
        void GetScanResult (std::vector<CCell>&) const
                                throw (nsErrors::CException, std::bad_alloc);

    }; // CRT2400Driver


    enum WirelessMode_e {Mixed, B_Only};
    enum BGProtection_e {AutoProtection, On, Off};
    enum TxPreamble_e {Long, Short, AutoPreamble};


    class CRT2500Driver : public CRTDriver
    {
      public :
        CRT2500Driver (const std::string&) throw (nsErrors::CException);
        CEncryptionD GetEncryption () throw (nsErrors::CSystemExc,
                                             std::bad_alloc);
        void SetEncryption (const CEncryptionD&)
                                throw (nsErrors::CSystemExc, std::bad_alloc);
        void GetScanResult (std::vector<CCell>&) const
                                throw (nsErrors::CException, std::bad_alloc);
        int GetTxRate () const throw (nsErrors::CSystemExc);
        void SetTxRate (int) throw (nsErrors::CSystemExc);

            // TODO CountryRegion (has an influence on GetSupportedFreq()).

        virtual WirelessMode_e GetWirelessMode () const throw();
        virtual void SetWirelessMode (WirelessMode_e)
                                                throw (nsErrors::CSystemExc);

        virtual bool GetTxBurst () const throw();
        virtual void SetTxBurst (bool) throw (nsErrors::CSystemExc);

        virtual BGProtection_e GetBGProtection () const throw();
        virtual void SetBGProtection (BGProtection_e)
                                                throw (nsErrors::CSystemExc);

        virtual TxPreamble_e GetTxPreamble () const throw();
        virtual void SetTxPreamble (TxPreamble_e) throw (nsErrors::CSystemExc);

        virtual bool GetTurboRate () const throw();
        virtual void SetTurboRate (bool) throw (nsErrors::CSystemExc);

        virtual bool GetAdHocOFDM () const throw();
        virtual void SetAdHocOFDM (bool) throw (nsErrors::CSystemExc);

        bool IsRfmontxSupported () const throw();
        virtual bool GetRfmontx () const throw();
        virtual void SetRfmontx (bool) throw (nsErrors::CSystemExc);


      protected :
        void SetIoctl (const char*, const std::string&, const std::string&)
                                            const throw (nsErrors::CSystemExc);
        void SetIoctl (const char*, int, const std::string&) const
                                                throw (nsErrors::CSystemExc);
        bool GetRfmontxFromDriver () const throw (nsErrors::CSystemExc);
        static const int InvalidIoctl = -1;


      private :
        int m_SetIoctl;
        int m_RfmontxIoctl;

        void SetFlag (int, bool) throw();
        enum {IsB_Only = 1, TxBurst = 2, TurboRate = 4, AdHocOFDM = 8,
              Rfmontx = 16};
        char m_Flags;

        BGProtection_e m_BGProtection;
        TxPreamble_e m_TxPreamble;

    }; // CRT2500Driver


    class CRT2570Driver : public CWE17Driver
    {
      public :
        CRT2570Driver (const std::string&) throw (nsErrors::CException);
        void SetEncryption (const CEncryptionD&)
                                throw (nsErrors::CSystemExc, std::bad_alloc);
        void GetSupportedRates (std::vector<int>&) const throw();
        bool IsRfmontxSupported () const throw();
            // No getter.
        virtual void SetRfmontx (bool) throw (nsErrors::CSystemExc);
        bool IsPrismHeaderSupported () const throw();
            // No getter.
        enum PrismMode_e {Default = 0, Force, ForceNo};
        virtual void SetPrismHeader (PrismMode_e) throw (nsErrors::CSystemExc);
            // No getter.
        enum AdHocMode_e {Std11 = 0, Auto = 1, Only54 = 2};
        virtual void SetAdHocMode (AdHocMode_e) throw (nsErrors::CSystemExc);
            // ? TODO ? Patch the driver to have getters for those ioctl ?


      protected :
        void PrivateIoctl (int, int, const std::string&)
                                                throw (nsErrors::CSystemExc);
        void PrivateIoctl (int, const std::string&, const std::string&)
                                                throw (nsErrors::CSystemExc);
        static const int InvalidIoctl = -1;


      private :
        int m_AuthIoctl;
        int m_EncIoctl;
        int m_KeyIoctl;
        int m_AdHocModeIoctl;
        int m_RfmontxIoctl;
        int m_PrismHeaderIoctl;

    }; // CRT2570Driver

} // namespace nsWireless

#include "private/RTDrivers.hxx"

#endif // __RTDRIVERS_H__
