/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTModules.h
    \author Romain BONDUE
    \date 19/08/2005 */
#ifndef __RTMODULES_H__
#define __RTMODULES_H__

#include <vector>
#include <string>
#include <memory> // std::auto_ptr<>

#include "Module.h"
#include "UserData.h"
#include "CWE17Module.h"
#include "ProfileEditor.h"
#include "WWidgets.h"



namespace nsWireless
{
    class IDriver;
    class CRT2500Driver;
    class CRT2400Driver;
    class CRT2570Driver;

} // namespace nsWireless



namespace nsGUI
{
    class CGtkGUI;


    class CRT25x0ConfigDialog : public CSharedConfigDialog
    {
      public :
        CRT25x0ConfigDialog (const std::vector<nsWireless::CFreq>&,
                             const nsWireless::EncryptType_e*, unsigned)
                                                                    throw();


      private :
        static void ModeChangedCallBack (::GtkToggleButton*,
                                         CRT25x0ConfigDialog*) throw();

    }; // CRT25x0ConfigDialog

} // namespace nsGUI



namespace nsCore
{
    class CRT2400Module : public IModule
    {
      public :
        CRT2400Module (const std::string&, const std::string&)
                                 throw (nsErrors::CException, std::bad_alloc);
        ~CRT2400Module () throw (nsErrors::CException);
        void BecomeRoot () throw (nsErrors::CSystemExc, std::bad_alloc);
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();
        nsUserData::CProfile* NewProfile () throw();
        nsUserData::CProfile* NewProfile (const nsWireless::CCell&) throw();
        bool EditProfile (unsigned) throw();
        void DeleteProfile (unsigned) throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        nsUserData::CProfile& GetProfile (unsigned) throw();
        unsigned GetNbProfile () const throw();
        void Connect (const nsWireless::CCell&)
                                throw (nsErrors::CSystemExc, std::bad_alloc);
        ::GtkWidget* GetPrivateTab () throw();


      protected :
        static const char* const NewProfileDefaultName;


      private :
        CRT2400Module (const CRT2400Module&);
        CRT2400Module& operator= (const CRT2400Module&);

        nsUserData::CProfile* EditNewProfile () throw();

        std::auto_ptr<nsWireless::CRT2400Driver> m_pDriver;
        CProfileEditor m_ProfileEditor;
        nsUserData::CProfilesFile<> m_ProfilesFile;

    }; // CRT2400Module


    class CRT2500Module : public IModule
    {
      public :
        CRT2500Module (const std::string&, const std::string&, nsGUI::CGtkGUI*)
                                throw (nsErrors::CException, std::bad_alloc);
        ~CRT2500Module () throw (nsErrors::CException);
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();
        nsUserData::CProfile* NewProfile () throw();
        nsUserData::CProfile* NewProfile (const nsWireless::CCell&) throw();
        bool EditProfile (unsigned) throw();
        void DeleteProfile (unsigned) throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        nsUserData::CProfile& GetProfile (unsigned) throw();
        unsigned GetNbProfile () const throw();
        void Connect (const nsWireless::CCell&)
                                throw (nsErrors::CSystemExc, std::bad_alloc);
        ::GtkWidget* GetPrivateTab () throw();
        void BecomeRoot () throw (nsErrors::CSystemExc, std::bad_alloc);


      protected :
        void CreateCBox (const char* [], unsigned, int, const char*, unsigned,
                         void (*) (::GtkComboBox*, CRT2500Module*)) throw();
        void CreateCheckButton (const char*, unsigned, unsigned, bool,
                                void (*) (::GtkToggleButton*, CRT2500Module*))
                                                                    throw();
        void SetDriver (nsWireless::CRT2500Driver*) throw();

        static const char* const NewProfileDefaultName;


      private :
        CRT2500Module (const CRT2500Module&);
        CRT2500Module& operator= (const CRT2500Module&);

        std::auto_ptr<nsWireless::CRT2500Driver> m_pDriver;
        CProfileEditor m_ProfileEditor;
        nsUserData::CProfilesFile<> m_ProfilesFile;

        nsUserData::CProfile* EditNewProfile () throw();

            // Private tab :
        ::GtkTable* const m_pTable;
        nsGUI::CGtkGUI* const m_pUI;
        unsigned m_CurrentActiveBoxItem;
        bool m_IsSkipped;

        typedef void (nsWireless::CRT2500Driver::*DriverCBoxMember_t) (int);
        void CommonCBoxCallBack (DriverCBoxMember_t, ::GtkComboBox*) throw();

        typedef void (nsWireless::CRT2500Driver::*DriverButtonMember_t) (bool);
        void CommonCButtonCallBack (DriverButtonMember_t,
                                    ::GtkToggleButton*) throw();
        void ResumePreviousState (::GtkComboBox*) throw();

        static void ModeCallBack (::GtkComboBox*, CRT2500Module*) throw();
        static void BGProtectionCallBack (::GtkComboBox*, CRT2500Module*)
                                                                    throw();
        static void TxPreambleCallBack (::GtkComboBox*, CRT2500Module*)
                                                                    throw();
        static void TxBurstCallBack (::GtkToggleButton*, CRT2500Module*)
                                                                    throw();
        static void TurboRateCallBack (::GtkToggleButton*, CRT2500Module*)
                                                                    throw();
        static void AdHocOFDMCallBack (::GtkToggleButton*, CRT2500Module*)
                                                                    throw();
        static void RfmontxCallBack (::GtkToggleButton*, CRT2500Module*)
                                                                    throw();
        static void CBoxFocusCallBack (::GtkComboBox*, bool, CRT2500Module*)
                                                                    throw();

    }; // CRT2500Module


    class CRT2570Module : public IModule
    {
      public :
        CRT2570Module (const std::string&, const std::string&, nsGUI::CGtkGUI*)
                                throw (nsErrors::CException, std::bad_alloc);
        ~CRT2570Module () throw (nsErrors::CException);
        void BecomeRoot () throw (nsErrors::CSystemExc, std::bad_alloc);
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();
        nsUserData::CProfile* NewProfile () throw();
        nsUserData::CProfile* NewProfile (const nsWireless::CCell&) throw();
        bool EditProfile (unsigned) throw();
        void DeleteProfile (unsigned) throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        nsUserData::CProfile& GetProfile (unsigned) throw();
        unsigned GetNbProfile () const throw();
        void Connect (const nsWireless::CCell&)
                                throw (nsErrors::CSystemExc, std::bad_alloc);
        ::GtkWidget* GetPrivateTab () throw();


      protected :
        static const char* const NewProfileDefaultName;
        void BuildPrivateTab () throw();


      private :
        CRT2570Module (const CRT2570Module&);
        CRT2570Module& operator= (const CRT2570Module&);

        nsUserData::CProfile* EditNewProfile () throw();

        std::auto_ptr<nsWireless::CRT2570Driver> m_pDriver;
        CProfileEditor m_ProfileEditor;
        nsUserData::CProfilesFile<> m_ProfilesFile;
        nsGUI::CGtkGUI* const m_pUI;

            // Private tab :
        ::GtkBox* const m_pBox;
        unsigned m_CurrentActiveBoxItem;
        bool m_IsSkipped;

        typedef void (nsWireless::CRT2570Driver::*DriverButtonMember_t) (bool);
        void CommonCButtonCallBack (DriverButtonMember_t,
                                    ::GtkToggleButton*) throw();
        typedef void (nsWireless::CRT2570Driver::*DriverBoxMember_t) (int);
        void CommonCBoxCallBack (DriverBoxMember_t, ::GtkComboBox*) throw();
        void ResumePreviousState (::GtkComboBox*) throw();

        static void AdhocModeCallBack (::GtkComboBox*, CRT2570Module*) throw();
        static void PrismHeaderCallBack (::GtkComboBox*, CRT2570Module*)
                                                                    throw();
        static void RfmontxCallBack (::GtkToggleButton*, CRT2570Module*)
                                                                    throw();
        static void CBoxFocusCallBack (::GtkComboBox*, bool, CRT2570Module*)
                                                                    throw();

    }; // CRT2570Module

} // namespace nsCore

#include "private/RTModules.hxx"

#endif // __RTMODULES_H__
