/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file UserData.hxx
    \author Romain BONDUE
    \date 05/07/2005
    \warning This file should only be included from UserData.h */
#include <cerrno> // EEXIST

extern "C"{
#include <sys/stat.h> // ::mkdir()
}



inline nsUserData::CProfile::CProfile (const std::string& Name) throw()
    : m_Name (Name), m_Mode (nsWireless::Unknown), m_Channel (0) {}


inline nsUserData::CProfile::~CProfile () throw() {}


inline const std::string& nsUserData::CProfile::GetName () const throw()
{
    return m_Name;

} // GetName()


inline const std::string& nsUserData::CProfile::GetSSID () const throw()
{
    return m_SSID;

} // GetSSID()


inline nsWireless::Mode_e nsUserData::CProfile::GetMode () const throw()
{
    return m_Mode;

} // GetMode()


inline unsigned nsUserData::CProfile::GetChannel () const throw()
{
    return m_Channel;

} // GetChannel()


inline const nsWireless::CEncryptionD& nsUserData::CProfile::GetEncryptionD ()
                                                                const throw()
{
    return m_EncryptionD;

} // GetEncryptionD()


inline nsWireless::CEncryptionD& nsUserData::CProfile::GetEncryptionD ()
                                                                        throw()
{
    return m_EncryptionD;

} // GetEncryptionD()


inline void nsUserData::CProfile::SetName (const std::string& Name) throw()
{
    m_Name = Name;

} // SetName()


inline void nsUserData::CProfile::SetSSID (const std::string& SSID) throw()
{
    m_SSID = SSID;

} // SetSSID()


inline void nsUserData::CProfile::SetMode (nsWireless::Mode_e Mode) throw()
{
    m_Mode = Mode;

} // SetMode()


inline void nsUserData::CProfile::SetChannel (unsigned Channel) throw()
{
    m_Channel = Channel;

} // SetChannel()


inline void nsUserData::CProfile::SetEncryptionD
                                            (const nsWireless::CEncryptionD& D)
{
    m_EncryptionD = D;

} // SetEncryptionD()


inline nsUserData::CIPSettings& nsUserData::CProfile::GetIPSettings () throw()
{
    return m_IPSettings;

} // GetIPSettings()


inline const nsUserData::CIPSettings& nsUserData::CProfile::GetIPSettings ()
                                                                const throw()
{
    return m_IPSettings;

} // GetIPSettings()


inline nsUserData::CProfilesFileBase::CProfilesFileBase
                    (const std::string& FileName) throw (nsErrors::CSystemExc)
    : m_FileName (AppDirectory + FileName) {MakeAppDirectory();}


inline nsUserData::CProfilesFileBase::~CProfilesFileBase () throw() {}


inline void nsUserData::CProfilesFileBase::Extract ()
                                                throw (nsErrors::CException)
{
    CXMLParser::Extract (m_FileName);

} // Extract()


inline void nsUserData::CProfilesFileBase::Error () throw()
{     // We remove the last CProfile as it may be invalid.
    DeleteLastProfile();

} // Error()


template<class C>
inline nsUserData::CProfilesFile<C>::CProfilesFile (const std::string& Path)
                                                throw (nsErrors::CException)
    : CProfilesFileBase (Path) {}


template<class C>
inline nsUserData::CProfilesFile<C>::~CProfilesFile () throw() {}


template<class C>
inline nsUserData::CProfile& nsUserData::CProfilesFile<C>::GetProfile
                                                        (unsigned Pos) throw()
{
    return this->operator [] (Pos);

} // GetProfile()


template<class C>
inline unsigned nsUserData::CProfilesFile<C>::Size () const throw()
{
    return this->size();

} // Size()


template<class C>
inline void nsUserData::CProfilesFile<C>::NewProfile (const char* Name) throw()
{
    this->push_back (CProfile (Name));

} // NewProfile()


template<class C>
inline void nsUserData::CProfilesFile<C>::NewProfile (const char* Name,
                                        const nsWireless::CCell& Cell) throw()
{
    try{this->push_back (CProfile (Name, Cell));}
    catch (std::bad_alloc) {this->push_back (CProfile (Name));}

} // NewProfile()


template<class C>
inline void nsUserData::CProfilesFile<C>::DeleteLastProfile () throw()
{
    if (!this->empty()) this->erase (--(this->end()));

} // DeleteLastProfile()


inline nsUserData::CIPSettings::CIPSettings (IPSetting_e Setting) throw()
    : m_Setting (Setting) {}


inline nsUserData::IPSetting_e nsUserData::CIPSettings::GetSetting () const
                                                                        throw()
{
    return m_Setting;

} // GetSetting()


inline void nsUserData::CIPSettings::SetSetting (IPSetting_e Setting) throw()
{
    m_Setting = Setting;

} // SetSetting()
