/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTDriversRoot.cxx
    \author Romain BONDUE
    \date 21/02/2006 */
#include "RTDriversRoot.h"
#include "RTSuWProtocolCodes.h"



nsWireless::CRT2400DriverRoot::CRT2400DriverRoot
                                                (const std::string& DeviceName)
                                throw (nsErrors::CException, std::bad_alloc)
    : CRT2400Driver (DeviceName), CSuWProtocol (RT2400Handler, DeviceName) {}


nsWireless::CRT2500DriverRoot::CRT2500DriverRoot
                                                (const std::string& DeviceName)
                                throw (nsErrors::CException, std::bad_alloc)
    : CRT2500Driver (DeviceName), CSuWProtocol (RT2500Handler, DeviceName) {}


nsWireless::CRT2570DriverRoot::CRT2570DriverRoot
                                                (const std::string& DeviceName)
                                throw (nsErrors::CException, std::bad_alloc)
    : CRT2570Driver (DeviceName), CSuWProtocol (RT2570Handler, DeviceName) {}


        // TODO the flag field is not set for all the function below.


void nsWireless::CRT2500DriverRoot::SetWirelessMode (WirelessMode_e Mode)
                                                throw (nsErrors::CSystemExc)
{
    SuDo (Mode, WModeC);

} // SetWirelessMode()


void nsWireless::CRT2500DriverRoot::SetTxBurst (bool TxBurst)
                                                throw (nsErrors::CSystemExc)
{
    SuDo (TxBurst, TxBurstC);

} // SetTxBurst()


void nsWireless::CRT2500DriverRoot::SetBGProtection
                    (BGProtection_e BGProtection) throw (nsErrors::CSystemExc)
{
    SuDo (BGProtection, BGProtectionC);

} // SetBGProtection()


void nsWireless::CRT2500DriverRoot::SetTxPreamble (TxPreamble_e TxPreamble)
                                                throw (nsErrors::CSystemExc)
{
    SuDo (TxPreamble, TxPreambleC);

} // SetTxPreamble()


void nsWireless::CRT2500DriverRoot::SetTurboRate (bool TurboRate)
                                                throw (nsErrors::CSystemExc)
{
    SuDo (TurboRate, TurboRateC);

} // SetTurboRate()


void nsWireless::CRT2500DriverRoot::SetAdHocOFDM (bool AdHocOFDM)
                                                throw (nsErrors::CSystemExc)
{
    SuDo (AdHocOFDM, AdHocOFDMC);

} // SetAdHocOFDM()


void nsWireless::CRT2500DriverRoot::SetRfmontx (bool RfmonTx)
                                                throw (nsErrors::CSystemExc)
{
    SuDo (RfmonTx, RfmontxC);

} // SetRfmontx()
