/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file ErrorsCode.h
    \author Romain BONDUE
    \date 05/07/2005 */
#ifndef __ERRORSCODE_H__
#define __ERRORSCODE_H__



namespace nsErrors
{
    enum ErrorsCode_t {InvalidArguments = -1, ProcParsing = -2,
                       NoDeviceFound = -3, OutOfMemory = -4,
                       GtkInitFailure = -5, ProfilesRecordFailure = -6,
                       ProfilesExtractionFailure = -7,
                       ProfilesExtractionMissingName = -8,
                       ProfilesExtractionMissingSSID = -9,
                       ProfilesExtractionMissingMode = -10,
                       ProfilesExtractionMissingChannel = -11,
                       ProfilesExtractionInvalidMode = -12,
                       ProfilesExtractionInvalidChannel = -13,
                       ProfilesExtractionInvalidKey = -14,
                       ProfilesExtractionExtraToken = -15,
                       HelperAuthenticationFailed = -16,
                       ProfileNotFound = -17, ScanningTimeOut = -18,
                       RTAdvancedSetIoctlNotFound = -19, InvalidCommand = -20,
                       UnknownHandler = -21, InvalidData = -22,
                       UnknownExc = -23, NoDriverSet = -24,
                       NoHandlerDefined = -25, InvalidRootPassword = -26,
                       InvalidDataFromHelper = -27, UnexpectedStreamEnd = -28,
                       RT2400AdHocLimitation = -29, StatsParsing = -30,
                       RT2570EncIoctlNotFound = -31,
                       RT2570AuthIoctlNotFound = -32,
                       RT2570KeyIoctlNotFound = -33, InvalidInstanceNum = -34,
                       CodeNotTransmitted = -35,
                       OptionsExtractionInvalidValue = -36,
                       OptionsRecordFailure = -37, SaltBufferOverflow = - 38,
                       HelperNotRoot = -39, RutilTAuthenticationFailed = -40,
                       DataParsingError1 = -41, DataParsingError2 = -42,
                       CannotSendRootPasswd = -43, CannotExecuteHelper = -44};

} // namespace nsErrors

#endif // __ERRORSCODE_H__
