/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file ProfileEditor.h
    \author Romain BONDUE
    \date 02/04/2006 */
#ifndef __PROFILEEDITOR_H__
#define __PROFILEEDITOR_H__

#include <memory> // auto_ptr<>



namespace nsUserData {class CProfile;}



namespace nsGUI {class CConfigDialog;}



namespace nsCore
{
        // See this class as an interface between the UI and the Profile.
    class CProfileEditor
    {
      public :
          // Own the pointer, which mustn't be null.
        CProfileEditor (nsGUI::CConfigDialog* pDialog) throw();
        ~CProfileEditor () throw();
        nsGUI::CConfigDialog* GetDialog () throw();
        const nsGUI::CConfigDialog* GetDialog () const throw();
        bool Edit (nsUserData::CProfile&) throw();


      private :
        std::auto_ptr<nsGUI::CConfigDialog> m_pDialog;

    }; // CProfileEditor

} // namespace nsCore

#include "private/ProfileEditor.hxx"

#endif // __PROFILEEDITOR_H__
