/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file UserData.h
    \author Romain BONDUE
    \date 03/08/2005 */
#ifndef __USERDATA_H__
#define __USERDATA_H__

#include <string>
#include <ostream>
#include <vector>
#include <stdexcept>

#include "XMLParser.h"
#include "Parameters.h"
#include "Exceptions.h"



namespace nsUserData
{
    extern const std::string AppDirectory;

    void MakeAppDirectory () throw (nsErrors::CSystemExc);


        // Could have been more beautiful...
    enum IPSetting_e {None, Dhcp, Static};

    class CIPSettings
    {
      public :
        CIPSettings (IPSetting_e = None) throw();
        IPSetting_e GetSetting () const throw();
        void SetSetting (IPSetting_e) throw();


      private :
        IPSetting_e m_Setting;

    }; // CIPSettings


    class CProfile
    {
      public :
        CProfile (const std::string& = std::string()) throw();
        CProfile (const std::string&, const nsWireless::CCell&)
                                                        throw (std::bad_alloc);
        virtual ~CProfile () throw();

        const std::string& GetName () const throw();
        const std::string& GetSSID () const throw();
        nsWireless::Mode_e GetMode () const throw();
        unsigned GetChannel () const throw();
        const nsWireless::CEncryptionD& GetEncryptionD () const throw();
        nsWireless::CEncryptionD& GetEncryptionD () throw();
        CIPSettings& GetIPSettings () throw();
        const CIPSettings& GetIPSettings () const throw();

        void SetName (const std::string&) throw();
        void SetSSID (const std::string&) throw();
        void SetMode (nsWireless::Mode_e) throw();
        void SetChannel (unsigned) throw();
        void SetEncryptionD (const nsWireless::CEncryptionD&);

        virtual bool Match (const nsWireless::CCell&) const throw();


      private :
        std::string m_Name;
        std::string m_SSID;
        nsWireless::Mode_e m_Mode;
        unsigned m_Channel;
        nsWireless::CEncryptionD m_EncryptionD;
        CIPSettings m_IPSettings;

    }; // CProfile


        // ? TODO ? Remove all virtual and template if it's never used ?
        // The base class to extract CProfile above (or derived class).
    class CProfilesFileBase : public CXMLParser
    {
      public :
        CProfilesFileBase (const std::string&) throw (nsErrors::CSystemExc);
        void Extract () throw (nsErrors::CException);
        void Record () throw (nsErrors::CException);
        virtual ~CProfilesFileBase () throw();


      protected :
            // For extracting :
        void StartElement (const char*, const char**, const char**)
                                throw (std::bad_alloc, nsErrors::CException);
        void EndElement (const char*) throw (nsErrors::CException);
        void Text (const char*, const std::string&)
                                                throw (nsErrors::CException);
        void Error () throw();
            // For recording :
        virtual const char* GetRootMarkupLabel () const throw();
        virtual void RecordFields (std::ostream&, unsigned)
                                                throw (std::ios_base::failure);

        static const char* const Indentation;

        virtual CProfile& GetProfile (unsigned) throw() = 0;
        virtual unsigned Size () const throw() = 0;
        virtual void NewProfile (const char*) throw() = 0;
        virtual void DeleteLastProfile () throw() = 0;


      private :
        const std::string m_FileName;

    }; // CProfilesFileBase


        // An helper to implement CXXXXProfilesFile.
    template<class ProfileType = CProfile>
    class CProfilesFile : public CProfilesFileBase,
                          public std::vector<ProfileType>
    {
      public :
        CProfilesFile (const std::string&) throw (nsErrors::CException);
        ~CProfilesFile () throw();
        void NewProfile (const char*) throw();
        virtual void NewProfile (const char*, const nsWireless::CCell&)
                                                                    throw();
        void DeleteLastProfile () throw();


      private : // It's better to use the std::vector<> member.
        /** \warning No bound check! */
        CProfile& GetProfile (unsigned) throw();
        unsigned Size () const throw();

    }; // CProfilesFile

} // namespace nsUserData

#include "private/UserData.hxx"

#endif // __USERDATA_H__
