/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file WE17Driver.hxx
    \author Romain BONDUE
    \date 05/07/2005
    \warning This file should only be included from WE17Driver.h */
#include "SystemTools.h" // Not a big problem, but...



inline void nsWireless::CWE17Driver::Ioctl (int Request,
                                            const std::string& ErrorMsg) const
                                                throw (nsErrors::CSystemExc)
{
    nsSystem::Ioctl (Request, (&m_Req), ErrorMsg);

} // Ioctl()


inline nsWireless::CWE17Driver::~CWE17Driver () throw() {}


inline const std::string& nsWireless::CWE17Driver::GetProtoName () const
                                                                        throw()
{
    return m_ProtoName;

} // GetProtoName()


inline unsigned nsWireless::CWE17Driver::GetMaxSSIDSize () const throw()
{
    return IW_ESSID_MAX_SIZE;

} // GetMaxSSIDSize()


inline unsigned nsWireless::CWE17Driver::GetMaxKeySize () const throw()
{
    return IW_ENCODING_TOKEN_MAX;

} // GetMaxKeySize()


inline const std::vector<nsWireless::CFreq>&
                    nsWireless::CWE17Driver::GetSupportedFreq () const throw()
{
    return m_SupportedFreqVec;

} // GetSupportedFrequency()


inline void nsWireless::CWE17Driver::AddSupportedFreq (unsigned Channel,
                                                   double Frequency) throw()
{
    m_SupportedFreqVec.push_back (CFreq (Channel, Frequency));

} // AddSupportedFrequency()


inline std::string nsWireless::CWE17Driver::GetDeviceName () const throw()
{
    return m_Req.ifr_ifrn.ifrn_name;

} // GetDeviceName()
