/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file ProfileEditor.cxx
    \author Romain BONDUE
    \date 02/04/2006 */
#include "ProfileEditor.h"
#include "UserData.h"
#include "GtkGUI.h" // NotifyError()
#include "WWidgets.h"



nsCore::CProfileEditor::~CProfileEditor () throw() {}


bool nsCore::CProfileEditor::Edit (nsUserData::CProfile& Profile) throw()
{
    m_pDialog->SetConfigName (Profile.GetName());
    m_pDialog->SetSSID (Profile.GetSSID());
    m_pDialog->SetMode (Profile.GetMode());
    m_pDialog->SetChannel (Profile.GetChannel());
    m_pDialog->SetAuth (Profile.GetEncryptionD().GetAuth());
    m_pDialog->SetEncrypt (Profile.GetEncryptionD().GetEncrypt());
    m_pDialog->SetDefaultKey (Profile.GetEncryptionD().GetDefaultKey());
    for (unsigned I (0) ; I < m_pDialog->GetNbKey() ; ++I)
        m_pDialog->SetKey (Profile.GetEncryptionD().GetKey (I), I);
    m_pDialog->SetIPSetting (Profile.GetIPSettings().GetSetting());

    bool IsModified (false);
    while (m_pDialog->Run())
    {
        const std::string Name (m_pDialog->GetConfigName());
        const std::string SSID (m_pDialog->GetSSID());
        const nsWireless::Mode_e Mode (m_pDialog->GetMode());
        if (Name.empty() || Mode != nsWireless::Monitor && SSID.empty())
            nsGUI::NotifyError ("Empty profile name and/or SSID.", 0,
                            GTK_WINDOW (m_pDialog->operator ::GtkDialog*()));
        else if (m_pDialog->GetEncrypt() != nsWireless::None &&
                                                m_pDialog->GetKey (0).Empty())
            nsGUI::NotifyError ("Empty key.", 0,
                            GTK_WINDOW (m_pDialog->operator ::GtkDialog*()));
        else
        {
            Profile.GetEncryptionD().SetAuth (m_pDialog->GetAuth());
            Profile.GetEncryptionD().SetEncrypt (m_pDialog->GetEncrypt());
            for (unsigned I (0) ; I < m_pDialog->GetNbKey() ; ++I)
                Profile.GetEncryptionD().SetKey (m_pDialog->GetKey (I), I);
            Profile.GetEncryptionD().SetDefaultKey (m_pDialog->GetDefaultKey());
            Profile.SetName (Name);
            Profile.SetSSID (SSID);
            Profile.SetMode (Mode);
            Profile.SetChannel (m_pDialog->GetChannel());
            Profile.GetIPSettings().SetSetting (m_pDialog->GetIPSetting());
            IsModified = true;
            break;
        }
    }
    m_pDialog->Hide();

    return IsModified;

} // Edit()
