/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CStatsPage.cxx
    \author Romain BONDUE
    \date 08/05/2006 */
#include <sstream>
#include <iomanip>

#include "CStatsPage.h"



namespace
{
    inline void NewLine (::GtkTable* pTable, const char* Label,
                         ::GtkLabel* pWidget,  unsigned Line) throw()
    {
        ::gtk_table_attach_defaults (pTable, ::gtk_label_new (Label),
                                     0, 1, Line, Line + 1);
        ::gtk_table_attach_defaults (pTable, GTK_WIDGET (pWidget), 1, 2,
                                     Line, Line + 1);

    } // NewLine()


    inline long double ToMBytes (unsigned long NbBytes)
    {
        long double Bytes (NbBytes);
        return Bytes / 1024.L / 1024.L;

    } // ToMBytes()


    std::string BytesLabel (unsigned long NbBytes) throw()
    {
        std::ostringstream Os;
        Os << NbBytes << " (" << std::fixed << std::setprecision (1)
           << ToMBytes (NbBytes) << " MB)";
        return Os.str();

    } // BytesLabel()

} // anonymous namespace



nsGUI::CStatsPage::CStatsPage () throw()
    : m_pBox (GTK_BOX (::gtk_vbox_new (true, 2))),
      m_pTXBytes (GTK_LABEL (::gtk_label_new ("0"))),
      m_pTXPackets (GTK_LABEL (::gtk_label_new ("0"))),
      m_pTXErrors (GTK_LABEL (::gtk_label_new ("0"))),
      m_pCollisions (GTK_LABEL (::gtk_label_new ("0"))),
      m_pRXBytes (GTK_LABEL (::gtk_label_new ("0"))),
      m_pRXPackets (GTK_LABEL (::gtk_label_new ("0"))),
      m_pRXErrors (GTK_LABEL (::gtk_label_new ("0"))) {BuildUI();}


void nsGUI::CStatsPage::BuildUI () throw()
{
    ::gtk_container_set_border_width (GTK_CONTAINER (m_pBox), 6);

    ::GtkTable* pTable (GTK_TABLE (::gtk_table_new (2, 4, true)));
    NewLine (pTable, "Bytes", m_pTXBytes, 0);
    NewLine (pTable, "Packets", m_pTXPackets, 1);
    NewLine (pTable, "Errors", m_pTXErrors, 2);
    NewLine (pTable, "Collisions", m_pCollisions, 3);
    ::GtkWidget* pFrame (::gtk_frame_new ("Transmitted"));
    ::gtk_container_add (GTK_CONTAINER (pFrame), GTK_WIDGET (pTable));
    ::gtk_box_pack_start_defaults (m_pBox, pFrame);

        // I reuse pFrame and pTable.       The fourth line is blank.
    pTable = GTK_TABLE (::gtk_table_new (2, 4, true));
    NewLine (pTable, "Bytes", m_pRXBytes, 0);
    NewLine (pTable, "Packets", m_pRXPackets, 1);
    NewLine (pTable, "Errors", m_pRXErrors, 2);
    pFrame = ::gtk_frame_new ("Received");
    ::gtk_container_add (GTK_CONTAINER (pFrame), GTK_WIDGET (pTable));
    ::gtk_box_pack_start_defaults (m_pBox, pFrame);

} // BuildUI()


void nsGUI::CStatsPage::SetTXBytes (unsigned long NbBytes) throw()
{
    ::gtk_label_set_text (m_pTXBytes, BytesLabel (NbBytes).c_str());

} // SetTXBytes()


void nsGUI::CStatsPage::SetRXBytes (unsigned long NbBytes) throw()
{
    ::gtk_label_set_text (m_pRXBytes, BytesLabel (NbBytes).c_str());

} // SetRXBytes()


void nsGUI::CStatsPage::SetLabel (::GtkLabel* pLabel, unsigned long N) throw()
{
    std::ostringstream Os;
    Os << N;
    ::gtk_label_set_text (pLabel, Os.str().c_str());

} // SetLabel()
