/* rygel-http-request_http-get.c generated by valac 0.15.2.4-51044, the Vala compiler
 * generated from rygel-http-request_http-get.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_client_hacks_unref0(var) ((var == NULL) ? NULL : (var = (rygel_client_hacks_unref (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpRequestRunData RygelHttpRequestRunData;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;
typedef struct _RygelHttpRequestFindItemData RygelHttpRequestFindItemData;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPRequestPrivate {
	RygelMediaContainer* root_container;
	GCancellable* _cancellable;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHttpRequestRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	SoupServer* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupURI* _tmp3_;
	SoupURI* _tmp4_;
	const gchar* _tmp5_;
	RygelHTTPServer* _tmp6_;
	RygelHTTPItemURI* _tmp7_;
	RygelHTTPItemURI* _tmp8_;
	GError* _error_;
	GError* _tmp9_;
	GError * _inner_error_;
};

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHttpRequestFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	RygelMediaContainer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	const gchar* _tmp2_;
	RygelMediaObject* _tmp3_;
	RygelMediaObject* media_object;
	gboolean _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelMediaObject* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	RygelHTTPItemURI* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaItem* _tmp13_;
	GError * _inner_error_;
};


static gpointer rygel_http_request_parent_class = NULL;
static RygelStateMachineIface* rygel_http_request_rygel_state_machine_parent_iface = NULL;

GQuark rygel_http_request_error_quark (void);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestPrivate))
enum  {
	RYGEL_HTTP_REQUEST_DUMMY_PROPERTY,
	RYGEL_HTTP_REQUEST_CANCELLABLE
};
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
static void rygel_http_request_real_run_data_free (gpointer _data);
static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* _data_);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_http_request_handle (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_handle_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_request_real_find_item_data_free (gpointer _data);
static void rygel_http_request_real_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
static void rygel_http_request_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
#line 54 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	return self ? rygel_media_object_ref (self) : NULL;
#line 300 "rygel-http-request_http-get.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	return self ? g_object_ref (self) : NULL;
#line 307 "rygel-http-request_http-get.c"
}


RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPRequest * self = NULL;
	RygelHTTPServer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	RygelHTTPServer* _tmp3_;
	RygelMediaContainer* _tmp4_;
	RygelMediaContainer* _tmp5_;
	SoupServer* _tmp6_;
	SoupMessage* _tmp7_;
	SoupMessage* _tmp8_;
	GError * _inner_error_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self = (RygelHTTPRequest*) g_object_new (object_type, NULL);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp0_ = http_server;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self->http_server = _tmp0_;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp1_ = g_cancellable_new ();
#line 53 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp2_ = _tmp1_;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp2_);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_g_object_unref0 (_tmp2_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp3_ = http_server;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp4_ = _tmp3_->root_container;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp5_ = _rygel_media_object_ref0 (_tmp4_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_rygel_media_object_unref0 (self->priv->root_container);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self->priv->root_container = _tmp5_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp6_ = server;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self->server = _tmp6_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp7_ = msg;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_g_object_unref0 (self->msg);
#line 56 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self->msg = _tmp8_;
#line 365 "rygel-http-request_http-get.c"
	{
		SoupMessage* _tmp9_;
		RygelClientHacks* _tmp10_ = NULL;
		RygelClientHacks* _tmp11_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_tmp9_ = msg;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_tmp10_ = rygel_client_hacks_create (_tmp9_, &_inner_error_);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_tmp11_ = _tmp10_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		if (_inner_error_ != NULL) {
#line 378 "rygel-http-request_http-get.c"
			goto __catch4_g_error;
		}
#line 58 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_rygel_client_hacks_unref0 (self->hack);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		self->hack = _tmp11_;
#line 385 "rygel-http-request_http-get.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_error_ = _inner_error_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_inner_error_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_g_error_free0 (_error_);
#line 397 "rygel-http-request_http-get.c"
	}
	__finally4:
#line 57 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (_inner_error_ != NULL) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_clear_error (&_inner_error_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		return NULL;
#line 408 "rygel-http-request_http-get.c"
	}
#line 49 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	return self;
#line 412 "rygel-http-request_http-get.c"
}


static void rygel_http_request_real_run_data_free (gpointer _data) {
	RygelHttpRequestRunData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_slice_free (RygelHttpRequestRunData, _data_);
#line 423 "rygel-http-request_http-get.c"
}


static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPRequest * self;
	RygelHttpRequestRunData* _data_;
	RygelHTTPRequest* _tmp0_;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self = (RygelHTTPRequest*) base;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_ = g_slice_new0 (RygelHttpRequestRunData);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_real_run);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_real_run_data_free);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_http_request_real_run_co (_data_);
#line 445 "rygel-http-request_http-get.c"
}


static void rygel_http_request_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpRequestRunData* _data_;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 453 "rygel-http-request_http-get.c"
}


static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestRunData* _data_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_ = _user_data_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_source_object_ = source_object;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_res_ = _res_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_http_request_real_run_co (_data_);
#line 467 "rygel-http-request_http-get.c"
}


static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* _data_) {
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	switch (_data_->_state_) {
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		case 0:
#line 476 "rygel-http-request_http-get.c"
		goto _state_0;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		case 1:
#line 480 "rygel-http-request_http-get.c"
		goto _state_1;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		case 2:
#line 484 "rygel-http-request_http-get.c"
		goto _state_2;
		default:
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_assert_not_reached ();
#line 489 "rygel-http-request_http-get.c"
	}
	_state_0:
#line 63 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp0_ = _data_->self->server;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp1_ = _data_->self->msg;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	soup_server_pause_message (_data_->_tmp0_, _data_->_tmp1_);
#line 498 "rygel-http-request_http-get.c"
	{
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp2_ = _data_->self->msg;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp3_ = soup_message_get_uri (_data_->_tmp2_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp5_ = _data_->_tmp4_->path;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp6_ = _data_->self->http_server;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp7_ = rygel_http_item_uri_new_from_string (_data_->_tmp5_, _data_->_tmp6_, &_data_->_inner_error_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp8_ = _data_->_tmp7_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		if (_data_->_inner_error_ != NULL) {
#line 516 "rygel-http-request_http-get.c"
			goto __catch5_g_error;
		}
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_g_object_unref0 (_data_->self->uri);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->self->uri = _data_->_tmp8_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_state_ = 1;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		rygel_http_request_find_item (_data_->self, rygel_http_request_run_ready, _data_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		return FALSE;
#line 529 "rygel-http-request_http-get.c"
		_state_1:
#line 69 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		rygel_http_request_find_item_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		if (_data_->_inner_error_ != NULL) {
#line 535 "rygel-http-request_http-get.c"
			goto __catch5_g_error;
		}
#line 71 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_state_ = 2;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		rygel_http_request_handle (_data_->self, rygel_http_request_run_ready, _data_);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		return FALSE;
#line 544 "rygel-http-request_http-get.c"
		_state_2:
#line 71 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		rygel_http_request_handle_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		if (_data_->_inner_error_ != NULL) {
#line 550 "rygel-http-request_http-get.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
#line 65 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_inner_error_ = NULL;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp9_ = _data_->_error_;
#line 73 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		rygel_http_request_handle_error (_data_->self, _data_->_tmp9_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_g_error_free0 (_data_->_error_);
#line 567 "rygel-http-request_http-get.c"
	}
	__finally5:
#line 65 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 65 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_clear_error (&_data_->_inner_error_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		return FALSE;
#line 578 "rygel-http-request_http-get.c"
	}
#line 77 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) _data_->self, NULL);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (_data_->_state_ == 0) {
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 586 "rygel-http-request_http-get.c"
	} else {
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 590 "rygel-http-request_http-get.c"
	}
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_object_unref (_data_->_async_result);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	return FALSE;
#line 596 "rygel-http-request_http-get.c"
}


void rygel_http_request_handle (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->handle (self, _callback_, _user_data_);
#line 603 "rygel-http-request_http-get.c"
}


void rygel_http_request_handle_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->handle_finish (self, _res_, error);
#line 610 "rygel-http-request_http-get.c"
}


static void rygel_http_request_real_find_item_data_free (gpointer _data) {
	RygelHttpRequestFindItemData* _data_;
	_data_ = _data;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_slice_free (RygelHttpRequestFindItemData, _data_);
#line 621 "rygel-http-request_http-get.c"
}


static void rygel_http_request_real_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* _data_;
	RygelHTTPRequest* _tmp0_;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_ = g_slice_new0 (RygelHttpRequestFindItemData);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_real_find_item);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_real_find_item_data_free);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->self = _tmp0_;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_http_request_real_find_item_co (_data_);
#line 640 "rygel-http-request_http-get.c"
}


static void rygel_http_request_real_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
	RygelHttpRequestFindItemData* _data_;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		return;
#line 650 "rygel-http-request_http-get.c"
	}
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 654 "rygel-http-request_http-get.c"
}


static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* _data_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_ = _user_data_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_source_object_ = source_object;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_res_ = _res_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_http_request_real_find_item_co (_data_);
#line 668 "rygel-http-request_http-get.c"
}


static gboolean rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* _data_) {
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	switch (_data_->_state_) {
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		case 0:
#line 677 "rygel-http-request_http-get.c"
		goto _state_0;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		case 1:
#line 681 "rygel-http-request_http-get.c"
		goto _state_1;
		default:
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_assert_not_reached ();
#line 686 "rygel-http-request_http-get.c"
	}
	_state_0:
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp0_ = _data_->self->priv->root_container;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp1_ = _data_->self->uri;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp2_ = _data_->_tmp1_->item_id;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_state_ = 1;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_media_container_find_object (_data_->_tmp0_, _data_->_tmp2_, NULL, rygel_http_request_find_item_ready, _data_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	return FALSE;
#line 701 "rygel-http-request_http-get.c"
	_state_1:
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp3_ = NULL;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp3_ = rygel_media_container_find_object_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->media_object = _data_->_tmp3_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		if (_data_->_state_ == 0) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 719 "rygel-http-request_http-get.c"
		} else {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 723 "rygel-http-request_http-get.c"
		}
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_object_unref (_data_->_async_result);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		return FALSE;
#line 729 "rygel-http-request_http-get.c"
	}
#line 87 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp5_ = _data_->media_object;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (_data_->_tmp5_ == NULL) {
#line 87 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp4_ = TRUE;
#line 737 "rygel-http-request_http-get.c"
	} else {
#line 87 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp6_ = _data_->media_object;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp4_ = !RYGEL_IS_MEDIA_ITEM (_data_->_tmp6_);
#line 743 "rygel-http-request_http-get.c"
	}
#line 87 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp7_ = _data_->_tmp4_;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (_data_->_tmp7_) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp8_ = NULL;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp8_ = _ ("Requested item '%s' not found");
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp9_ = _data_->self->uri;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp10_ = _data_->_tmp9_->item_id;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_tmp11_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _data_->_tmp8_, _data_->_tmp10_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_data_->_inner_error_ = _data_->_tmp11_;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_rygel_media_object_unref0 (_data_->media_object);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		if (_data_->_state_ == 0) {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 771 "rygel-http-request_http-get.c"
		} else {
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 775 "rygel-http-request_http-get.c"
		}
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_object_unref (_data_->_async_result);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		return FALSE;
#line 781 "rygel-http-request_http-get.c"
	}
#line 93 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp12_ = _data_->media_object;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->_tmp13_ = _rygel_media_object_ref0 (RYGEL_MEDIA_ITEM (_data_->_tmp12_));
#line 93 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_rygel_media_object_unref0 (_data_->self->item);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_data_->self->item = _data_->_tmp13_;
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_rygel_media_object_unref0 (_data_->media_object);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (_data_->_state_ == 0) {
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 797 "rygel-http-request_http-get.c"
	} else {
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 801 "rygel-http-request_http-get.c"
	}
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_object_unref (_data_->_async_result);
#line 82 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	return FALSE;
#line 807 "rygel-http-request_http-get.c"
}


void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->find_item (self, _callback_, _user_data_);
#line 814 "rygel-http-request_http-get.c"
}


void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->find_item_finish (self, _res_, error);
#line 821 "rygel-http-request_http-get.c"
}


void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_) {
	GError* _tmp0_;
	const gchar* _tmp1_;
	SoupServer* _tmp2_;
	SoupMessage* _tmp3_;
	guint status = 0U;
	GError* _tmp4_;
	guint _tmp7_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_return_if_fail (self != NULL);
#line 97 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp0_ = _error_;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp1_ = _tmp0_->message;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_warning ("rygel-http-request_http-get.vala:97: %s", _tmp1_);
#line 98 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp2_ = self->server;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp3_ = self->msg;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	soup_server_unpause_message (_tmp2_, _tmp3_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp4_ = _error_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (_tmp4_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 851 "rygel-http-request_http-get.c"
		GError* _tmp5_;
		gint _tmp6_;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_tmp5_ = _error_;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_tmp6_ = _tmp5_->code;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		status = (guint) _tmp6_;
#line 860 "rygel-http-request_http-get.c"
	} else {
#line 104 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		status = (guint) SOUP_STATUS_NOT_FOUND;
#line 864 "rygel-http-request_http-get.c"
	}
#line 107 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp7_ = status;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_http_request_end (self, _tmp7_);
#line 870 "rygel-http-request_http-get.c"
}


void rygel_http_request_end (RygelHTTPRequest* self, guint status) {
	guint _tmp0_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp0_ = status;
#line 111 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	if (_tmp0_ != ((guint) SOUP_STATUS_NONE)) {
#line 882 "rygel-http-request_http-get.c"
		SoupMessage* _tmp1_;
		guint _tmp2_;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_tmp1_ = self->msg;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		_tmp2_ = status;
#line 112 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		soup_message_set_status (_tmp1_, _tmp2_);
#line 891 "rygel-http-request_http-get.c"
	}
#line 115 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 895 "rygel-http-request_http-get.c"
}


static GCancellable* rygel_http_request_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPRequest* self;
	GCancellable* _tmp0_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self = (RygelHTTPRequest*) base;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp0_ = self->priv->_cancellable;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	result = _tmp0_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	return result;
#line 911 "rygel-http-request_http-get.c"
}


static void rygel_http_request_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPRequest* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self = (RygelHTTPRequest*) base;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self->priv->_cancellable = _tmp1_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 931 "rygel-http-request_http-get.c"
}


static void rygel_http_request_class_init (RygelHTTPRequestClass * klass) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_http_request_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPRequestPrivate));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item = rygel_http_request_real_find_item;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item_finish = rygel_http_request_real_find_item_finish;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_request_get_property;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_request_set_property;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_request_finalize;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_REQUEST_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", G_TYPE_CANCELLABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 952 "rygel-http-request_http-get.c"
}


static void rygel_http_request_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	rygel_http_request_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_request_real_run;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	iface->run_finish = rygel_http_request_real_run_finish;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	iface->get_cancellable = rygel_http_request_real_get_cancellable;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	iface->set_cancellable = rygel_http_request_real_set_cancellable;
#line 967 "rygel-http-request_http-get.c"
}


static void rygel_http_request_instance_init (RygelHTTPRequest * self) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self->priv = RYGEL_HTTP_REQUEST_GET_PRIVATE (self);
#line 974 "rygel-http-request_http-get.c"
}


static void rygel_http_request_finalize (GObject* obj) {
	RygelHTTPRequest * self;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	self = RYGEL_HTTP_REQUEST (obj);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_rygel_media_object_unref0 (self->priv->root_container);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_g_object_unref0 (self->msg);
#line 42 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 44 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_g_object_unref0 (self->uri);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_rygel_media_object_unref0 (self->item);
#line 47 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	_rygel_client_hacks_unref0 (self->hack);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	G_OBJECT_CLASS (rygel_http_request_parent_class)->finalize (obj);
#line 996 "rygel-http-request_http-get.c"
}


/**
 * Base class for HTTP client requests.
 */
GType rygel_http_request_get_type (void) {
	static volatile gsize rygel_http_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPRequest), 0, (GInstanceInitFunc) rygel_http_request_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_request_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_request_type_id;
		rygel_http_request_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPRequest", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_http_request_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_request_type_id__volatile, rygel_http_request_type_id);
	}
	return rygel_http_request_type_id__volatile;
}


static void _vala_rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (object);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		break;
#line 1028 "rygel-http-request_http-get.c"
		default:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		break;
#line 1034 "rygel-http-request_http-get.c"
	}
}


static void _vala_rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = RYGEL_HTTP_REQUEST (object);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		break;
#line 1050 "rygel-http-request_http-get.c"
		default:
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-request_http-get.vala"
		break;
#line 1056 "rygel-http-request_http-get.c"
	}
}



