/* rygel-v1-hacks.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-v1-hacks.vala, do not modify */

/*
 * Copyright (C) 2011 Nokia Corporation.
 * Copyright (C) 2012 Jens Georg.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <rygel-core.h>
#include <libsoup/soup.h>
#include <libgupnp/gupnp.h>


#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_V1_HACKS (rygel_v1_hacks_get_type ())
#define RYGEL_V1_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_V1_HACKS, RygelV1Hacks))
#define RYGEL_V1_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_V1_HACKS, RygelV1HacksClass))
#define RYGEL_IS_V1_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_V1_HACKS))
#define RYGEL_IS_V1_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_V1_HACKS))
#define RYGEL_V1_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_V1_HACKS, RygelV1HacksClass))

typedef struct _RygelV1Hacks RygelV1Hacks;
typedef struct _RygelV1HacksClass RygelV1HacksClass;
typedef struct _RygelV1HacksPrivate RygelV1HacksPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaItem* item);
	void (*filter_sort_criteria) (RygelClientHacks* self, gchar** sort_criteria);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelV1Hacks {
	RygelClientHacks parent_instance;
	RygelV1HacksPrivate * priv;
	gchar* description_path;
};

struct _RygelV1HacksClass {
	RygelClientHacksClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_v1_hacks_parent_class = NULL;
static gchar* rygel_v1_hacks_agent_pattern;
static gchar* rygel_v1_hacks_agent_pattern = NULL;

GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_v1_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_V1_HACKS_DUMMY_PROPERTY
};
#define RYGEL_V1_HACKS_DMS "urn:schemas-upnp-org:device:MediaServer"
#define RYGEL_V1_HACKS_DMS_V1 RYGEL_V1_HACKS_DMS ":1"
#define RYGEL_V1_HACKS_MATCHING_PATTERN ".*%s.*"
static gchar* rygel_v1_hacks_generate_agent_pattern (void);
static const gchar** _vala_array_dup1 (const gchar** self, int length);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
GQuark rygel_client_hacks_error_quark (void);
RygelV1Hacks* rygel_v1_hacks_new (GError** error);
RygelV1Hacks* rygel_v1_hacks_construct (GType object_type, GError** error);
RygelClientHacks* rygel_client_hacks_construct (GType object_type, const gchar* agent, SoupMessage* message, GError** error);
void rygel_v1_hacks_apply_on_device (RygelV1Hacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:2"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
static void rygel_v1_hacks_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_V1_HACKS_AGENTS[5] = {"Allegro-Software-WebClient", "SEC HHP", "SEC_HHP", "Mediabolic-IMHTTP/1.", "TwoPlayer"};

/**
     * Read the user-agent snippets from the config file and generate the
     * regular expression string for matching.
     *
     * Returns: A regular expression pattern matching any of the configured
     *          user-agents.
     */
static const gchar** _vala_array_dup1 (const gchar** self, int length) {
	return g_memdup (self, length * sizeof (const gchar*));
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* rygel_v1_hacks_generate_agent_pattern (void) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMetaConfig* _tmp4_ = NULL;
	RygelMetaConfig* config;
	const gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar** raw_agents;
	gint raw_agents_length1;
	gint _raw_agents_size_;
	gchar** _tmp12_ = NULL;
	gchar** agents;
	gint agents_length1;
	gint _agents_size_;
	const gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_v1_hacks_agent_pattern;
	_tmp1_ = G_LIKELY (_tmp0_ != NULL);
	if (_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = rygel_v1_hacks_agent_pattern;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = rygel_meta_config_get_default ();
	config = _tmp4_;
	_tmp5_ = (RYGEL_V1_HACKS_AGENTS != NULL) ? _vala_array_dup1 (RYGEL_V1_HACKS_AGENTS, G_N_ELEMENTS (RYGEL_V1_HACKS_AGENTS)) : ((gpointer) RYGEL_V1_HACKS_AGENTS);
	_tmp5__length1 = G_N_ELEMENTS (RYGEL_V1_HACKS_AGENTS);
	raw_agents = _tmp5_;
	raw_agents_length1 = _tmp5__length1;
	_raw_agents_size_ = raw_agents_length1;
	{
		RygelMetaConfig* _tmp6_;
		GeeArrayList* _tmp7_ = NULL;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_ = 0;
		gpointer* _tmp11_ = NULL;
		_tmp6_ = config;
		_tmp7_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp6_, "general", "force-downgrade-for", &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch51_g_error;
		}
		_tmp9_ = _tmp8_;
		_tmp11_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp9_, &_tmp10_);
		raw_agents = (g_free (raw_agents), NULL);
		raw_agents = _tmp11_;
		raw_agents_length1 = _tmp10_;
		_raw_agents_size_ = raw_agents_length1;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally51:
	if (_inner_error_ != NULL) {
		raw_agents = (g_free (raw_agents), NULL);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp12_ = g_new0 (gchar*, 0 + 1);
	agents = _tmp12_;
	agents_length1 = 0;
	_agents_size_ = agents_length1;
	_tmp13_ = raw_agents;
	_tmp13__length1 = raw_agents_length1;
	{
		const gchar** agent_collection = NULL;
		gint agent_collection_length1 = 0;
		gint _agent_collection_size_ = 0;
		gint agent_it = 0;
		agent_collection = _tmp13_;
		agent_collection_length1 = _tmp13__length1;
		for (agent_it = 0; agent_it < _tmp13__length1; agent_it = agent_it + 1) {
			const gchar* agent = NULL;
			agent = agent_collection[agent_it];
			{
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				_tmp14_ = agents;
				_tmp14__length1 = agents_length1;
				_tmp15_ = agent;
				_tmp16_ = g_regex_escape_string (_tmp15_, -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strdup_printf (RYGEL_V1_HACKS_MATCHING_PATTERN, _tmp17_);
				_vala_array_add2 (&agents, &agents_length1, &_agents_size_, _tmp18_);
				_g_free0 (_tmp17_);
			}
		}
	}
	_tmp19_ = agents;
	_tmp19__length1 = agents_length1;
	if (_tmp19__length1 > 0) {
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_ = NULL;
		_tmp20_ = agents;
		_tmp20__length1 = agents_length1;
		_tmp21_ = g_strjoinv ("|", _tmp20_);
		_g_free0 (rygel_v1_hacks_agent_pattern);
		rygel_v1_hacks_agent_pattern = _tmp21_;
	}
	_tmp22_ = rygel_v1_hacks_agent_pattern;
	g_debug ("rygel-v1-hacks.vala:78: V1 downgrade will be applied for devices match" \
"ing %s", _tmp22_);
	_tmp23_ = rygel_v1_hacks_agent_pattern;
	_tmp24_ = g_strdup (_tmp23_);
	result = _tmp24_;
	agents = (_vala_array_free (agents, agents_length1, (GDestroyNotify) g_free), NULL);
	raw_agents = (g_free (raw_agents), NULL);
	_g_object_unref0 (config);
	return result;
}


RygelV1Hacks* rygel_v1_hacks_construct (GType object_type, GError** error) {
	RygelV1Hacks * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_v1_hacks_generate_agent_pattern ();
	_tmp1_ = _tmp0_;
	self = (RygelV1Hacks*) rygel_client_hacks_construct (object_type, _tmp1_, NULL, &_inner_error_);
	_g_free0 (_tmp1_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_CLIENT_HACKS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


RygelV1Hacks* rygel_v1_hacks_new (GError** error) {
	return rygel_v1_hacks_construct (RYGEL_TYPE_V1_HACKS, error);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch52_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch52_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally52;
	__catch52_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally52:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void rygel_v1_hacks_apply_on_device (RygelV1Hacks* self, RygelRootDevice* device, const gchar* template_path, GError** error) {
	RygelRootDevice* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	DescriptionFile* _tmp5_;
	DescriptionFile* description_file;
	DescriptionFile* _tmp6_;
	DescriptionFile* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	DescriptionFile* _tmp10_;
	const gchar* _tmp11_;
	RygelRootDevice* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* server_path;
	RygelRootDevice* _tmp15_;
	GUPnPContext* _tmp16_;
	GUPnPContext* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GRegex* _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = device;
	_tmp1_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) _tmp0_);
	_tmp2_ = g_str_has_prefix (_tmp1_, RYGEL_V1_HACKS_DMS);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = template_path;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = template_path;
	_tmp5_ = description_file_new (_tmp4_, &_inner_error_);
	description_file = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp6_ = description_file;
	description_file_set_device_type (_tmp6_, RYGEL_V1_HACKS_DMS_V1);
	_tmp7_ = description_file;
	description_file_modify_service_type (_tmp7_, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1);
	_tmp8_ = template_path;
	_tmp9_ = string_replace (_tmp8_, ".xml", "-v1.xml");
	_g_free0 (self->description_path);
	self->description_path = _tmp9_;
	_tmp10_ = description_file;
	_tmp11_ = self->description_path;
	description_file_save (_tmp10_, _tmp11_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (description_file);
		return;
	}
	_tmp12_ = device;
	_tmp13_ = gupnp_root_device_get_relative_location ((GUPnPRootDevice*) _tmp12_);
	_tmp14_ = g_strconcat ("/", _tmp13_, NULL);
	server_path = _tmp14_;
	_tmp15_ = device;
	_tmp16_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->description_path;
	_tmp19_ = server_path;
	_tmp20_ = ((RygelClientHacks*) self)->agent_regex;
	gupnp_context_host_path_for_agent (_tmp17_, _tmp18_, _tmp19_, _tmp20_);
	_g_free0 (server_path);
	_g_object_unref0 (description_file);
}


static void rygel_v1_hacks_class_init (RygelV1HacksClass * klass) {
	rygel_v1_hacks_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_v1_hacks_finalize;
}


static void rygel_v1_hacks_instance_init (RygelV1Hacks * self) {
}


static void rygel_v1_hacks_finalize (GObject* obj) {
	RygelV1Hacks * self;
	self = RYGEL_V1_HACKS (obj);
	_g_free0 (self->description_path);
	G_OBJECT_CLASS (rygel_v1_hacks_parent_class)->finalize (obj);
}


/**
 * Various devices that need a downgrade to MediaServer:1 and
 * ContentDirectory:1 because they ignore that higher versions are
 * required to be backwards-compatible.
 */
GType rygel_v1_hacks_get_type (void) {
	static volatile gsize rygel_v1_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_v1_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelV1HacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_v1_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelV1Hacks), 0, (GInstanceInitFunc) rygel_v1_hacks_instance_init, NULL };
		GType rygel_v1_hacks_type_id;
		rygel_v1_hacks_type_id = g_type_register_static (RYGEL_TYPE_CLIENT_HACKS, "RygelV1Hacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_v1_hacks_type_id__volatile, rygel_v1_hacks_type_id);
	}
	return rygel_v1_hacks_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



