/* rygel-basic-management-test-nslookup.c generated by valac 0.34.4, the Vala compiler
 * generated from rygel-basic-management-test-nslookup.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP (rygel_basic_management_test_ns_lookup_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))

typedef struct _RygelBasicManagementTestNSLookup RygelBasicManagementTestNSLookup;
typedef struct _RygelBasicManagementTestNSLookupClass RygelBasicManagementTestNSLookupClass;
typedef struct _RygelBasicManagementTestNSLookupPrivate RygelBasicManagementTestNSLookupPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_RESULT (rygel_basic_management_test_ns_lookup_result_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_PROCESS_STATE (rygel_basic_management_test_ns_lookup_process_state_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_RESULT_STATUS (rygel_basic_management_test_ns_lookup_result_status_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_ANSWER_TYPE (rygel_basic_management_test_ns_lookup_answer_type_get_type ())
typedef struct _RygelBasicManagementTestNSLookupResult RygelBasicManagementTestNSLookupResult;

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_GENERIC_STATUS (rygel_basic_management_test_ns_lookup_generic_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_EXECUTION_STATE (rygel_basic_management_test_execution_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestNSLookup {
	RygelBasicManagementTest parent_instance;
	RygelBasicManagementTestNSLookupPrivate * priv;
};

struct _RygelBasicManagementTestNSLookupClass {
	RygelBasicManagementTestClass parent_class;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME
} RygelBasicManagementTestNSLookupProcessState;

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER
} RygelBasicManagementTestNSLookupResultStatus;

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE
} RygelBasicManagementTestNSLookupAnswerType;

struct _RygelBasicManagementTestNSLookupResult {
	RygelBasicManagementTestNSLookupProcessState state;
	gchar* name_server_address;
	gchar* returned_host_name;
	gchar** addresses;
	gint addresses_length1;
	gint _addresses_size_;
	RygelBasicManagementTestNSLookupResultStatus status;
	RygelBasicManagementTestNSLookupAnswerType answer_type;
	guint execution_time;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER
} RygelBasicManagementTestNSLookupGenericStatus;

struct _RygelBasicManagementTestNSLookupPrivate {
	gchar* _host_name;
	gchar* _name_server;
	guint _interval_time_out;
	guint _repetitions;
	RygelBasicManagementTestNSLookupResult* results;
	gint results_length1;
	gint _results_size_;
	RygelBasicManagementTestNSLookupGenericStatus generic_status;
	gchar* additional_info;
	GTimer* timer;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED
} RygelBasicManagementTestExecutionState;


static gpointer rygel_basic_management_test_ns_lookup_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_ns_lookup_get_type (void) G_GNUC_CONST;
static GType rygel_basic_management_test_ns_lookup_result_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ns_lookup_process_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ns_lookup_result_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ns_lookup_answer_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static RygelBasicManagementTestNSLookupResult* rygel_basic_management_test_ns_lookup_result_dup (const RygelBasicManagementTestNSLookupResult* self);
static void rygel_basic_management_test_ns_lookup_result_free (RygelBasicManagementTestNSLookupResult* self);
static void rygel_basic_management_test_ns_lookup_result_copy (const RygelBasicManagementTestNSLookupResult* self, RygelBasicManagementTestNSLookupResult* dest);
static void rygel_basic_management_test_ns_lookup_result_destroy (RygelBasicManagementTestNSLookupResult* self);
static GType rygel_basic_management_test_ns_lookup_generic_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupPrivate))
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DUMMY_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE
};
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_REPETITIONS ((guint) 1)
static gchar* rygel_basic_management_test_ns_lookup_generic_status_to_string (RygelBasicManagementTestNSLookupGenericStatus self);
static gchar* rygel_basic_management_test_ns_lookup_result_status_to_string (RygelBasicManagementTestNSLookupResultStatus self);
static gchar* rygel_basic_management_test_ns_lookup_answer_type_to_string (RygelBasicManagementTestNSLookupAnswerType self);
static void _vala_RygelBasicManagementTestNSLookupResult_array_free (RygelBasicManagementTestNSLookupResult* array, gint array_length);
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HEADER "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" "<bms:NSLookupResult " "xmlns:bms=\"urn:schemas-upnp-org:dm:bms\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"" "urn:schemas-upnp-org:dm:bms " "http://www.upnp.org/schemas/dm/bms.xsd\">\n"
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_FOOTER "</bms:NSLookupResult>\n"
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_REPETITIONS ((guint) 100)
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MIN_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_INTERVAL_TIMEOUT ((guint) 30000)
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_new (const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_construct (GType object_type, const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
static void rygel_basic_management_test_ns_lookup_real_constructed (GObject* base);
static guint rygel_basic_management_test_ns_lookup_get_interval_time_out (RygelBasicManagementTestNSLookup* self);
static guint rygel_basic_management_test_ns_lookup_get_repetitions (RygelBasicManagementTestNSLookup* self);
static const gchar* rygel_basic_management_test_ns_lookup_get_host_name (RygelBasicManagementTestNSLookup* self);
static const gchar* rygel_basic_management_test_ns_lookup_get_name_server (RygelBasicManagementTestNSLookup* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void rygel_basic_management_test_ns_lookup_real_init_iteration (RygelBasicManagementTest* base);
void rygel_basic_management_test_init_iteration (RygelBasicManagementTest* self);
static void _vala_array_add2 (RygelBasicManagementTestNSLookupResult** array, int* length, int* size, const RygelBasicManagementTestNSLookupResult* value);
static gboolean rygel_basic_management_test_ns_lookup_real_finish_iteration (RygelBasicManagementTest* base);
gboolean rygel_basic_management_test_finish_iteration (RygelBasicManagementTest* self);
static void rygel_basic_management_test_ns_lookup_real_handle_error (RygelBasicManagementTest* base, const gchar* line);
GType rygel_basic_management_test_execution_state_get_type (void) G_GNUC_CONST;
void rygel_basic_management_test_set_execution_state (RygelBasicManagementTest* self, RygelBasicManagementTestExecutionState value);
static void rygel_basic_management_test_ns_lookup_real_handle_output (RygelBasicManagementTest* base, const gchar* line);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
void rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self, gchar** status, gchar** additional_info, guint* success_count, gchar** result_string);
static gchar* rygel_basic_management_test_ns_lookup_result_to_xml_fragment (RygelBasicManagementTestNSLookupResult *self);
static void rygel_basic_management_test_ns_lookup_set_host_name (RygelBasicManagementTestNSLookup* self, const gchar* value);
static void rygel_basic_management_test_ns_lookup_set_name_server (RygelBasicManagementTestNSLookup* self, const gchar* value);
static void rygel_basic_management_test_ns_lookup_set_interval_time_out (RygelBasicManagementTestNSLookup* self, guint value);
static void rygel_basic_management_test_ns_lookup_set_repetitions (RygelBasicManagementTestNSLookup* self, guint value);
static gchar* rygel_basic_management_test_ns_lookup_result_get_addresses_csv (RygelBasicManagementTestNSLookupResult *self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void rygel_basic_management_test_ns_lookup_finalize (GObject* obj);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static void _vala_rygel_basic_management_test_ns_lookup_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_basic_management_test_ns_lookup_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType rygel_basic_management_test_ns_lookup_process_state_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_process_state_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_process_state_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT", "init"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER", "server"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME", "name"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_process_state_type_id;
		rygel_basic_management_test_ns_lookup_process_state_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupProcessState", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_process_state_type_id__volatile, rygel_basic_management_test_ns_lookup_process_state_type_id);
	}
	return rygel_basic_management_test_ns_lookup_process_state_type_id__volatile;
}


static gchar* rygel_basic_management_test_ns_lookup_generic_status_to_string (RygelBasicManagementTestNSLookupGenericStatus self) {
	gchar* result = NULL;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("Success");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("Error_DNSServerNotResolved");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("Error_Internal");
			result = _tmp2_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("Error_Other");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GType rygel_basic_management_test_ns_lookup_generic_status_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED", "error-dns-server-not-resolved"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL", "error-internal"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_generic_status_type_id;
		rygel_basic_management_test_ns_lookup_generic_status_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupGenericStatus", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile, rygel_basic_management_test_ns_lookup_generic_status_type_id);
	}
	return rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile;
}


static gchar* rygel_basic_management_test_ns_lookup_result_status_to_string (RygelBasicManagementTestNSLookupResultStatus self) {
	gchar* result = NULL;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("Success");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("Error_DNSServerNotAvailable");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("Error_HostNameNotResolved");
			result = _tmp2_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("Error_Timeout");
			result = _tmp3_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("Error_Other");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GType rygel_basic_management_test_ns_lookup_result_status_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_result_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_result_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE", "error-dns-server-not-available"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED", "error-hostname-not-resolved"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT", "error-timeout"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_result_status_type_id;
		rygel_basic_management_test_ns_lookup_result_status_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupResultStatus", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_result_status_type_id__volatile, rygel_basic_management_test_ns_lookup_result_status_type_id);
	}
	return rygel_basic_management_test_ns_lookup_result_status_type_id__volatile;
}


static gchar* rygel_basic_management_test_ns_lookup_answer_type_to_string (RygelBasicManagementTestNSLookupAnswerType self) {
	gchar* result = NULL;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("None");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("Authoritative");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("NonAuthoritative");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GType rygel_basic_management_test_ns_lookup_answer_type_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE", "none"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE", "authoritative"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE", "non-authoritative"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_answer_type_type_id;
		rygel_basic_management_test_ns_lookup_answer_type_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupAnswerType", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile, rygel_basic_management_test_ns_lookup_answer_type_type_id);
	}
	return rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile;
}


static void _vala_RygelBasicManagementTestNSLookupResult_array_free (RygelBasicManagementTestNSLookupResult* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			rygel_basic_management_test_ns_lookup_result_destroy (&array[i]);
		}
	}
	g_free (array);
}


RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_construct (GType object_type, const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out) {
	RygelBasicManagementTestNSLookup * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint32 _tmp3_ = 0U;
	g_return_val_if_fail (host_name != NULL, NULL);
	_tmp0_ = host_name;
	_tmp1_ = name_server;
	_tmp2_ = repetitions;
	_tmp3_ = interval_time_out;
	self = (RygelBasicManagementTestNSLookup*) g_object_new (object_type, "host-name", _tmp0_, "name-server", _tmp1_, "repetitions", _tmp2_, "interval-time-out", _tmp3_, NULL);
	return self;
}


RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_new (const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out) {
	return rygel_basic_management_test_ns_lookup_construct (RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, host_name, name_server, repetitions, interval_time_out);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void rygel_basic_management_test_ns_lookup_real_constructed (GObject* base) {
	RygelBasicManagementTestNSLookup * self;
	gchar* _tmp0_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gchar* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	self = (RygelBasicManagementTestNSLookup*) base;
	G_OBJECT_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->additional_info);
	self->priv->additional_info = _tmp0_;
	_tmp1_ = g_new0 (RygelBasicManagementTestNSLookupResult, 0);
	self->priv->results = (_vala_RygelBasicManagementTestNSLookupResult_array_free (self->priv->results, self->priv->results_length1), NULL);
	self->priv->results = _tmp1_;
	self->priv->results_length1 = 0;
	self->priv->_results_size_ = self->priv->results_length1;
	_tmp2_ = g_strdup ("nslookup");
	_tmp3_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("-timeout=%u", _tmp4_ / 1000);
	_tmp6_ = rygel_basic_management_test_ns_lookup_get_repetitions (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("-retry=%u", _tmp7_);
	_tmp9_ = self->priv->_host_name;
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = g_new0 (gchar*, 4 + 1);
	_tmp11_[0] = _tmp2_;
	_tmp11_[1] = _tmp5_;
	_tmp11_[2] = _tmp8_;
	_tmp11_[3] = _tmp10_;
	((RygelBasicManagementTest*) self)->command = (_vala_array_free (((RygelBasicManagementTest*) self)->command, ((RygelBasicManagementTest*) self)->command_length1, (GDestroyNotify) g_free), NULL);
	((RygelBasicManagementTest*) self)->command = _tmp11_;
	((RygelBasicManagementTest*) self)->command_length1 = 4;
	((RygelBasicManagementTest*) self)->_command_size_ = ((RygelBasicManagementTest*) self)->command_length1;
	_tmp13_ = self->priv->_name_server;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		_tmp14_ = self->priv->_name_server;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_ > 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp17_ = ((RygelBasicManagementTest*) self)->command;
		_tmp17__length1 = ((RygelBasicManagementTest*) self)->command_length1;
		_tmp18_ = self->priv->_name_server;
		_tmp19_ = g_strdup (_tmp18_);
		_vala_array_add1 (&((RygelBasicManagementTest*) self)->command, &((RygelBasicManagementTest*) self)->command_length1, &((RygelBasicManagementTest*) self)->_command_size_, _tmp19_);
	}
	_tmp20_ = rygel_basic_management_test_ns_lookup_get_repetitions (self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ > RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_REPETITIONS) {
		gchar* msg = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		guint _tmp25_ = 0U;
		gchar* _tmp26_ = NULL;
		((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
		_tmp22_ = g_strdup ("NumberOfRepetitions %u is not in allowed range [0, %u]");
		msg = _tmp22_;
		_tmp23_ = msg;
		_tmp24_ = rygel_basic_management_test_ns_lookup_get_repetitions (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf (_tmp23_, _tmp25_, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_REPETITIONS);
		_g_free0 (self->priv->additional_info);
		self->priv->additional_info = _tmp26_;
		_g_free0 (msg);
	} else {
		gboolean _tmp27_ = FALSE;
		guint _tmp28_ = 0U;
		guint _tmp29_ = 0U;
		_tmp28_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ < RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MIN_INTERVAL_TIMEOUT) {
			_tmp27_ = TRUE;
		} else {
			guint _tmp30_ = 0U;
			guint _tmp31_ = 0U;
			_tmp30_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ > RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_INTERVAL_TIMEOUT;
		}
		if (_tmp27_) {
			gchar* msg = NULL;
			gchar* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			guint _tmp34_ = 0U;
			guint _tmp35_ = 0U;
			gchar* _tmp36_ = NULL;
			((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
			_tmp32_ = g_strdup ("Timeout %u is not in allowed range [%u, %u]");
			msg = _tmp32_;
			_tmp33_ = msg;
			_tmp34_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strdup_printf (_tmp33_, _tmp35_, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MIN_INTERVAL_TIMEOUT, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_INTERVAL_TIMEOUT);
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp36_;
			_g_free0 (msg);
		}
	}
}


static void _vala_array_add2 (RygelBasicManagementTestNSLookupResult** array, int* length, int* size, const RygelBasicManagementTestNSLookupResult* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (RygelBasicManagementTestNSLookupResult, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void rygel_basic_management_test_ns_lookup_real_init_iteration (RygelBasicManagementTest* base) {
	RygelBasicManagementTestNSLookup * self;
	RygelBasicManagementTestNSLookupResult _result_ = {0};
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	RygelBasicManagementTestNSLookupResult _tmp3_ = {0};
	RygelBasicManagementTestNSLookupResult* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	RygelBasicManagementTestNSLookupResult _tmp5_ = {0};
	RygelBasicManagementTestNSLookupResult _tmp6_ = {0};
	GTimer* _tmp7_ = NULL;
	self = (RygelBasicManagementTestNSLookup*) base;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->init_iteration (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	_tmp0_ = g_strdup ("");
	_tmp1_ = g_strdup ("");
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	memset (&_tmp3_, 0, sizeof (RygelBasicManagementTestNSLookupResult));
	_tmp3_.state = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT;
	_g_free0 (_tmp3_.name_server_address);
	_tmp3_.name_server_address = _tmp0_;
	_g_free0 (_tmp3_.returned_host_name);
	_tmp3_.returned_host_name = _tmp1_;
	_tmp3_.addresses = (_vala_array_free (_tmp3_.addresses, _tmp3_.addresses_length1, (GDestroyNotify) g_free), NULL);
	_tmp3_.addresses = _tmp2_;
	_tmp3_.addresses_length1 = 0;
	_tmp3_._addresses_size_ = _tmp3_.addresses_length1;
	_tmp3_.status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER;
	_tmp3_.answer_type = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE;
	_tmp3_.execution_time = (guint) 0;
	_result_ = _tmp3_;
	_tmp4_ = self->priv->results;
	_tmp4__length1 = self->priv->results_length1;
	_tmp5_ = _result_;
	rygel_basic_management_test_ns_lookup_result_copy (&_tmp5_, &_tmp6_);
	_vala_array_add2 (&self->priv->results, &self->priv->results_length1, &self->priv->_results_size_, &_tmp6_);
	_tmp7_ = self->priv->timer;
	g_timer_start (_tmp7_);
	rygel_basic_management_test_ns_lookup_result_destroy (&_result_);
}


static gboolean rygel_basic_management_test_ns_lookup_real_finish_iteration (RygelBasicManagementTest* base) {
	RygelBasicManagementTestNSLookup * self;
	gboolean result = FALSE;
	RygelBasicManagementTestInitState _tmp0_ = 0;
	gboolean _tmp13_ = FALSE;
	self = (RygelBasicManagementTestNSLookup*) base;
	_tmp0_ = ((RygelBasicManagementTest*) self)->init_state;
	switch (_tmp0_) {
		case RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED:
		{
			gchar* _tmp1_ = NULL;
			RygelBasicManagementTestNSLookupResult* _tmp2_ = NULL;
			gint _tmp2__length1 = 0;
			RygelBasicManagementTestNSLookupResult* _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
			self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL;
			_tmp1_ = g_strdup ("Failed to spawn nslookup");
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp1_;
			_tmp2_ = self->priv->results;
			_tmp2__length1 = self->priv->results_length1;
			_tmp3_ = self->priv->results;
			_tmp3__length1 = self->priv->results_length1;
			_tmp2_[_tmp3__length1 - 1].status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER;
			break;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER:
		{
			RygelBasicManagementTestNSLookupResult* _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			RygelBasicManagementTestNSLookupResult* _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER;
			_tmp4_ = self->priv->results;
			_tmp4__length1 = self->priv->results_length1;
			_tmp5_ = self->priv->results;
			_tmp5__length1 = self->priv->results_length1;
			_tmp4_[_tmp5__length1 - 1].status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER;
			break;
		}
		default:
		{
			gdouble elapsed_msec = 0.0;
			GTimer* _tmp6_ = NULL;
			gdouble _tmp7_ = 0.0;
			guint exec_time = 0U;
			gdouble _tmp8_ = 0.0;
			gdouble _tmp9_ = 0.0;
			RygelBasicManagementTestNSLookupResult* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			RygelBasicManagementTestNSLookupResult* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			guint _tmp12_ = 0U;
			_tmp6_ = self->priv->timer;
			_tmp7_ = g_timer_elapsed (_tmp6_, NULL);
			elapsed_msec = _tmp7_ * 1000;
			_tmp8_ = elapsed_msec;
			_tmp9_ = round (_tmp8_);
			exec_time = (guint) _tmp9_;
			_tmp10_ = self->priv->results;
			_tmp10__length1 = self->priv->results_length1;
			_tmp11_ = self->priv->results;
			_tmp11__length1 = self->priv->results_length1;
			_tmp12_ = exec_time;
			_tmp10_[_tmp11__length1 - 1].execution_time = _tmp12_;
			break;
		}
	}
	_tmp13_ = RYGEL_BASIC_MANAGEMENT_TEST_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->finish_iteration (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	result = _tmp13_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void rygel_basic_management_test_ns_lookup_real_handle_error (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestNSLookup * self;
	RygelBasicManagementTestNSLookupResult* _result_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	RygelBasicManagementTestNSLookupResult* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	self = (RygelBasicManagementTestNSLookup*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->results;
	_tmp0__length1 = self->priv->results_length1;
	_tmp1_ = self->priv->results;
	_tmp1__length1 = self->priv->results_length1;
	_result_ = &_tmp0_[_tmp1__length1 - 1];
	_tmp2_ = line;
	_tmp3_ = string_contains (_tmp2_, "couldn't get address for");
	if (_tmp3_) {
		self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED;
		rygel_basic_management_test_set_execution_state ((RygelBasicManagementTest*) self, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED);
		(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void rygel_basic_management_test_ns_lookup_real_handle_output (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestNSLookup * self;
	RygelBasicManagementTestNSLookupResult* _result_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	RygelBasicManagementTestNSLookupResult* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	self = (RygelBasicManagementTestNSLookup*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->results;
	_tmp0__length1 = self->priv->results_length1;
	_tmp1_ = self->priv->results;
	_tmp1__length1 = self->priv->results_length1;
	_result_ = &_tmp0_[_tmp1__length1 - 1];
	_tmp2_ = line;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp4_);
	_tmp5_ = line;
	_tmp6_ = g_str_has_prefix (_tmp5_, "Server:");
	if (_tmp6_) {
		RygelBasicManagementTestNSLookupResult* _tmp7_ = NULL;
		RygelBasicManagementTestNSLookupProcessState _tmp8_ = 0;
		_tmp7_ = _result_;
		_tmp8_ = (*_tmp7_).state;
		if (_tmp8_ != RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT) {
			g_debug ("rygel-basic-management-test-nslookup.vala:305: nslookup parser: Unexpe" \
"cted 'Server:' line.\n");
		}
		(*_result_).state = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER;
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = line;
		_tmp10_ = g_str_has_prefix (_tmp9_, "Name:");
		if (_tmp10_) {
			RygelBasicManagementTestNSLookupResult* _tmp11_ = NULL;
			RygelBasicManagementTestNSLookupProcessState _tmp12_ = 0;
			_tmp11_ = _result_;
			_tmp12_ = (*_tmp11_).state;
			if (_tmp12_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT) {
				g_debug ("rygel-basic-management-test-nslookup.vala:310: nslookup parser: Unexpe" \
"cted 'Name:' line");
			} else {
				RygelBasicManagementTestNSLookupResult* _tmp13_ = NULL;
				RygelBasicManagementTestNSLookupProcessState _tmp14_ = 0;
				_tmp13_ = _result_;
				_tmp14_ = (*_tmp13_).state;
				if (_tmp14_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER) {
					gchar* name = NULL;
					const gchar* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					_tmp15_ = line;
					_tmp16_ = strlen ("Name:");
					_tmp17_ = _tmp16_;
					_tmp18_ = string_substring (_tmp15_, (glong) _tmp17_, (glong) -1);
					_tmp19_ = _tmp18_;
					_tmp20_ = string_strip (_tmp19_);
					_tmp21_ = _tmp20_;
					_g_free0 (_tmp19_);
					name = _tmp21_;
					_tmp22_ = name;
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 ((*_result_).returned_host_name);
					(*_result_).returned_host_name = _tmp23_;
					_g_free0 (name);
				}
			}
			(*_result_).state = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME;
		} else {
			const gchar* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			_tmp24_ = line;
			_tmp25_ = g_str_has_prefix (_tmp24_, "Address:");
			if (_tmp25_) {
				RygelBasicManagementTestNSLookupResult* _tmp26_ = NULL;
				RygelBasicManagementTestNSLookupProcessState _tmp27_ = 0;
				_tmp26_ = _result_;
				_tmp27_ = (*_tmp26_).state;
				if (_tmp27_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER) {
					gchar* address = NULL;
					const gchar* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					gchar** _tmp36_ = NULL;
					gchar** _tmp37_ = NULL;
					gchar** _tmp38_ = NULL;
					gint _tmp38__length1 = 0;
					const gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					_tmp28_ = line;
					_tmp29_ = strlen ("Address:");
					_tmp30_ = _tmp29_;
					_tmp31_ = string_substring (_tmp28_, (glong) _tmp30_, (glong) -1);
					_tmp32_ = _tmp31_;
					_tmp33_ = string_strip (_tmp32_);
					_tmp34_ = _tmp33_;
					_g_free0 (_tmp32_);
					address = _tmp34_;
					_tmp35_ = address;
					_tmp37_ = _tmp36_ = g_strsplit (_tmp35_, "#", 2);
					_tmp38_ = _tmp37_;
					_tmp38__length1 = _vala_array_length (_tmp36_);
					_tmp39_ = _tmp38_[0];
					_tmp40_ = g_strdup (_tmp39_);
					_g_free0 ((*_result_).name_server_address);
					(*_result_).name_server_address = _tmp40_;
					_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
					self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS;
					_g_free0 (address);
				} else {
					RygelBasicManagementTestNSLookupResult* _tmp41_ = NULL;
					RygelBasicManagementTestNSLookupProcessState _tmp42_ = 0;
					_tmp41_ = _result_;
					_tmp42_ = (*_tmp41_).state;
					if (_tmp42_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME) {
						gchar** _tmp43_ = NULL;
						gint _tmp43__length1 = 0;
						const gchar* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						gint _tmp46_ = 0;
						gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_ = NULL;
						RygelBasicManagementTestNSLookupResult* _tmp50_ = NULL;
						RygelBasicManagementTestNSLookupAnswerType _tmp51_ = 0;
						_tmp43_ = (*_result_).addresses;
						_tmp43__length1 = (*_result_).addresses_length1;
						_tmp44_ = line;
						_tmp45_ = strlen ("Address:");
						_tmp46_ = _tmp45_;
						_tmp47_ = string_substring (_tmp44_, (glong) _tmp46_, (glong) -1);
						_tmp48_ = _tmp47_;
						_tmp49_ = string_strip (_tmp48_);
						_vala_array_add3 (&(*_result_).addresses, &(*_result_).addresses_length1, &(*_result_)._addresses_size_, _tmp49_);
						_g_free0 (_tmp48_);
						(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS;
						_tmp50_ = _result_;
						_tmp51_ = (*_tmp50_).answer_type;
						if (_tmp51_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE) {
							(*_result_).answer_type = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE;
						}
					} else {
						g_debug ("rygel-basic-management-test-nslookup.vala:328: nslookup parser: Unexpe" \
"cted 'Address:' line");
					}
				}
			} else {
				const gchar* _tmp52_ = NULL;
				gboolean _tmp53_ = FALSE;
				_tmp52_ = line;
				_tmp53_ = g_str_has_prefix (_tmp52_, "Non-authoritative answer:");
				if (_tmp53_) {
					(*_result_).answer_type = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE;
				} else {
					const gchar* _tmp54_ = NULL;
					gboolean _tmp55_ = FALSE;
					_tmp54_ = line;
					_tmp55_ = string_contains (_tmp54_, "server can't find");
					if (_tmp55_) {
						(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED;
					} else {
						const gchar* _tmp56_ = NULL;
						gboolean _tmp57_ = FALSE;
						_tmp56_ = line;
						_tmp57_ = string_contains (_tmp56_, "couldn't get address for");
						if (_tmp57_) {
							self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED;
							(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE;
							rygel_basic_management_test_set_execution_state ((RygelBasicManagementTest*) self, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED);
						} else {
							const gchar* _tmp58_ = NULL;
							gboolean _tmp59_ = FALSE;
							_tmp58_ = line;
							_tmp59_ = string_contains (_tmp58_, "no servers could be reached");
							if (_tmp59_) {
								(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE;
							}
						}
					}
				}
			}
		}
	}
}


void rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self, gchar** status, gchar** additional_info, guint* success_count, gchar** result_string) {
	gchar* _vala_status = NULL;
	gchar* _vala_additional_info = NULL;
	guint _vala_success_count = 0U;
	gchar* _vala_result_string = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GString* _tmp9_ = NULL;
	GString* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	RygelBasicManagementTestNSLookupGenericStatus _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_vala_success_count = (guint) 0;
	_tmp0_ = g_string_new (RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HEADER);
	builder = _tmp0_;
	_tmp1_ = self->priv->results;
	_tmp1__length1 = self->priv->results_length1;
	{
		RygelBasicManagementTestNSLookupResult* result_collection = NULL;
		gint result_collection_length1 = 0;
		gint _result_collection_size_ = 0;
		gint result_it = 0;
		result_collection = _tmp1_;
		result_collection_length1 = _tmp1__length1;
		for (result_it = 0; result_it < _tmp1__length1; result_it = result_it + 1) {
			RygelBasicManagementTestNSLookupResult _tmp2_ = {0};
			RygelBasicManagementTestNSLookupResult _result_ = {0};
			rygel_basic_management_test_ns_lookup_result_copy (&result_collection[result_it], &_tmp2_);
			_result_ = _tmp2_;
			{
				GString* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				RygelBasicManagementTestNSLookupResult _tmp6_ = {0};
				RygelBasicManagementTestNSLookupResultStatus _tmp7_ = 0;
				_tmp3_ = builder;
				_tmp4_ = rygel_basic_management_test_ns_lookup_result_to_xml_fragment (&_result_);
				_tmp5_ = _tmp4_;
				g_string_append (_tmp3_, _tmp5_);
				_g_free0 (_tmp5_);
				_tmp6_ = _result_;
				_tmp7_ = _tmp6_.status;
				if (_tmp7_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS) {
					guint _tmp8_ = 0U;
					_tmp8_ = _vala_success_count;
					_vala_success_count = _tmp8_ + 1;
				}
				rygel_basic_management_test_ns_lookup_result_destroy (&_result_);
			}
		}
	}
	_tmp9_ = builder;
	g_string_append (_tmp9_, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_FOOTER);
	_tmp10_ = builder;
	_tmp11_ = _tmp10_->str;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (_vala_result_string);
	_vala_result_string = _tmp12_;
	_tmp13_ = self->priv->generic_status;
	_tmp14_ = rygel_basic_management_test_ns_lookup_generic_status_to_string (_tmp13_);
	_g_free0 (_vala_status);
	_vala_status = _tmp14_;
	_tmp15_ = self->priv->additional_info;
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (_vala_additional_info);
	_vala_additional_info = _tmp16_;
	_g_string_free0 (builder);
	if (status) {
		*status = _vala_status;
	} else {
		_g_free0 (_vala_status);
	}
	if (additional_info) {
		*additional_info = _vala_additional_info;
	} else {
		_g_free0 (_vala_additional_info);
	}
	if (success_count) {
		*success_count = _vala_success_count;
	}
	if (result_string) {
		*result_string = _vala_result_string;
	} else {
		_g_free0 (_vala_result_string);
	}
}


static const gchar* rygel_basic_management_test_ns_lookup_get_host_name (RygelBasicManagementTestNSLookup* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_host_name;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_ns_lookup_set_host_name (RygelBasicManagementTestNSLookup* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_host_name);
	self->priv->_host_name = _tmp1_;
	g_object_notify ((GObject *) self, "host-name");
}


static const gchar* rygel_basic_management_test_ns_lookup_get_name_server (RygelBasicManagementTestNSLookup* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name_server;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_ns_lookup_set_name_server (RygelBasicManagementTestNSLookup* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name_server);
	self->priv->_name_server = _tmp1_;
	g_object_notify ((GObject *) self, "name-server");
}


static guint rygel_basic_management_test_ns_lookup_get_interval_time_out (RygelBasicManagementTestNSLookup* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_interval_time_out;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_ns_lookup_set_interval_time_out (RygelBasicManagementTestNSLookup* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_interval_time_out = _tmp0_;
	_tmp1_ = self->priv->_interval_time_out;
	if (_tmp1_ == ((guint) 0)) {
		self->priv->_interval_time_out = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_INTERVAL_TIMEOUT;
	}
	g_object_notify ((GObject *) self, "interval-time-out");
}


static guint rygel_basic_management_test_ns_lookup_get_repetitions (RygelBasicManagementTestNSLookup* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_repetitions;
	result = _tmp0_;
	return result;
}


static void rygel_basic_management_test_ns_lookup_set_repetitions (RygelBasicManagementTestNSLookup* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	((RygelBasicManagementTest*) self)->iterations = (guint) 1;
	_tmp0_ = value;
	self->priv->_repetitions = _tmp0_;
	_tmp1_ = self->priv->_repetitions;
	if (_tmp1_ == ((guint) 0)) {
		self->priv->_repetitions = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_REPETITIONS;
	}
	g_object_notify ((GObject *) self, "repetitions");
}


static const gchar* rygel_basic_management_test_ns_lookup_real_get_method_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestNSLookup* self;
	self = (RygelBasicManagementTestNSLookup*) base;
	result = "NSLookup";
	return result;
}


static const gchar* rygel_basic_management_test_ns_lookup_real_get_results_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestNSLookup* self;
	self = (RygelBasicManagementTestNSLookup*) base;
	result = "GetNSLookupResult";
	return result;
}


static gchar* rygel_basic_management_test_ns_lookup_result_get_addresses_csv (RygelBasicManagementTestNSLookupResult *self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GString* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = (*self).addresses;
	_tmp1__length1 = (*self).addresses_length1;
	{
		gchar** address_collection = NULL;
		gint address_collection_length1 = 0;
		gint _address_collection_size_ = 0;
		gint address_it = 0;
		address_collection = _tmp1_;
		address_collection_length1 = _tmp1__length1;
		for (address_it = 0; address_it < _tmp1__length1; address_it = address_it + 1) {
			gchar* _tmp2_ = NULL;
			gchar* address = NULL;
			_tmp2_ = g_strdup (address_collection[address_it]);
			address = _tmp2_;
			{
				GString* _tmp3_ = NULL;
				gssize _tmp4_ = 0L;
				GString* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				_tmp3_ = builder;
				_tmp4_ = _tmp3_->len;
				if (_tmp4_ != ((gssize) 0)) {
					GString* _tmp5_ = NULL;
					_tmp5_ = builder;
					g_string_append (_tmp5_, ",");
				}
				_tmp6_ = builder;
				_tmp7_ = address;
				g_string_append (_tmp6_, _tmp7_);
				_g_free0 (address);
			}
		}
	}
	_tmp8_ = builder;
	_tmp9_ = _tmp8_->str;
	_tmp10_ = g_strdup (_tmp9_);
	result = _tmp10_;
	_g_string_free0 (builder);
	return result;
}


static gchar* rygel_basic_management_test_ns_lookup_result_to_xml_fragment (RygelBasicManagementTestNSLookupResult *self) {
	gchar* result = NULL;
	RygelBasicManagementTestNSLookupResultStatus _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelBasicManagementTestNSLookupAnswerType _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	_tmp0_ = (*self).status;
	_tmp1_ = rygel_basic_management_test_ns_lookup_result_status_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (*self).answer_type;
	_tmp4_ = rygel_basic_management_test_ns_lookup_answer_type_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = (*self).returned_host_name;
	_tmp7_ = rygel_basic_management_test_ns_lookup_result_get_addresses_csv (&(*self));
	_tmp8_ = _tmp7_;
	_tmp9_ = (*self).name_server_address;
	_tmp10_ = (*self).execution_time;
	_tmp11_ = g_strdup_printf ("<Result>\n" "<Status>%s</Status>\n" "<AnswerType>%s</AnswerType>\n" "<HostNameReturned>%s</HostNameReturned>\n" "<IPAddresses>%s</IPAddresses>\n" "<DNSServerIP>%s</DNSServerIP>\n" "<ResponseTime>%u</ResponseTime>\n" "</Result>\n", _tmp2_, _tmp5_, _tmp6_, _tmp8_, _tmp9_, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp12_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void rygel_basic_management_test_ns_lookup_result_copy (const RygelBasicManagementTestNSLookupResult* self, RygelBasicManagementTestNSLookupResult* dest) {
	RygelBasicManagementTestNSLookupProcessState _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	RygelBasicManagementTestNSLookupResultStatus _tmp7_ = 0;
	RygelBasicManagementTestNSLookupAnswerType _tmp8_ = 0;
	guint _tmp9_ = 0U;
	_tmp0_ = (*self).state;
	(*dest).state = _tmp0_;
	_tmp1_ = (*self).name_server_address;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name_server_address);
	(*dest).name_server_address = _tmp2_;
	_tmp3_ = (*self).returned_host_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).returned_host_name);
	(*dest).returned_host_name = _tmp4_;
	_tmp5_ = (*self).addresses;
	_tmp5__length1 = (*self).addresses_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup1 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	(*dest).addresses = (_vala_array_free ((*dest).addresses, (*dest).addresses_length1, (GDestroyNotify) g_free), NULL);
	(*dest).addresses = _tmp6_;
	(*dest).addresses_length1 = _tmp6__length1;
	(*dest)._addresses_size_ = (*dest).addresses_length1;
	_tmp7_ = (*self).status;
	(*dest).status = _tmp7_;
	_tmp8_ = (*self).answer_type;
	(*dest).answer_type = _tmp8_;
	_tmp9_ = (*self).execution_time;
	(*dest).execution_time = _tmp9_;
}


static void rygel_basic_management_test_ns_lookup_result_destroy (RygelBasicManagementTestNSLookupResult* self) {
	_g_free0 ((*self).name_server_address);
	_g_free0 ((*self).returned_host_name);
	(*self).addresses = (_vala_array_free ((*self).addresses, (*self).addresses_length1, (GDestroyNotify) g_free), NULL);
}


static RygelBasicManagementTestNSLookupResult* rygel_basic_management_test_ns_lookup_result_dup (const RygelBasicManagementTestNSLookupResult* self) {
	RygelBasicManagementTestNSLookupResult* dup;
	dup = g_new0 (RygelBasicManagementTestNSLookupResult, 1);
	rygel_basic_management_test_ns_lookup_result_copy (self, dup);
	return dup;
}


static void rygel_basic_management_test_ns_lookup_result_free (RygelBasicManagementTestNSLookupResult* self) {
	rygel_basic_management_test_ns_lookup_result_destroy (self);
	g_free (self);
}


static GType rygel_basic_management_test_ns_lookup_result_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_result_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_result_type_id__volatile)) {
		GType rygel_basic_management_test_ns_lookup_result_type_id;
		rygel_basic_management_test_ns_lookup_result_type_id = g_boxed_type_register_static ("RygelBasicManagementTestNSLookupResult", (GBoxedCopyFunc) rygel_basic_management_test_ns_lookup_result_dup, (GBoxedFreeFunc) rygel_basic_management_test_ns_lookup_result_free);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_result_type_id__volatile, rygel_basic_management_test_ns_lookup_result_type_id);
	}
	return rygel_basic_management_test_ns_lookup_result_type_id__volatile;
}


static void rygel_basic_management_test_ns_lookup_class_init (RygelBasicManagementTestNSLookupClass * klass) {
	rygel_basic_management_test_ns_lookup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelBasicManagementTestNSLookupPrivate));
	((GObjectClass *) klass)->constructed = rygel_basic_management_test_ns_lookup_real_constructed;
	((RygelBasicManagementTestClass *) klass)->init_iteration = rygel_basic_management_test_ns_lookup_real_init_iteration;
	((RygelBasicManagementTestClass *) klass)->finish_iteration = rygel_basic_management_test_ns_lookup_real_finish_iteration;
	((RygelBasicManagementTestClass *) klass)->handle_error = rygel_basic_management_test_ns_lookup_real_handle_error;
	((RygelBasicManagementTestClass *) klass)->handle_output = rygel_basic_management_test_ns_lookup_real_handle_output;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_method_type = rygel_basic_management_test_ns_lookup_real_get_method_type;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_results_type = rygel_basic_management_test_ns_lookup_real_get_results_type;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_ns_lookup_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_ns_lookup_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_ns_lookup_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME, g_param_spec_string ("host-name", "host-name", "host-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER, g_param_spec_string ("name-server", "name-server", "name-server", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT, g_param_spec_uint ("interval-time-out", "interval-time-out", "interval-time-out", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_INTERVAL_TIMEOUT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS, g_param_spec_uint ("repetitions", "repetitions", "repetitions", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_REPETITIONS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE, g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE, g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_basic_management_test_ns_lookup_instance_init (RygelBasicManagementTestNSLookup * self) {
	gchar* _tmp0_ = NULL;
	GTimer* _tmp1_ = NULL;
	self->priv = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_host_name = _tmp0_;
	self->priv->_name_server = NULL;
	_tmp1_ = g_timer_new ();
	self->priv->timer = _tmp1_;
}


static void rygel_basic_management_test_ns_lookup_finalize (GObject* obj) {
	RygelBasicManagementTestNSLookup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup);
	_g_free0 (self->priv->_host_name);
	_g_free0 (self->priv->_name_server);
	self->priv->results = (_vala_RygelBasicManagementTestNSLookupResult_array_free (self->priv->results, self->priv->results_length1), NULL);
	_g_free0 (self->priv->additional_info);
	_g_timer_destroy0 (self->priv->timer);
	G_OBJECT_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->finalize (obj);
}


GType rygel_basic_management_test_ns_lookup_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestNSLookupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_ns_lookup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTestNSLookup), 0, (GInstanceInitFunc) rygel_basic_management_test_ns_lookup_instance_init, NULL };
		GType rygel_basic_management_test_ns_lookup_type_id;
		rygel_basic_management_test_ns_lookup_type_id = g_type_register_static (RYGEL_TYPE_BASIC_MANAGEMENT_TEST, "RygelBasicManagementTestNSLookup", &g_define_type_info, 0);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_type_id__volatile, rygel_basic_management_test_ns_lookup_type_id);
	}
	return rygel_basic_management_test_ns_lookup_type_id__volatile;
}


static void _vala_rygel_basic_management_test_ns_lookup_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestNSLookup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME:
		g_value_set_string (value, rygel_basic_management_test_ns_lookup_get_host_name (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER:
		g_value_set_string (value, rygel_basic_management_test_ns_lookup_get_name_server (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT:
		g_value_set_uint (value, rygel_basic_management_test_ns_lookup_get_interval_time_out (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS:
		g_value_set_uint (value, rygel_basic_management_test_ns_lookup_get_repetitions (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE:
		g_value_set_string (value, rygel_basic_management_test_get_method_type ((RygelBasicManagementTest*) self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE:
		g_value_set_string (value, rygel_basic_management_test_get_results_type ((RygelBasicManagementTest*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_basic_management_test_ns_lookup_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestNSLookup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME:
		rygel_basic_management_test_ns_lookup_set_host_name (self, g_value_get_string (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER:
		rygel_basic_management_test_ns_lookup_set_name_server (self, g_value_get_string (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT:
		rygel_basic_management_test_ns_lookup_set_interval_time_out (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS:
		rygel_basic_management_test_ns_lookup_set_repetitions (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



