/* rygel-mpris-interfaces.c generated by valac 0.10.0, the Vala compiler
 * generated from rygel-mpris-interfaces.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <float.h>
#include <math.h>


#define RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY (rygel_mpris_media_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxy))
#define RYGEL_MPRIS_IS_MEDIA_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, RygelMPRISMediaPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerProxy RygelMPRISMediaPlayerProxy;
typedef struct _RygelMPRISMediaPlayerProxyIface RygelMPRISMediaPlayerProxyIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMPRISMediaPlayerProxyDBusProxy RygelMPRISMediaPlayerProxyDBusProxy;
typedef DBusGProxyClass RygelMPRISMediaPlayerProxyDBusProxyClass;

#define RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY (rygel_mpris_media_player_player_proxy_get_type ())
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxy))
#define RYGEL_MPRIS_MEDIA_PLAYER_IS_PLAYER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY))
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, RygelMPRISMediaPlayerPlayerProxyIface))

typedef struct _RygelMPRISMediaPlayerPlayerProxy RygelMPRISMediaPlayerPlayerProxy;
typedef struct _RygelMPRISMediaPlayerPlayerProxyIface RygelMPRISMediaPlayerPlayerProxyIface;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _RygelMPRISMediaPlayerPlayerProxyDBusProxy RygelMPRISMediaPlayerPlayerProxyDBusProxy;
typedef DBusGProxyClass RygelMPRISMediaPlayerPlayerProxyDBusProxyClass;

struct _RygelMPRISMediaPlayerProxyIface {
	GTypeInterface parent_iface;
	char* (*get_identity) (RygelMPRISMediaPlayerProxy* self);
	char** (*get_supported_uri_schemes) (RygelMPRISMediaPlayerProxy* self, int* result_length1);
	char** (*get_supported_mime_types) (RygelMPRISMediaPlayerProxy* self, int* result_length1);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _RygelMPRISMediaPlayerProxyDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelMPRISMediaPlayerPlayerProxyIface {
	GTypeInterface parent_iface;
	void (*pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play_pause) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*stop) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*play) (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
	void (*seek) (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
	void (*open_uri) (RygelMPRISMediaPlayerPlayerProxy* self, const char* uri, GError** error);
	char* (*get_playback_status) (RygelMPRISMediaPlayerPlayerProxy* self);
	double (*get_volume) (RygelMPRISMediaPlayerPlayerProxy* self);
	void (*set_volume) (RygelMPRISMediaPlayerPlayerProxy* self, double value);
	gint64 (*get_position) (RygelMPRISMediaPlayerPlayerProxy* self);
	GHashTable* (*get_metadata) (RygelMPRISMediaPlayerPlayerProxy* self);
};

struct _RygelMPRISMediaPlayerPlayerProxyDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};



GType rygel_mpris_media_player_proxy_get_type (void) G_GNUC_CONST;
RygelMPRISMediaPlayerProxy* rygel_mpris_media_player_proxy_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
#define RYGEL_MPRIS_MEDIA_PLAYER_PROXY_IFACE "org.mpris.MediaPlayer2"
char* rygel_mpris_media_player_proxy_get_identity (RygelMPRISMediaPlayerProxy* self);
char** rygel_mpris_media_player_proxy_get_supported_uri_schemes (RygelMPRISMediaPlayerProxy* self, int* result_length1);
char** rygel_mpris_media_player_proxy_get_supported_mime_types (RygelMPRISMediaPlayerProxy* self, int* result_length1);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void rygel_mpris_media_player_proxy_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_mpris_media_player_proxy_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_mpris_media_player_proxy_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_mpris_media_player_proxy_introspect (RygelMPRISMediaPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_proxy_property_get (RygelMPRISMediaPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_proxy_property_get_all (RygelMPRISMediaPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
GType rygel_mpris_media_player_proxy_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult rygel_mpris_media_player_proxy_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_MPRIS_MEDIA_PLAYER_PROXY_DBUS_PROXY_DUMMY_PROPERTY,
	RYGEL_MPRIS_MEDIA_PLAYER_PROXY_DBUS_PROXY_IDENTITY,
	RYGEL_MPRIS_MEDIA_PLAYER_PROXY_DBUS_PROXY_SUPPORTED_URI_SCHEMES,
	RYGEL_MPRIS_MEDIA_PLAYER_PROXY_DBUS_PROXY_SUPPORTED_MIME_TYPES
};
static char* rygel_mpris_media_player_proxy_dbus_proxy_get_identity (RygelMPRISMediaPlayerProxy* self);
static char** rygel_mpris_media_player_proxy_dbus_proxy_get_supported_uri_schemes (RygelMPRISMediaPlayerProxy* self, int* result_length1);
static char** rygel_mpris_media_player_proxy_dbus_proxy_get_supported_mime_types (RygelMPRISMediaPlayerProxy* self, int* result_length1);
static void rygel_mpris_media_player_proxy_dbus_proxy_rygel_mpris_media_player_proxy__interface_init (RygelMPRISMediaPlayerProxyIface* iface);
static void rygel_mpris_media_player_proxy_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_mpris_media_player_proxy_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
RygelMPRISMediaPlayerPlayerProxy* rygel_mpris_media_player_player_proxy_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType rygel_mpris_media_player_player_proxy_get_type (void) G_GNUC_CONST;
void rygel_mpris_media_player_player_proxy_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
void rygel_mpris_media_player_player_proxy_play_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
void rygel_mpris_media_player_player_proxy_stop (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
void rygel_mpris_media_player_player_proxy_play (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
void rygel_mpris_media_player_player_proxy_seek (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
void rygel_mpris_media_player_player_proxy_open_uri (RygelMPRISMediaPlayerPlayerProxy* self, const char* uri, GError** error);
#define RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_IFACE "org.mpris.MediaPlayer2.Player"
char* rygel_mpris_media_player_player_proxy_get_playback_status (RygelMPRISMediaPlayerPlayerProxy* self);
double rygel_mpris_media_player_player_proxy_get_volume (RygelMPRISMediaPlayerPlayerProxy* self);
void rygel_mpris_media_player_player_proxy_set_volume (RygelMPRISMediaPlayerPlayerProxy* self, double value);
gint64 rygel_mpris_media_player_player_proxy_get_position (RygelMPRISMediaPlayerPlayerProxy* self);
GHashTable* rygel_mpris_media_player_player_proxy_get_metadata (RygelMPRISMediaPlayerPlayerProxy* self);
void rygel_mpris_media_player_player_proxy_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_mpris_media_player_player_proxy_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_mpris_media_player_player_proxy_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_introspect (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_property_get (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_property_set (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_property_get_all (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_pause (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_play_pause (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_stop (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_play (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_seek (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_open_uri (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message);
GType rygel_mpris_media_player_player_proxy_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult rygel_mpris_media_player_player_proxy_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_DBUS_PROXY_DUMMY_PROPERTY,
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_DBUS_PROXY_PLAYBACK_STATUS,
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_DBUS_PROXY_VOLUME,
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_DBUS_PROXY_POSITION,
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_DBUS_PROXY_METADATA
};
static void rygel_mpris_media_player_player_proxy_dbus_proxy_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
static void rygel_mpris_media_player_player_proxy_dbus_proxy_play_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
static void rygel_mpris_media_player_player_proxy_dbus_proxy_stop (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
static void rygel_mpris_media_player_player_proxy_dbus_proxy_play (RygelMPRISMediaPlayerPlayerProxy* self, GError** error);
static void rygel_mpris_media_player_player_proxy_dbus_proxy_seek (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error);
static void rygel_mpris_media_player_player_proxy_dbus_proxy_open_uri (RygelMPRISMediaPlayerPlayerProxy* self, const char* uri, GError** error);
static char* rygel_mpris_media_player_player_proxy_dbus_proxy_get_playback_status (RygelMPRISMediaPlayerPlayerProxy* self);
static double rygel_mpris_media_player_player_proxy_dbus_proxy_get_volume (RygelMPRISMediaPlayerPlayerProxy* self);
static void rygel_mpris_media_player_player_proxy_dbus_proxy_set_volume (RygelMPRISMediaPlayerPlayerProxy* self, double value);
static gint64 rygel_mpris_media_player_player_proxy_dbus_proxy_get_position (RygelMPRISMediaPlayerPlayerProxy* self);
static GHashTable* rygel_mpris_media_player_player_proxy_dbus_proxy_get_metadata (RygelMPRISMediaPlayerPlayerProxy* self);
static void rygel_mpris_media_player_player_proxy_dbus_proxy_rygel_mpris_media_player_player_proxy__interface_init (RygelMPRISMediaPlayerPlayerProxyIface* iface);
static void rygel_mpris_media_player_player_proxy_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_mpris_media_player_player_proxy_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _rygel_mpris_media_player_proxy_dbus_path_vtable = {_rygel_mpris_media_player_proxy_dbus_unregister, rygel_mpris_media_player_proxy_dbus_message};
static const _DBusObjectVTable _rygel_mpris_media_player_proxy_dbus_vtable = {rygel_mpris_media_player_proxy_dbus_register_object};
static const DBusObjectPathVTable _rygel_mpris_media_player_player_proxy_dbus_path_vtable = {_rygel_mpris_media_player_player_proxy_dbus_unregister, rygel_mpris_media_player_player_proxy_dbus_message};
static const _DBusObjectVTable _rygel_mpris_media_player_player_proxy_dbus_vtable = {rygel_mpris_media_player_player_proxy_dbus_register_object};


char* rygel_mpris_media_player_proxy_get_identity (RygelMPRISMediaPlayerProxy* self) {
	return RYGEL_MPRIS_MEDIA_PLAYER_PROXY_GET_INTERFACE (self)->get_identity (self);
}


char** rygel_mpris_media_player_proxy_get_supported_uri_schemes (RygelMPRISMediaPlayerProxy* self, int* result_length1) {
	return RYGEL_MPRIS_MEDIA_PLAYER_PROXY_GET_INTERFACE (self)->get_supported_uri_schemes (self, result_length1);
}


char** rygel_mpris_media_player_proxy_get_supported_mime_types (RygelMPRISMediaPlayerProxy* self, int* result_length1) {
	return RYGEL_MPRIS_MEDIA_PLAYER_PROXY_GET_INTERFACE (self)->get_supported_mime_types (self, result_length1);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _rygel_mpris_media_player_proxy_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_proxy_introspect (RygelMPRISMediaPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.mpris.MediaPlayer2\">\n  <property name=\"Identity\" type=\"s\" access=\"read\"/>\n  <property name=\"SupportedUriSchemes\" type=\"as\" access=\"read\"/>\n  <property name=\"SupportedMimeTypes\" type=\"as\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_proxy_property_get (RygelMPRISMediaPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.mpris.MediaPlayer2") == 0) && (strcmp (property_name, "Identity") == 0)) {
		char* result;
		const char* _tmp2_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_mpris_media_player_proxy_get_identity (self);
		_tmp2_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp2_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.mpris.MediaPlayer2") == 0) && (strcmp (property_name, "SupportedUriSchemes") == 0)) {
		char** result;
		int result_length1;
		char** _tmp3_;
		DBusMessageIter _tmp4_;
		int _tmp5_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = rygel_mpris_media_player_proxy_get_supported_uri_schemes (self, &result_length1);
		_tmp3_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp4_);
		for (_tmp5_ = 0; _tmp5_ < result_length1; _tmp5_++) {
			const char* _tmp6_;
			_tmp6_ = *_tmp3_;
			dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp6_);
			_tmp3_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp4_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.mpris.MediaPlayer2") == 0) && (strcmp (property_name, "SupportedMimeTypes") == 0)) {
		char** result;
		int result_length1;
		char** _tmp7_;
		DBusMessageIter _tmp8_;
		int _tmp9_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = rygel_mpris_media_player_proxy_get_supported_mime_types (self, &result_length1);
		_tmp7_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp8_);
		for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
			const char* _tmp10_;
			_tmp10_ = *_tmp7_;
			dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_STRING, &_tmp10_);
			_tmp7_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp8_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_proxy_property_get_all (RygelMPRISMediaPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp11_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp11_);
	if (strcmp (interface_name, "org.mpris.MediaPlayer2") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp12_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Identity";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_mpris_media_player_proxy_get_identity (self);
			_tmp12_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp12_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp13_;
			DBusMessageIter _tmp14_;
			int _tmp15_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "SupportedUriSchemes";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = rygel_mpris_media_player_proxy_get_supported_uri_schemes (self, &result_length1);
			_tmp13_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp14_);
			for (_tmp15_ = 0; _tmp15_ < result_length1; _tmp15_++) {
				const char* _tmp16_;
				_tmp16_ = *_tmp13_;
				dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_STRING, &_tmp16_);
				_tmp13_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp14_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp17_;
			DBusMessageIter _tmp18_;
			int _tmp19_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "SupportedMimeTypes";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = rygel_mpris_media_player_proxy_get_supported_mime_types (self, &result_length1);
			_tmp17_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp18_);
			for (_tmp19_ = 0; _tmp19_ < result_length1; _tmp19_++) {
				const char* _tmp20_;
				_tmp20_ = *_tmp17_;
				dbus_message_iter_append_basic (&_tmp18_, DBUS_TYPE_STRING, &_tmp20_);
				_tmp17_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp18_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult rygel_mpris_media_player_proxy_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_mpris_media_player_proxy_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_rygel_mpris_media_player_proxy_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_mpris_media_player_proxy_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_mpris_media_player_proxy_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_mpris_media_player_proxy_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_mpris_media_player_proxy_base_init (RygelMPRISMediaPlayerProxyIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("identity", "identity", "identity", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("supported-uri-schemes", "supported-uri-schemes", "supported-uri-schemes", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("supported-mime-types", "supported-mime-types", "supported-mime-types", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_type_set_qdata (RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_mpris_media_player_proxy_dbus_vtable));
	}
}


GType rygel_mpris_media_player_proxy_get_type (void) {
	static volatile gsize rygel_mpris_media_player_proxy_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mpris_media_player_proxy_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISMediaPlayerProxyIface), (GBaseInitFunc) rygel_mpris_media_player_proxy_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_mpris_media_player_proxy_type_id;
		rygel_mpris_media_player_proxy_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelMPRISMediaPlayerProxy", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_mpris_media_player_proxy_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_mpris_media_player_proxy_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_mpris_media_player_proxy_dbus_proxy_get_type);
		g_once_init_leave (&rygel_mpris_media_player_proxy_type_id__volatile, rygel_mpris_media_player_proxy_type_id);
	}
	return rygel_mpris_media_player_proxy_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (RygelMPRISMediaPlayerProxyDBusProxy, rygel_mpris_media_player_proxy_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_MPRIS_TYPE_MEDIA_PLAYER_PROXY, rygel_mpris_media_player_proxy_dbus_proxy_rygel_mpris_media_player_proxy__interface_init) );
RygelMPRISMediaPlayerProxy* rygel_mpris_media_player_proxy_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelMPRISMediaPlayerProxy* self;
	self = g_object_new (rygel_mpris_media_player_proxy_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.mpris.MediaPlayer2", NULL);
	return self;
}


static GObject* rygel_mpris_media_player_proxy_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_mpris_media_player_proxy_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_mpris_media_player_proxy_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_mpris_media_player_proxy_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_mpris_media_player_proxy_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelMPRISMediaPlayerProxyDBusProxy*) self)->disposed) {
		return;
	}
	((RygelMPRISMediaPlayerProxyDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_mpris_media_player_proxy_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_mpris_media_player_proxy_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_mpris_media_player_proxy_dbus_proxy_class_init (RygelMPRISMediaPlayerProxyDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_mpris_media_player_proxy_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_mpris_media_player_proxy_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_mpris_media_player_proxy_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_mpris_media_player_proxy_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_MEDIA_PLAYER_PROXY_DBUS_PROXY_IDENTITY, "identity");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_MEDIA_PLAYER_PROXY_DBUS_PROXY_SUPPORTED_URI_SCHEMES, "supported-uri-schemes");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_MEDIA_PLAYER_PROXY_DBUS_PROXY_SUPPORTED_MIME_TYPES, "supported-mime-types");
}


static void rygel_mpris_media_player_proxy_dbus_proxy_init (RygelMPRISMediaPlayerProxyDBusProxy* self) {
}


static char* rygel_mpris_media_player_proxy_dbus_proxy_get_identity (RygelMPRISMediaPlayerProxy* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp0_;
	const char* _tmp1_;
	char* _result;
	const char* _tmp2_;
	if (((RygelMPRISMediaPlayerProxyDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp0_ = "org.mpris.MediaPlayer2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp0_);
	_tmp1_ = "Identity";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp1_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp2_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp2_);
	dbus_message_unref (_reply);
	return _result;
}


static char** rygel_mpris_media_player_proxy_dbus_proxy_get_supported_uri_schemes (RygelMPRISMediaPlayerProxy* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp3_;
	const char* _tmp4_;
	char** _result;
	int _result_length1;
	char** _tmp5_;
	int _tmp5__length;
	int _tmp5__size;
	int _tmp5__length1;
	DBusMessageIter _tmp6_;
	if (((RygelMPRISMediaPlayerProxyDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp3_ = "org.mpris.MediaPlayer2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp3_);
	_tmp4_ = "SupportedUriSchemes";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp4_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp5_ = g_new (char*, 5);
	_tmp5__length = 0;
	_tmp5__size = 4;
	_tmp5__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp6_);
	for (; dbus_message_iter_get_arg_type (&_tmp6_); _tmp5__length1++) {
		const char* _tmp7_;
		if (_tmp5__size == _tmp5__length) {
			_tmp5__size = 2 * _tmp5__size;
			_tmp5_ = g_renew (char*, _tmp5_, _tmp5__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp6_, &_tmp7_);
		dbus_message_iter_next (&_tmp6_);
		_tmp5_[_tmp5__length++] = g_strdup (_tmp7_);
	}
	_result_length1 = _tmp5__length1;
	_tmp5_[_tmp5__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp5_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** rygel_mpris_media_player_proxy_dbus_proxy_get_supported_mime_types (RygelMPRISMediaPlayerProxy* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp8_;
	const char* _tmp9_;
	char** _result;
	int _result_length1;
	char** _tmp10_;
	int _tmp10__length;
	int _tmp10__size;
	int _tmp10__length1;
	DBusMessageIter _tmp11_;
	if (((RygelMPRISMediaPlayerProxyDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp8_ = "org.mpris.MediaPlayer2";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp8_);
	_tmp9_ = "SupportedMimeTypes";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp9_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp10_ = g_new (char*, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp11_);
	for (; dbus_message_iter_get_arg_type (&_tmp11_); _tmp10__length1++) {
		const char* _tmp12_;
		if (_tmp10__size == _tmp10__length) {
			_tmp10__size = 2 * _tmp10__size;
			_tmp10_ = g_renew (char*, _tmp10_, _tmp10__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp11_, &_tmp12_);
		dbus_message_iter_next (&_tmp11_);
		_tmp10_[_tmp10__length++] = g_strdup (_tmp12_);
	}
	_result_length1 = _tmp10__length1;
	_tmp10_[_tmp10__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp10_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_mpris_media_player_proxy_dbus_proxy_rygel_mpris_media_player_proxy__interface_init (RygelMPRISMediaPlayerProxyIface* iface) {
	iface->get_identity = rygel_mpris_media_player_proxy_dbus_proxy_get_identity;
	iface->get_supported_uri_schemes = rygel_mpris_media_player_proxy_dbus_proxy_get_supported_uri_schemes;
	iface->get_supported_mime_types = rygel_mpris_media_player_proxy_dbus_proxy_get_supported_mime_types;
}


static void rygel_mpris_media_player_proxy_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_mpris_media_player_proxy_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void rygel_mpris_media_player_player_proxy_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error) {
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->pause (self, error);
}


void rygel_mpris_media_player_player_proxy_play_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error) {
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->play_pause (self, error);
}


void rygel_mpris_media_player_player_proxy_stop (RygelMPRISMediaPlayerPlayerProxy* self, GError** error) {
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->stop (self, error);
}


void rygel_mpris_media_player_player_proxy_play (RygelMPRISMediaPlayerPlayerProxy* self, GError** error) {
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->play (self, error);
}


void rygel_mpris_media_player_player_proxy_seek (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error) {
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->seek (self, offset, error);
}


void rygel_mpris_media_player_player_proxy_open_uri (RygelMPRISMediaPlayerPlayerProxy* self, const char* uri, GError** error) {
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->open_uri (self, uri, error);
}


char* rygel_mpris_media_player_player_proxy_get_playback_status (RygelMPRISMediaPlayerPlayerProxy* self) {
	return RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->get_playback_status (self);
}


double rygel_mpris_media_player_player_proxy_get_volume (RygelMPRISMediaPlayerPlayerProxy* self) {
	return RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->get_volume (self);
}


void rygel_mpris_media_player_player_proxy_set_volume (RygelMPRISMediaPlayerPlayerProxy* self, double value) {
	RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->set_volume (self, value);
}


gint64 rygel_mpris_media_player_player_proxy_get_position (RygelMPRISMediaPlayerPlayerProxy* self) {
	return RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->get_position (self);
}


GHashTable* rygel_mpris_media_player_player_proxy_get_metadata (RygelMPRISMediaPlayerPlayerProxy* self) {
	return RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_GET_INTERFACE (self)->get_metadata (self);
}


void _rygel_mpris_media_player_player_proxy_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_introspect (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.mpris.MediaPlayer2.Player\">\n  <method name=\"Pause\">\n  </method>\n  <method name=\"PlayPause\">\n  </method>\n  <method name=\"Stop\">\n  </method>\n  <method name=\"Play\">\n  </method>\n  <method name=\"Seek\">\n    <arg name=\"offset\" type=\"x\" direction=\"in\"/>\n  </method>\n  <method name=\"OpenUri\">\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n  </method>\n  <property name=\"PlaybackStatus\" type=\"s\" access=\"read\"/>\n  <property name=\"Volume\" type=\"d\" access=\"readwrite\"/>\n  <property name=\"Position\" type=\"x\" access=\"read\"/>\n  <property name=\"Metadata\" type=\"a{sv}\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_property_get (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.mpris.MediaPlayer2.Player") == 0) && (strcmp (property_name, "PlaybackStatus") == 0)) {
		char* result;
		const char* _tmp2_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = rygel_mpris_media_player_player_proxy_get_playback_status (self);
		_tmp2_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp2_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.mpris.MediaPlayer2.Player") == 0) && (strcmp (property_name, "Volume") == 0)) {
		double result;
		double _tmp3_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "d", &subiter);
		result = rygel_mpris_media_player_player_proxy_get_volume (self);
		_tmp3_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_DOUBLE, &_tmp3_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.mpris.MediaPlayer2.Player") == 0) && (strcmp (property_name, "Position") == 0)) {
		gint64 result;
		dbus_int64_t _tmp4_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "x", &subiter);
		result = rygel_mpris_media_player_player_proxy_get_position (self);
		_tmp4_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_INT64, &_tmp4_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.mpris.MediaPlayer2.Player") == 0) && (strcmp (property_name, "Metadata") == 0)) {
		GHashTable* result;
		DBusMessageIter _tmp5_, _tmp6_;
		GHashTableIter _tmp7_;
		gpointer _tmp8_, _tmp9_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "a{sv}", &subiter);
		result = rygel_mpris_media_player_player_proxy_get_metadata (self);
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "{sv}", &_tmp5_);
		g_hash_table_iter_init (&_tmp7_, result);
		while (g_hash_table_iter_next (&_tmp7_, &_tmp8_, &_tmp9_)) {
			char* _key;
			GValue* _value;
			const char* _tmp10_;
			DBusMessageIter _tmp11_;
			dbus_message_iter_open_container (&_tmp5_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp6_);
			_key = (char*) _tmp8_;
			_value = (GValue*) _tmp9_;
			_tmp10_ = _key;
			dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_STRING, &_tmp10_);
			if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
				guint8 _tmp12_;
				dbus_message_iter_open_container (&_tmp6_, DBUS_TYPE_VARIANT, "y", &_tmp11_);
				_tmp12_ = g_value_get_uchar (_value);
				dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_BYTE, &_tmp12_);
				dbus_message_iter_close_container (&_tmp6_, &_tmp11_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
				dbus_bool_t _tmp13_;
				dbus_message_iter_open_container (&_tmp6_, DBUS_TYPE_VARIANT, "b", &_tmp11_);
				_tmp13_ = g_value_get_boolean (_value);
				dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_BOOLEAN, &_tmp13_);
				dbus_message_iter_close_container (&_tmp6_, &_tmp11_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
				dbus_int32_t _tmp14_;
				dbus_message_iter_open_container (&_tmp6_, DBUS_TYPE_VARIANT, "i", &_tmp11_);
				_tmp14_ = g_value_get_int (_value);
				dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_INT32, &_tmp14_);
				dbus_message_iter_close_container (&_tmp6_, &_tmp11_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
				dbus_uint32_t _tmp15_;
				dbus_message_iter_open_container (&_tmp6_, DBUS_TYPE_VARIANT, "u", &_tmp11_);
				_tmp15_ = g_value_get_uint (_value);
				dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_UINT32, &_tmp15_);
				dbus_message_iter_close_container (&_tmp6_, &_tmp11_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
				dbus_int64_t _tmp16_;
				dbus_message_iter_open_container (&_tmp6_, DBUS_TYPE_VARIANT, "x", &_tmp11_);
				_tmp16_ = g_value_get_int64 (_value);
				dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_INT64, &_tmp16_);
				dbus_message_iter_close_container (&_tmp6_, &_tmp11_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
				dbus_uint64_t _tmp17_;
				dbus_message_iter_open_container (&_tmp6_, DBUS_TYPE_VARIANT, "t", &_tmp11_);
				_tmp17_ = g_value_get_uint64 (_value);
				dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_UINT64, &_tmp17_);
				dbus_message_iter_close_container (&_tmp6_, &_tmp11_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
				double _tmp18_;
				dbus_message_iter_open_container (&_tmp6_, DBUS_TYPE_VARIANT, "d", &_tmp11_);
				_tmp18_ = g_value_get_double (_value);
				dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_DOUBLE, &_tmp18_);
				dbus_message_iter_close_container (&_tmp6_, &_tmp11_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
				const char* _tmp19_;
				dbus_message_iter_open_container (&_tmp6_, DBUS_TYPE_VARIANT, "s", &_tmp11_);
				_tmp19_ = g_value_get_string (_value);
				dbus_message_iter_append_basic (&_tmp11_, DBUS_TYPE_STRING, &_tmp19_);
				dbus_message_iter_close_container (&_tmp6_, &_tmp11_);
			} else if (G_VALUE_TYPE (_value) == G_TYPE_STRV) {
				const char** _tmp20_;
				DBusMessageIter _tmp21_;
				int _tmp22_;
				dbus_message_iter_open_container (&_tmp6_, DBUS_TYPE_VARIANT, "as", &_tmp11_);
				_tmp20_ = g_value_get_boxed (_value);
				dbus_message_iter_open_container (&_tmp11_, DBUS_TYPE_ARRAY, "s", &_tmp21_);
				for (_tmp22_ = 0; _tmp22_ < g_strv_length (g_value_get_boxed (_value)); _tmp22_++) {
					const char* _tmp23_;
					_tmp23_ = *_tmp20_;
					dbus_message_iter_append_basic (&_tmp21_, DBUS_TYPE_STRING, &_tmp23_);
					_tmp20_++;
				}
				dbus_message_iter_close_container (&_tmp11_, &_tmp21_);
				dbus_message_iter_close_container (&_tmp6_, &_tmp11_);
			}
			dbus_message_iter_close_container (&_tmp5_, &_tmp6_);
		}
		dbus_message_iter_close_container (&subiter, &_tmp5_);
		_g_hash_table_unref0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_property_set (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, subiter;
	char* interface_name;
	const char* _tmp24_;
	char* property_name;
	const char* _tmp25_;
	if (strcmp (dbus_message_get_signature (message), "ssv")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp24_);
	dbus_message_iter_get_basic (&iter, &_tmp25_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp25_);
	dbus_message_iter_recurse (&iter, &subiter);
	if ((strcmp (interface_name, "org.mpris.MediaPlayer2.Player") == 0) && (strcmp (property_name, "Volume") == 0)) {
		double value;
		double _tmp26_;
		dbus_message_iter_get_basic (&subiter, &_tmp26_);
		dbus_message_iter_next (&subiter);
		value = _tmp26_;
		rygel_mpris_media_player_player_proxy_set_volume (self, value);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_property_get_all (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp27_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp27_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp27_);
	if (strcmp (interface_name, "org.mpris.MediaPlayer2.Player") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp28_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "PlaybackStatus";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = rygel_mpris_media_player_player_proxy_get_playback_status (self);
			_tmp28_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp28_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			double result;
			double _tmp29_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Volume";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "d", &value_iter);
			result = rygel_mpris_media_player_player_proxy_get_volume (self);
			_tmp29_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_DOUBLE, &_tmp29_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gint64 result;
			dbus_int64_t _tmp30_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Position";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "x", &value_iter);
			result = rygel_mpris_media_player_player_proxy_get_position (self);
			_tmp30_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_INT64, &_tmp30_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			GHashTable* result;
			DBusMessageIter _tmp31_, _tmp32_;
			GHashTableIter _tmp33_;
			gpointer _tmp34_, _tmp35_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Metadata";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "a{sv}", &value_iter);
			result = rygel_mpris_media_player_player_proxy_get_metadata (self);
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "{sv}", &_tmp31_);
			g_hash_table_iter_init (&_tmp33_, result);
			while (g_hash_table_iter_next (&_tmp33_, &_tmp34_, &_tmp35_)) {
				char* _key;
				GValue* _value;
				const char* _tmp36_;
				DBusMessageIter _tmp37_;
				dbus_message_iter_open_container (&_tmp31_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp32_);
				_key = (char*) _tmp34_;
				_value = (GValue*) _tmp35_;
				_tmp36_ = _key;
				dbus_message_iter_append_basic (&_tmp32_, DBUS_TYPE_STRING, &_tmp36_);
				if (G_VALUE_TYPE (_value) == G_TYPE_UCHAR) {
					guint8 _tmp38_;
					dbus_message_iter_open_container (&_tmp32_, DBUS_TYPE_VARIANT, "y", &_tmp37_);
					_tmp38_ = g_value_get_uchar (_value);
					dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_BYTE, &_tmp38_);
					dbus_message_iter_close_container (&_tmp32_, &_tmp37_);
				} else if (G_VALUE_TYPE (_value) == G_TYPE_BOOLEAN) {
					dbus_bool_t _tmp39_;
					dbus_message_iter_open_container (&_tmp32_, DBUS_TYPE_VARIANT, "b", &_tmp37_);
					_tmp39_ = g_value_get_boolean (_value);
					dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_BOOLEAN, &_tmp39_);
					dbus_message_iter_close_container (&_tmp32_, &_tmp37_);
				} else if (G_VALUE_TYPE (_value) == G_TYPE_INT) {
					dbus_int32_t _tmp40_;
					dbus_message_iter_open_container (&_tmp32_, DBUS_TYPE_VARIANT, "i", &_tmp37_);
					_tmp40_ = g_value_get_int (_value);
					dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_INT32, &_tmp40_);
					dbus_message_iter_close_container (&_tmp32_, &_tmp37_);
				} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT) {
					dbus_uint32_t _tmp41_;
					dbus_message_iter_open_container (&_tmp32_, DBUS_TYPE_VARIANT, "u", &_tmp37_);
					_tmp41_ = g_value_get_uint (_value);
					dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_UINT32, &_tmp41_);
					dbus_message_iter_close_container (&_tmp32_, &_tmp37_);
				} else if (G_VALUE_TYPE (_value) == G_TYPE_INT64) {
					dbus_int64_t _tmp42_;
					dbus_message_iter_open_container (&_tmp32_, DBUS_TYPE_VARIANT, "x", &_tmp37_);
					_tmp42_ = g_value_get_int64 (_value);
					dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_INT64, &_tmp42_);
					dbus_message_iter_close_container (&_tmp32_, &_tmp37_);
				} else if (G_VALUE_TYPE (_value) == G_TYPE_UINT64) {
					dbus_uint64_t _tmp43_;
					dbus_message_iter_open_container (&_tmp32_, DBUS_TYPE_VARIANT, "t", &_tmp37_);
					_tmp43_ = g_value_get_uint64 (_value);
					dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_UINT64, &_tmp43_);
					dbus_message_iter_close_container (&_tmp32_, &_tmp37_);
				} else if (G_VALUE_TYPE (_value) == G_TYPE_DOUBLE) {
					double _tmp44_;
					dbus_message_iter_open_container (&_tmp32_, DBUS_TYPE_VARIANT, "d", &_tmp37_);
					_tmp44_ = g_value_get_double (_value);
					dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_DOUBLE, &_tmp44_);
					dbus_message_iter_close_container (&_tmp32_, &_tmp37_);
				} else if (G_VALUE_TYPE (_value) == G_TYPE_STRING) {
					const char* _tmp45_;
					dbus_message_iter_open_container (&_tmp32_, DBUS_TYPE_VARIANT, "s", &_tmp37_);
					_tmp45_ = g_value_get_string (_value);
					dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_STRING, &_tmp45_);
					dbus_message_iter_close_container (&_tmp32_, &_tmp37_);
				} else if (G_VALUE_TYPE (_value) == G_TYPE_STRV) {
					const char** _tmp46_;
					DBusMessageIter _tmp47_;
					int _tmp48_;
					dbus_message_iter_open_container (&_tmp32_, DBUS_TYPE_VARIANT, "as", &_tmp37_);
					_tmp46_ = g_value_get_boxed (_value);
					dbus_message_iter_open_container (&_tmp37_, DBUS_TYPE_ARRAY, "s", &_tmp47_);
					for (_tmp48_ = 0; _tmp48_ < g_strv_length (g_value_get_boxed (_value)); _tmp48_++) {
						const char* _tmp49_;
						_tmp49_ = *_tmp46_;
						dbus_message_iter_append_basic (&_tmp47_, DBUS_TYPE_STRING, &_tmp49_);
						_tmp46_++;
					}
					dbus_message_iter_close_container (&_tmp37_, &_tmp47_);
					dbus_message_iter_close_container (&_tmp32_, &_tmp37_);
				}
				dbus_message_iter_close_container (&_tmp31_, &_tmp32_);
			}
			dbus_message_iter_close_container (&value_iter, &_tmp31_);
			_g_hash_table_unref0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_pause (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	rygel_mpris_media_player_player_proxy_pause (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_play_pause (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	rygel_mpris_media_player_player_proxy_play_pause (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_stop (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	rygel_mpris_media_player_player_proxy_stop (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_play (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	rygel_mpris_media_player_player_proxy_play (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_seek (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gint64 offset = 0LL;
	dbus_int64_t _tmp50_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "x")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp50_);
	dbus_message_iter_next (&iter);
	offset = _tmp50_;
	rygel_mpris_media_player_player_proxy_seek (self, offset, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_mpris_media_player_player_proxy_open_uri (RygelMPRISMediaPlayerPlayerProxy* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* uri = NULL;
	const char* _tmp51_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp51_);
	dbus_message_iter_next (&iter);
	uri = g_strdup (_tmp51_);
	rygel_mpris_media_player_player_proxy_open_uri (self, uri, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (uri);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult rygel_mpris_media_player_player_proxy_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Set")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_property_set (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.mpris.MediaPlayer2.Player", "Pause")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_pause (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.mpris.MediaPlayer2.Player", "PlayPause")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_play_pause (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.mpris.MediaPlayer2.Player", "Stop")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_stop (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.mpris.MediaPlayer2.Player", "Play")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_play (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.mpris.MediaPlayer2.Player", "Seek")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_seek (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.mpris.MediaPlayer2.Player", "OpenUri")) {
		result = _dbus_rygel_mpris_media_player_player_proxy_open_uri (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_mpris_media_player_player_proxy_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_mpris_media_player_player_proxy_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_mpris_media_player_player_proxy_base_init (RygelMPRISMediaPlayerPlayerProxyIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("playback-status", "playback-status", "playback-status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("metadata", "metadata", "metadata", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_type_set_qdata (RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_mpris_media_player_player_proxy_dbus_vtable));
	}
}


GType rygel_mpris_media_player_player_proxy_get_type (void) {
	static volatile gsize rygel_mpris_media_player_player_proxy_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mpris_media_player_player_proxy_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMPRISMediaPlayerPlayerProxyIface), (GBaseInitFunc) rygel_mpris_media_player_player_proxy_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_mpris_media_player_player_proxy_type_id;
		rygel_mpris_media_player_player_proxy_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelMPRISMediaPlayerPlayerProxy", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_mpris_media_player_player_proxy_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_mpris_media_player_player_proxy_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_mpris_media_player_player_proxy_dbus_proxy_get_type);
		g_once_init_leave (&rygel_mpris_media_player_player_proxy_type_id__volatile, rygel_mpris_media_player_player_proxy_type_id);
	}
	return rygel_mpris_media_player_player_proxy_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (RygelMPRISMediaPlayerPlayerProxyDBusProxy, rygel_mpris_media_player_player_proxy_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_MPRIS_MEDIA_PLAYER_TYPE_PLAYER_PROXY, rygel_mpris_media_player_player_proxy_dbus_proxy_rygel_mpris_media_player_player_proxy__interface_init) );
RygelMPRISMediaPlayerPlayerProxy* rygel_mpris_media_player_player_proxy_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelMPRISMediaPlayerPlayerProxy* self;
	self = g_object_new (rygel_mpris_media_player_player_proxy_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.mpris.MediaPlayer2.Player", NULL);
	return self;
}


static GObject* rygel_mpris_media_player_player_proxy_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_mpris_media_player_player_proxy_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_mpris_media_player_player_proxy_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_mpris_media_player_player_proxy_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		return;
	}
	((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_mpris_media_player_player_proxy_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_mpris_media_player_player_proxy_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_class_init (RygelMPRISMediaPlayerPlayerProxyDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_mpris_media_player_player_proxy_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_mpris_media_player_player_proxy_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_mpris_media_player_player_proxy_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_mpris_media_player_player_proxy_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_DBUS_PROXY_PLAYBACK_STATUS, "playback-status");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_DBUS_PROXY_VOLUME, "volume");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_DBUS_PROXY_POSITION, "position");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MPRIS_MEDIA_PLAYER_PLAYER_PROXY_DBUS_PROXY_METADATA, "metadata");
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_init (RygelMPRISMediaPlayerPlayerProxyDBusProxy* self) {
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.mpris.MediaPlayer2.Player", "Pause");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp13_;
			_edomain = DBUS_GERROR;
			_tmp13_ = _dbus_error.name + 27;
			if (strcmp (_tmp13_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp13_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp13_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp13_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp13_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp13_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp13_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp13_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp13_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp13_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp13_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp13_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp13_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp13_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp13_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp13_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp13_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp13_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp13_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp13_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp13_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp13_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp13_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp13_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp13_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp13_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp13_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp13_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp13_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp13_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp13_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp13_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp13_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_play_pause (RygelMPRISMediaPlayerPlayerProxy* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.mpris.MediaPlayer2.Player", "PlayPause");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp14_;
			_edomain = DBUS_GERROR;
			_tmp14_ = _dbus_error.name + 27;
			if (strcmp (_tmp14_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp14_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp14_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp14_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp14_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp14_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp14_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp14_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp14_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp14_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp14_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp14_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp14_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp14_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp14_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp14_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp14_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp14_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp14_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp14_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp14_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp14_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp14_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp14_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp14_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp14_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp14_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp14_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp14_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp14_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp14_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp14_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp14_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_stop (RygelMPRISMediaPlayerPlayerProxy* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.mpris.MediaPlayer2.Player", "Stop");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp15_;
			_edomain = DBUS_GERROR;
			_tmp15_ = _dbus_error.name + 27;
			if (strcmp (_tmp15_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp15_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp15_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp15_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp15_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp15_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp15_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp15_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp15_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp15_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp15_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp15_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp15_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp15_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp15_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp15_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp15_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp15_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp15_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp15_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp15_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp15_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp15_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp15_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp15_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp15_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp15_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp15_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp15_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp15_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp15_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp15_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp15_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_play (RygelMPRISMediaPlayerPlayerProxy* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.mpris.MediaPlayer2.Player", "Play");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp16_;
			_edomain = DBUS_GERROR;
			_tmp16_ = _dbus_error.name + 27;
			if (strcmp (_tmp16_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp16_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp16_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp16_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp16_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp16_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp16_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp16_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp16_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp16_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp16_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp16_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp16_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp16_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp16_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp16_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp16_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp16_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp16_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp16_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp16_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp16_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp16_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp16_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp16_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp16_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp16_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp16_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp16_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp16_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp16_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp16_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp16_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_seek (RygelMPRISMediaPlayerPlayerProxy* self, gint64 offset, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_int64_t _tmp17_;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.mpris.MediaPlayer2.Player", "Seek");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp17_ = offset;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT64, &_tmp17_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp18_;
			_edomain = DBUS_GERROR;
			_tmp18_ = _dbus_error.name + 27;
			if (strcmp (_tmp18_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp18_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp18_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp18_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp18_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp18_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp18_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp18_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp18_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp18_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp18_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp18_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp18_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp18_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp18_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp18_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp18_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp18_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp18_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp18_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp18_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp18_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp18_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp18_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp18_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp18_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp18_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp18_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp18_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp18_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp18_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp18_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp18_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_open_uri (RygelMPRISMediaPlayerPlayerProxy* self, const char* uri, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp19_;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.mpris.MediaPlayer2.Player", "OpenUri");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp19_ = uri;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp19_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp20_;
			_edomain = DBUS_GERROR;
			_tmp20_ = _dbus_error.name + 27;
			if (strcmp (_tmp20_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp20_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp20_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp20_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp20_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp20_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp20_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp20_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp20_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp20_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp20_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp20_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp20_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp20_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp20_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp20_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp20_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp20_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp20_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp20_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp20_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp20_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp20_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp20_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp20_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp20_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp20_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp20_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp20_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp20_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp20_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp20_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp20_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* rygel_mpris_media_player_player_proxy_dbus_proxy_get_playback_status (RygelMPRISMediaPlayerPlayerProxy* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp21_;
	const char* _tmp22_;
	char* _result;
	const char* _tmp23_;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp21_ = "org.mpris.MediaPlayer2.Player";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp21_);
	_tmp22_ = "PlaybackStatus";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp22_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp23_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp23_);
	dbus_message_unref (_reply);
	return _result;
}


static double rygel_mpris_media_player_player_proxy_dbus_proxy_get_volume (RygelMPRISMediaPlayerPlayerProxy* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp24_;
	const char* _tmp25_;
	double _result;
	double _tmp26_;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		return 0.0;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp24_ = "org.mpris.MediaPlayer2.Player";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp24_);
	_tmp25_ = "Volume";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp25_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0.0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0.0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "d")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "d", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0.0;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp26_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp26_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_set_volume (RygelMPRISMediaPlayerPlayerProxy* self, double value) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp27_;
	const char* _tmp28_;
	double _tmp29_;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Set");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp27_ = "org.mpris.MediaPlayer2.Player";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp27_);
	_tmp28_ = "Volume";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp28_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_VARIANT, "d", &_subiter);
	_tmp29_ = value;
	dbus_message_iter_append_basic (&_subiter, DBUS_TYPE_DOUBLE, &_tmp29_);
	dbus_message_iter_close_container (&_iter, &_subiter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gint64 rygel_mpris_media_player_player_proxy_dbus_proxy_get_position (RygelMPRISMediaPlayerPlayerProxy* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp30_;
	const char* _tmp31_;
	gint64 _result;
	dbus_int64_t _tmp32_;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		return 0LL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp30_ = "org.mpris.MediaPlayer2.Player";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp30_);
	_tmp31_ = "Position";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp31_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0LL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0LL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "x")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "x", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0LL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp32_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp32_;
	dbus_message_unref (_reply);
	return _result;
}


static GHashTable* rygel_mpris_media_player_player_proxy_dbus_proxy_get_metadata (RygelMPRISMediaPlayerPlayerProxy* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp33_;
	const char* _tmp34_;
	GHashTable* _result;
	GHashTable* _tmp35_;
	DBusMessageIter _tmp36_;
	DBusMessageIter _tmp37_;
	if (((RygelMPRISMediaPlayerPlayerProxyDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp33_ = "org.mpris.MediaPlayer2.Player";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp33_);
	_tmp34_ = "Metadata";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp34_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "a{sv}")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "a{sv}", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_tmp35_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	dbus_message_iter_recurse (&_subiter, &_tmp36_);
	while (dbus_message_iter_get_arg_type (&_tmp36_)) {
		char* _key;
		GValue* _value;
		const char* _tmp38_;
		GValue _tmp39_ = {0};
		DBusMessageIter _tmp40_;
		dbus_message_iter_recurse (&_tmp36_, &_tmp37_);
		dbus_message_iter_get_basic (&_tmp37_, &_tmp38_);
		dbus_message_iter_next (&_tmp37_);
		_key = g_strdup (_tmp38_);
		dbus_message_iter_recurse (&_tmp37_, &_tmp40_);
		if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_BYTE) {
			guint8 _tmp41_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp41_);
			g_value_init (&_tmp39_, G_TYPE_UCHAR);
			g_value_set_uchar (&_tmp39_, _tmp41_);
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_BOOLEAN) {
			dbus_bool_t _tmp42_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp42_);
			g_value_init (&_tmp39_, G_TYPE_BOOLEAN);
			g_value_set_boolean (&_tmp39_, _tmp42_);
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_INT16) {
			dbus_int16_t _tmp43_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp43_);
			g_value_init (&_tmp39_, G_TYPE_INT);
			g_value_set_int (&_tmp39_, _tmp43_);
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_UINT16) {
			dbus_uint16_t _tmp44_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp44_);
			g_value_init (&_tmp39_, G_TYPE_UINT);
			g_value_set_uint (&_tmp39_, _tmp44_);
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_INT32) {
			dbus_int32_t _tmp45_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp45_);
			g_value_init (&_tmp39_, G_TYPE_INT);
			g_value_set_int (&_tmp39_, _tmp45_);
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_UINT32) {
			dbus_uint32_t _tmp46_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp46_);
			g_value_init (&_tmp39_, G_TYPE_UINT);
			g_value_set_uint (&_tmp39_, _tmp46_);
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_INT64) {
			dbus_int64_t _tmp47_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp47_);
			g_value_init (&_tmp39_, G_TYPE_INT64);
			g_value_set_int64 (&_tmp39_, _tmp47_);
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_UINT64) {
			dbus_uint64_t _tmp48_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp48_);
			g_value_init (&_tmp39_, G_TYPE_UINT64);
			g_value_set_uint64 (&_tmp39_, _tmp48_);
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_DOUBLE) {
			double _tmp49_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp49_);
			g_value_init (&_tmp39_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp39_, _tmp49_);
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_STRING) {
			const char* _tmp50_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp50_);
			g_value_init (&_tmp39_, G_TYPE_STRING);
			g_value_take_string (&_tmp39_, g_strdup (_tmp50_));
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_OBJECT_PATH) {
			const char* _tmp51_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp51_);
			g_value_init (&_tmp39_, G_TYPE_STRING);
			g_value_take_string (&_tmp39_, g_strdup (_tmp51_));
		} else if (dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_SIGNATURE) {
			const char* _tmp52_;
			dbus_message_iter_get_basic (&_tmp40_, &_tmp52_);
			g_value_init (&_tmp39_, G_TYPE_STRING);
			g_value_take_string (&_tmp39_, g_strdup (_tmp52_));
		} else if ((dbus_message_iter_get_arg_type (&_tmp40_) == DBUS_TYPE_ARRAY) && (dbus_message_iter_get_element_type (&_tmp40_) == DBUS_TYPE_STRING)) {
			const char** _tmp53_;
			int _tmp53__length;
			int _tmp53__size;
			int _tmp53__length1;
			DBusMessageIter _tmp54_;
			_tmp53_ = g_new (const char*, 5);
			_tmp53__length = 0;
			_tmp53__size = 4;
			_tmp53__length1 = 0;
			dbus_message_iter_recurse (&_tmp40_, &_tmp54_);
			for (; dbus_message_iter_get_arg_type (&_tmp54_); _tmp53__length1++) {
				const char* _tmp55_;
				if (_tmp53__size == _tmp53__length) {
					_tmp53__size = 2 * _tmp53__size;
					_tmp53_ = g_renew (const char*, _tmp53_, _tmp53__size + 1);
				}
				dbus_message_iter_get_basic (&_tmp54_, &_tmp55_);
				dbus_message_iter_next (&_tmp54_);
				_tmp53_[_tmp53__length++] = g_strdup (_tmp55_);
			}
			_tmp53_[_tmp53__length] = NULL;
			g_value_init (&_tmp39_, G_TYPE_STRV);
			g_value_take_boxed (&_tmp39_, _tmp53_);
		}
		dbus_message_iter_next (&_tmp37_);
		_value = g_memdup (&_tmp39_, sizeof (GValue));
		g_hash_table_insert (_tmp35_, _key, _value);
		dbus_message_iter_next (&_tmp36_);
	}
	dbus_message_iter_next (&_subiter);
	_result = _tmp35_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_rygel_mpris_media_player_player_proxy__interface_init (RygelMPRISMediaPlayerPlayerProxyIface* iface) {
	iface->pause = rygel_mpris_media_player_player_proxy_dbus_proxy_pause;
	iface->play_pause = rygel_mpris_media_player_player_proxy_dbus_proxy_play_pause;
	iface->stop = rygel_mpris_media_player_player_proxy_dbus_proxy_stop;
	iface->play = rygel_mpris_media_player_player_proxy_dbus_proxy_play;
	iface->seek = rygel_mpris_media_player_player_proxy_dbus_proxy_seek;
	iface->open_uri = rygel_mpris_media_player_player_proxy_dbus_proxy_open_uri;
	iface->get_playback_status = rygel_mpris_media_player_player_proxy_dbus_proxy_get_playback_status;
	iface->get_volume = rygel_mpris_media_player_player_proxy_dbus_proxy_get_volume;
	iface->set_volume = rygel_mpris_media_player_player_proxy_dbus_proxy_set_volume;
	iface->get_position = rygel_mpris_media_player_player_proxy_dbus_proxy_get_position;
	iface->get_metadata = rygel_mpris_media_player_player_proxy_dbus_proxy_get_metadata;
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_mpris_media_player_player_proxy_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




