/*
 * s390-tools/zipl/include/procpart.h
 *   Scanner for the /proc/partitions file
 *
 * Copyright (C) 2003 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Author(s): Peter Oberparleiter <Peter.Oberparleiter@de.ibm.com>
 */

#ifndef PROC_PART_H
#define PROC_PART_H

#include "zipl.h"

#include <ctype.h>
#include <sys/types.h>


struct procpart_entry {
	dev_t device;
	size_t blockcount;
	char* name;
};


int procpart_get_entry(dev_t device, struct procpart_entry* entry);
void procpart_free_entry(struct procpart_entry* entry);

#endif /* not PROC_PART_H */
