/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Map;
import org.sablecc.sablecc.IntegerCast;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.ResolveProdTransformIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AAst;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AListTerm;
import org.sablecc.sablecc.node.ANewListTerm;
import org.sablecc.sablecc.node.ANewTerm;
import org.sablecc.sablecc.node.ANullTerm;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.AProdName;
import org.sablecc.sablecc.node.ASimpleListTerm;
import org.sablecc.sablecc.node.ASimpleTerm;
import org.sablecc.sablecc.node.PAlt;
import org.sablecc.sablecc.node.TId;

public class ComputeCGNomenclature
extends DepthFirstAdapter {
    private String currentProd;
    private String currentAlt;
    private int counter;
    private ResolveIds ids;
    private ResolveProdTransformIds prodTransformIds;
    private Map altElemTypes;
    private final Map altTransformElemTypes = new TypedHashMap(NodeCast.instance, StringCast.instance);
    private final Map termNumbers = new TypedHashMap(NodeCast.instance, IntegerCast.instance);

    public ComputeCGNomenclature(ResolveIds resolveIds, ResolveProdTransformIds resolveProdTransformIds) {
        this.ids = resolveIds;
        this.prodTransformIds = resolveProdTransformIds;
    }

    public void setAltElemTypes(Map map) {
        this.altElemTypes = map;
    }

    public Map getAltTransformElemTypes() {
        return this.altTransformElemTypes;
    }

    public Map getTermNumbers() {
        return this.termNumbers;
    }

    public void caseAProd(AProd aProd) {
        this.currentProd = "P" + ResolveIds.name(aProd.getId().getText());
        Object[] objectArray = aProd.getAlts().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((PAlt)objectArray[i]).apply(this);
        }
    }

    public void inAAlt(AAlt aAlt) {
        this.counter = 0;
        this.currentAlt = aAlt.getAltName() != null ? "A" + ResolveIds.name(aAlt.getAltName().getText()) + this.currentProd.substring(1) : "A" + this.currentProd.substring(1);
        this.counter = 0;
    }

    public void caseAAst(AAst aAst) {
    }

    public void inAElem(AElem aElem) {
        String string = (String)this.ids.elemTypes.get(aElem);
        if (aElem.getElemName() != null) {
            this.ids.altsElemNameTypes.put(this.currentAlt + "." + aElem.getElemName().getText(), string);
        }
    }

    public void inANewTerm(ANewTerm aNewTerm) {
        AProdName aProdName = (AProdName)aNewTerm.getProdName();
        String string = "P" + ResolveIds.name(aProdName.getId().getText());
        this.altTransformElemTypes.put(aNewTerm, string);
        this.termNumbers.put(aNewTerm, new Integer(++this.counter));
    }

    public void inANewListTerm(ANewListTerm aNewListTerm) {
        AProdName aProdName = (AProdName)aNewListTerm.getProdName();
        String string = "P" + ResolveIds.name(aProdName.getId().getText());
        this.altTransformElemTypes.put(aNewListTerm, string);
        this.termNumbers.put(aNewListTerm, new Integer(++this.counter));
    }

    public void outAListTerm(AListTerm aListTerm) {
        if (aListTerm.getListTerms().size() > 0) {
            Object[] objectArray = aListTerm.getListTerms().toArray();
            String string = (String)this.altTransformElemTypes.get(objectArray[0]);
            if (string != null) {
                if (!string.startsWith("L")) {
                    this.altTransformElemTypes.put(aListTerm, "L" + string);
                } else {
                    this.altTransformElemTypes.put(aListTerm, string);
                }
            }
        } else {
            this.altTransformElemTypes.put(aListTerm, "Lnull");
        }
        this.termNumbers.put(aListTerm, new Integer(++this.counter));
    }

    public void caseASimpleTerm(ASimpleTerm aSimpleTerm) {
        String string;
        String string2 = (String)this.altElemTypes.get(this.currentAlt + "." + aSimpleTerm.getId().getText());
        if (aSimpleTerm.getSimpleTermTail() == null) {
            string = string2;
            if (string.startsWith("P")) {
                aSimpleTerm.setSimpleTermTail((TId)aSimpleTerm.getId().clone());
            }
        } else {
            String string3 = aSimpleTerm.getSimpleTermTail().getText();
            string = (String)this.prodTransformIds.prodTransformElemTypesString.get(string2 + "." + string3);
        }
        if (string.endsWith("?")) {
            string = string.substring(0, string.length() - 1);
        }
        this.altTransformElemTypes.put(aSimpleTerm, string);
        this.termNumbers.put(aSimpleTerm, new Integer(++this.counter));
    }

    public void caseANullTerm(ANullTerm aNullTerm) {
        this.altTransformElemTypes.put(aNullTerm, "null");
        this.termNumbers.put(aNullTerm, new Integer(++this.counter));
    }

    public void caseASimpleListTerm(ASimpleListTerm aSimpleListTerm) {
        String string;
        String string2 = (String)this.altElemTypes.get(this.currentAlt + "." + aSimpleListTerm.getId().getText());
        if (aSimpleListTerm.getSimpleTermTail() == null) {
            string = string2;
            if (string.startsWith("P")) {
                aSimpleListTerm.setSimpleTermTail((TId)aSimpleListTerm.getId().clone());
            }
        } else {
            String string3 = aSimpleListTerm.getSimpleTermTail().getText();
            string = (String)this.prodTransformIds.prodTransformElemTypesString.get(string2 + "." + string3);
        }
        if (string.endsWith("?")) {
            string = string.substring(0, string.length() - 1);
        }
        this.altTransformElemTypes.put(aSimpleListTerm, string);
        this.termNumbers.put(aSimpleListTerm, new Integer(++this.counter));
    }
}

