/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AAltTransform;
import org.sablecc.sablecc.node.AAst;
import org.sablecc.sablecc.node.AAstAlt;
import org.sablecc.sablecc.node.AAstProd;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AListTerm;
import org.sablecc.sablecc.node.ANewListTerm;
import org.sablecc.sablecc.node.ANewTerm;
import org.sablecc.sablecc.node.ANullTerm;
import org.sablecc.sablecc.node.APlusUnOp;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.AProdName;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.ASimpleListTerm;
import org.sablecc.sablecc.node.ASimpleTerm;
import org.sablecc.sablecc.node.AStarUnOp;
import org.sablecc.sablecc.node.ATokenSpecifier;
import org.sablecc.sablecc.node.PAlt;
import org.sablecc.sablecc.node.PListTerm;
import org.sablecc.sablecc.node.PTerm;

public class PrettyPrinter
extends DepthFirstAdapter {
    public static String production_INDENT = "    ";
    public static String prod_transform_INDENT = "         ";
    public static String alternative_INDENT = "     ";
    public static String alt_transform_INDENT = "         ";

    public void caseAProductions(AProductions aProductions) {
        System.err.println("Productions \n");
        AProd[] aProdArray = aProductions.getProds().toArray(new AProd[0]);
        for (int i = 0; i < aProdArray.length; ++i) {
            aProdArray[i].apply(this);
        }
    }

    public void caseAProd(AProd aProd) {
        System.err.print(production_INDENT + aProd.getId().getText());
        String string = "=";
        if (aProd.getArrow() == null) {
            string = "";
            System.err.println(" = ");
        }
        System.err.println();
        AElem[] aElemArray = aProd.getProdTransform().toArray(new AElem[0]);
        if (aElemArray.length > 0) {
            System.err.print(prod_transform_INDENT + "{-> ");
            for (int i = 0; i < aElemArray.length; ++i) {
                aElemArray[i].apply(this);
                System.err.print(" ");
            }
            System.err.println(" } " + string);
        }
        Object[] objectArray = aProd.getAlts().toArray();
        for (int i = 0; i < objectArray.length - 1; ++i) {
            ((PAlt)objectArray[i]).apply(this);
            System.err.println(" |");
        }
        ((PAlt)objectArray[objectArray.length - 1]).apply(this);
        System.err.println("\n" + alternative_INDENT + ";\n");
    }

    public void caseAAlt(AAlt aAlt) {
        System.err.print("\n" + alternative_INDENT);
        if (aAlt.getAltName() != null) {
            System.err.print("{" + aAlt.getAltName().getText() + "} ");
        }
        AElem[] aElemArray = aAlt.getElems().toArray(new AElem[0]);
        for (int i = 0; i < aElemArray.length; ++i) {
            aElemArray[i].apply(this);
            System.err.print(" ");
        }
        if (aAlt.getAltTransform() != null) {
            aAlt.getAltTransform().apply(this);
        }
    }

    public void caseAAltTransform(AAltTransform aAltTransform) {
        System.err.print("\n" + alt_transform_INDENT + "{-> ");
        Object[] objectArray = aAltTransform.getTerms().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((PTerm)objectArray[i]).apply(this);
            System.err.print(" ");
        }
        System.err.print(" }  ");
    }

    public void caseAProdName(AProdName aProdName) {
        System.err.print(aProdName.getId().getText());
        if (aProdName.getProdNameTail() != null) {
            System.err.print("." + aProdName.getProdNameTail().getText());
        }
    }

    public void caseANewTerm(ANewTerm aNewTerm) {
        System.err.print("New ");
        aNewTerm.getProdName().apply(this);
        System.err.print(" (");
        Object[] objectArray = aNewTerm.getParams().toArray();
        if (objectArray.length > 0) {
            for (int i = 0; i < objectArray.length - 1; ++i) {
                ((PTerm)objectArray[i]).apply(this);
                System.err.print(", ");
            }
            ((PTerm)objectArray[objectArray.length - 1]).apply(this);
        }
        System.err.print(" )");
    }

    public void caseAListTerm(AListTerm aListTerm) {
        System.err.print("[ ");
        Object[] objectArray = aListTerm.getListTerms().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((PListTerm)objectArray[i]).apply(this);
        }
        System.err.print(" ]");
    }

    public void caseASimpleTerm(ASimpleTerm aSimpleTerm) {
        if (aSimpleTerm.getSpecifier() != null) {
            if (aSimpleTerm.getSpecifier() instanceof ATokenSpecifier) {
                System.err.print("T.");
            } else {
                System.err.print("P.");
            }
        }
        System.err.print(aSimpleTerm.getId().getText());
        if (aSimpleTerm.getSimpleTermTail() != null) {
            System.err.print("." + aSimpleTerm.getSimpleTermTail().getText());
        }
        System.err.print(" ");
    }

    public void caseANullTerm(ANullTerm aNullTerm) {
        System.err.print("Null ");
    }

    public void caseANewListTerm(ANewListTerm aNewListTerm) {
        System.err.print("New ");
        aNewListTerm.getProdName().apply(this);
        System.err.print(" (");
        Object[] objectArray = aNewListTerm.getParams().toArray();
        if (objectArray.length > 0) {
            for (int i = 0; i < objectArray.length - 1; ++i) {
                ((PTerm)objectArray[i]).apply(this);
                System.err.print(", ");
            }
            ((PTerm)objectArray[objectArray.length - 1]).apply(this);
        }
        System.err.print(" )");
    }

    public void caseASimpleListTerm(ASimpleListTerm aSimpleListTerm) {
        if (aSimpleListTerm.getSpecifier() != null) {
            if (aSimpleListTerm.getSpecifier() instanceof ATokenSpecifier) {
                System.err.print("T.");
            } else {
                System.err.print("P.");
            }
        }
        System.err.print(aSimpleListTerm.getId().getText());
        if (aSimpleListTerm.getSimpleTermTail() != null) {
            System.err.print("." + aSimpleListTerm.getSimpleTermTail().getText());
        }
        System.err.print(" ");
    }

    public void caseAAst(AAst aAst) {
        System.err.print("Abstract Syntax Tree\n");
        AAstProd[] aAstProdArray = aAst.getProds().toArray(new AAstProd[0]);
        for (int i = 0; i < aAstProdArray.length; ++i) {
            aAstProdArray[i].apply(this);
        }
    }

    public void caseAAstProd(AAstProd aAstProd) {
        System.err.println(production_INDENT + aAstProd.getId().getText() + " =");
        AAstAlt[] aAstAltArray = aAstProd.getAlts().toArray(new AAstAlt[0]);
        for (int i = 0; i < aAstAltArray.length - 1; ++i) {
            aAstAltArray[i].apply(this);
            System.err.println("| ");
        }
        aAstAltArray[aAstAltArray.length - 1].apply(this);
        System.err.println("\n" + alternative_INDENT + ";\n");
    }

    public void caseAAstAlt(AAstAlt aAstAlt) {
        System.err.print(alternative_INDENT);
        if (aAstAlt.getAltName() != null) {
            System.err.print("{" + aAstAlt.getAltName().getText() + "} ");
        }
        AElem[] aElemArray = aAstAlt.getElems().toArray(new AElem[0]);
        for (int i = 0; i < aElemArray.length; ++i) {
            aElemArray[i].apply(this);
            System.err.print(" ");
        }
    }

    public void caseAElem(AElem aElem) {
        if (aElem.getElemName() != null) {
            System.err.print("[" + aElem.getElemName().getText() + "]: ");
        }
        if (aElem.getSpecifier() != null) {
            if (aElem.getSpecifier() instanceof ATokenSpecifier) {
                System.err.print("T.");
            } else {
                System.err.print("P.");
            }
        }
        System.err.print(aElem.getId().getText());
        if (aElem.getUnOp() != null) {
            aElem.getUnOp().apply(new DepthFirstAdapter(){

                public void caseAStarUnOp(AStarUnOp aStarUnOp) {
                    System.err.print("*");
                }

                public void caseAQMarkUnOp(AQMarkUnOp aQMarkUnOp) {
                    System.err.print("?");
                }

                public void caseAPlusUnOp(APlusUnOp aPlusUnOp) {
                    System.err.print("+");
                }
            });
        }
    }
}

