/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : CamProfile.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/14
 *    Last                 : 2003/06/27
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "types.h"
#include "MemoryLeak.h"
#include "List_cam.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Select.h"
#include "global.h"
#include "Trace.h"
#include "Draw.h"
#include "sagcad.h"
#include "MsgBox.h"
#include "etc.h"

#define _CAMPROFILE_
#include "CamProfile.h"



/* -------------------------------------------------------------------
 *  (double) ǡؤ
 *	
 */
int Swap(double *a, double *b)
{
	double dumy;

	dumy = *a;
	*a = *b;
	*b = dumy;
	return 1;
}





/* -------------------------------------------------------------------
 * 쥯ȤƤǡ LIST  CAM ǡɤ߹
 *	
 * frag : ǽο޷θ
 *	   1 : 
 *	   2 : 
 */
int CamDataRead(int frag)
{
	SELECT_LIST *p;
	CAM cam;
	struct RtnDat LAH;


	if (select_list_info.head == NULL) return 0;
	/* ꥹȤ */
	cam_list_all_free();

	p = select_list_info.head;
	while (p != NULL) {
		/* ޷ǡ */
		if (p->select->index == 2 || p->select->index == 4) {
			/* ȱ߸̥ǡΤ (ȱߤ̵) */
			if (p->select->diagram_point.cad_point->code == 1 || p->select->diagram_point.cad_point->code == 2) {
				cam.code = p->select->diagram_point.cad_point->code;
				cam.gcode = p->select->diagram_point.cad_point->code;
				cam.sx = p->select->diagram_point.cad_point->sx;
				cam.sy = p->select->diagram_point.cad_point->sy;
				cam.ex = p->select->diagram_point.cad_point->ex;
				cam.ey = p->select->diagram_point.cad_point->ey;
				cam.cx = p->select->diagram_point.cad_point->cx;
				cam.cy = p->select->diagram_point.cad_point->cy;
				cam.r = p->select->diagram_point.cad_point->r;

				/* ߸̤ΤȤϡȤꤢϤΤޤޤ gcode = 3 */
				if (cam.gcode == 2 || cam.gcode == 4) {
					cam.gcode = 3;

					/* SA  */
					LAH.sx[1] = p->select->diagram_point.cad_point->cx;
					LAH.sy[1] = p->select->diagram_point.cad_point->cy;
					LAH.ex[1] = p->select->diagram_point.cad_point->sx;
					LAH.ey[1] = p->select->diagram_point.cad_point->sy;
					la(&LAH);
					cam.sa = LAH.angle;

					/* EA  */
					LAH.sx[1] = p->select->diagram_point.cad_point->cx;
					LAH.sy[1] = p->select->diagram_point.cad_point->cy;
					LAH.ex[1] = p->select->diagram_point.cad_point->ex;
					LAH.ey[1] = p->select->diagram_point.cad_point->ey;
					la(&LAH);
					cam.ea = LAH.angle;

					/* IA  */
					if (cam.sa < cam.ea) {
						cam.ia = cam.ea - cam.sa;
					}
					else {
						cam.ia = cam.ea + (360 - cam.sa);
					}
				}

				/* ǽΥǡθ(frag = 4) ΤȤ */
				if (frag == 4 && p == select_list_info.head) {
					/* ǡ */
					if (cam.gcode == 1){
						Swap(&cam.sx, &cam.ex);
						Swap(&cam.sy, &cam.ey);
					}
					/* ߸̥ǡ */
					else if (cam.gcode == 3){
						cam.gcode = 2;
						Swap(&cam.sx, &cam.ex);
						Swap(&cam.sy, &cam.ey);
						Swap(&cam.sa, &cam.ea);
						cam.ia = -1 * cam.ia;
					}
				}
				/* CAM Data ꥹȤκǸɲ */
				cam_list_add_last(&cam);
			}
		}

		/* ˡǡ */
		if (p->select->index == 3) {
			/* ̵ */
		}
		else {
			/* ̵ */
		}


		/* Υ쥯ȥǡ */
		p = p->next;
	}

	return 1;
}





/* -------------------------------------------------------------------
 * Hitohude
 *	
 * ǽΥǡϷƤ(ǽˤꡢƤ)
 *	
 *	
 * ǽΥǡĤʤäƤǡ¤٤롣
 *	
 * 1:ꤷǡνƱĥǡõ
 * 2:ǡĤäʤСꤷǡμ褦¤ؤ롣
 * 3:Ĥäǡʤ餽ΤޤޤɡʤСν򤹤롣
 *	   ʤСȽؤ롣
 *	   ߸̤ʤСȽϳѤȽλѡؤIA (-) ˤ롣
 * 4:ǡƤĤʤʤϡ顼Ȥ롣
 *	
 */
int Hitohude(int CamCheck)
{
	CAM_LIST *p_i, *p_j;
	CAM *cam_dumy;
	int K;
	char Txt[256];
	double DX, DY;



	/* Ͽ޷ơOK ɤγǧ */
	if (cam_list_info.head->cam->gcode == 1) {
		LineDraw (drawing_area, cam_list_info.head->cam->sx, cam_list_info.head->cam->sy, 
								cam_list_info.head->cam->ex, cam_list_info.head->cam->ey, 
								1, sagcad_color.Cam);
	}
	else if ( cam_list_info.head->cam->gcode == 3) {
		ArcDraw (drawing_area, cam_list_info.head->cam->cx, cam_list_info.head->cam->cy, cam_list_info.head->cam->r, 
							   cam_list_info.head->cam->sx, cam_list_info.head->cam->sy, 
							   cam_list_info.head->cam->ex, cam_list_info.head->cam->ey, 1, sagcad_color.Cam);
	}
	else if ( cam_list_info.head->cam->gcode == 2) {
		ArcDraw(drawing_area, cam_list_info.head->cam->cx, cam_list_info.head->cam->cy, cam_list_info.head->cam->r, 
							  cam_list_info.head->cam->ex, cam_list_info.head->cam->ey, 
							  cam_list_info.head->cam->sx, cam_list_info.head->cam->sy, 1, sagcad_color.Cam);
	}



	if (MsgBox("SagCAD", "CAM Check", _("Does it check a movement?") , "Yes", "No", NULL) == 1) {
		CamCheck = 1;
	}
	else {
		CamCheck = 0;
	}



	/* ǧ */
	if (CamCheck == 1) {
		MsgBox("SagCAD", "CAM", "Check OK ?", NULL, NULL, "OK");
	}

	/* ǡĤʤ齪 */
	if (cam_list_info.head->next == NULL) return 1;

	/* CAM DATA ǽ餫Ǹ1ޤ */
	p_i = cam_list_info.head;
	while (p_i->next != NULL) {
		/* ʤä ե饰 򤿤Ƥ */
		K = 0;

		/* CAM DATA  i μǸޤ */
		p_j = p_i->next;
		while (p_j != NULL) {
			/* ---------------------------------------------
			 * Ȱ
			 * 
			 * i ν j λ
			 */
//			if (	sg(p_i->cam->ex, compa_digits) == sg(p_j->cam->sx, compa_digits) 
//					&& 
//					sg(p_i->cam->ey, compa_digits) == sg(p_j->cam->sy, compa_digits)) {
			if (	(p_i->cam->ex + (1/pow(10, compa_digits)) > p_j->cam->sx) 
					&& 
					(p_i->cam->ex - (1/pow(10, compa_digits)) < p_j->cam->sx) 
					&& 
					(p_i->cam->ey + (1/pow(10, compa_digits)) > p_j->cam->sy) 
					&& 
					(p_i->cam->ey - (1/pow(10, compa_digits)) < p_j->cam->sy) )
			{
				/* ֤ؤ */
				/* CAM Data ΥꥹȤ¤Ӥִ */
				cam_dumy = p_i->next->cam;
				p_i->next->cam = p_j->cam;
				p_j->cam = cam_dumy;

				/* Ĥ޷οѤ */
				if (p_i->next->cam->gcode == 1) {
					LineDraw(drawing_area,	p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Back);
					LineDraw(drawing_area,	p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Cam);
					p_i->cam->code = 0;
					K = 1;
					break;
				}
				else if ( p_i->next->cam->gcode == 3) {
					ArcDraw(drawing_area,	p_i->next->cam->cx, p_i->next->cam->cy, 
											p_i->next->cam->r, 
											p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Back);
					ArcDraw(drawing_area,	p_i->next->cam->cx, p_i->next->cam->cy, 
											p_i->next->cam->r, 
											p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Cam);
					p_i->cam->code = 0;
					K = 1;
					break;
				}
			}



			/* ---------------------------------------------
			 * Ȱ
			 * 
			 * i ν j ν
			 * 
			 * ȰפϡIA ޥʥ G02 ˤʤ
			 *	   G02ˤʤ
			 *	   IA ޥʥˤʤ
			 *	   (sx,sy) Ƚ(ex,ey) ؤ
			 * G03->G02   IA->-IA	 sx,sy,-> ex,ey
			 * 
			 */
//			else if (	sg(p_i->cam->ex, 3) == sg(p_j->cam->ex, 3) 
//						&& 
//						sg(p_i->cam->ey, 3) == sg(p_j->cam->ey, 3)) {
			else if (	(p_i->cam->ex + (1/pow(10, compa_digits)) > p_j->cam->ex) 
						&& 
						(p_i->cam->ex - (1/pow(10, compa_digits)) < p_j->cam->ex) 
						&& 
						(p_i->cam->ey + (1/pow(10, compa_digits)) > p_j->cam->ey) 
						&& 
						(p_i->cam->ey - (1/pow(10, compa_digits)) < p_j->cam->ey) )
			{

				/* ֤ؤ */
				/* CAM Data ΥꥹȤ¤Ӥִ */
				cam_dumy = p_i->next->cam;
				p_i->next->cam = p_j->cam;
				p_j->cam = cam_dumy;

				Swap(&p_i->next->cam->sx, &p_i->next->cam->ex);
				Swap(&p_i->next->cam->sy, &p_i->next->cam->ey);
				Swap(&p_i->next->cam->sa, &p_i->next->cam->ea);
				p_i->next->cam->ia = -1 * (p_i->next->cam->ia);

				/* Ĥ޷οѤ */
				if (p_i->next->cam->gcode == 1) {
					LineDraw(drawing_area,	p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Back);
					LineDraw(drawing_area,	p_i->next->cam->sx, p_i->next->cam->sy, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											1, sagcad_color.Cam);
					p_i->cam->code = 0;
					K = 1;
					break;
				}
				else if ( p_i->next->cam->gcode == 3) {
					p_i->next->cam->gcode = 2;
					/* IA ʤ G02 */
					ArcDraw(drawing_area,	p_i->next->cam->cx, p_i->next->cam->cy, p_i->next->cam->r, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											p_i->next->cam->sx, p_i->next->cam->sy, 1, sagcad_color.Back);
					ArcDraw(drawing_area,	p_i->next->cam->cx, p_i->next->cam->cy, p_i->next->cam->r, 
											p_i->next->cam->ex, p_i->next->cam->ey, 
											p_i->next->cam->sx, p_i->next->cam->sy, 1, sagcad_color.Cam);
					p_i->cam->code = 0;
					K = 1;
					break;
				}
			}
			p_j = p_j->next;
		} /* <for j> */





		if (K == 0) {
			MsgBox("SagCAD", "CAM Check", _("Can't connect.") , NULL, NULL, "OK");
			return 0;
		}

		/* CamCheck  On ʤ11Ļߤ */
		if (CamCheck == 1) {
			MsgBox("SagCAD", "CAM Check", "Check OK ?", NULL, NULL, "OK");
			//MessageBox(NULL , "Check OK ?", (LPCSTR)"ã " , MB_OK);
		}
		UpDate();
	
		p_i = p_i->next;
	} /* <for i> */

	DX = sg(cam_list_info.tail->cam->ex - cam_list_info.head->cam->sx, 3);
	DY = sg(cam_list_info.tail->cam->ey - cam_list_info.head->cam->sy, 3);

	/* CamCheck  On ʤ11Ļߤ */
	if (CamCheck == 1) {
		sprintf(Txt, "DX = %f  DY = %f", DX, DY);
		MsgBox("SagCAD", _("Connected") , Txt, NULL, NULL, "OK");
	}
	return 1;
}





/* -------------------------------------------------------------------
 * NcOut
 * 
 * AbsInc
 *    0 : G90
 *    1 : G91
 * Heel
 *    0 : ɥߥ
 *    1 : ء G03+
 *    2 : ء G02+
 * Modal
 *    0 : ⡼
 *    1 : 
 * RIJ
 *    0 : R 
 *    1 : IJ 
 * 
 * NC Ѥι¤Τ褦
 */
int NcOut(CAM_ENV CamProperty)
{
	CAM_LIST *p;
	int modal_0 = 0;
//	int len, j;
	char command[256], path[256];

	double G91X = 0, G91Y = 0, G91C = 0;
	double x = 0, y = 0;
//	int i;
	char DumyStr[256], str[256], FileName[256];
	char XCode[256], YCode[256], NcCode[256], NcMode[256];
	char CCode[256], DCode[256], ECode[256], GK[256];
	FILE *stream;


	if ( strstr(sagcad_user.NcPath, "CADPATH") != NULL )
		sprintf(FileName, "%s/NoName.NC", sagcad_user.CadPath);
	else sprintf(FileName, "%s/NoName.NC", sagcad_user.NcPath);



	/* ե򥪡ץ */ 
	if((stream = fopen(FileName, "w")) == NULL) {
		g_print( _("The file could not be opened. [%s]\n") , FileName);
		//MessageBox(NULL, "ѥե뤬ޤǤ", (LPCSTR)"ERROR", MB_OK);
//		MessageBox(NULL, sagcad_user.CadPath, (LPCSTR)"sagcad_user.CadPath", MB_OK);
//		MessageBox(NULL, sagcad_user.NcPath, (LPCSTR)"sagcad_user.NcPath", MB_OK);
		return 0;
	}


	/* -----------------------------------------------------
	 * ƬԤե˽񤭹
	 */
	sprintf(str, "(SAGCAD OUTPUT NC FILE)\n");
	fputs(str, stream );

//sprintf(str, "(sagcad_digits.cam_digits = %d)\n", sagcad_digits.cam_digits);
//fputs(str, stream );

	if(CamProperty.AbsInc == 1)
		sprintf(str, "G91");
	else if( CamProperty.AbsInc == 0)
		sprintf(str, "G90");
	if(CamProperty.Heel == 0)
		strcat(str, " PROFILE MODE");
	else if( CamProperty.Heel == 1)
		strcat(str, " HEEL [G03 +] FOR FNC MODE");
	else if( CamProperty.Heel == 2)
		strcat(str, " HEEL [G02 +] FOR BN MODE");
	sprintf(NcMode, "(%s)\n", str);
	/* ե˽񤭹 */
	fputs(NcMode, stream );



	/* -----------------------------------------------------
	 * Ͼե˽񤭹
	 */
	if (CamProperty.StartStr[0] != '\0') {
#ifdef TEST
		len = strlen(CamProperty.StartStr);
		j = 0;
		for (i = 0 ; i < len ; i++) {
			if (CamProperty.StartStr[i] != '\r') {
				str[j] = CamProperty.StartStr[i];
				j++;
			}
		}
		str[j] = '\0';
#endif
		/* ե˽񤭹 */
		fputs(CamProperty.StartStr, stream );
	}





	/* -----------------------------------------------------
	 * CAM DATA ǽ餫Ǹޤ 
	 * 
	 */
	p = cam_list_info.head;
	while (p != NULL) {
		/* -------------------------------------------------
		 * G01 
		 * 
		 */
		if(p->cam->gcode == 1) {
			/* 󥯥Ȼ */
			if (CamProperty.AbsInc == 1) {
				x = sg(sg(p->cam->ex, sagcad_digits.cam_digits) - sg(p->cam->sx, sagcad_digits.cam_digits), sagcad_digits.cam_digits);
				y = sg(sg(p->cam->ey, sagcad_digits.cam_digits) - sg(p->cam->sy, sagcad_digits.cam_digits), sagcad_digits.cam_digits);
				G91X = sg((G91X + x), sagcad_digits.cam_digits);
				G91Y = sg((G91Y + y), sagcad_digits.cam_digits);
			}
			/* ֥塼Ȼ */
			if (CamProperty.AbsInc == 0) {
				x = sg(p->cam->ex, sagcad_digits.cam_digits);
				y = sg(p->cam->ey, sagcad_digits.cam_digits);
			}

			/* X Code */
			FloatOut_n(str, x, sagcad_digits.cam_digits, 1);
			sprintf(XCode, "X%s", str);
			/* Y Code */
			FloatOut_n(str, y, sagcad_digits.cam_digits, 1);
			sprintf(YCode, "Y%s", str);

			/* G01 Υ⡼ */
			sprintf(GK, "G01");
			if (p != cam_list_info.head && CamProperty.Modal == 1 && modal_0 == 1) {
				strcpy(GK, "");
			}

			/* G90 & G91 Υ⡼ */
			if (CamProperty.AbsInc == 1 && (p == cam_list_info.head || CamProperty.Modal == 0)) {
				strcat(GK, "G91");
			}
			if (CamProperty.AbsInc == 0 && (p == cam_list_info.head || CamProperty.Modal == 0)) {
				strcat(GK, "G90");
			}
			/* ե˽񤭹 */
			sprintf(NcCode, "%s%s%s\n", GK, XCode, YCode);
			fputs(NcCode, stream );
			
			modal_0 = 1;
		}





		/* -------------------------------------------------
		 * G02 & G03 
		 * 
		 */
		if (p->cam->gcode == 2 || p->cam->gcode == 3) {
			/* 󥯥Ȼ */
			if (CamProperty.AbsInc == 1) {
				x = sg(sg(p->cam->ex, sagcad_digits.cam_digits) - sg(p->cam->sx, sagcad_digits.cam_digits), sagcad_digits.cam_digits);
				y = sg(sg(p->cam->ey, sagcad_digits.cam_digits) - sg(p->cam->sy, sagcad_digits.cam_digits), sagcad_digits.cam_digits);
				G91X = sg((G91X + x), sagcad_digits.cam_digits);
				G91Y = sg((G91Y + y), sagcad_digits.cam_digits);
			}
			/* ֥塼Ȼ */
			if (CamProperty.AbsInc == 0) {
				x = sg(p->cam->ex, sagcad_digits.cam_digits);
				y = sg(p->cam->ey, sagcad_digits.cam_digits);
			}
			G91C = sg(G91C + p->cam->ia, sagcad_digits.cam_digits);
			/* X Code */
			FloatOut_n(str, x, sagcad_digits.cam_digits, 1);
			sprintf(XCode, "X%s", str);
			/* Y Code */
			FloatOut_n(str, y, sagcad_digits.cam_digits, 1);
			sprintf(YCode, "Y%s", str);

			/* C Code */
			if (CamProperty.Heel == 1) {
				FloatOut_n(str, p->cam->ia, sagcad_digits.cam_digits, 1);
				sprintf(CCode, "C%s", str);
			}
			else if (CamProperty.Heel == 2) {
				p->cam->ia = -1 * p->cam->ia;
				FloatOut_n(str, p->cam->ia, sagcad_digits.cam_digits, 1);
				sprintf(CCode, "C%s", str);
			}
			else if (CamProperty.Heel == 0) CCode[0] = '\0';

			/* NC(IJ) */
			if (CamProperty.RIJ == 1) {
				/* D Code (I) */
				FloatOut_n(str, p->cam->cx - p->cam->sx, sagcad_digits.cam_digits, 1);
				sprintf(DCode, "I%s", str);
				/* E Code (J) */
				FloatOut_n(str, p->cam->cy - p->cam->sy, sagcad_digits.cam_digits, 1);
				sprintf(ECode, "J%s", str);
			}

			/* NC(R) */
			if (CamProperty.RIJ == 0) {
				/* D Code (I) */
				FloatOut_n(str, p->cam->r, sagcad_digits.cam_digits, 1);
				if (p->cam->ia > 180 || p->cam->ia < -180) {
					sprintf(DCode, "R-%s", str);
				}
				else sprintf(DCode, "R%s", str);
				/* E Code (J) */
				ECode[0] = '\0';
			}


			/* [ G02 G03 NCOUT ] */
			if (p->cam->gcode == 3) 
				sprintf(GK, "G03");
			else if(p->cam->gcode == 2) 
				sprintf(GK, "G02");

			/* G02 & G03 Υ⡼ */
			if (p != cam_list_info.head && CamProperty.Modal == 1 && modal_0 == p->cam->gcode) 
				GK[0] = '\0';
			/* G90 & G91 Υ⡼ */
			if (CamProperty.AbsInc == 1 && (p == cam_list_info.head || CamProperty.Modal == 0)) 
				strcat(GK, "G91");
			else if(CamProperty.AbsInc == 0 && (p == cam_list_info.head || CamProperty.Modal == 0)) 
				strcat(GK, "G90");

			/* ե˽񤭹 */
			/* G02-X--Y--C--IR-J- */
			sprintf(NcCode, "%s%s%s%s%s%s\n", GK, XCode, YCode, DCode, ECode, CCode);
			fputs(NcCode, stream );

			modal_0 = p->cam->gcode;
		}
		p = p->next;
	}





	/* G90 ץबȽλƱɤΥå */
	if (CamProperty.AbsInc == 0) {
		/* ե˽񤭹 */
		FloatOut_n(str, cam_list_info.head->cam->sx, sagcad_digits.cam_digits, 1);
		FloatOut_n(DumyStr, cam_list_info.head->cam->sy, sagcad_digits.cam_digits, 1);
		sprintf(NcCode, "(START X%s Y%s)\n", str, DumyStr);
		fputs(NcCode, stream );

		/* ե˽񤭹 */
		FloatOut_n(str, cam_list_info.tail->cam->ex, sagcad_digits.cam_digits, 1);
		FloatOut_n(DumyStr, cam_list_info.tail->cam->ey, sagcad_digits.cam_digits, 1);
		sprintf(NcCode, "(END X%s Y%s)\n", str, DumyStr);
		fputs(NcCode, stream );

		if (sg(cam_list_info.tail->cam->ex - cam_list_info.head->cam->sx, sagcad_digits.cam_digits) != 0 
				|| sg(cam_list_info.tail->cam->ey - cam_list_info.head->cam->sy, sagcad_digits.cam_digits) != 0)
			/* ե˽񤭹 */
			fputs("(START-END NO RETURN)\n", stream );
		if (sg(cam_list_info.tail->cam->ex - cam_list_info.head->cam->sx, sagcad_digits.cam_digits) == 0 
				&& sg(cam_list_info.tail->cam->ey - cam_list_info.head->cam->sy, sagcad_digits.cam_digits) == 0)
			/* ե˽񤭹 */
			fputs("(START-END 0 RETURN OK)\n", stream );
	}


	/* G91 ץबȽλƱɤΥå */
	if (CamProperty.AbsInc == 1) {
		FloatOut_n(str, G91X, sagcad_digits.cam_digits, 1);
		FloatOut_n(DumyStr, G91Y, sagcad_digits.cam_digits, 1);
		sprintf(NcCode, "(START-END X%s Y%s)\n", str, DumyStr);
		fputs(NcCode, stream );

		if (sg(G91X, sagcad_digits.cam_digits) != 0 || sg(G91Y, sagcad_digits.cam_digits) != 0)
			fputs("(X-Y NO RETURN)\n", stream );
		if (sg(G91X, sagcad_digits.cam_digits) == 0 && sg(G91Y, sagcad_digits.cam_digits) == 0)
			fputs("(X-Y 0 RETURN OK)\n", stream );
	}

	/* Heel Mode  1 360٤ǽäƤ뤫å */
	if (CamProperty.Heel > 0) {
		/* Ϥ齪λޤǤγ */
		FloatOut_n(str, G91C, sagcad_digits.cam_digits, 1);
		sprintf(NcCode, "(1 CYCLE %s)\n", str);
		fputs(NcCode, stream );

		if (sg(G91C, sagcad_digits.cam_digits) != 360 && sg(G91C, sagcad_digits.cam_digits) != -360)
			fputs("(C-NOT 360 RETURN)\n", stream );
		if (sg(G91C, sagcad_digits.cam_digits) == 360 || sg(G91C, sagcad_digits.cam_digits) == -360)
			fputs("(C-360 RETURN OK)\n", stream );
	}


	/* -----------------------------------------------------
	 * λե˽񤭹
	 */
	if (CamProperty.EndStr[0] != '\0') {
#ifdef TEST
		len = strlen(CamProperty.EndStr);
		j =0;
		for (i=0 ; i<len ; i++) {
			if (CamProperty.EndStr[i] != '\r') {
				str[j] = CamProperty.EndStr[i];
				j++;
			}
		}
		str[j] = '\0';
#endif
		/* ե˽񤭹 */
		fputs(CamProperty.EndStr, stream );
	}

	/* ե򥯥 */ 
	fclose(stream);





	/* Editor command */
	strcpy(path, sagcad_user.editor_command);
	replace(path, "&", "");

	if (strstr(path, "%s") != NULL) {
		replace(path, "%s", FileName);
	}
//	else {
//		sprintf(path , "%s %s", sagcad_user.editor_command, FileName);
//	}

	sprintf(command, "%s &", path);
	g_print("%s\n", command);
	system(command);

	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : CamProfile.c
 * ====================================================================
 */
