/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Command.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/07
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <langinfo.h>
#include <iconv.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_insert.h"
#include "List_Ellipse.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"

#include "toolbar.h"
#include "Mouse.h"
#include "etc.h"
#include "Trace.h"
#include "Ellipse.h"
#include "sagcad.h"
#include "Draw.h"
#include "Select.h"
#include "InputBox.h"
#include "MsgBox.h"

#include "sgy.h"
#include "iges.h"
#include "DXF_read.h"
#include "DXF_write.h"
#include "NC_read.h"

#include "Dimension.h"
#include "B_spline.h"
#include "spline.h"
#include "fileselect.h"
#include "CopyFunc.h"
#include "CopyDlg.h"
#include "TurnDlg.h"
#include "ScalingDlg.h"
#include "GridCopyDlg.h"
#include "SnapDlg.h"
#include "TextEditDlg.h"
#include "LayerSet.h"
#include "EnvSetDlg.h"
#include "plcDlg.h"
#include "PrintSetDlg.h"
#include "CamSetDlg.h"
#include "EllipseSetDlg.h"

#include "about.h"
#include "PostScript.h"
#include "CulcInputDlg.h"
#include "OutsideProcess.h"

#define _COMMAND_
#include "Command.h"





/* -------------------------------------------------------------------
 * ƥ key 't' 
 */
void test(void)
{
	char str[256], command[256];
	char *envvalue;
	int Ret, lang, language = 0;


	iconv_t cd;
	char *inbuf, *outbuf, *inptr, *outptr;
	size_t inbyteleft, outbyteleft, ret;


	g_print("CODE is %s\n", nl_langinfo(CODESET));

	strcpy(str, " ë yutaka");

	inbuf = strdup(str);
	inbyteleft = strlen(inbuf);
	outbuf = malloc(inbyteleft * 4 + 1);
	outbyteleft = inbyteleft * 4;


	inbyteleft = strlen(inbuf)+1;


	if (!outbuf) {
		g_print("error in malloc\n");
	return;
	}

	outptr = outbuf;
	inptr = inbuf;

//	cd = iconv_open("UTF-16BE", nl_langinfo(CODESET));
	cd = iconv_open("UTF-16", nl_langinfo(CODESET));
	if ((iconv_t)(-1) == cd) {
		g_print("error in iconv_open\n");
	return;
	}

	ret = iconv(cd, &inptr, &inbyteleft, &outptr, &outbyteleft);
	g_print("ret = %d\n", ret);
	if ((size_t)(-1) != ret) {
		ret = iconv(cd, NULL, NULL, &outptr, &outbyteleft);
		g_print("ret = %d\n", ret);
	}

	g_print("outbuf = %s(%d)\n", outbuf, outbyteleft);
	g_print("[0x%x]  ", outbuf[0]);
	g_print("[0x%x]  ", outbuf[1]);
	g_print("[0x%x]  ", outbuf[2]);
	g_print("[0x%x]  ", outbuf[3]);
	g_print("[0x%x]  ", outbuf[4]);
	g_print("[0x%x]  ", outbuf[5]);
	g_print("[0x%x]  ", outbuf[6]);
	g_print("[0x%x]  ", outbuf[7]);
	g_print("[0x%x]  ", outbuf[8]);
	g_print("[0x%x]  ", outbuf[9]);
	g_print("[0x%x]  ", outbuf[10]);
	
	iconv_close(cd);
//	return;




	/* getenv */
	envvalue = getenv("LANGUAGE");
	if (envvalue != NULL) {
		language = 1;
		sprintf(command, "OLD LANGUAGE = %s", envvalue);
	}
	else {
		envvalue = getenv("LANG");
		if (envvalue != NULL) {
			language = 0;
			sprintf(command, "OLD LANG = %s", envvalue);
		}
		else {
			sprintf(command, "OLD LANG = No Setting");
		}
	}



	strcpy(str, "1");
	Ret = InputBox("locale set", command, "1:ja_JP.eucJP  2:C  3:de", str);
	if (Ret == 1) {
		lang = atoi(str);
		if (lang == 1) {
			strcpy(str, "ja_JP.eucJP");
		}
		else if (lang == 2) {
			strcpy(str, "C");
		}
		else if (lang == 3) {
			strcpy(str, "de_DE@euro");
		}
		else {
			strcpy(str, "C");
		}

		/* putenv */
		if (language  == 1) {
			sprintf(command, "LANG=%s", str);
		}
		else if (language  == 0) {
			sprintf(command, "LANGUAGE=%s", str);
		}
		else {
			return;
		}

		putenv(command);



		/* getenv */
		envvalue = getenv("LANGUAGE");
		if (envvalue != NULL) {
			MsgBox("SagCAD", "LANGUAGE", envvalue, NULL, NULL, "OK");
		}
		else {
			envvalue = getenv("LANG");
			if (envvalue != NULL) {
				language = 0;
				MsgBox("SagCAD", "LANG", envvalue, NULL, NULL, "OK");
			}
			else {
				MsgBox("SagCAD", "LANG", "No Setting", NULL, NULL, "OK");
			}
		}
	}
	return;
}



/* ---------------------------------------------------------
 *  (Outside Proces)
 * 
 */
void cmd_outside_process(void)
{
	os_process();
	return;
}



/* ---------------------------------------------------------
 * ʱߺ
 * 
 */
void cmd_Ellipse_Draw(void)
{
	ELLIPSE ellipse;
	ELLIPSE_SET_DLG ellipse_set_dlg;
	struct RtnDat PAPH;
//	char str[256];

	ellipse_set_dlg.value = 0;
	ellipse_set_dlg.cx = 0;
	ellipse_set_dlg.cy = 0;
	ellipse_set_dlg.long_r = 5;
	ellipse_set_dlg.k = 0.5;
	ellipse_set_dlg.angle = 0;
	ellipse_set_dlg.sa = 0;
	ellipse_set_dlg.ea = 360;

	ellipse_set_dlg.cx_entry = NULL;
	ellipse_set_dlg.cy_entry = NULL;
	ellipse_set_dlg.long_r_entry = NULL;
	ellipse_set_dlg.k_entry = NULL;
	ellipse_set_dlg.angle_entry = NULL;
	ellipse_set_dlg.sa_entry = NULL;
	ellipse_set_dlg.ea_entry = NULL;

	ellipse_set_dlg.parent = MainWindow;
	ellipse_set_dlg.dialog = NULL;


	EllipseSetDialog(&ellipse_set_dlg);

#ifdef TEST
	if (ellipse_set_dlg.value == 0) {
		g_print("Cancel ޤ\n");
	}
	else {
		g_print ("濴(%f,%f) L = %f   S = %f   angle = %f   sa = %f   ea = %f\n", 
				 ellipse_set_dlg.cx, 
				 ellipse_set_dlg.cy, 
				 ellipse_set_dlg.long_r, 
				 ellipse_set_dlg.k, 
				 ellipse_set_dlg.angle, 
				 ellipse_set_dlg.sa, 
				 ellipse_set_dlg.ea 
				);
	}
#endif

	ellipse.layer = NowLayer;
	ellipse.color = NowColor;
	ellipse.style = NowStyle;

	ellipse.cx = ellipse_set_dlg.cx;
	ellipse.cy = ellipse_set_dlg.cy;
	ellipse.k = ellipse_set_dlg.k;
	ellipse.sa = ellipse_set_dlg.sa;
	ellipse.ea = ellipse_set_dlg.ea;

	/* -------------------------------------------------------------------
	 * pap : [6] ȳ٤ȵΥľν
	 */
	PAPH.sx[1] = ellipse_set_dlg.cx;
	PAPH.sy[1] = ellipse_set_dlg.cy;
	PAPH.angle = ellipse_set_dlg.angle;
	PAPH.l = ellipse_set_dlg.long_r;
	pap(&PAPH);
	ellipse.dx = PAPH.ex[1] - ellipse_set_dlg.cx;
	ellipse.dy = PAPH.ey[1] - ellipse_set_dlg.cy;

	undo_index_plus();
	ellipse_list_add_first_with_undo(&ellipse, &ellipse_list_info);
	EllipseDraw(drawing_area, &ellipse, SCD_ORG);
	UpDate();




	return;
}



/* ---------------------------------------------------------
 * 
 * 
 */
void cmd_print_set(void)
{
	PRINTSET_DLG printset_dlg;


	printset_dlg.value = 0;
	printset_dlg.view = printer.Draw_View;
	printset_dlg.paper = printer.Paper;
	printset_dlg.orientation = printer.Orientation;
	printset_dlg.up_scale = printer.up_scale;
	printset_dlg.low_scale = printer.low_scale;

	printset_dlg.toggle_frag = 0;

	printset_dlg.display_check = NULL;
	printset_dlg.drawing_check = NULL;
	printset_dlg.up_scale_entry = NULL;
	printset_dlg.low_scale_entry = NULL;
	printset_dlg.A4_check = NULL;
	printset_dlg.A3_check = NULL;
	printset_dlg.B5_check = NULL;
	printset_dlg.B4_check = NULL;
	printset_dlg.portrait_check = NULL;
	printset_dlg.landscape_check = NULL;

	printset_dlg.parent = MainWindow;
	printset_dlg.dialog = NULL;


	PrintSetDialog(&printset_dlg);


	if (printset_dlg.value != 0) {
		printer.Paper = printset_dlg.paper;
		printer.Orientation = printset_dlg.orientation;
		printer.Draw_View = printset_dlg.view;
		printer.up_scale = printset_dlg.up_scale;
		printer.low_scale = printset_dlg.low_scale;
		printer.scale = printer.up_scale / printer.low_scale;
		
		Redraw();
	}
	if (printset_dlg.value == 2) {
		keep_printer = printer;
		ConfigWrite();
	}
}



/* ---------------------------------------------------------
 *  (ID_PRINT)
 *	
 */
void cmd_print(void)
{
	char str[256], command[256], path[256];
//	int ps = 1, 
	int Ret;

#ifdef TEST
	Ret = MsgBox("ps or eps", "ps File Ǥ", "Ȥ eps FileǤ", "ps", "eps", "CANCEL");
	
	/* ps */
	if (Ret == 1) {
		strcpy(str, "NoName.ps");
		ps = 1;
	}
	/* eps */
	else if (Ret == 0) {
		strcpy(str, "NoName.eps");
		ps = 0;
	}
	/* CANCEL */
	else {
		return;
	}
#endif



	sprintf(str, "%s/NoName.ps", sagcad_user.CadPath);
	Ret = save_file_name_get(str);
	/* ե򥭥󥻥 */
	if (Ret == 0 || str == NULL) {
		//g_print("save_file : str = NULL\n");
		return;
	}
	if (Ret == 1 && str != NULL){
		PostScript(str);
	}



	/* Editor command */
	strcpy(path, sagcad_user.print_command);
	replace(path, "&", "");

	if (strstr(path, "%s") != NULL) {
		replace(path, "%s", str);
	}
//	else {
//		sprintf(path , "%s %s", sagcad_user.editor_command, FileName);
//	}

	sprintf(command, "%s &", path);
	g_print("%s\n", command);
	system(command);


#ifdef OLD
	sprintf(command,  _("The file saved. [%s]\n") , str);
	Ret = MsgBox(" / GhostView", command,  _("Which does it execute?") , "GhostView",  _("Print") , "λ");

	/* GhostView */
	if (Ret == 1) {
		sprintf(command, "ghostview %s &", str);
		system(command);
	}
	/*  */
	else if (Ret == 0) {
		sprintf(command, "lpr %s &", str);
		system(command);
	}
#endif

	return;
}



/* -------------------------------------------------------------------
 * Ϣ³
 */
void cmd_polyline(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_PolyLine;
	select_list_all_free();
	DcObj = 15;
	mode = 255;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 쥤䡼
 */
void cmd_LayerSet(void)
{
	LAYERSET_DLG layerset_dlg;
	int i;

	layerset_dlg.value = 0;
	layerset_dlg.layerNo = 0;
	layerset_dlg.entry = NULL;
	for (i=0;i<256;i++) {
		layerset_dlg.Layer_widget[i] = NULL;
	}
	layerset_dlg.parent = MainWindow;
	layerset_dlg.dialog = NULL;

	LayerSetDialog(&layerset_dlg);

	return;
}



/* -------------------------------------------------------------------
 * Help ɽ
 */
void cmd_help(void)
{
	FILE *stream;
	char str[256], path[256], BrowserPath[256];

	char *envvalue, str_locale[256];

	/* ja_JP.eucJP */
	envvalue = getenv("LANGUAGE");
	if (envvalue == NULL) {
		envvalue = getenv("LANG");
	}

	if (envvalue != NULL) {
		/* japanese */
		if (strstr(envvalue, "ja_JP.eucJP") != NULL) {
			strcpy(str_locale, "ja");
		}
		else if (strstr(envvalue, "ja") != NULL) {
			strcpy(str_locale, "ja");
		}
		/* German */
		else if (strstr(envvalue, "de_DE@euro") != NULL) {
			strcpy(str_locale, "de");
		}
		else if (strstr(envvalue, "de") != NULL) {
			strcpy(str_locale, "de");
		}
#ifdef AFTER
		/* english */
		else if (strstr(envvalue, "en") != NULL) {
			strcpy(str_locale, "en");
		}
		else if (strstr(envvalue, "cs") != NULL) {
			strcpy(str_locale, "cs");
		}
		else if (strstr(envvalue, "da") != NULL) {
			strcpy(str_locale, "da");
		}
		else if (strstr(envvalue, "el") != NULL) {
			strcpy(str_locale, "el");
		}
		else if (strstr(envvalue, "es") != NULL) {
			strcpy(str_locale, "es");
		}
		else if (strstr(envvalue, "et") != NULL) {
			strcpy(str_locale, "et");
		}
		else if (strstr(envvalue, "fr") != NULL) {
			strcpy(str_locale, "fr");
		}
		else if (strstr(envvalue, "gl") != NULL) {
			strcpy(str_locale, "gl");
		}
		else if (strstr(envvalue, "hr") != NULL) {
			strcpy(str_locale, "hr");
		}
		else if (strstr(envvalue, "hu") != NULL) {
			strcpy(str_locale, "hu");
		}
		else if (strstr(envvalue, "it") != NULL) {
			strcpy(str_locale, "it");
		}
		else if (strstr(envvalue, "ko") != NULL) {
			strcpy(str_locale, "ko");
		}
		else if (strstr(envvalue, "nl") != NULL) {
			strcpy(str_locale, "nl");
		}
		else if (strstr(envvalue, "pl") != NULL) {
			strcpy(str_locale, "pl");
		}
		else if (strstr(envvalue, "pt_BR") != NULL) {
			strcpy(str_locale, "pt_BR");
		}
		else if (strstr(envvalue, "ro") != NULL) {
			strcpy(str_locale, "ro");
		}
		else if (strstr(envvalue, "ru") != NULL) {
			strcpy(str_locale, "ru");
		}
		else if (strstr(envvalue, "sk") != NULL) {
			strcpy(str_locale, "sk");
		}
		else if (strstr(envvalue, "sl") != NULL) {
			strcpy(str_locale, "sl");
		}
		else if (strstr(envvalue, "sr") != NULL) {
			strcpy(str_locale, "sr");
		}
		else if (strstr(envvalue, "sv") != NULL) {
			strcpy(str_locale, "sv");
		}
		else if (strstr(envvalue, "tr") != NULL) {
			strcpy(str_locale, "tr");
		}
		else if (strstr(envvalue, "zh_CN") != NULL) {
			strcpy(str_locale, "zh_CN");
		}
		else if (strstr(envvalue, "zh_TW.Big5") != NULL) {
			strcpy(str_locale, "zh_TW.Big5");
		}
#endif

		else {
			strcpy(str_locale, "ja");
		}
	}
	else {
		strcpy(str_locale, "ja");
	}

	/* إץեѥǧ */
	strcpy(path, DOCDIR);
	sprintf(str, "%s/%s/index.html", path, str_locale);
	if ( (stream  = fopen( str, "r" )) == NULL ) {
		//g_print("إץե [ %s ] ʤ\n", str);
		MsgBox("SagCAD", _("Can't Find Help File.") , str, "OK", NULL, NULL);
		return;
	}
	fclose(stream);


	strcpy(path, sagcad_user.browser_command);
	replace(path, "&", "");

	if (strstr(path, "%s") != NULL) {
		replace(path, "%s", str);
	}
	else {
		sprintf(path , "%s %s", sagcad_user.browser_command, str);
	}

	sprintf(BrowserPath, "%s &", path);
	g_print("%s\n", BrowserPath);
	if ( system(BrowserPath) ) {
		MsgBox("SagCAD", _("Can't Open Browser.") , _("The path setting will be how.") , "OK", NULL, NULL);
	}
}



/* ---------------------------------------------------------
 * Ķ
 */
void cmd_env_set(void)
{
	ENVSET_DLG envset_dlg;
	int i;


	envset_dlg.Value = 0;	// 0:CANCEL  1:OK
	
	/* User */
	strcpy(envset_dlg.user_name, sagcad_user.UserName);
	strcpy(envset_dlg.user_company, sagcad_user.CompanyName);

	envset_dlg.entry_user_name = NULL;
	envset_dlg.entry_user_company = NULL;


	/* Path */
	strcpy(envset_dlg.KeepCadPath, sagcad_user.KeepCadPath);
	strcpy(envset_dlg.NcPath, sagcad_user.NcPath);
//	strcpy(envset_dlg.BrowserPath, sagcad_user.BrowserPath);

	envset_dlg.entry_cad_path = NULL;
	envset_dlg.entry_nc_path = NULL;
	envset_dlg.entry_browser_path = NULL;


	/* Command */
	strcpy(envset_dlg.print_command, sagcad_user.print_command);
	strcpy(envset_dlg.editor_command, sagcad_user.editor_command);
	strcpy(envset_dlg.browser_command, sagcad_user.browser_command);

	envset_dlg.entry_p_command = NULL;
	envset_dlg.entry_e_command = NULL;
	envset_dlg.entry_b_command = NULL;


	/* System */
	envset_dlg.system_WinMode = sagcad_system.WinMode;
	envset_dlg.system_win_x_pos = sagcad_system.win_x_pos;
	envset_dlg.system_win_y_pos = sagcad_system.win_y_pos;
	envset_dlg.system_win_width = sagcad_system.win_width;
	envset_dlg.system_win_height = sagcad_system.win_height;
	envset_dlg.system_Search = sagcad_system.Search;
	envset_dlg.system_Wait = sagcad_system.Wait;
//	envset_dlg.system_MaxLayer = sagcad_system.MaxLayer;
	envset_dlg.system_Splits = sagcad_system.Splits;
	envset_dlg.system_ZoomMag = sagcad_system.ZoomMag;
	envset_dlg.system_ViewX = sagcad_system.ViewX;
	envset_dlg.system_FilletRC = sagcad_system.FilletRC;
	envset_dlg.system_Length = sagcad_system.Length;

	envset_dlg.entry_system_WinMode = NULL;
	envset_dlg.entry_system_win_x_pos = NULL;
	envset_dlg.entry_system_win_y_pos = NULL;
	envset_dlg.entry_system_win_width = NULL;
	envset_dlg.entry_system_win_height = NULL;
	envset_dlg.entry_system_Search = NULL;
	envset_dlg.entry_system_Wait = NULL;
//	envset_dlg.entry_system_MaxLayer = NULL;
	envset_dlg.entry_system_Splits = NULL;
	envset_dlg.entry_system_ZoomMag = NULL;
	envset_dlg.entry_system_ViewX = NULL;
	envset_dlg.entry_system_FilletRC = NULL;
	envset_dlg.entry_system_Length = NULL;


	/* Dimension */
	envset_dlg.dimension_FontHeight = sagcad_dimension.Font_height;
	envset_dlg.dimension_FontLetterSpace = sagcad_dimension.Font_space;
	envset_dlg.dimension_FontWordSpace = sagcad_dimension.Word_space;
	envset_dlg.dimension_FontOverLineLength = sagcad_dimension.Font_space_line;
	strcpy(envset_dlg.dimension_Font1, sagcad_dimension.font_file);
	strcpy(envset_dlg.dimension_Font2, sagcad_dimension.font_file2);
	envset_dlg.dimension_DimensionArrowLength = sagcad_dimension.arrow_length;
	envset_dlg.dimension_DimensionArrowAngle = sagcad_dimension.arrow_angle;
	envset_dlg.dimension_DimensionOverArrowLength = sagcad_dimension.arrow_line_extension;
	envset_dlg.dimension_DimensionOverLength = sagcad_dimension.assistance_line_extension;
	envset_dlg.dimension_DimensionUnderLength = sagcad_dimension.assistance_line_space;

	envset_dlg.entry_dimension_FontHeight = NULL;
	envset_dlg.entry_dimension_FontLetterSpace = NULL;
	envset_dlg.entry_dimension_FontWordSpace = NULL;
	envset_dlg.entry_dimension_FontOverLineLength = NULL;
	envset_dlg.entry_dimension_Font1 = NULL;
	envset_dlg.entry_dimension_Font2 = NULL;
	envset_dlg.entry_dimension_DimensionArrowLength = NULL;
	envset_dlg.entry_dimension_DimensionArrowAngle = NULL;
	envset_dlg.entry_dimension_DimensionOverArrowLength = NULL;
	envset_dlg.entry_dimension_DimensionOverLength = NULL;
	envset_dlg.entry_dimension_DimensionUnderLength = NULL;


	/* SystemColor */
	envset_dlg.BackColor = sagcad_color.Back;
	envset_dlg.SelectColor = sagcad_color.Select;
	envset_dlg.DimensionColor = sagcad_color.Dimension;
	envset_dlg.CamColor = sagcad_color.Cam;
	envset_dlg.PrinterRectColor = sagcad_color.PrinterRect;
	envset_dlg.FirstCenterLine = sagcad_color.FirstCenterLine;

	envset_dlg.entry_system_color_BackColor = NULL;
	envset_dlg.entry_system_color_SelectColor = NULL;
	envset_dlg.entry_system_color_DimensionColor = NULL;
	envset_dlg.entry_system_color_CamColor = NULL;
	envset_dlg.entry_system_color_PrinterRectColor = NULL;
	envset_dlg.entry_system_color_FirstCenterLine = NULL;


	/* Color */
	for (i = 0 ; i < 25 ; i++) {
		envset_dlg.color_name[i] = sagcad_color.Menu[i+1];
		envset_dlg.entry_color_name[i] = NULL;
	}


	/* Style */
	for (i = 0 ; i < 7 ; i++) {
		envset_dlg.style_max[i] = sagcad_line_style[i].max;
		envset_dlg.style_min[i] = sagcad_line_style[i].min;
		envset_dlg.style_DisplayWidth[i] = sagcad_line_style[i].DsplayWidth;
		envset_dlg.style_PrinterWidth[i] = sagcad_line_style[i].PrinterWidth;

		envset_dlg.entry_style_max[i] = NULL;
		envset_dlg.entry_style_min[i] = NULL;
		envset_dlg.entry_style_DisplayWidth[i] = NULL;
		envset_dlg.entry_style_PrinterWidth[i] = NULL;
	}


	envset_dlg.parent = MainWindow;
	envset_dlg.dialog = NULL;


	/* Ķɽ */
	EnvSetDialog(&envset_dlg);
	if (envset_dlg.Value == 0) {
		return;	// 0:CANCEL  1:OK
	}


	/* User */
	strcpy(sagcad_user.UserName, envset_dlg.user_name);
	strcpy(sagcad_user.CompanyName, envset_dlg.user_company);

	/* Path */
	strcpy(sagcad_user.KeepCadPath, envset_dlg.KeepCadPath);
	strcpy(sagcad_user.NcPath, envset_dlg.NcPath);
//	strcpy(sagcad_user.BrowserPath, envset_dlg.BrowserPath);

	/* Command */
	strcpy(sagcad_user.print_command, envset_dlg.print_command);
	strcpy(sagcad_user.editor_command, envset_dlg.editor_command);
	strcpy(sagcad_user.browser_command, envset_dlg.browser_command);

	/* System */
	sagcad_system.Search	= envset_dlg.system_Search;
	sagcad_system.Wait		= envset_dlg.system_Wait;
//	sagcad_system.MaxLayer	= envset_dlg.system_MaxLayer;
	sagcad_system.Splits	= envset_dlg.system_Splits;
	sagcad_system.ZoomMag	= envset_dlg.system_ZoomMag;
	sagcad_system.ViewX		= envset_dlg.system_ViewX;
	sagcad_system.FilletRC	= envset_dlg.system_FilletRC;
	sagcad_system.Length	= envset_dlg.system_Length;

	sagcad_system.WinMode	= envset_dlg.system_WinMode;
	sagcad_system.win_x_pos	= envset_dlg.system_win_x_pos;
	sagcad_system.win_y_pos	= envset_dlg.system_win_y_pos;
	sagcad_system.win_width	= envset_dlg.system_win_width;
	sagcad_system.win_height= envset_dlg.system_win_height;

	/* Dimension */
	sagcad_dimension.Font_height		 = envset_dlg.dimension_FontHeight;
	sagcad_dimension.Font_space			 = envset_dlg.dimension_FontLetterSpace;
	sagcad_dimension.Word_space			 = envset_dlg.dimension_FontWordSpace;
	sagcad_dimension.Font_space_line	 = envset_dlg.dimension_FontOverLineLength;
	strcpy(sagcad_dimension.font_file, envset_dlg.dimension_Font1);
	strcpy(sagcad_dimension.font_file2, envset_dlg.dimension_Font2);
	sagcad_dimension.arrow_length				 = envset_dlg.dimension_DimensionArrowLength;
	sagcad_dimension.arrow_angle				 = envset_dlg.dimension_DimensionArrowAngle;
	sagcad_dimension.arrow_line_extension		 = envset_dlg.dimension_DimensionOverArrowLength;
	sagcad_dimension.assistance_line_extension	 = envset_dlg.dimension_DimensionOverLength;
	sagcad_dimension.assistance_line_space		 = envset_dlg.dimension_DimensionUnderLength;

	/* SystemColor */
	sagcad_color.Back				 = envset_dlg.BackColor;
	sagcad_color.Select				 = envset_dlg.SelectColor;
	sagcad_color.Dimension			 = envset_dlg.DimensionColor;
	sagcad_color.Cam				 = envset_dlg.CamColor;
	sagcad_color.PrinterRect		 = envset_dlg.PrinterRectColor;
	sagcad_color.FirstCenterLine	 = envset_dlg.FirstCenterLine;


	/* Color */
	for (i = 0 ; i < 25 ; i++) {
		sagcad_color.Menu[i+1] = envset_dlg.color_name[i];
	}


	/* Style */
	for (i = 0 ; i < 7 ; i++) {
		sagcad_line_style[i].max				 = envset_dlg.style_max[i];
		sagcad_line_style[i].min				 = envset_dlg.style_min[i];
		sagcad_line_style[i].DsplayWidth		 = envset_dlg.style_DisplayWidth[i];
		sagcad_line_style[i].PrinterWidth		 = envset_dlg.style_PrinterWidth[i];
	}


	ConfigWrite();
	Redraw();
}



/* -------------------------------------------------------------------
 * ޤǤƤʤɽ
 */
void not_make(void)
{
	MsgBox("SagCAD", _("It is sorry.") , _("It creates from now.") , "OK", NULL, NULL);

}



/* -------------------------------------------------------
 * SagCAD νλ
 */
void cmd_end(void)
{
	int Ret;


	if (Undo_index != 0) {
		//                                                                          1     0        -1
		Ret = MsgBox("SagCAD", _("A drawing is changed!") , _("Does it save?") , "Yes", "No", "Cancel");
		/* Yes : (Save) */
		if (Ret == 1) {
			cmd_save();
		}
		/* No : (No Save) */
		else if (Ret == 0) {
		}
		/* Cancel : (return) */
		else {
			return;
		}
	}

	ending();
	gtk_exit(0); 
}





/* =====================================================================
 * << ɽ >>
 * =====================================================================
 */

/* -------------------------------------------------------
 * Ψ(Mag)
 */
void mag_box_click(GtkWidget *widget, GtkWidget *data)
{
	char str[256];
	double dbl;
	int Ret;

	dbl=Mag;
	FloatOut6(str, dbl, 0); /* () */
	Ret = InputBox( _("Setting of magnification") , _("Input a magnification.") , _("(0 is hopeless!)"), str);
	if(Ret == 1) {
		dbl = atof(str);
		if(dbl == 0) {
			MsgBox("SagCAD", "Error", _("It is impossible to set 0.") , NULL, NULL, "OK");
		}
		else {
			SetMag(dbl);
			Redraw();
		}
	}
}



/* -------------------------------------------------------
 * filletRC 
 */
void fillet_box_click(GtkWidget *widget, GtkWidget *data)
{
	char str[256], DumyStr[256];
	double dbl;
	int Ret;

	dbl=sagcad_system.FilletRC;
	FloatOut6(str, dbl, 0); /* () */
	Ret = InputBox("R or C", _("Set R of Fillet.") , _("Or Set C of Chamfer.") , str);
	if(Ret == 1) {
		dbl = atof(str);
		if(dbl == 0) {
			MsgBox("SagCAD", "Error", _("It is impossible to set 0.") , NULL, NULL, "OK");
		}
		else {
			/* < filletRC > */
			sagcad_system.FilletRC = dbl;
			FloatOut(str, dbl, 0);
			sprintf(DumyStr," R %s ",str);
			gtk_label_set(GTK_LABEL(fillet), DumyStr);
		}
	}
}



/* -------------------------------------------------------
 * length 
 */
void length_box_click(GtkWidget *widget, GtkWidget *data)
{
	char str[256], DumyStr[256];
	double dbl;
	int Ret;

	dbl = sagcad_system.Length;
	FloatOut6(str, dbl, 0); /* () */
	Ret = InputBox( _("Basic Length Setting") , " ", _("Input basic length.") , str);
	if(Ret == 1) {
		dbl = atof(str);
		if(dbl == 0) {
			MsgBox("SagCAD", "Error", _("It is impossible to set 0.") , NULL, NULL, "OK");
		}
		else {
			/* < length > */
			sagcad_system.Length = atof(str);
			FloatOut(str, sagcad_system.Length, 0);
			sprintf(DumyStr," L %s ",str);
			gtk_label_set(GTK_LABEL(length), DumyStr);
			dbl = sagcad_system.Length;
		}
	}
}



/* -------------------------------------------------------
 * ScrollPitch 
 */
void scroll_pitch_box_click(GtkWidget *widget, GtkWidget *data)
{
	char str[256], DumyStr[256];
	double dbl;
	int Ret;

	dbl = sagcad_system.ScrollPitch;
	FloatOut6(str, dbl, 0); /* () */
	Ret = InputBox( _("Scroll Pitch Setting") , "", _("Input Scroll Pitch") , str);
	if(Ret == 1) {
		dbl = atof(str);
		if(dbl==0) {
			MsgBox("SagCAD", "Error", _("It is impossible to set 0.") , NULL, NULL, "OK");
		}
		else {
			/* < ScrollPitch > */
			sagcad_system.ScrollPitch = atof(str);
			FloatOut(str, sagcad_system.ScrollPitch, 0);
			sprintf(DumyStr," SP %s ",str);
			gtk_label_set(GTK_LABEL(scroll_pitch), DumyStr);
			dbl = sagcad_system.ScrollPitch;
		}
	}
}





/* -------------------------------------------------------------------
 * ⡼ɥ󥻥
 */
void cmd_all_cancel(void)
{
	SelectCancel(drawing_area);
	mode = 0;
	OnlyOne_mode = 0;
	Center_set_mode = 0;
	ReturnFunc = MouseRet_Non;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * С
 */
void cmd_version(void)
{
	about(MainWindow);
}



/* -------------------------------------------------------------------
 * ¸ǡե̾
 * 
 */
int save_file_name_get(char *save_filename)
{
	char *str;

	str = GetFilename ( _("Save") , save_filename);
	if (str == NULL) {
		save_filename = NULL;
		//g_print("save_file_name_get : Get FileName = NULL\n");
		return 0;
	}

	strcpy (save_filename, str);
	//g_print("save_file_name_get : Get FileName = [%s]\n", save_filename);
	return 1;
}



/* -------------------------------------------------------------------
 * ɤ߹ߥǡե̾
 * 
 */
int read_file_name_get(char *read_filename)
{
	char *str;

	str = GetFilename ( _("Read") , read_filename);
	if (str == NULL) {
		read_filename = NULL;
		//g_print("read_file_name_get : Get FileName = NULL\n");
		return 0;
	}

	strcpy (read_filename, str);
	//g_print("read_file_name_get : Get FileName = [%s]\n", read_filename);
	return 1;
}





/* =====================================================================
 * << ե >>
 * =====================================================================
 */

/* ̥ե򳫤 */
void cmd_open(void)
{
	char str[256], check_str[256], msg[256];
	int Ret;


	if (Undo_index != 0) {
		//                                                                          1     0        -1
		Ret = MsgBox("SagCAD", _("A drawing is changed!") , _("Does it save?") , "Yes", "No", "Cancel");
		/* Yes : (Save) */
		if (Ret == 1) {
			cmd_save();
		}
		/* No : (No Save) */
		else if (Ret == 0) {
		}
		/* Cancel : (return) */
		else {
			return;
		}
	}

	sprintf(check_str, "%s/NoName.dxf", sagcad_user.CadPath);
	if (strcmp(check_str, NowFile) == 0) {
		sprintf (str, "%s/", sagcad_user.CadPath);
	}
	else {
		strcpy (str, NowFile);
	}


	Ret = read_file_name_get(str);
	/* ե򥭥󥻥 */
	if (Ret == 0) {
		return;
	}
	if (Ret == 1 && str != NULL){
		if (strstr(str, ".sgy") != NULL || strstr(str, ".SGY") != NULL) {

//			StartData = NULL;
			cad_list_all_free(&cad_list_info);
			dimension_list_all_free(&dimension_list_info);
			polyline_list_all_free(&polyline_list_info);
			insert_list_all_free(&insert_list_info);
			block_list_all_free(&block_list_info);
			/* ɥ */
			undo_list_all_free();

			sprintf(msg, "Reading SGY       ");
			StatusMsg(msg);
			UpDate_widget(MainWindow);
			sgyFileOpen(str);
		}
		else if(strstr(str, ".dxf") != NULL || strstr(str, ".DXF") != NULL) {

//			StartData = NULL;
			cad_list_all_free(&cad_list_info);
			dimension_list_all_free(&dimension_list_info);
			polyline_list_all_free(&polyline_list_info);
			ellipse_list_all_free(&ellipse_list_info);
			insert_list_all_free(&insert_list_info);
			block_list_all_free(&block_list_info);
			/* ɥ */
			undo_list_all_free();

			sprintf(msg, "Reading DXF       ");
			StatusMsg(msg);
			//g_print("%s\n", msg);
			UpDate_widget(MainWindow);
			Ret = DxfFileOpen(str, 0, 0);
		}

		strcpy(NowFile, str);
		/* ȥ */
		SetTitle(NowFile);
		undo_buttun(0);
		redo_buttun(0);

		//Redraw();
		sprintf(msg, _("Reading OK! display Now. [%d]") , Ret);
		StatusMsg(msg);
		UpDate_widget(MainWindow);
		SetMag(Mag);
		sprintf(msg, _("display OK!") );
		StatusMsg(msg);
	}
	return;
}



/* ̤ե¸ */
void cmd_rename(void)
{
	char str[256];
	int Ret;

	if (Undo_index != 0) {
		//                                                                          1     0        -1
		Ret = MsgBox("SagCAD", _("A drawing is changed!") , _("Does it save?") , "Yes", "No", "Cancel");
		/* Yes : (Save) */
		if (Ret == 1) {
			cmd_save();
		}
		/* No : (No Save) */
		else if (Ret == 0) {
		}
		/* Cancel : (return) */
		else {
			return;
		}
	}

	strcpy (str, NowFile);
	Ret = save_file_name_get(str);
	/* ե򥭥󥻥 */
	if (Ret == 0) {
		//g_print("save_file : str = NULL\n");
		return;
	}
	if(Ret == 1 && str != NULL){
		if (strstr(str, ".sgy") != NULL || strstr(str, ".SGY") != NULL) {
			sgyFileSave(str);
		}
		else if(strstr(str, ".igs") != NULL || strstr(str, ".IGS") != NULL) {
			igesFileSave(str);
		}
		else if(strstr(str, ".dxf") != NULL || strstr(str, ".DXF") != NULL) {
			DxfFileSave(str);
		}

		strcpy(NowFile, str);
		/* ȥ */
		SetTitle(NowFile);

		undo_buttun(0);
		redo_buttun(0);

		/* ɥ */
		undo_list_all_free();
	}
	return;
}



/* ¸ */
void cmd_save(void)
{
	char str[256];


	strcpy (str, NowFile);
	if(str != NULL){
		if (strstr(str, ".sgy") != NULL || strstr(str, ".SGY") != NULL) {
			sgyFileSave(str);
		}
		else if(strstr(str, ".igs") != NULL || strstr(str, ".IGS") != NULL) {
			igesFileSave(str);
		}
		else if(strstr(str, ".dxf") != NULL || strstr(str, ".DXF") != NULL) {
			DxfFileSave(str);
		}

		/* ɥ */
		undo_list_all_free();

		/* ȥ */
		SetTitle(NowFile);

		undo_buttun(0);
		redo_buttun(0);

	}
	return;
}



/* ޷ */ 
void cmd_delete(void)
{
	if (select_list_info.head == NULL) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}
	SelectDelete(drawing_area);
}



/* ޷󥻥 */ 
void cmd_cancel(void)
{
	SelectCancel(drawing_area);
}



/* 쥤䡼ư */ 
void cmd_layer_move(void)
{
	if (select_list_info.head == NULL) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	 Change_Layer(1);
}



/* 쥤䡼ʣ */ 
void cmd_layer_copy(void)
{
	if (select_list_info.head == NULL) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	Change_Layer(2);
}



/* ѹ */ 
void cmd_line_style_change(void)
{
	Change_Line_Style();
}



/* New */
void cmd_New(void)
{
	system("sagcad &");
}



int cmd_view(GtkWidget *widget, GdkEventButton *event, gint i)
{
//	g_print("View = %d     event->button = %d\n", i, event->button);
	if (event->button == 1)
		view_func(1, i);
	else if (event->button == 3)
		view_func(0, i);
	return 1;
}



/* View 0 - 5  */
void view_func(int save0_or_view1, int number)
{
	/* ɽξ֤¸ */
	if (save0_or_view1 == 0)
	{
		GamenMag[number]  = Mag;
		GamenMagX[number] = MagX;
		GamenMagY[number] = MagY;
//		g_print("Mag = %f\n", Mag);
		return;
	}

	/* ɽξ֤ */
	else 
	{
		Mag = GamenMag[number];
		MagX = GamenMagX[number];
		MagY = GamenMagY[number];
//		g_print("Mag = %f\n", Mag);
		SetMag(Mag);
		/*  */
		Redraw();
		return;
	}
}



/* 濴 */
void cmd_center(void)
{
	char str[256];

	sprintf(str, _(" [View Center] (Left Search Point / Right Mouse Point / Center Cencel)") );
	StatusMsg(str);
	Center_set_mode = 100;
	return;
}



/* -------------------------------------------------------------------
 *  
 */
void cmd_select(void)
{
	if (outside_process_on == 1) {
		ReturnFunc = MouseRet_Select_ops;
		DcObj = outside_process.Work[outside_process.now].sel_obj;
		mode = 300;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		SelectChainFrag = 0;
		SelectColorFrag = 0;
	}

	else {
		if (mode != 300 && mode != 310 && mode != 900) {
			SelectCancel(drawing_area);
		}
		ReturnFunc = MouseRet_Select;
		DcObj = 15+256+512+2048;
		mode = 300;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		SelectChainFrag = 0;
		SelectColorFrag = 0;
	}

	return;
}



/* -------------------------------------------------------------------
 * ϰ
 */
void cmd_rect_select(void)
{
	if (outside_process_on == 1) {
		if (outside_process.Work[outside_process.now].work == OPS_SELECT_ONE) {
			MsgBox("SagCADOutside Process", 
				   _("Now SELECT ONE Mode") , 
				   _("So this feature Can't use Now.") , NULL, NULL, "OK");
			return;
		}
		
		ReturnFunc = MouseRet_Rect_ops;
		DcObj = outside_process.Work[outside_process.now].sel_obj;
		mode = 310;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		SelectChainFrag = 0;
		SelectColorFrag = 0;
	}


	else {
		if (mode != 300 && mode != 310 && mode != 900) {
			SelectCancel(drawing_area);
		}
		ReturnFunc = MouseRet_Rect;
		DcObj = 15+256+512+2048;
		mode = 310;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		SelectChainFrag = 0;
		SelectColorFrag = 0;
	}

	return;
}



/* =====================================================================
 * <<  >>
 * =====================================================================
 */


/* -------------------------------------------------------------------
 * 
 */
void cmd_draw(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Draw;
	select_list_all_free();
	DcObj = 15+2048;
	mode = 200;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 
 */
void cmd_select_chain(void)
{
	SelectChainFrag = 1;
	SelectColorFrag = 0;

	/* ߣİʾ奻쥯ȤƤ */
	if (select_list_info.tail != NULL) {
		OP_SelectList = select_list_info.tail;
	}

	/* ߣĥ쥯ȤƤ */
	else if (select_list_info.head != NULL) {
		OP_SelectList = select_list_info.head;
	}

	/* ߣĤ⥻쥯ȤƤʤ */
	else if (select_list_info.head == NULL) {
		OP_SelectList = NULL;
	}

	return;
}



/* -------------------------------------------------------------------
 * ɮ
 */
void cmd_select_chain2(void)
{
	SelectChainFrag = 2;
	SelectColorFrag = 0;

	/* ߣİʾ奻쥯ȤƤ */
	if (select_list_info.tail != NULL) {
		OP_SelectList = select_list_info.tail;
	}

	/* ߣĥ쥯ȤƤ */
	else if (select_list_info.head != NULL) {
		OP_SelectList = select_list_info.head;
	}

	/* ߣĤ⥻쥯ȤƤʤ */
	else if (select_list_info.head == NULL) {
		OP_SelectList = NULL;
	}

	return;
}



/* -------------------------------------------------------------------
 * 顼
 */
void cmd_select_color(void)
{
	SelectColorFrag = 1;
	SelectChainFrag = 0;
	if (select_list_info.tail != NULL)
		OP_SelectList = select_list_info.tail;
	else if (select_list_info.head != NULL)
		OP_SelectList = select_list_info.head;
	else if (select_list_info.head == NULL)
		OP_SelectList = NULL;

	return;
}



/* -------------------------------------------------------------------
 * ȥ
 */
void cmd_trim(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Trim;
	select_list_all_free();
	DcObj = 15+2048;
	mode = 220;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ξȥ
 */
void cmd_both_trim(void) 
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Trim;
	select_list_all_free();
	DcObj = 15+2048;
	mode = 225;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ʬ
 */
void cmd_split(void) 
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Split;
	select_list_all_free();
	DcObj = 15+2048;
	mode = 260;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -----------------------------------------------------------------------
 * եå
 */
void cmd_fillet(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Fillet;
	select_list_all_free();
	DcObj = 15;
	mode = 270;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ̼
 */
void cmd_Chamfering(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_Chamfering;
	select_list_all_free();
	DcObj = 15;
	mode = 280;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * Ϣ³
 */
void cmd_cont_line(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_ContLine;
	select_list_all_free();
	DcObj = 15;
	mode = 250;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * Ǳ
 */
void cmd_3point(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_3P_Circle;
	select_list_all_free();
	DcObj = 1;
	mode = 230;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * դǱ
 */
void cmd_3line(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_3L_Circle;
	select_list_all_free();
	DcObj = 2;
	mode = 240;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ɸ
 */
void cmd_point(void)
{
	int Ret;
	CAD cad;
	char str[256];
	double x, y;
	CAD_LIST *p_cad_list;


	while(1) {
		/* ϥܥåɽ */
//		plaX = 100;
//		plaY = 105;
		Ret = InputBox( _("Make Point - Input Coordinates") , _("Input the coordinates of X.") , "", str);
		if (Ret == -1) return;
		x = atof(str);

		/* ϥܥåɽ */
		Ret = InputBox( _("Make Point - Input Coordinates") , _("Input the coordinates of Y") , "", str);
		if (Ret == -1) return;
		y = atof(str);

		/* ǡϿ */
		cad.code = 0;
		cad.layer = NowLayer;
		cad.style = NowStyle;
		cad.color = NowColor;
		cad.sx = x;
		cad.sy = y;
		cad.ex = 0;
		cad.ey = 0;
		cad.cx = 0;
		cad.cy = 0;
		cad.r  = 0;
		cad.OnScreen = 0;

		undo_index_plus();
		p_cad_list = cad_list_add_first_with_undo(&cad, &cad_list_info);
		SelectCadDraw(drawing_area, p_cad_list->cad, SCD_ORG);
	}
	return;
}



/*  */
void cmd_redraw(void)
{
	Redraw();
	return;
}



/* -------------------------------------------------------------------
 * ʿ
 */
void cmd_parallel_copy(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	CopyFrag = select_list_num();
	ReturnFunc = MouseRet_Parallel;
	DcObj = 15;
	mode = 340;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ž
 */
void cmd_turn(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	CopyFrag = select_list_num();
	ReturnFunc = MouseRet_Turn;
	DcObj = 15;
	mode = 350;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * о
 */
void cmd_mirr(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	CopyFrag = select_list_num();
	ReturnFunc = MouseRet_Mirror;
	DcObj = 15;
	mode = 330;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * 
 */
void cmd_scaling(void)
{
	SCALING_DLG scaling_dlg;
	char str[256];

	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	sprintf(str, _("Scaling Setting") );
	StatusMsg(str);

	/* ScalingDialog */
	scaling_dlg.x_pos = 0;
	scaling_dlg.y_pos = 0;
	scaling_dlg.coefficient = 1;
	scaling_dlg.x_pos_entry = NULL;
	scaling_dlg.y_pos_entry = NULL;
	scaling_dlg.coefficient_entry = NULL;
	scaling_dlg.parent = MainWindow;
	scaling_dlg.dialog = NULL;

	ScalingDialog(&scaling_dlg);
	CopyScaling(scaling_dlg.x_pos, scaling_dlg.y_pos, scaling_dlg.coefficient, 1);

	/* mode ⡼ 300  */
	ReturnFunc = MouseRet_Select;
	DcObj = 15;
	mode = 300;
	/* åɽ */
	(*ReturnFunc)(drawing_area, 1, 0, 0);

	return;
}



/* -------------------------------------------------------------------
 * ʣ
 */
void cmd_grid_copy(void)
{
	GRIDCOPY_DLG gridcopy_dlg;
	char str[256];

	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	sprintf(str, _("Procession Copy Setting") );
	StatusMsg(str);

	/* GridCopyDialog */
	gridcopy_dlg.x_pitch = 0;
	gridcopy_dlg.y_pitch = 0;
	gridcopy_dlg.x_repeats = 1;
	gridcopy_dlg.y_repeats = 1;
	gridcopy_dlg.x_pitch_entry = NULL;
	gridcopy_dlg.y_pitch_entry = NULL;
	gridcopy_dlg.x_repeats_entry = NULL;
	gridcopy_dlg.y_repeats_entry = NULL;
	gridcopy_dlg.parent = MainWindow;
	gridcopy_dlg.dialog = NULL;

	GridCopyDialog(&gridcopy_dlg);
	CopyKousi(gridcopy_dlg.x_pitch, gridcopy_dlg.y_pitch, gridcopy_dlg.x_repeats, gridcopy_dlg.y_repeats);

	/* mode ⡼ 300  */
	ReturnFunc = MouseRet_Select;
	DcObj = 15;
	mode = 300;
	/* åɽ */
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* =====================================================================
 * << ˡ >>
 * =====================================================================
 */
/* -------------------------------------------------------------------
 * ˡ X
 */
void cmd_x_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionX;
	DcObj = 113;
	Dim_now.Type = 10;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

//g_print("Command.c : cmd_x_dimension() : Dim_now.FontHeight = %f\n", Dim_now.FontHeight);
//g_print("Command.c : cmd_x_dimension() : Dim_now.FontSpace = %f\n", Dim_now.FontSpace);

	Dim_now.DrawType = DRAW_REAL;//sagcad_dimension.Draw_Type;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 510;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ˡ Y
 */
void cmd_y_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionY;
	DcObj = 113;
	Dim_now.Type = 20;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
//	Dim_now.FontType = 1;
	Dim_now.AssistLine = NULL;
	mode = 520;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ˡ Υ
 */
void cmd_p_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionP;
	DcObj = 113;
	Dim_now.Type = 30;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 530;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ˡ Ⱦ
 */
void cmd_r_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionR;
	DcObj = 113;
	Dim_now.Type = 40;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.Text[0] = '\0';
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 540;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ˡ ľ
 */
void cmd_d_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionD;
	DcObj = 113;
	Dim_now.Type = 50;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.Text[0] = '\0';
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 550;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ˡ 
 */
void cmd_a_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionA;
	DcObj = 113;
	Dim_now.Type = 60;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
	Dim_old.Text[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 560;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ˡ ɸ
 */
void cmd_pt_dimension(void)
{
	double scale;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionPT;
	DcObj = 113;
	Dim_now.Type = 70;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;
	Dim_now.FontType = sagcad_dimension.font_Type;

	Dim_now.FontHeight = sagcad_dimension.Font_height;
	scale = (Dim_now.FontHeight / 9.);
	Dim_now.FontSpace = sagcad_dimension.Font_space * scale;
	Dim_now.WordSpace = sagcad_dimension.Word_space * scale;
	Dim_now.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	Dim_now.DrawType = DRAW_REAL;
	Dim_now.UpperText[0] = '\0';
	Dim_now.LowerText[0] = '\0';
//	Dim_now.FontType = 1;
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	Dim_old.Text[0] = '\0';
	mode = 570;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ˡ 
 */
void cmd_hd_dimension(void)
{
	double scale;
	TEXT_EDIT_DLG a;

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionHD;
	(*ReturnFunc)(drawing_area, 1, 0, 0);


	/* TextEditDialog */
	strcpy(a.Text, "");
	strcpy(a.UpperText, "");
	strcpy(a.LowerText, "");

	a.FontHeight = sagcad_dimension.Font_height;
	scale = a.FontHeight / 9;
	a.FontSpace = sagcad_dimension.Font_space * scale;
	a.WordSpace = sagcad_dimension.Word_space * scale;
	a.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	a.Angle = 0;
	a.SearchPointX = 0;
	a.SearchPointY = 0;
	a.FitPointX = 0;
	a.FitPointY = 1;


	a.entry_Text = NULL;
	a.entry_UpperText = NULL;
	a.entry_LowerText = NULL;

	a.entry_FontHeight = NULL;
	a.entry_FontSpace = NULL;
	a.entry_WordSpace = NULL;
	a.entry_FontOverLineSpace = NULL;
	a.entry_SearchPointX = NULL;
	a.entry_SearchPointY = NULL;
	a.entry_Angle = NULL;
	a.entry_FitPointX = NULL;
	a.entry_FitPointY = NULL;

	a.parent = MainWindow;
	a.dialog = NULL;

	TextEditDialog(&a);
	if (a.FontHeight == 0) {
		SelectCancel(drawing_area);
		mode = 0;
		return;
	}

	strcpy(Dim_now.Text, a.Text);
	strcpy(Dim_now.UpperText, a.UpperText);
	strcpy(Dim_now.LowerText, a.LowerText);
	Dim_now.FontHeight = a.FontHeight;
	Dim_now.FontSpace = a.FontSpace;
	Dim_now.WordSpace = a.WordSpace;
	Dim_now.FontOverLineSpace = a.FontOverLineSpace;


	ReturnFunc = MouseRet_DimensionHD;
	DcObj = 113;
	Dim_now.Type = 80;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;

	Dim_now.FontType = sagcad_dimension.font_Type;
	Dim_now.DrawType = DRAW_REAL;
	Dim_old.Text[0] = '\0';
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 580;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ˡ 
 */
void cmd_at_dimension(void)
{
	double scale;
	TEXT_EDIT_DLG a;
	char mstr[256];


	SelectCancel(drawing_area);
	/* ޥɥ饤ɽ */
	sprintf(mstr, _(" [Drawer Line Dimension] Text Setting") );
	StatusMsg(mstr);

	/* TextEditDialog */
	strcpy(a.Text, "");
	strcpy(a.UpperText, "");
	strcpy(a.LowerText, "");

	a.FontHeight = sagcad_dimension.Font_height;
	scale = a.FontHeight / 9;
	a.FontSpace = sagcad_dimension.Font_space * scale;
	a.WordSpace = sagcad_dimension.Word_space * scale;
	a.FontOverLineSpace = sagcad_dimension.Font_space_line * scale;

	a.Angle = 0;
	a.SearchPointX = 0;
	a.SearchPointY = 0;
	a.FitPointX = 0;
	a.FitPointY = 1;


	a.entry_Text = NULL;
	a.entry_UpperText = NULL;
	a.entry_LowerText = NULL;

	a.entry_FontHeight = NULL;
	a.entry_FontSpace = NULL;
	a.entry_WordSpace = NULL;
	a.entry_FontOverLineSpace = NULL;
	a.entry_SearchPointX = NULL;
	a.entry_SearchPointY = NULL;
	a.entry_Angle = NULL;
	a.entry_FitPointX = NULL;
	a.entry_FitPointY = NULL;

	a.parent = MainWindow;
	a.dialog = NULL;

	TextEditDialog(&a);
	if (a.FontHeight == 0) {
		SelectCancel(drawing_area);
		mode = 0;
		return;
	}

	strcpy(Dim_now.Text, a.Text);
	strcpy(Dim_now.UpperText, a.UpperText);
	strcpy(Dim_now.LowerText, a.LowerText);
	Dim_now.FontHeight = a.FontHeight;
	Dim_now.FontSpace = a.FontSpace;
	Dim_now.WordSpace = a.WordSpace;
	Dim_now.FontOverLineSpace = a.FontOverLineSpace;


	ReturnFunc = MouseRet_DimensionAT;
	DcObj = 113;
	Dim_now.Type = 90;
	Dim_now.Layer = NowLayer;
	Dim_now.text_color = sagcad_color.Dimension;
	Dim_now.Assist_color = sagcad_color.Dimension;

	Dim_now.FontType = sagcad_dimension.font_Type;
	Dim_now.DrawType = DRAW_REAL;
	Dim_old.Text[0] = '\0';
	
	Dim_now.start.x = 0;
	Dim_now.start.y = 0;
	Dim_now.end.x = 0;
	Dim_now.end.y = 0;

	Dim_now.diagram_of_char_index = 0;
	Dim_now.diagram_of_char = NULL;
	Dim_now.index = 0;
	Dim_now.AssistLine = NULL;
	mode = 590;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * ˡ Խ
 */
void cmd_edt_dimension(void)
{
	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_DimensionEDT;
	DcObj = 256;
	mode = 610;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * Undo
 */
void cmd_Undo(void)
{
	StartData = NULL;

	if (Undo() != 0) {
		Redraw();
		if (Undo_Now == 1) {
			undo_buttun(0);
		}
		redo_buttun(1);
	}
//	else MsgBox("err", "Undo End", " ", NULL, NULL, NULL);

	return;
}



/* -------------------------------------------------------------------
 * Redo
 */
void cmd_Redo(void)
{
	StartData = NULL;

	if (Redo() != 0) {
		Redraw();
		if (Undo_index +1 ==Undo_Now) {
			redo_buttun(0);
		}
		undo_buttun(1);
	}

//	else MsgBox("err", "Redo End", " ", NULL, NULL, NULL);

	return;
}



/* -------------------------------------------------------------------
 * å
 */
void cmd_cut(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	WriteClipFile();
	SelectDelete(drawing_area);
}



/* -------------------------------------------------------------------
 * ԡ
 */
void cmd_copy(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	WriteClipFile();
}



/* -------------------------------------------------------------------
 * ڡ
 */
void cmd_paste(void)
{
	ReadClipFile();
	ModifiedFlag = 1;
	/*  */
	Redraw();
}





/* -------------------------------------------------------------------
 * ʿ
 */
void cmd_parts_in(void)
{
	char mstr[256];
	int Ret;


	sprintf(PartsFile, "%s/NoName.dxf", sagcad_user.CadPath);
	Ret = read_file_name_get(PartsFile);
	/* ե򥭥󥻥 */
	if (Ret == 0) {
		return;
	}
	if(Ret == 1 && PartsFile != NULL){
		if (strstr(PartsFile, ".sgy") != NULL || strstr(PartsFile, ".SGY") != NULL) {
			//
		}
		else if (strstr(PartsFile, ".dxf") != NULL || strstr(PartsFile, ".DXF") != NULL) {
			//
		}
		else {
			return;
		}
	}

//g_print("PartsFile = [%s]\n", PartsFile);

	SelectCancel(drawing_area);
	ReturnFunc = MouseRet_PartsRead;
	/* ޥɥ饤ɽ */
	sprintf(mstr, _(" [Part Insert] Select Starting Point") );
	StatusMsg(mstr);
	mode = 110;
	select_list_all_free();
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* ---------------------------------------------------------
 * CAM Profile
 * 
 */
void cmd_profile(void)
{
	if (select_list_num() == 0) {
		MsgBox("SagCAD", _("Execute after selecting a diagram.") , "", NULL, NULL, "OK");
		return;
	}

	ReturnFunc = MouseRet_CamProfile;
	mode = 900;
	CopyFrag = select_list_num();
	(*ReturnFunc)(drawing_area, 1, 0, 0);

	return;
}



/* ---------------------------------------------------------
 * NC 
 * 
 */
void cmd_NcDraw(void)
{
	NcFileRead();
	UpDate();
	return;
}





















#ifdef AFTER
void DUMMY_____________________________1(void) {}




/* CAM ݥå (ID_POKET) */
void cmd_poket(void)
{
	char str[256];

	if(select_list_num() == 0) {
		sprintf(str, "޷쥯ȤƤޤ");
		MsgBox("Boo !", str);
		return;
	}

//	sprintf(str, "ϤޤƥǤ\nե꡼ǽ礭Τ\nи礷Ʋ");
//	MsgBox("᤿å", str);


	ReturnFunc = MouseRet_offset;
	mode = 1000;
	CopyFrag = select_list_num();
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return;
}



/* -------------------------------------------------------------------
 * Key  (ID_ESC_PUSH)
 */
void cmd_key_ESC(void)
{
	if (OnlyOne_mode == 210) OnlyOne (0); /* Cancel */
//	if(Chain2_OnlyOne_mode == 211)	SelectChain2_OnlyOne (0); /* Cancel */
	else {
		SelectCancel(drawing_area);
	}
	return;
}



/* -------------------------------------------------------------------
 * Key  (ID_SPACE_PUSH)
 */
void cmd_key_SPACE(void)
{
	if(OnlyOne_mode == 210)	OnlyOne (2); /* No */
//	if(Chain2_OnlyOne_mode == 211)	SelectChain2_OnlyOne (2); /* No */
	return;
}



/* -------------------------------------------------------------------
 * Key  (ID_RETURN_PUSH)
 */
void cmd_key_RETURN(void)
{
	if(OnlyOne_mode == 210)	OnlyOne (1); /* Yes */
//	if(Chain2_OnlyOne_mode == 211)	SelectChain2_OnlyOne (1); /* Yes */
	return;
}



#endif


/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Command.c
 * ====================================================================
 */

