/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : Command.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2002 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/03/14
 *    Last                 : 2002/09/27
 * ====================================================================
 */
#ifndef __COMMAND_H__
#define __COMMAND_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */
struct _MenuItem
{
	int ID;
//	void *func;
	void (*func)();
};



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _COMMAND_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _COMMAND_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */

/* ƥ key 't'  */
void test(void);

/*  (Outside Proces) */
void cmd_outside_process(void);
/* ʱߺ */
void cmd_Ellipse_Draw(void);
/*  */
void cmd_print_set(void);
/*  */
void cmd_print(void);
/* Ϣ³ */
void cmd_polyline(void);
/* 쥤䡼 */
void cmd_LayerSet(void);
/* Help ɽ */
void cmd_help(void);
/* Ķ */
void cmd_env_set(void);
/* ޤǤƤʤɽ */
void not_make(void);
/* SagCAD νλ */
void cmd_end(void);
/* Ψ(Mag) */
void mag_box_click(GtkWidget *widget, GtkWidget *data);
/* filletRC  */
void fillet_box_click(GtkWidget *widget, GtkWidget *data);
/* length  */
void length_box_click(GtkWidget *widget, GtkWidget *data);
/* ScrollPitch  */
void scroll_pitch_box_click(GtkWidget *widget, GtkWidget *data);
/* ⡼ɥ󥻥 */
void cmd_all_cancel(void);
/* С */
void cmd_version(void);
/* ¸ǡե̾ */
int save_file_name_get(char *save_filename);
/* ɤ߹ߥǡե̾ */
int read_file_name_get(char *read_filename);
/* ̥ե򳫤 */
void cmd_open(void);
/* ̤̾դƥե¸ */
void cmd_rename(void);
/* ¸ */
void cmd_save(void);
/* ޷ */ 
void cmd_delete(void);
/* ޷󥻥 */ 
void cmd_cancel(void);
/* 쥤䡼ư */ 
void cmd_layer_move(void);
/* 쥤䡼ʣ */ 
void cmd_layer_copy(void);
/* ѹ */ 
void cmd_line_style_change(void);
/* New */
void cmd_New(void);

/* View */
int cmd_view(GtkWidget *widget, GdkEventButton *event, gint i);
/* View 0 - 5  */
void view_func(int save0_or_view1, int number);

/* 濴 */
void cmd_center(void);

/*  */
void cmd_select(void);
/* ϰ */
void cmd_rect_select(void);

/*  */
void cmd_draw(void);
/* ȥ */
void cmd_trim(void);
/* ξȥ */
void cmd_both_trim(void);
/* ʬ */
void cmd_split(void) ;
/* եå */
void cmd_fillet(void) ;
/* ̼ */
void cmd_Chamfering(void);
/* Ϣ³ */
void cmd_cont_line(void);
/* Ǳ */
void cmd_3point(void);
/* դǱ */
void cmd_3line(void);
/* ɸ */
void cmd_point(void);

/*  */
void cmd_redraw(void);

/* ʿ */
void cmd_parallel_copy(void);
/* ž */
void cmd_turn(void);
/* о */
void cmd_mirr(void);
/*  */
void cmd_scaling(void);
/* ʣ */
void cmd_grid_copy(void);


/* ˡ X */
void cmd_x_dimension(void);
/* ˡ Y */
void cmd_y_dimension(void);
/* ˡ Υ */
void cmd_p_dimension(void);
/* ˡ Ⱦ */
void cmd_r_dimension(void);
/* ˡ ľ */
void cmd_d_dimension(void);
/* ˡ  */
void cmd_a_dimension(void);
/* ˡ ɸ */
void cmd_pt_dimension(void);
/* ˡ  */
void cmd_hd_dimension(void);
/* ˡ  */
void cmd_at_dimension(void);
/* ˡ Խ */
void cmd_edt_dimension(void);



/*  */
void cmd_select_chain(void);
/* ɮ */
void cmd_select_chain2(void);
/* 顼 */
void cmd_select_color(void);

/* Undo */
void cmd_Undo(void);
/* Redo */
void cmd_Redo(void);
/* å */
void cmd_cut(void);
/* ԡ */
void cmd_copy(void);
/* ڡ */
void cmd_paste(void);
/* ʿ */
void cmd_parts_in(void);

/* CAM Profile */
void cmd_profile(void);

/* NC  */
void cmd_NcDraw(void);


#ifdef AFTER
void select_list_log(void);
void undo_list_log(void);
void CommandMenu(HWND hWnd, int MenuID);
int Dimension_List_Log(char *filename, char *msg);
#endif



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __COMMAND_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2002 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Source               : Command.h
 * ====================================================================
 */
