/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Dimension.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/02/27
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DRAW
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "List_font.h"
#include "global.h"
#include "Trace.h"
#include "Select.h"
#include "Draw.h"
#include "etc.h"
#include "MsgBox.h"

#include "Assistance.h"
#include "font.h"
#include "Select.h"
#define _DIMENSION_
#include "Dimension.h"





/* -------------------------------------------------------------------
 * ˡ (HWND)
 *	
 * TextFrag 
 *		0:ʤ				   1:				2:쥯ȥ顼
 *	   10:MouseMove ΤȤ	  11:MouseMove ΤȤ
 * draw() ʳ褹Ȥ˻
 * #define SCD_ORG		0
 * #define SCD_SELECT	1
 * #define SCD_HIDE		2
 * #define SCD_CAM		3
 */
int DimensionDraw(GtkWidget *widget, DIMENSION *a, int TextFrag)
{
	if (a == NULL) {
		MsgBox("SagCAD error", "DIMENSION Data is NULL !", "DimensionDraw error", NULL, NULL, "OK");
		return 0;
	}

	Dimension_Text_Basic(widget, a, TextFrag);
	Dimension_Line_Basic(widget, a, TextFrag);

	return 1;
}





/* -------------------------------------------------------------------
 * ˡ  (HDC)
 *	
 * TextFrag = 0:ʤ	1:	  2:쥯ȥ顼
 *	
 */
int Dimension_Line_Basic(GtkWidget *widget, DIMENSION *a, int TextFrag)
{
	int i;
	long color = sagcad_color.Dimension;

//g_print("Dimension.c : Dimension_Line_Basic() : in\n");


	if (TextFrag == SCD_HIDE)
		color = sagcad_color.Back;
	else if (TextFrag == SCD_SELECT)
		color = sagcad_color.Select;


	/*  */
	/* ǥץ쥤 */
	if (DrawObject == 0)
		SearchPointDraw(widget, a->SearchPointX, a->SearchPointY, color);

	if (a->index > 0 && a->AssistLine != NULL) {
		for (i = 0 ; i < a->index ; i++) {
			if (&a->AssistLine[i] == NULL) {
				g_print("AssistLine is null.\n");
				return 0;
			}
			
			switch (a->AssistLine[i].defin) {
				/*  */
				case 0:
					PointDraw(widget, a->AssistLine[i].sx, a->AssistLine[i].sy, 1, color);
					break;
				/*  */
				case 1:
					LineDraw(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
									a->AssistLine[i].ex, a->AssistLine[i].ey, 1, color);
					break;
				/* ߸ */
				case 2:
					ArcDraw(widget,	a->AssistLine[i].cx, a->AssistLine[i].cy, a->AssistLine[i].r, 
									a->AssistLine[i].sx, a->AssistLine[i].sy, 
									a->AssistLine[i].ex, a->AssistLine[i].ey, 1, color);
					break;
				/*  */
				case 4:
					CircleDraw(widget, a->AssistLine[i].cx, a->AssistLine[i].cy, a->AssistLine[i].r, 1, color);
					break;
				/* () */
				case 10:
					LineEndArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 0, a->DrawType, color);
					break;
				/* () */
				case 11:
					LineEndArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 1, a->DrawType, color);
					break;
				/* ξü() */
				case 20:
					LineBothArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 0, a->DrawType, color);
					break;
				/* ξü() */
				case 21:
					LineBothArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 1, a->DrawType, color);
					break;
				/* ξü˵() */
				case 30:
					LineBothConverseArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
												a->AssistLine[i].ex, a->AssistLine[i].ey, 0, a->DrawType, color);
					break;
				/* ξü˵() */
				case 31:
					LineBothConverseArrow(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
												a->AssistLine[i].ex, a->AssistLine[i].ey, 1, a->DrawType, color);
					break;
				/* (߸) */
	//			case 40:
				/* (߸) */
	//			case 50:
				/* ξü(߸) */
				case 60:
					ArcBothArrow(widget,	a->AssistLine[i].cx, a->AssistLine[i].cy, a->AssistLine[i].r, 
										a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 0, a->DrawType, color);
					break;
				/* ξü(߸) */
				case 61:
					ArcBothArrow(widget,	a->AssistLine[i].cx, a->AssistLine[i].cy, a->AssistLine[i].r, 
										a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, 1, a->DrawType, color);
					break;
				/*  */
				case 70:
					AssistanceLine(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
										a->AssistLine[i].ex, a->AssistLine[i].ey, a->DrawType, color);
					break;
				/* ()αĹ */
				case 80:
					LineEndExtension(widget,	a->AssistLine[i].sx, a->AssistLine[i].sy, 
											a->AssistLine[i].ex, a->AssistLine[i].ey, a->DrawType, color);
					break;
			}
		}
	}
	else if (a->index > 0 && a->AssistLine == NULL) {
		OneShotLog("ˡ index > 0 ʤΤ AssistLine  NULL Ǥ\n");
	}

//g_print("Dimension.c : Dimension_Line_Basic() : out\n");

	return 1;
}





/* -------------------------------------------------------------------
 * ˡ  (HDC)
 *	
 * TextFrag = 0:ʤ	1:	  2:쥯ȥ顼
 *	
 */
int Dimension_Text_Basic(GtkWidget *widget, DIMENSION *a, int TextFrag)
{
	long color = sagcad_color.Dimension;


//g_print("Dimension.c : Dimension_Text_Basic() : in\n");

	if (TextFrag == SCD_HIDE)
		color = sagcad_color.Back;
	else if (TextFrag == SCD_SELECT)
		color = sagcad_color.Select;


	DrawTextVector (widget,	a, color);

//g_print("Dimension.c : Dimension_Text_Basic() : out\n");

	return 1;
}





/* -------------------------------------------------------------------
 * ʿˡ (׻)
 * -------------------------------------------------------------------
 *	
 * (X[1],Y[1]) , (X[2],Y[2]) , (X[3],Y[3]) ׻
 *	
 *	
 *	
 *				   (X[4],Y[4])				 (X[5],Y[5])
 *						   l		 (X[3],Y[3])		  l
 * (X[6],Y[6]) +---->+<----------------+--------------->+<----+(X[6],Y[6])
 *						   l								  l
 *						   l								  l
 *						   l								  l
 *						   l								  l
 *						   l								  l
 *						   l								  l
 *						   +								  +
 *				   (X[1],Y[1])				 (X[2],Y[2])
 *	
 *	
 *	
 * Save Data   (X[1],Y[1]) , (X[2],Y[2]) , (X[3],Y[3])
 * -------------------------------------------------------------------
 */
int Dimension_X_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	struct RtnDat PAPH;
	double X[4], Y[4];


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	/* ޥɤ߼äɸ */
	X[1] = PicPoint.X[1];
	Y[1] = PicPoint.Y[1];
	X[2] = PicPoint.X[2];
	Y[2] = PicPoint.Y[2];
	a->SearchPointX = PicPoint.X[3];
	a->SearchPointY = PicPoint.Y[3];


	/* X[1] < X[2] ˤ롣*/
	if (X[1] > X[2]) {
		Swap_double(&X[1], &X[2]);
		Swap_double(&Y[1], &Y[2]);
	}

	/* ˡͤ a->Text  */
	if (a->Text != '\0')
//		FloatOut(a->Text, sg(X[2] - X[1], sagcad_dimension.dimension_figure), 0);
		FloatOut_n(a->Text, X[2] - X[1], sagcad_dimension.dimension_figure, 0);





	/* a->SearchPointX  X[2] 礭Ȥˡͤϱ¦롣
	 * ˡͤΰ֤ϡa->SearchPointX Ǥ
	 * ϳ˳ΤǡˡͤȿФĹФ
	 */
	if (X[2] < a->SearchPointX) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* ()αĹ : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = X[1];
		a->AssistLine[2].ey = a->SearchPointY;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* ξü˵ : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = X[1];
		a->AssistLine[3].sy = a->SearchPointY;
		a->AssistLine[3].ex = X[2];
		a->AssistLine[3].ey = a->SearchPointY;
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->Angle = 0;
		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* a->SearchPointX  X[1] ⾮ȤˡͤϺ¦롣
	 * ˡͤΰ֤ϡa->SearchPointX Ǥ
	 * ϳ˳ΤǡˡͤȿФĹФ
	 * κɸ (X[6],Y[6])
	 */
	else if ( X[1] > a->SearchPointX) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/*  : 1 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = X[2];
		a->AssistLine[2].ey = a->SearchPointY;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* ξü˵ : 32 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = X[1];
		a->AssistLine[3].sy = a->SearchPointY;
		a->AssistLine[3].ex = X[2];
		a->AssistLine[3].ey = a->SearchPointY;
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->Angle = 0;
		a->StartPoint = 0;
		a->FitPointX = 0;
		a->FitPointY = 1;
	}

	/* a->SearchPointX  X[1]  X[2] δ֤ˤȤˡͤϿ롣
	 * ˡͤΰ֤ϡa->SearchPointX ˷׻ƽ
	 * (X[6],Y[6]) ϻȤʤ
	 */
	else {
		if (a->AssistLine == NULL) {
			a->index = 3;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 3;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		PAPH.sx[1] = X[1];
		PAPH.sy[1] = a->SearchPointY;
		PAPH.ex[1] = X[2];
		PAPH.ey[1] = a->SearchPointY;
		PAPH.sx[2] = 1;
		PAPH.ex[2] = 1;
		ppp(&PAPH);

		/* ξü : 16 */
		a->AssistLine[2].defin = 21;
		a->AssistLine[2].sx = X[1];
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = X[2];
		a->AssistLine[2].ey = a->SearchPointY;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;

		a->Angle = 0;
		a->SearchPointX = PAPH.sx[3];
		a->SearchPointY = PAPH.sy[3];
		a->StartPoint = 1;
		a->FitPointX = 1;
		a->FitPointY = 1;
	}


	/* -----------------------------------------------------
	 *  1 : 70 
	 */
	/*  (X[1],Y[1]) ľ */
	/* PAP	ȳ٤ȵΥľν */
	PAPH.l = a->SearchPointY - Y[1];
	/* a->SearchPointY-Y[1] ʤ顢90 */
	if (PAPH.l >= 0) {
		PAPH.angle = 90;
	}
	/* a->SearchPointY-Y[1] ʤ顢-90٤Ĺˤ */
	else if ( PAPH.l < 0) {
		PAPH.angle = -90;
		PAPH.l = (-1 * PAPH.l);
	}
	/*  */
	PAPH.l = PAPH.l;
	PAPH.sx[1] = X[1];
	PAPH.sy[1] = Y[1];
	pap(&PAPH);

	a->AssistLine[0].defin = 70;
	a->AssistLine[0].sx = X[1];
	a->AssistLine[0].sy = Y[1];
	a->AssistLine[0].ex = PAPH.ex[1];
	a->AssistLine[0].ey = PAPH.ey[1];
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;


	/* -----------------------------------------------------
	 *  2 : 70 
	 */
	/*  (X[2],Y[2]) ľ */
	PAPH.l = a->SearchPointY - Y[2];
	/* a->SearchPointY-Y[2] ʤ顢90 */
	if (PAPH.l >= 0) {
		PAPH.angle = 90;
	}
	/* a->SearchPointY-Y[2] ʤ顢-90٤Ĺˤ */
	else if ( PAPH.l < 0) {
		PAPH.angle = -90;
		PAPH.l = -1 * PAPH.l;
	}
	/*  */
	PAPH.l = PAPH.l;
	PAPH.sx[1] = X[2];
	PAPH.sy[1] = Y[2];
	pap(&PAPH);

	a->AssistLine[1].defin = 70;
	a->AssistLine[1].sx = X[2];
	a->AssistLine[1].sy = Y[2];
	a->AssistLine[1].ex = PAPH.ex[1];
	a->AssistLine[1].ey = PAPH.ey[1];
	a->AssistLine[1].cx = 0;
	a->AssistLine[1].cy = 0;
	a->AssistLine[1].r = 0;

	return 1;
}





/* -------------------------------------------------------------------
 * ľˡ (׻)
 * -------------------------------------------------------------------
 *	
 * (X[1],Y[1]) , (X[2],Y[2]) , (X[3],Y[3]) ׻
 * Save Data   (X[1],Y[1]) , (X[2],Y[2]) , (X[3],Y[3])
 * -------------------------------------------------------------------
 */
int Dimension_Y_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	struct RtnDat PAPH;
	double X[4], Y[4];


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	/* ޥɤ߼äɸ */
	X[1] = PicPoint.X[1];
	Y[1] = PicPoint.Y[1];
	X[2] = PicPoint.X[2];
	Y[2] = PicPoint.Y[2];
	a->SearchPointX = PicPoint.X[3];
	a->SearchPointY = PicPoint.Y[3];


	/* Y[1] < Y[2] ˤ롣*/
	if (Y[1] > Y[2]) {
		Swap_double(&X[1], &X[2]);
		Swap_double(&Y[1], &Y[2]);
	}


	/* ˡͤ a->Text  */
	if (a->Text != '\0')
		FloatOut_n(a->Text, Y[2] - Y[1], sagcad_dimension.dimension_figure, 0);
//		FloatOut(a->Text, sg(Y[2] - Y[1], sagcad_dimension.dimension_figure), 0);





	/* a->SearchPointY  Y[2] 礭Ȥˡͤϲ¦롣
	 * ˡͤΰ֤ϡa->SearchPointY Ǥ
	 * ϳ˳ΤǡˡͤȿФĹФ
	 */
	if (Y[2] < a->SearchPointY) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* ()αĹ : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = a->SearchPointX;
		a->AssistLine[2].ey = Y[1];
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* ξü˵ : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = a->SearchPointX;
		a->AssistLine[3].sy = Y[2];
		a->AssistLine[3].ex = a->SearchPointX;
		a->AssistLine[3].ey = Y[1];
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->Angle = 90;
		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* a->SearchPointY  Y[1] ⾮ȤˡͤϾ¦롣
	 * ˡͤΰ֤ϡa->SearchPointY Ǥ
	 * ϳ˳ΤǡˡͤȿФĹФ
	 * κɸ (X[6],Y[6])
	 */
	else if ( Y[1] > a->SearchPointY) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* ()αĹ : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = a->SearchPointX;
		a->AssistLine[2].ey = Y[2];
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* ξü˵ : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = a->SearchPointX;
		a->AssistLine[3].sy = Y[1];
		a->AssistLine[3].ex = a->SearchPointX;
		a->AssistLine[3].ey = Y[2];
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->Angle = 90;
		a->StartPoint = 0;
		a->FitPointX = 0;
		a->FitPointY = 1;
	}

	/* a->SearchPointY  Y[1]  Y[2] δ֤ˤȤˡͤϿ롣
	 * ˡͤΰ֤ϡa->SearchPointY ˷׻ƽ
	 * (X[6],Y[6]) ϻȤʤ
	 */
	else {
		if (a->AssistLine == NULL) {
			a->index = 3;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 3;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		PAPH.sx[1] = a->SearchPointX;
		PAPH.sy[1] = Y[1];
		PAPH.ex[1] = a->SearchPointX;
		PAPH.ey[1] = Y[2];
		PAPH.sx[2] = 1;
		PAPH.ex[2] = 1;
		ppp(&PAPH);

		/* ξü : 16 */
		a->AssistLine[2].defin = 21;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = Y[1];
		a->AssistLine[2].ex = a->SearchPointX;
		a->AssistLine[2].ey = Y[2];
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;

		a->Angle = 90;
		a->SearchPointX = PAPH.sx[3];
		a->SearchPointY = PAPH.sy[3];
		a->StartPoint = 1;
		a->FitPointX = 1;
		a->FitPointY = 1;
	}





	/* -----------------------------------------------------
	 *  1 : 70 
	 */
	/*  (X[1],Y[1]) ľ*/
	PAPH.l = a->SearchPointX - X[1];
	/* a->SearchPointX-X[1] ʤ顢0 */
	if (PAPH.l >= 0) {
		PAPH.angle = 0;
	}
	/* a->SearchPointX-XY[1] ʤ顢180٤Ĺˤ */
	else if ( PAPH.l < 0) {
		PAPH.angle = 180;
		PAPH.l = (-1 * PAPH.l);
	}
	/* Ĺ */
	PAPH.l = PAPH.l;
	PAPH.sx[1] = X[1];
	PAPH.sy[1] = Y[1];
	pap(&PAPH);

	a->AssistLine[0].defin = 70;
	a->AssistLine[0].sx = X[1];
	a->AssistLine[0].sy = Y[1];
	a->AssistLine[0].ex = PAPH.ex[1];
	a->AssistLine[0].ey = PAPH.ey[1];
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;


	/* -----------------------------------------------------
	 *  2 : 70 
	 */
	/*  (X[2],Y[2]) ľ*/
	PAPH.l = a->SearchPointX - X[2];
	/* a->SearchPointX-X[2] ʤ顢0 */
	if (PAPH.l >= 0) {
		PAPH.angle = 0;
	}
	/* a->SearchPointX-X[2] ʤ顢180٤Ĺˤ */
	else if ( PAPH.l < 0) {
		PAPH.angle = 180;
		PAPH.l = (-1 * PAPH.l);
	}
	/* Ĺ */
	PAPH.l = PAPH.l;
	PAPH.sx[1] = X[2];
	PAPH.sy[1] = Y[2];
	pap(&PAPH);
	a->AssistLine[1].defin = 70;
	a->AssistLine[1].sx = X[2];
	a->AssistLine[1].sy = Y[2];
	a->AssistLine[1].ex = PAPH.ex[1];
	a->AssistLine[1].ey = PAPH.ey[1];
	a->AssistLine[1].cx = 0;
	a->AssistLine[1].cy = 0;
	a->AssistLine[1].r = 0;


	return 1;
}





/* -------------------------------------------------------------------
 * Υˡ (׻)
 *	
 *	
 */
int Dimension_P_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
//#define DIMENSION_P_CULC_TEST
#ifdef DIMENSION_P_CULC_TEST
	char str[256];
#endif

	struct RtnDat PPH, PLLH, LAH, PAPH, LLPH, PPPH;
	double P1X, P1Y, P2X, P2Y;
	double X[4], Y[4];


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	/* ޥɤ߼äɸ */
	X[1] = PicPoint.X[1];
	Y[1] = PicPoint.Y[1];
	X[2] = PicPoint.X[2];
	Y[2] = PicPoint.Y[2];
	a->SearchPointX = PicPoint.X[3];
	a->SearchPointY = PicPoint.Y[3];

	/* X[1] < X[2] ˤ */
	if (X[1] > X[2]) {
		Swap_double(&X[1], &X[2]);
		Swap_double(&Y[1], &Y[2]);
	}
	else if (X[1] == X[2] && Y[1] > Y[2]) {
		Swap_double(&X[1], &X[2]);
		Swap_double(&Y[1], &Y[2]);
	}

	/* -------------------------------------------
	 * εΥơ ˡ a->Text 롣
	 */
	PPH.sx[1] = X[1];
	PPH.sy[1] = Y[1];
	PPH.ex[1] = X[2];
	PPH.ey[1] = Y[2];
	pp(&PPH);

	/* ˡͤ a->Text  */
	if (a->Text != '\0')
		FloatOut_n(a->Text, PPH.l, sagcad_dimension.dimension_figure, 0);
//		FloatOut(a->Text, sg(PPH.l, sagcad_dimension.dimension_figure), 0);

	/* -------------------------------------------
	 * 3 ̤äơ1 2 ޤǤʿԤľ3 
	 * (PLL	̤ꡢľʿԤľ)
	 */
	PLLH.sx[1] = a->SearchPointX;
	PLLH.sy[1] = a->SearchPointY;
	PLLH.sx[2] = X[1];
	PLLH.sy[2] = Y[1];
	PLLH.ex[2] = X[2];
	PLLH.ey[2] = Y[2];
	pll(&PLLH);


	/* -------------------------------------------
	 * ޤǤ1,2γ٤롣
	 * (LA	  ľγ)
	 */
	LAH.sx[1] = X[1];
	LAH.sy[1] = Y[1];
	LAH.ex[1] = X[2];
	LAH.ey[1] = Y[2];
	la(&LAH);

	/* ˡʸγ */
	a->Angle = (float) sg(LAH.angle, 3);





	/*  (P1X,P1Y)4 & (P2X,P2Y)5  */

	/* (P1X,P1Y)4 */

	/* -------------------------------------------
	 * ľ򤹤٤ȡȤθ
	 * (PAP	ȳ٤ȵΥľν)
	 */
	PAPH.sx[1] = X[1];
	PAPH.sy[1] = Y[1];
	PAPH.angle = LAH.angle + 90;
	PAPH.l = 50;
	pap(&PAPH);

	/* LLP	 ľθ */
	LLPH.sx[1] = X[1];
	LLPH.sy[1] = Y[1];
	LLPH.ex[1] = PAPH.ex[1];
	LLPH.ey[1] = PAPH.ey[1];
	LLPH.sx[2] = PLLH.sx[3];
	LLPH.sy[2] = PLLH.sy[3];
	LLPH.ex[2] = PLLH.ex[3];
	LLPH.ey[2] = PLLH.ey[3];
	llp(&LLPH);
	P1X = sg(LLPH.sx[3], 6);
	P1Y = sg(LLPH.sy[3], 6);

#ifdef DIMENSION_P_CULC_TEST
	sprintf(str, "Dimension_P_Culc 1 : LINE 1 (%f , %f)-(%f , %f)\n", LLPH.sx[1], LLPH.sy[1], LLPH.ex[1], LLPH.ey[1]);
	OneShotLog(str);
	sprintf(str, "Dimension_P_Culc 1 : LINE 2 (%f , %f)-(%f , %f)\n", LLPH.sx[2], LLPH.sy[2], LLPH.ex[2], LLPH.ey[2]);
	OneShotLog(str);
	sprintf(str, "Dimension_P_Culc 1 : CROSS POINT (%f , %f)\n", LLPH.sx[3], LLPH.sy[3]);
	OneShotLog(str);
#endif


	/* (P2X,P2Y)5 */

	/* -------------------------------------------
	 * ľ򤹤٤ȡȤθ
	 * (PAP	ȳ٤ȵΥľν)
	 */
	PAPH.sx[1] = X[2];
	PAPH.sy[1] = Y[2];
	PAPH.angle = LAH.angle + 90;
	PAPH.l = 50;
	pap(&PAPH);

	/* LLP	 ľθ */
	LLPH.sx[1] = X[2];
	LLPH.sy[1] = Y[2];
	LLPH.ex[1] = PAPH.ex[1];
	LLPH.ey[1] = PAPH.ey[1];
	LLPH.sx[2] = PLLH.sx[3];
	LLPH.sy[2] = PLLH.sy[3];
	LLPH.ex[2] = PLLH.ex[3];
	LLPH.ey[2] = PLLH.ey[3];
	llp(&LLPH);
	P2X = sg(LLPH.sx[3], 6);
	P2Y = sg(LLPH.sy[3], 6);

#ifdef DIMENSION_P_CULC_TEST
	sprintf(str, "Dimension_P_Culc 2 : LINE 1 (%f , %f)-(%f , %f)\n", LLPH.sx[1], LLPH.sy[1], LLPH.ex[1], LLPH.ey[1]);
	OneShotLog(str);
	sprintf(str, "Dimension_P_Culc 2 : LINE 2 (%f , %f)-(%f , %f)\n", LLPH.sx[2], LLPH.sy[2], LLPH.ex[2], LLPH.ey[2]);
	OneShotLog(str);
	sprintf(str, "Dimension_P_Culc 2 : CROSS POINT (%f , %f)\n", LLPH.sx[3], LLPH.sy[3]);
	OneShotLog(str);
#endif





	/*  3 & 6  */

	/* ˡͤ¦Ȥ */
	/* a->SearchPointX  X[5] 礭Ȥˡͤϱ¦롣
	 * ˡͤΰ֤ϡa->SearchPointX Ǥ
	 * ϳ˳ΤǡˡͤȿФĹФ
	 * κɸ (X[6],Y[6])
	 */
	if ((X[1] != X[2] && P2X < a->SearchPointX) || (X[1] == X[2] && P2Y < a->SearchPointY)) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* ()αĹ : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = P1X;
		a->AssistLine[2].ey = P1Y;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* ξü˵ : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = P1X;
		a->AssistLine[3].sy = P1Y;
		a->AssistLine[3].ex = P2X;
		a->AssistLine[3].ey = P2Y;
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* ˡͤ¦Ȥ */
	/* a->SearchPointX  X[4] 礭ȤˡͤϺ¦롣
	 * ˡͤΰ֤ϡa->SearchPointX Ǥ
	 * ϳ˳ΤǡˡͤȿФĹФ
	 * κɸ (X[6],Y[6])
	 */
	else if ((X[1] != X[2] && P1X > a->SearchPointX) || (X[1] == X[2] && P1Y > a->SearchPointY)) {
		if (a->AssistLine == NULL) {
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 4;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* ()αĹ : 80 */
		a->AssistLine[2].defin = 80;
		a->AssistLine[2].sx = a->SearchPointX;
		a->AssistLine[2].sy = a->SearchPointY;
		a->AssistLine[2].ex = P2X;
		a->AssistLine[2].ey = P2Y;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;
		/* ξü˵ : 30 */
		a->AssistLine[3].defin = 30;
		a->AssistLine[3].sx = P1X;
		a->AssistLine[3].sy = P1Y;
		a->AssistLine[3].ex = P2X;
		a->AssistLine[3].ey = P2Y;
		a->AssistLine[3].cx = 0;
		a->AssistLine[3].cy = 0;
		a->AssistLine[3].r = 0;

		a->StartPoint = 0;
		a->FitPointX = 0;
		a->FitPointY = 1;
	}


	/* ȸ (a->SearchPointX,a->SearchPointY) ˤ */
	else {
		if (a->AssistLine == NULL) {
			a->index = 3;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 3;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		PPPH.sx[1] = P1X;
		PPPH.sy[1] = P1Y;
		PPPH.ex[1] = P2X;
		PPPH.ey[1] = P2Y;
		PPPH.sx[2] = 1;
		PPPH.ex[2] = 1;
		ppp(&PPPH);

		a->SearchPointX = sg(PPPH.sx[3], 3);
		a->SearchPointY = sg(PPPH.sy[3], 3);


		/* ξü : 16 */
		a->AssistLine[2].defin = 21;
		a->AssistLine[2].sx = P1X;
		a->AssistLine[2].sy = P1Y;
		a->AssistLine[2].ex = P2X;
		a->AssistLine[2].ey = P2Y;
		a->AssistLine[2].cx = 0;
		a->AssistLine[2].cy = 0;
		a->AssistLine[2].r = 0;

		a->StartPoint = 1;
		a->FitPointX = 1;
		a->FitPointY = 1;
	}


	a->AssistLine[0].defin = 70;
	a->AssistLine[0].sx = X[1];
	a->AssistLine[0].sy = Y[1];
	a->AssistLine[0].ex = P1X;
	a->AssistLine[0].ey = P1Y;
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;

	a->AssistLine[1].defin = 70;
	a->AssistLine[1].sx = X[2];
	a->AssistLine[1].sy = Y[2];
	a->AssistLine[1].ex = P2X;
	a->AssistLine[1].ey = P2Y;
	a->AssistLine[1].cx = 0;
	a->AssistLine[1].cy = 0;
	a->AssistLine[1].r = 0;


	DimensionAngleCH(&a->Angle, &a->StartPoint);
	if (a->StartPoint > 9) {
		a->FitPointY = 4;
		a->FitPointX = a->StartPoint - 10;
	}
	else {
		a->FitPointX = a->StartPoint;
		a->FitPointY = 1;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * Ⱦˡ (׻)
 *	
 * CX,CY   ߤ濴
 * a->SearchPointX,a->SearchPointY	 å
 * R		   Ⱦ
 */
int Dimension_R_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	char str[256];
	struct RtnDat LAH, LCPH, PPH;
	double LL, CX, CY, R, SA, EA, ArrowPointX = 0, ArrowPointY = 0;

//MsgBox("TEST", "Dimension_R_Culc : in");

	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	/* ޥɤ߼äɸ */
	CX = PicPoint.X[1];
	CY = PicPoint.Y[1];
	R = PicPoint.X[3];
	SA = PicPoint.X[4];
	EA = PicPoint.Y[4];
	a->SearchPointX = PicPoint.X[2];
	a->SearchPointY = PicPoint.Y[2];

//sprintf (str, "%f", R);
//MsgBox("Dimension_R_Culc", str);

	/* ˡͤ a->Text  */
	if (a->Text != '\0') {
//		FloatOut(str, R, 0);
		FloatOut_n(str, R * 1, sagcad_dimension.dimension_figure, 0);
		sprintf(a->Text, "R%s", str);
	}


	/* -------------------------------------------
	 * ߤ濴饯åγ٤ӣţϰϤĴ٤롣
	 * LA	  ľγ
	 */
	LAH.sx[1] = CX;
	LAH.sy[1] = CY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);
	
	if (SA < EA) {
		if (LAH.angle < SA || LAH.angle > EA) {
			a->index = 0;
			a->AssistLine = NULL;
			a->Angle = 0;
			strcpy(a->Text, "NOT DRAW");
			return 0;
		}
	}
	else if ( SA > EA) {
		if (LAH.angle < SA && LAH.angle > EA) {
			a->index = 0;
			a->AssistLine = NULL;
			a->Angle = 0;
			strcpy(a->Text, "NOT DRAW");
			return 0;
		}
	}
	a->Angle = (float) LAH.angle;

	/* ---------------------------------
	 * Ĥ߸̤ȡ߸̤濴饯åޤǤȤθ롣
	 * LCP ľȱߤθ	 ƤΥեå P126
	 */
	LCPH.sx[1] = CX;
	LCPH.sy[1] = CY;
	LCPH.ex[1] = a->SearchPointX;
	LCPH.ey[1] = a->SearchPointY;
	LCPH.cx[1] = CX;
	LCPH.cy[1] = CY;
	LCPH.r[1] = R;
	lcp(&LCPH);

	/* ---------------------------------
	 * åȶᤤθ롣
	 * PP	  ֤εΥ
	 */
	PPH.sx[1] = a->SearchPointX;
	PPH.sy[1] = a->SearchPointY;
	PPH.ex[1] = LCPH.sx[2];
	PPH.ey[1] = LCPH.sy[2];
	pp(&PPH);
	LL = PPH.l;

	PPH.sx[1] = a->SearchPointX;
	PPH.sy[1] = a->SearchPointY;
	PPH.ex[1] = LCPH.sx[3];
	PPH.ey[1] = LCPH.sy[3];
	pp(&PPH);

	if (LL < PPH.l) {
		ArrowPointX = LCPH.sx[2];
		ArrowPointY = LCPH.sy[2];
	}
			
	if (LL > PPH.l) {
		ArrowPointX = LCPH.sx[3];
		ArrowPointY = LCPH.sy[3];
	}

	/* ---------------------------------
	 * ߤ濴饯åεΥȾ¤礭
	 * PP	  ֤εΥ
	 */
	PPH.sx[1] = CX;
	PPH.sy[1] = CY;
	PPH.ex[1] = a->SearchPointX;
	PPH.ey[1] = a->SearchPointY;
	pp(&PPH);


	/* åߤ */
	if (PPH.l < R) {
		if (a->AssistLine == NULL) {
			a->index = 1;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 1;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		a->AssistLine[0].defin = 11;
		a->AssistLine[0].sx = CX;
		a->AssistLine[0].sy = CY;
		a->AssistLine[0].ex = ArrowPointX;
		a->AssistLine[0].ey = ArrowPointY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

//		a->SearchPointX = CX;
//		a->SearchPointY = CY;
		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* åߤγ */
	if (PPH.l > R) {
		if (a->AssistLine == NULL) {
			a->index = 2;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 2;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		a->AssistLine[0].defin = 1;
		a->AssistLine[0].sx = CX;
		a->AssistLine[0].sy = CY;
		a->AssistLine[0].ex = a->SearchPointX;
		a->AssistLine[0].ey = a->SearchPointY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

		a->AssistLine[1].defin = 10;
		a->AssistLine[1].sx = a->SearchPointX;
		a->AssistLine[1].sy = a->SearchPointY;
		a->AssistLine[1].ex = ArrowPointX;
		a->AssistLine[1].ey = ArrowPointY;
		a->AssistLine[1].cx = 0;
		a->AssistLine[1].cy = 0;
		a->AssistLine[1].r = 0;

		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}
//MsgBox("TEST", "Dimension_R_Culc : out");
	DimensionAngleCH(&a->Angle, &a->StartPoint);
	if (a->StartPoint > 9) {
		a->FitPointY = 4;
		a->FitPointX = a->StartPoint - 10;
	}
	else {
		a->FitPointX = a->StartPoint;
		a->FitPointY = 1;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * ľˡ (׻)
 *	
 */
int Dimension_D_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	char str[256];
	struct RtnDat LAH, LCPH, PPH;
	double LL, CX, CY, R, ArrowPointX_Pic = 0, ArrowPointY_Pic = 0, ArrowPointX = 0, ArrowPointY = 0;


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	CX = PicPoint.X[1];
	CY = PicPoint.Y[1];
	R = PicPoint.X[6];
	a->SearchPointX = PicPoint.X[2];
	a->SearchPointY = PicPoint.Y[2];


	/* ˡͤ a->Text  */
	if (a->Text != '\0') {
		FloatOut_n(str, R * 2, sagcad_dimension.dimension_figure, 0);
//		FloatOut(str, sg(R * 2, 3), 0);
		sprintf(a->Text, "%s", str);
	}


	/* ˡͤγ */
	/* LA	  ľγ */
	LAH.sx[1] = CX;
	LAH.sy[1] = CY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);
	a->Angle = (float) LAH.angle;


	/* Ĥߤȡߤ濴饯åޤǤȤθ롣 */
	/* LCP ľȱߤθ	 ƤΥեå P126 */
	LCPH.sx[1] = CX;
	LCPH.sy[1] = CY;
	LCPH.ex[1] = a->SearchPointX;
	LCPH.ey[1] = a->SearchPointY;
	LCPH.cx[1] = CX;
	LCPH.cy[1] = CY;
	LCPH.r[1] = R;
	lcp(&LCPH);


	/* åȶᤤθ(X[3],Y[3])롣 */
	/* PP	  ֤εΥ */
	/*  */
	PPH.sx[1] = a->SearchPointX;
	PPH.sy[1] = a->SearchPointY;
	PPH.ex[1] = LCPH.sx[2];
	PPH.ey[1] = LCPH.sy[2];
	pp(&PPH);
	LL = PPH.l;

	/*  */
	PPH.sx[1] = a->SearchPointX;
	PPH.sy[1] = a->SearchPointY;
	PPH.ex[1] = LCPH.sx[3];
	PPH.ey[1] = LCPH.sy[3];
	pp(&PPH);

	if (LL <= PPH.l) {
		ArrowPointX_Pic = LCPH.sx[2];
		ArrowPointY_Pic = LCPH.sy[2];
		ArrowPointX 	= LCPH.sx[3];
		ArrowPointY 	= LCPH.sy[3];
	}
	else if (LL > PPH.l) {
		ArrowPointX_Pic = LCPH.sx[3];
		ArrowPointY_Pic = LCPH.sy[3];
		ArrowPointX 	= LCPH.sx[2];
		ArrowPointY 	= LCPH.sy[2];
	}


	/* ߤ濴饯åεΥȾ¤礭 */
	/* PP	  ֤εΥ */
	PPH.sx[1] = CX;
	PPH.sy[1] = CY;
	PPH.ex[1] = a->SearchPointX;
	PPH.ey[1] = a->SearchPointY;
	pp(&PPH);

	/* åߤ */
	if (PPH.l < R) {
		if (a->AssistLine == NULL) {
			a->index = 1;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 1;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* ξü() */
		a->AssistLine[0].defin = 21;
		a->AssistLine[0].sx = ArrowPointX_Pic;
		a->AssistLine[0].sy = ArrowPointY_Pic;
		a->AssistLine[0].ex = ArrowPointX;
		a->AssistLine[0].ey = ArrowPointY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}

	/* åߤγ */
	if (PPH.l > R) {
		if (a->AssistLine == NULL) {
			a->index = 2;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}
		else {
			xfree(a->AssistLine);
			a->index = 2;
			/* ǡ (AssistLine) 񤭹िΰݤ */
			a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
		}

		/* ξü() */
		a->AssistLine[0].defin = 21;
		a->AssistLine[0].sx = ArrowPointX_Pic;
		a->AssistLine[0].sy = ArrowPointY_Pic;
		a->AssistLine[0].ex = ArrowPointX;
		a->AssistLine[0].ey = ArrowPointY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

		a->AssistLine[1].defin = 1;
		a->AssistLine[1].sx = ArrowPointX_Pic;
		a->AssistLine[1].sy = ArrowPointY_Pic;
		a->AssistLine[1].ex = a->SearchPointX;
		a->AssistLine[1].ey = a->SearchPointY;
		a->AssistLine[1].cx = 0;
		a->AssistLine[1].cy = 0;
		a->AssistLine[1].r = 0;

		a->StartPoint = 2;
		a->FitPointX = 2;
		a->FitPointY = 1;
	}
	DimensionAngleCH(&a->Angle, &a->StartPoint);
	if (a->StartPoint > 9) {
		a->FitPointY = 4;
		a->FitPointX = a->StartPoint - 10;
	}
	else {
		a->FitPointX = a->StartPoint;
		a->FitPointY = 1;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * ˡ (׻)
 *	
 *	
 * (X[1],Y[1])		濴
 * (X[2],Y[2])		
 * (X[3],Y[3])		
 * (X[4],Y[4])		å
 */
int Dimension_A_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	struct RtnDat PPH, LAH, PAPH;
	double ctX, ctY, saX, saY, eaX, eaY, SA = 0, EA = 0, EX1, EY1, EX2, EY2;
	double DUMY, L, Ang1, Ang2, AngK;
	char str[256];


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	ctX = PicPoint.X[1];
	ctY = PicPoint.Y[1];
	saX = PicPoint.X[2];
	saY = PicPoint.Y[2];
	eaX = PicPoint.X[3];
	eaY = PicPoint.Y[3];
	a->SearchPointX = PicPoint.X[4];
	a->SearchPointY = PicPoint.Y[4];


	/* 濴ȥåεΥ */
	/* PP	  ֤εΥ */
	PPH.sx[1] = ctX;
	PPH.sy[1] = ctY;
	PPH.ex[1] = a->SearchPointX;
	PPH.ey[1] = a->SearchPointY;
	pp(&PPH);
	L = PPH.l;

	/* 濴饯åγ AngK 롣 */
	/* LA	  ľγ */
	LAH.sx[1] = ctX;
	LAH.sy[1] = ctY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);
	AngK = LAH.angle;

	/* 濴γ Ang1 롣 */
	/* LA	  ľγ */
	LAH.sx[1] = ctX;
	LAH.sy[1] = ctY;
	LAH.ex[1] = saX;
	LAH.ey[1] = saY;
	la(&LAH);
	Ang1 = LAH.angle;
	if (Ang1 > 360) Ang1 = Ang1 - 360;

	/* 濴γ Ang2 롣 */
	/* LA	  ľγ */
	LAH.sx[1] = ctX;
	LAH.sy[1] = ctY;
	LAH.ex[1] = eaX;
	LAH.ey[1] = eaY;
	la(&LAH);
	Ang2 = LAH.angle;
	if (Ang2 > 360) Ang2 = Ang2 - 360;


	/* Ang2  Ang1 礭
	 * Ang2 礭ʤ褦˥ǡ򤤤줫
	 */
	if (Ang1 > Ang2) {
		Swap_double(&Ang1, &Ang2);
		Swap_double(&saX, &eaX);
		Swap_double(&saY, &eaY);
	}


	/* -----------------------------------------------------
	 * AngK  Ang1 礭Ang2 ⾮Ȥ
	 * 
	 * 
	 */
	if (Ang1 < AngK && AngK < Ang2) {
		SA = Ang1;
		EA = Ang2;
		DUMY = Ang2 - Ang1;

		/* ˡͤ a->Text  */
		if (a->Text != '\0') {
			FloatOut_n(str, DUMY, sagcad_dimension.dimension_figure, 0);
//			FloatOut(str, sg(DUMY, sagcad_dimension.dimension_figure), 0);
			sprintf(a->Text, "%s", str);
		}


		DUMY = Ang1 + (DUMY / 2);
		/* PAP	ȳ٤ȵΥľν */
		PAPH.sx[1] = ctX;
		PAPH.sy[1] = ctY;
		PAPH.angle = DUMY;
		PAPH.l = L;
		pap(&PAPH);
		a->SearchPointX = PAPH.ex[1];
		a->SearchPointY = PAPH.ey[1];
	}


	/* -----------------------------------------------------
	 * AngK  Ang2 ⾮Ang1 礭Ȥ
	 * 
	 * 
	 */
	if (Ang2 < AngK || Ang1 > AngK) {
		SA = Ang2;
		EA = Ang1;
		DUMY = sg((360 - Ang2) + Ang1, 3);


		/* ˡͤ a->Text  */
		if (a->Text != '\0') {
			FloatOut_n(str, DUMY, sagcad_dimension.dimension_figure, 0);
//			FloatOut(str, sg(DUMY, sagcad_dimension.dimension_figure), 0);
			sprintf(a->Text, "%s", str);
		}


		DUMY = Ang2 + (DUMY / 2);
		/* PAP	ȳ٤ȵΥľν */
		PAPH.sx[1] = ctX;
		PAPH.sy[1] = ctY;
		PAPH.angle = DUMY;
		PAPH.l = L;
		pap(&PAPH);
		a->SearchPointX = PAPH.ex[1];
		a->SearchPointY = PAPH.ey[1];
	}



	/* PAP	ȳ٤ȵΥľν */
	PAPH.sx[1] = ctX;
	PAPH.sy[1] = ctY;
	PAPH.angle = SA;
	PAPH.l = L;  /* + bow(a->DrawType); */
	pap(&PAPH);
	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = ctX;
	PAPH.sy[1] = ctY;
	PAPH.angle = EA;
	PAPH.l = L;  /* + bow(a->DrawType); */
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];


	/* LA	  ľγ */
	LAH.sx[1] = ctX;
	LAH.sy[1] = ctY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);

	a->Angle = (float) LAH.angle + 90;



	if (a->AssistLine == NULL) {
		a->index = 3;
		/* ǡ (AssistLine) 񤭹िΰݤ */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}
	else {
		xfree(a->AssistLine);
		a->index = 3;
		/* ǡ (AssistLine) 񤭹िΰݤ */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}

	/* ξü() */
	a->AssistLine[0].defin = 70;
	a->AssistLine[0].sx = ctX;
	a->AssistLine[0].sy = ctY;
	a->AssistLine[0].ex = EX1;
	a->AssistLine[0].ey = EY1;
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;

	a->AssistLine[1].defin = 70;
	a->AssistLine[1].sx = ctX;
	a->AssistLine[1].sy = ctY;
	a->AssistLine[1].ex = EX2;
	a->AssistLine[1].ey = EY2;
	a->AssistLine[1].cx = 0;
	a->AssistLine[1].cy = 0;
	a->AssistLine[1].r = 0;

	a->AssistLine[2].defin = 61;
	a->AssistLine[2].sx = EX1;
	a->AssistLine[2].sy = EY1;
	a->AssistLine[2].ex = EX2;
	a->AssistLine[2].ey = EY2;
	a->AssistLine[2].cx = ctX;
	a->AssistLine[2].cy = ctY;
	a->AssistLine[2].r	= L;

	a->StartPoint = 1;
	a->FitPointX = 1;
	a->FitPointY = 1;

	DimensionAngleCH(&a->Angle, &a->StartPoint);
	if (a->StartPoint > 9) {
		a->FitPointY = 4;
		a->FitPointX = a->StartPoint - 10;
	}
	else {
		a->FitPointX = a->StartPoint;
		a->FitPointY = 1;
	}
	return 1;
}





/* -------------------------------------------------------------------
 * ˡ (׻)
 *	
 *	
 */
int Dimension_HD_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	struct RtnDat PAPH;
	double SX, SY, ESX, ESY, Width;


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	if (a->AssistLine == NULL) {
		a->index = 2;
		/* ǡ (AssistLine) 񤭹िΰݤ */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}
	else {
		xfree(a->AssistLine);
		a->index = 2;
		/* ǡ (AssistLine) 񤭹िΰݤ */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}





	if (PicPoint.X[3] == 0 && PicPoint.Y[3] == 0) {
		SX = PicPoint.X[1];
		SY = PicPoint.Y[1];
		a->SearchPointX = PicPoint.X[2];
		a->SearchPointY = PicPoint.Y[2];

//		if (a->FontType == 0)
//			Width = DrawTextTrue (NULL, a->Text, a->UpperText, a->LowerText, a->Type, a->FontHeight, a->FontSpace, a->Angle, a->DrawType, a->StartPoint, a->SearchPointX, a->SearchPointY, 0, 0);
//		else 
			Width = CulcTextVector (NULL, a);


		if (SX <= a->SearchPointX) {
			/* PAP	ȳ٤ȵΥľν */
			PAPH.sx[1] = a->SearchPointX;
			PAPH.sy[1] = a->SearchPointY;
			PAPH.angle = 0;
			PAPH.l = Width;
			pap(&PAPH);    // ( PAPH.ex[1] , PAPH.ey[1] )

			/*  */
			a->AssistLine[0].defin = 11;
			a->AssistLine[0].sx = a->SearchPointX;
			a->AssistLine[0].sy = a->SearchPointY;
			a->AssistLine[0].ex = SX;
			a->AssistLine[0].ey = SY;
			a->AssistLine[0].cx = 0;
			a->AssistLine[0].cy = 0;
			a->AssistLine[0].r = 0;

			/* ˡΤ */
			a->AssistLine[1].defin = 1;
			a->AssistLine[1].sx = a->SearchPointX;
			a->AssistLine[1].sy = a->SearchPointY;
			a->AssistLine[1].ex = PAPH.ex[1];
			a->AssistLine[1].ey = PAPH.ey[1];
			a->AssistLine[1].cx = 0;
			a->AssistLine[1].cy = 0;
			a->AssistLine[1].r = 0;

			a->Angle = 0;
			a->StartPoint = 2;
			a->FitPointX = 2;
			a->FitPointY = 1;
			a->SearchPointX = PAPH.ex[1];
			a->SearchPointY = PAPH.ey[1];

			return 1;
		}

		else if (SX > a->SearchPointX) {
			/* PAP	ȳ٤ȵΥľν */
			PAPH.sx[1] = a->SearchPointX;
			PAPH.sy[1] = a->SearchPointY;
			PAPH.angle = 180;
			PAPH.l = Width;
			pap(&PAPH);    // ( PAPH.ex[1] , PAPH.ey[1] )
			
			/*  */
			a->AssistLine[0].defin = 11;
			a->AssistLine[0].sx = a->SearchPointX;
			a->AssistLine[0].sy = a->SearchPointY;
			a->AssistLine[0].ex = SX;
			a->AssistLine[0].ey = SY;
			a->AssistLine[0].cx = 0;
			a->AssistLine[0].cy = 0;
			a->AssistLine[0].r = 0;

			/* ˡΤ */
			a->AssistLine[1].defin = 1;
			a->AssistLine[1].sx = a->SearchPointX;
			a->AssistLine[1].sy = a->SearchPointY;
			a->AssistLine[1].ex = PAPH.ex[1];
			a->AssistLine[1].ey = PAPH.ey[1];
			a->AssistLine[1].cx = 0;
			a->AssistLine[1].cy = 0;
			a->AssistLine[1].r = 0;

			a->Angle = 0;
			a->StartPoint = 0;
			a->FitPointX = 0;
			a->FitPointY = 1;
			a->SearchPointX = PAPH.ex[1];
			a->SearchPointY = PAPH.ey[1];

			return 1;
		}
	}





	else {
		SX = PicPoint.X[1];
		SY = PicPoint.Y[1];
		ESX = PicPoint.X[2];
		ESY = PicPoint.Y[2];
		a->SearchPointX = PicPoint.X[3];
		a->SearchPointY = PicPoint.Y[3];


		if (ESX <= a->SearchPointX) {
			a->StartPoint = 2;
			a->FitPointX = 2;
			a->FitPointY = 1;
		}
		else if (ESX > a->SearchPointX) {
			a->StartPoint = 0;
			a->FitPointX = 0;
			a->FitPointY = 1;
		}

		/*  */
		a->AssistLine[0].defin = 11;
		a->AssistLine[0].sx = ESX;
		a->AssistLine[0].sy = ESY;
		a->AssistLine[0].ex = SX;
		a->AssistLine[0].ey = SY;
		a->AssistLine[0].cx = 0;
		a->AssistLine[0].cy = 0;
		a->AssistLine[0].r = 0;

		/* ˡΤ */
		a->AssistLine[1].defin = 1;
		a->AssistLine[1].sx = ESX;
		a->AssistLine[1].sy = ESY;
		a->AssistLine[1].ex = a->SearchPointX;
		a->AssistLine[1].ey = ESY;//a->SearchPointY;
		a->AssistLine[1].cx = 0;
		a->AssistLine[1].cy = 0;
		a->AssistLine[1].r = 0;

		a->SearchPointY = ESY;
		a->Angle = 0;
	}

	return 1;
}





/* -------------------------------------------------------------------
 * ɸˡ (׻)
 *	
 */
int Dimension_PT_Culc(DIMENSION *a, DIMENSION_CULC PicPoint)
{
	char strX[256], strY[256];
	struct RtnDat LAH;
	double PX, PY;


	/*  */
	a->diagram_of_char_index = 0;
	if (a->diagram_of_char != NULL) {
		xfree(a->diagram_of_char);
	}
	a->diagram_of_char = NULL;


	PX = PicPoint.X[1];
	PY = PicPoint.Y[1];
	a->SearchPointX = PicPoint.X[2];
	a->SearchPointY = PicPoint.Y[2];


	/* ˡͤ a->Text  */
	if (a->Text != '\0') {
		FloatOut_n(strX, PX, sagcad_dimension.dimension_figure, 0);
		FloatOut_n(strY, PY, sagcad_dimension.dimension_figure, 0);
//		FloatOut(strX, sg(PX, sagcad_dimension.dimension_figure), 0);
//		FloatOut(strY, sg(PY, sagcad_dimension.dimension_figure), 0);
		sprintf(a->Text, "(%s,%s)", strX, strY);
	}

	a->Angle = 0;


	LAH.sx[1] = PX;
	LAH.sy[1] = PY;
	LAH.ex[1] = a->SearchPointX;
	LAH.ey[1] = a->SearchPointY;
	la(&LAH);
	if ( (LAH.angle > 180) && (LAH.angle < 360) ) {
		a->StartPoint = 11;
		a->FitPointX = 1;
		a->FitPointY = 4;
	}
	else {
		a->StartPoint = 1;
		a->FitPointX = 1;
		a->FitPointY = 1;
	}


	if (a->AssistLine == NULL) {
		a->index = 1;
		/* ǡ (AssistLine) 񤭹िΰݤ */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}
	else {
		xfree(a->AssistLine);
		a->index = 1;
		/* ǡ (AssistLine) 񤭹िΰݤ */
		a->AssistLine = (ASSISTANCE *)xmalloc(a->index * sizeof(ASSISTANCE));
	}

	/* () */
	a->AssistLine[0].defin = 11;
	a->AssistLine[0].sx = a->SearchPointX;
	a->AssistLine[0].sy = a->SearchPointY;
	a->AssistLine[0].ex = PX;
	a->AssistLine[0].ey = PY;
	a->AssistLine[0].cx = 0;
	a->AssistLine[0].cy = 0;
	a->AssistLine[0].r = 0;

	return 1;
}





/* -------------------------------------------------------------------
 * ˡʸγ٤ SagCAD Υγ٤Ѵ
 *	
 * ٤θ  270 < Angle <= 360	0 =< Angle <= 90
 */
int DimensionAngleCH (float *angle, int *point)
{

	/* ޤ٤  0-360 ϰˤ */
	while(*angle < 0) {
		*angle = *angle + 360;
	}
	while (*angle > 360) {
		*angle = *angle - 360;
	}


	/* ٤θ  270 < Angle <= 360	0 =< Angle <= 90 */
	if (*angle > 90 && *angle <= 270) {
		*angle = *angle - 180;
		if (*point == 0) *point = 2;
		else if (*point == 2) *point = 0;
		else if (*point == 10) *point = 12;
		else if (*point == 12) *point = 10;
	}


	/* Ǹˤޤ٤  0-360 ϰˤ */
	while(*angle < 0) {
		*angle = *angle + 360;
	}
	while (*angle > 360) {
		*angle = *angle - 360;
	}

	return 1;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Dimension.c
 * ====================================================================
 */
