/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : LayerSet.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/18
 *    Last                 : 2003/03/21
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "Draw.h"
#include "sagcad.h"
#include "global.h"

#define _LAYERSET_
#include "LayerSet.h"





/* -------------------------------------------------------------------
 * sample_table "expose ()" ٥ȥϥɥ
 * 
 */
gint sample_table_expose_event(GtkWidget *widget, GdkEventExpose *event, LAYERSET_DLG *layerset_dlg)
{
	gint w, h, key;
	GdkGC *lds_gc;
	long BackCol = 0;


	/* widget ͤ */
	key = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "value"));

	/* طʿ */
	/*  */
	if (key == 0) BackCol = 0xff0000;
	else if (key == 1) BackCol = 0xffff00;
	else if (key == 2) BackCol = 0x808000;
	else if (key == 3) BackCol = 0x0000ff;
	else if (key == 4) BackCol = 0x000080;
	else BackCol = 0xffffff;

	/* GC  */
	lds_gc = create_gc(widget);

	/* ɥ󥰥쥢礭 */
	w = widget->allocation.width;
	h = widget->allocation.height;

	PenSet(lds_gc, 1, BackCol);
	gdk_draw_rectangle (widget->window, lds_gc, TRUE, 0, 0, w, h);

	PenSet(lds_gc, 1, 0xe0e0e0);
	gdk_draw_line(widget->window, lds_gc, 0, 0, w, 0);
	gdk_draw_line(widget->window, lds_gc, 0, h, w, h);
	gdk_draw_line(widget->window, lds_gc, 0, 0, 0, h);
	gdk_draw_line(widget->window, lds_gc, w, 0, w, h);

	PenSet(lds_gc, 1, 0x000000);
	gdk_draw_line(widget->window, lds_gc, 1, 1, w-1, 1);
	gdk_draw_line(widget->window, lds_gc, 1, h-1, w-1, h-1);
	gdk_draw_line(widget->window, lds_gc, 1, 1, 1, h-1);
	gdk_draw_line(widget->window, lds_gc, w-1, 1, w-1, h-1);

	/* GC  */
	delete_gc(lds_gc);

	return FALSE;
}





/* -------------------------------------------------------------------
 * OK Button Press
 * 
 */
void layerset_dlg_ok_pushed(GtkWidget *widget, LAYERSET_DLG *layerset_dlg)
{
	layerset_dlg->value = 1;
	return;
}





/* -------------------------------------------------------------------
 * layer_box "expose ()"
 * 
 */
int layer_area_draw(GtkWidget *widget, LAYERSET_DLG *layerset_dlg)
{
	gint w, h, layerNo = -1;
	GdkGC *ld_gc;
	long BackCol = 0, TextCol = 0;
	GdkFont *font;
	char str[256];
	int locateX = 3;


	/* widget ͤ */
	layerNo = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "value"));


	/* ɽʸ */
	if (layerNo < 16) sprintf(str, "0%X", layerNo);
	else sprintf(str, "%X", layerNo);


	/* طʿʸ */
	if (Layer[layerNo].draw == 1 && Layer[layerNo].data == 1) {
		TextCol = 0x000000;
		BackCol = 0xffff00;
	}
	else if (Layer[layerNo].draw == 1 && Layer[layerNo].data == 0) {
		TextCol = 0xffffff;
		BackCol = 0x808000;
	}
	else if (Layer[layerNo].draw == 0 && Layer[layerNo].data == 1) {
		TextCol = 0xffffff;
		BackCol = 0x0000ff;
	}
	else if (Layer[layerNo].draw == 0 && Layer[layerNo].data == 0) {
		TextCol = 0xffffff;
		BackCol = 0x000080;
	}
	
	if (NowLayer == layerNo) {
		TextCol = 0xffffff;
		BackCol = 0xff0000;
	}

	/* GC  */
	ld_gc = gdk_gc_new(widget->window);

	font = gdk_font_load(
		"-adobe-helvetica-medium-r-normal--*-120-*-*-*-*-*-*");


	/* ɥ󥰥쥢礭 */
	w = widget->allocation.width;
	h = widget->allocation.height;

	PenSet(ld_gc, 1, BackCol);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 0, 0, w, h);

	PenSet(ld_gc, 1, 0xe0e0e0);
	gdk_draw_line(widget->window, ld_gc, 0, 0, w, 0);
	gdk_draw_line(widget->window, ld_gc, 0, h, w, h);
	gdk_draw_line(widget->window, ld_gc, 0, 0, 0, h);
	gdk_draw_line(widget->window, ld_gc, w, 0, w, h);

	PenSet(ld_gc, 1, 0x000000);
	gdk_draw_line(widget->window, ld_gc, 1, 1, w-1, 1);
	gdk_draw_line(widget->window, ld_gc, 1, h-1, w-1, h-1);
	gdk_draw_line(widget->window, ld_gc, 1, 1, 1, h-1);
	gdk_draw_line(widget->window, ld_gc, w-1, 1, w-1, h-1);

	/* Хå顼 */
	PenSet_with_back(ld_gc, 1, TextCol, BackCol);
	gdk_draw_string(widget->window, font, ld_gc, locateX, 15, str);

	/* GC  */
	gdk_gc_destroy(ld_gc);

	return FALSE;
}





/* -------------------------------------------------------------------
 * All on "clicked"
 * 
 */
void layerset_dlg_on_pushed(GtkWidget *widget, LAYERSET_DLG *layerset_dlg)
{
	gint i;


	for (i = 0 ; i < 256 ; i++) {
//		if (Layer[i].data == 1) {
			Layer[i].draw = 1;
			layer_area_draw(layerset_dlg->Layer_widget[i], layerset_dlg);
//		}
	}
	if (sagcad_system.RealTimeLayerSet == 1) Redraw();
}





/* -------------------------------------------------------------------
 * All off "clicked"
 * 
 */
void layerset_dlg_off_pushed(GtkWidget *widget, LAYERSET_DLG *layerset_dlg)
{
	gint i;

	for (i = 0 ; i < 256 ; i++) {
//		if (Layer[i].data == 1) {
			if (i != NowLayer) Layer[i].draw = 0;
			layer_area_draw(layerset_dlg->Layer_widget[i], layerset_dlg);
//		}
	}
	if (sagcad_system.RealTimeLayerSet == 1) Redraw();
}





/* -------------------------------------------------------------------
 * layer_area "button_press_event (ޥå)" ٥ȥϥɥ
 * 
 */
int layer_area_button_press_event(GtkWidget *widget, GdkEventButton *event, LAYERSET_DLG *layerset_dlg)
{
	int layerNo, old;
	char str[256];


	/* widget ͤ */
	layerNo = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget), "value"));


	/* ܥ */
	if (event->button == 1) {
		if (layerNo != NowLayer) {
			if (Layer[layerNo].draw == 1) Layer[layerNo].draw = 0;
			else if (Layer[layerNo].draw == 0) Layer[layerNo].draw = 1;
		}
	}
	/* ܥ */
	else if (event->button == 3) {
		old = NowLayer;
		Layer[old].draw = sagcad_system.LostCurrent;
		
		NowLayer = layerNo;
		Layer[layerNo].draw = 1; 

		/* ƥȥȥ꡼ʸ */
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(layerset_dlg->entry)));
		strcpy(Layer[old].name ,str);


		gtk_entry_set_text(GTK_ENTRY(layerset_dlg->entry), Layer[NowLayer].name);
		sprintf(str,"Layer-%X [ %s ]", NowLayer, Layer[NowLayer].name);
		gtk_label_set(GTK_LABEL(layer), str);

		layer_area_draw(layerset_dlg->Layer_widget[old], layerset_dlg);
	}

	/* ܥ */
//	else if (event->button == 3) ;

	layer_area_draw(layerset_dlg->Layer_widget[layerNo], layerset_dlg);
	
	if (sagcad_system.RealTimeLayerSet == 1) Redraw();
	return TRUE;
}





/* -------------------------------------------------------------------
 * layer_area "expose ()" ٥ȥϥɥ
 * 
 */
gint layer_area_expose_event(GtkWidget *widget, GdkEventExpose *event, LAYERSET_DLG *layerset_dlg)
{
	layer_area_draw(widget, layerset_dlg);
	return FALSE;
}





/* -------------------------------------------------------------------
 * 쥤䡼
 * 
 */
gint LayerSetDialog(LAYERSET_DLG *layerset_dlg)
{
	gint i, x, y, l;
	gchar str[20];
	CAD_LIST *p;
	DIMENSION_LIST *pd;
	POLYLINE_LIST *pld;


//	GtkWidget *dialog;
		GtkWidget *main_vbox;
			GtkWidget *table;
				GtkWidget *layer_area;

			GtkWidget *separator;

			GtkWidget *action_vbox;
				GtkWidget *name_hbox;
					GtkWidget *name_label;
//					GtkWidget *name_entry;
				GtkWidget *sample_table;
					GtkWidget *label;
					GtkWidget *current_draw;
					GtkWidget *on_o_draw;
					GtkWidget *on_x_draw;
					GtkWidget *off_o_draw;
					GtkWidget *off_x_draw;
				GtkWidget *button_hbox;
					GtkWidget *on_buttun;
					GtkWidget *off_buttun;
					GtkWidget *ok_buttun;


	/*  */
	i = 0;
	while (i < 256 ) {
		Layer[i].data = 0;
		i++;
	}
	/* ޷ǡ 1 */
	p = cad_list_info.head;
	while (p != NULL) {
		Layer[p->cad->layer].data = 1;
		p = p->next;
	}
	/* ˡǡ 1 */
	pd = dimension_list_info.head;
	while (pd != NULL) {
		Layer[pd->dimension->Layer].data = 1;
		pd = pd->next;
	}
	/* ݥ饤ǡ 1 */
	pld = polyline_list_info.head;
	while(pld != NULL) {
		Layer[pld->polyline->layer].data = 1;
		pld = pld->next;
	}



	/* (copy_dlg->dialog) (GTK_WIN_POS_MOUSE  GTK_WIN_POS_CENTER) */
	layerset_dlg->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(layerset_dlg->dialog), GTK_WIN_POS_MOUSE);
	gtk_window_set_title(GTK_WINDOW(layerset_dlg->dialog), _("Layer Setting") );
//	gtk_signal_connect( GTK_OBJECT(layerset_dlg->dialog), "key_press_event",
//						GTK_SIGNAL_FUNC(layerset_dlg_key_press_event), layerset_dlg);


		/* ˤޤѥå󥰥ܥå(main_vbox) */
		main_vbox = gtk_vbox_new(0, 2);
		gtk_container_add(GTK_CONTAINER(layerset_dlg->dialog), main_vbox);
		gtk_container_border_width(GTK_CONTAINER(layerset_dlg->dialog), 5);
		gtk_widget_show(main_vbox);


			/* ơ֥륳ƥʺ */
			table = gtk_table_new(16, 16, TRUE);
			gtk_box_pack_start( GTK_BOX(main_vbox), table, TRUE, TRUE, 0);
			gtk_widget_show(table);
			
			for (x = 0 ; x < 16 ; x++) {
				for (y = 0 ; y < 16 ; y++) {
					l = y * 16 + x;
					sprintf(str, "%x", l);

					layer_area = gtk_drawing_area_new();
					layerset_dlg->Layer_widget[l] = layer_area;
					layerset_dlg->layerNo = l;
					/* ɥ󥰥ꥢΥ */
					gtk_drawing_area_size( GTK_DRAWING_AREA(layer_area), 20, 20);
					gtk_table_attach_defaults(GTK_TABLE(table), layer_area, x, x+1, y, y+1);
					gtk_object_set_data(GTK_OBJECT(layer_area), "value", (gpointer)l);

					/* "expose_event" ٥ȥϥɥ */
					gtk_signal_connect(GTK_OBJECT(layer_area), "expose_event",
							   (GtkSignalFunc) layer_area_expose_event, (gpointer)layerset_dlg);
					/* "button_press_event" ٥ȥϥɥ */
					gtk_signal_connect(GTK_OBJECT(layer_area), "button_press_event",
							   (GtkSignalFunc) layer_area_button_press_event, (gpointer)layerset_dlg);
					/* ٥ȥޥ */
					gtk_widget_set_events(layer_area,  GDK_EXPOSURE_MASK
													 | GDK_LEAVE_NOTIFY_MASK
													 | GDK_BUTTON_PRESS_MASK
													 | GDK_POINTER_MOTION_MASK
													 | GDK_POINTER_MOTION_HINT_MASK);
					gtk_widget_show(layer_area);
				}
			}


			/* ѥ졼(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);



			/* ѥå󥰥ܥå(action_vbox) */
			action_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(main_vbox), action_vbox, TRUE, TRUE, 0);
			gtk_widget_show(action_vbox);


				/* ѥå󥰥ܥå(name_hbox) */
				name_hbox = gtk_hbox_new(FALSE, 2);
				gtk_box_pack_start( GTK_BOX(action_vbox), name_hbox, TRUE, TRUE, 0);
				gtk_widget_show(name_hbox);

					/* ٥ (name_label) */
					name_label = gtk_label_new( _("Active Layer Name") );
					//gtk_widget_set_usize (name_label, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(name_hbox), name_label, TRUE, TRUE, 0);
					gtk_label_set_justify(GTK_LABEL(name_label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(name_label);


					/* ƥȥȥ꡼ (name_entry) */
					layerset_dlg->entry = gtk_entry_new();
					//gtk_widget_set_usize (layerset_dlg->entry, 150, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(name_hbox), layerset_dlg->entry, TRUE, TRUE, 1);
					/*  */
					gtk_entry_set_text(GTK_ENTRY(layerset_dlg->entry), Layer[NowLayer].name);
					//gtk_signal_connect (GTK_OBJECT(layerset_dlg->entry), "activate", 
					//					  GTK_SIGNAL_FUNC(entry_callback), NULL);
					gtk_widget_show(layerset_dlg->entry);





				/* ѥ졼(separator) */
				separator = gtk_hseparator_new();
				gtk_box_pack_start( GTK_BOX(action_vbox), separator, TRUE, TRUE, 0);
				gtk_widget_show(separator);


				/* ơ֥ѥå󥰥ܥå(sample_table) */
				sample_table = gtk_table_new(3, 16, TRUE);
				gtk_box_pack_start( GTK_BOX(action_vbox), sample_table, TRUE, TRUE, 0);
				gtk_widget_set_usize (sample_table, 320, 60);
				gtk_widget_show(sample_table);

					/* ȥ쥤䡼Υץ */
					current_draw = gtk_drawing_area_new();
					gtk_drawing_area_size( GTK_DRAWING_AREA(current_draw), 20, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), current_draw, 0, 1, 0, 1);
					gtk_object_set_data(GTK_OBJECT(current_draw), "value", (gpointer)0);
					/* "expose_event" ٥ȥϥɥ */
					gtk_signal_connect(GTK_OBJECT(current_draw), "expose_event",
									   (GtkSignalFunc) sample_table_expose_event, (gpointer)layerset_dlg);
					/* ٥ȥޥ */
					gtk_widget_set_events(layer_area, GDK_EXPOSURE_MASK);
					gtk_widget_show(current_draw);

					/* ٥ (label) */
					label = gtk_label_new( _("Active") );
					gtk_widget_set_usize (label, 140, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), label, 1, 8, 0, 1);
					gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(label);


					/* on_o Υץ */
					on_o_draw = gtk_drawing_area_new();
					gtk_drawing_area_size( GTK_DRAWING_AREA(on_o_draw), 20, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), on_o_draw, 0, 1, 1, 2);
					gtk_object_set_data(GTK_OBJECT(on_o_draw), "value", (gpointer)1);
					/* "expose_event" ٥ȥϥɥ */
					gtk_signal_connect(GTK_OBJECT(on_o_draw), "expose_event",
									   (GtkSignalFunc) sample_table_expose_event, (gpointer)layerset_dlg);
					/* ٥ȥޥ */
					gtk_widget_set_events(on_o_draw, GDK_EXPOSURE_MASK);
					gtk_widget_show(on_o_draw);

					/* ٥ (label) */
					label = gtk_label_new( _("display-on Data-O") );
					gtk_widget_set_usize (label, 140, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), label, 1, 8, 1, 2);
					gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(label);


					/* on_x Υץ */
					on_x_draw = gtk_drawing_area_new();
					gtk_drawing_area_size( GTK_DRAWING_AREA(on_x_draw), 20, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), on_x_draw, 8, 9, 1, 2);
					gtk_object_set_data(GTK_OBJECT(on_x_draw), "value", (gpointer)2);
					/* "expose_event" ٥ȥϥɥ */
					gtk_signal_connect(GTK_OBJECT(on_x_draw), "expose_event",
									   (GtkSignalFunc) sample_table_expose_event, (gpointer)layerset_dlg);
					/* ٥ȥޥ */
					gtk_widget_set_events(on_x_draw, GDK_EXPOSURE_MASK);
					gtk_widget_show(on_x_draw);

					/* ٥ (label) */
					label = gtk_label_new( _("display-on Data-X") );
					gtk_widget_set_usize (label, 140, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), label, 9, 16, 1, 2);
					gtk_widget_show(label);


					/* off_o Υץ */
					off_o_draw = gtk_drawing_area_new();
					gtk_drawing_area_size( GTK_DRAWING_AREA(off_o_draw), 20, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), off_o_draw, 0, 1, 2, 3);
					gtk_object_set_data(GTK_OBJECT(off_o_draw), "value", (gpointer)3);
					/* "expose_event" ٥ȥϥɥ */
					gtk_signal_connect(GTK_OBJECT(off_o_draw), "expose_event",
									   (GtkSignalFunc) sample_table_expose_event, (gpointer)layerset_dlg);
					/* ٥ȥޥ */
					gtk_widget_set_events(off_o_draw, GDK_EXPOSURE_MASK);
					gtk_widget_show(off_o_draw);

					/* ٥ (label) */
					label = gtk_label_new( _("display-off Data-O") );
					gtk_widget_set_usize (label, 140, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), label, 1, 8, 2, 3);
					gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(label);


					/* off_x Υץ */
					off_x_draw = gtk_drawing_area_new();
					gtk_drawing_area_size( GTK_DRAWING_AREA(off_x_draw), 20, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), off_x_draw, 8, 9, 2, 3);
					gtk_object_set_data(GTK_OBJECT(off_x_draw), "value", (gpointer)4);
					/* "expose_event" ٥ȥϥɥ */
					gtk_signal_connect(GTK_OBJECT(off_x_draw), "expose_event",
									   (GtkSignalFunc) sample_table_expose_event, (gpointer)layerset_dlg);
					/* ٥ȥޥ */
					gtk_widget_set_events(off_x_draw, GDK_EXPOSURE_MASK);
					gtk_widget_show(off_x_draw);

					/* ٥ (label) */
					label = gtk_label_new( _("display-off Data-X") );
					gtk_widget_set_usize (label, 140, 20);
					gtk_table_attach_defaults(GTK_TABLE(sample_table), label, 9, 16, 2, 3);
					gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(label);



				/* ѥ졼(separator) */
				separator = gtk_hseparator_new();
				gtk_box_pack_start( GTK_BOX(action_vbox), separator, TRUE, TRUE, 0);
				gtk_widget_show(separator);


				/* ѥå󥰥ܥå(button_hbox) */
				button_hbox = gtk_hbox_new(FALSE, 2);
				gtk_box_pack_start( GTK_BOX(action_vbox), button_hbox, TRUE, TRUE, 0);
				gtk_widget_show(button_hbox);

					/* ON ܥ */
					on_buttun = gtk_button_new_with_label("All on");
					//gtk_widget_set_usize (on_buttun, 80, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(button_hbox), on_buttun, TRUE, TRUE, 2);
					gtk_signal_connect(GTK_OBJECT(on_buttun), "clicked", 
									   GTK_SIGNAL_FUNC(layerset_dlg_on_pushed), /*(gpointer)*/layerset_dlg);
					gtk_widget_show(on_buttun);


					/* OFF ܥ */
					off_buttun = gtk_button_new_with_label("All off");
					//gtk_widget_set_usize (off_buttun, 80, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(button_hbox), off_buttun, TRUE, TRUE, 2);
					gtk_signal_connect(GTK_OBJECT(off_buttun), "clicked", 
									   GTK_SIGNAL_FUNC(layerset_dlg_off_pushed), /*(gpointer)*/layerset_dlg);
					gtk_widget_show(off_buttun);


					/* OKܥ */
					ok_buttun = gtk_button_new_with_label("OK");
					//gtk_widget_set_usize (ok_buttun, 80, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(button_hbox), ok_buttun, TRUE, TRUE, 2);
					gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(layerset_dlg_ok_pushed), layerset_dlg);
					gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
					gtk_widget_show(ok_buttun);



	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(layerset_dlg->dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(layerset_dlg->dialog), GTK_WINDOW(layerset_dlg->parent));


	/* Ļ֤ */
	gtk_widget_show(layerset_dlg->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(layerset_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : LayerSet.c
 * ====================================================================
 */
