/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Block.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/15
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "types.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_insert.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_Undo.h"
#define _LIST_BLOCK_
#include "List_Block.h"





int init_block(BLOCK *block)
{
	strcpy(block->name, "noname");
	block->layer = 0;

	block->cad_list_info.head = NULL;
	block->cad_list_info.tail = NULL;

	block->dimension_list_info.head = NULL;
	block->dimension_list_info.tail = NULL;

	block->polyline_list_info.head = NULL;
	block->polyline_list_info.tail = NULL;

	block->ellipse_list_info.head = NULL;
	block->ellipse_list_info.tail = NULL;

	block->insert_list_info.head = NULL;
	block->insert_list_info.tail = NULL;

	return 1;
}





/* -------------------------------------------------------------------
 * BLOCK Data ꥹȤκǽɲ
 *	
 * ǡ (CAD DIMENSION TEXT POLYLINE) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
BLOCK_LIST *r_block_list_add_first(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	/* ǡ (LIST) 񤭹िΰݤ */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* ݤΰ˥ǡ (block) 񤭹 */
	p_block_list->block = add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_block_list_info->head;
		p_block_list_info->head = p_block_list;
		p_block_list->next = p;
	}

	return p_block_list_info->head;
}





/* -------------------------------------------------------------------
 * BLOCK Data ꥹȤκǽɲ
 *	
 */
BLOCK_LIST *block_list_add_first(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	/* ǡ (LIST) 񤭹िΰݤ */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* ǡ (block) 񤭹िΰݤ */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* vertex ΰϡ */
	/* ǡ (vertex) 񤭹िΰݤ */
//	p_block_list->block->vertex = (VERTEX *)xmalloc(add_block->block->index * sizeof(VERTEX));

	/* ݤΰ˥ǡ (block) 񤭹 */
	*p_block_list->block = *add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_block_list_info->head;
		p_block_list_info->head = p_block_list;
		p_block_list->next = p;
	}

	return p_block_list_info->head;
}



/* ---------------------------------------------------------
 * BLOCK Data ꥹȤκǽɲäơ Undo Baffer ˽
 *	
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
BLOCK_LIST *block_list_add_first_with_undo(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	BLOCK block = {"",0,{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* ǡ (block) 񤭹िΰݤ */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* ǡ (AssistLine) 񤭹िΰݤ */
//	p_block_list->block->AssistLine = (ASSISTANCE *)xmalloc(add_block->index * sizeof(ASSISTANCE));

	/* ݤΰ˥ǡ (block) 񤭹 */
	*p_block_list->block = *add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_block_list_info->head;
		p_block_list_info->head = p_block_list;
		p_block_list->next = p;
	}


	lpdiagram.block_point = p_block_list_info->head->block;
	diagram.block = block;

	/* Undo Buffa Write */
	undo_list_add_first(BLOCK_NEW, lpdiagram, diagram);
	return p_block_list_info->head;
}





/* -------------------------------------------------------------------
 * BLOCK Data ꥹȤκǸɲ
 *	
 */
BLOCK_LIST *block_list_add_last(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	/* ǡ (LIST) 񤭹िΰݤ */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* ǡ (block) 񤭹िΰݤ */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* vertex ΰϡ */
	/* ǡ (vertex) 񤭹िΰݤ */
//	p_block_list->block->vertex = (VERTEX *)xmalloc(add_block->block->index * sizeof(VERTEX));

	/* ݤΰ˥ǡ (block) 񤭹 */
	*p_block_list->block = *add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_block_list_info->head != NULL 
				&& p_block_list_info->tail != NULL 
					&& p_block_list_info->head == p_block_list_info->tail) {
		p_block_list_info->head->next = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_block_list_info->tail;
		p_block_list_info->tail = p_block_list;
		p->next = p_block_list_info->tail;
	}

	/* ɥХåե˽ */
//	undo_list_add_first(11, p_block_list_info->tail, NULL);
	return p_block_list_info->tail;
}





/* ---------------------------------------------------------
 * BLOCK Data ꥹȤκǸɲá Undo Baffer ˽
 *	
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
BLOCK_LIST *block_list_add_last_with_undo(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	BLOCK block = {"",0,{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* ǡ (block) 񤭹िΰݤ */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* ǡ (AssistLine) 񤭹िΰݤ */
//	p_block_list->block->AssistLine = (ASSISTANCE *)xmalloc(add_block->index * sizeof(ASSISTANCE));

	/* ݤΰ˥ǡ (block) 񤭹 */
	*p_block_list->block = *add_block;
	p_block_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_block_list_info->head == NULL && p_block_list_info->tail == NULL) {
		p_block_list_info->head = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_block_list_info->head != NULL 
				&& p_block_list_info->tail != NULL 
					&& p_block_list_info->head == p_block_list_info->tail) {
		p_block_list_info->head->next = p_block_list;
		p_block_list_info->tail = p_block_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_block_list_info->tail;
		p_block_list_info->tail = p_block_list;
		p->next = p_block_list_info->tail;
	}


	lpdiagram.block_point = p_block_list_info->tail->block;
	diagram.block = block;

	/* Undo Buffa Write */
	undo_list_add_first(BLOCK_NEW, lpdiagram, diagram);
	return p_block_list_info->tail;
}





/* -------------------------------------------------------------------
 * BLOCK Data κǽ (κǤϤʤ)
 * 
 */
int block_list_delete(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p = NULL;
	BLOCK_LIST *pb = NULL;
	long i;

	/* -------------------------------------------
	 * ݥ󥿤ΥǡΤꤿΤǡ
	 * head (ꥹȤƬ) ݥ󥿤
	 * ĤޤǷ֤Υǡõ
	 */
	p = p_block_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL && p != del_List) {
		if (i == 0) i++;
		pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}


	/* Ĥä (p  NULL ǤϤʤȤ) */
	if(p != NULL){
		/* ƬΥǡ (i = 0 ΤȤ) */
		if (i == 0) {
			/* ƬΥǡĤʤ(ΥǡΥݥ󥿤 NULL) */
			if (p->next == NULL) {
				p_block_list_info->head = NULL;
				p_block_list_info->tail = NULL;
			}
			/* İʾǡȤ */
			else 
				p_block_list_info->head = p->next;
		}

		/* ǸΥǡΤȤ (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* ֤Υǡ (ξʳ) */
		else pb->next = p->next;
		block_list_free(del_List, p_block_list_info);
		return 1;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * BLOCK Data κǽ (κǤϤʤUndo Buffer ذܤ)
 * 
 */
int block_list_delete_Undo(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p = NULL;
	BLOCK_LIST *pb = NULL;
	long i;

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* -------------------------------------------
	 * ݥ󥿤ΥǡΤꤿΤǡ
	 * head (ꥹȤƬ) ݥ󥿤
	 * ĤޤǷ֤Υǡõ
	 */
	p = p_block_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL && p != del_List) {
		i++;
		pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}


	/* Ĥä (p  NULL ǤϤʤȤ) */
	if(p != NULL){
		/* ƬΥǡ (i = 0 ΤȤ) */
		if (i == 0) {
			/* ƬΥǡĤʤ(ΥǡΥݥ󥿤 NULL) */
			if (p->next == NULL) {
				p_block_list_info->head = NULL;
				p_block_list_info->tail = NULL;
			}
			/* İʾǡȤ */
			else 
				p_block_list_info->head = p->next;
		}

		/* ǸΥǡΤȤ (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* ֤Υǡ (ξʳ) */
		else pb->next = p->next;

		lpdiagram.block_point = del_List->block;
		diagram.block = *del_List->block;

		undo_list_add_first(BLOCK_DEL, lpdiagram, diagram);
		block_list_free(del_List, p_block_list_info);
		return 1;
	}
	return 0;
}





/* ---------------------------------------------------------
 * BLOCK Υݥ󥿤Υǡ Undo ХåեԽˤơ
 * ξ˿ǡ롣
 * 
 * ͡ΥǡΥɥ쥹
 * 
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
BLOCK_LIST *block_list_edit(BLOCK_LIST *point, BLOCK *change_block, BLOCK_LIST_INFO *p_block_list_info)
{
	/* ǡ (LIST) 񤭹िΰݤ */
	p_block_list = (BLOCK_LIST *)xmalloc(sizeof(BLOCK_LIST));

	/* ǡ (block) 񤭹िΰݤ */
	p_block_list->block = (BLOCK *)xmalloc(sizeof(BLOCK));

	/* ǡ (AssistLine) 񤭹िΰݤ */
//	p_block_list->block->AssistLine = (ASSISTANCE *)xmalloc(change_block->index * sizeof(ASSISTANCE));

	/* ݤΰѹΥǡ (block) 񤭹 */
	*p_block_list->block = *point->block;
//	p_block_list->next = point;

	/* ѹǡ񤭹 */
	*point->block = *change_block;

//	undo_list_add_first(13, p_block_list, NULL);
	return p_block_list;
}





/* ---------------------------------------------------------
 * BLOCK ѹΥǡ(point) Undo ХåեԽˤơ
 * ξ˿ǡ(change_block)졢Undo Baffer ˽
 *	
 * ͡ΥǡΥɥ쥹
 *	
 * ǡ (AssistLine) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
BLOCK_LIST *block_list_edit_with_undo(BLOCK_LIST *point, BLOCK *change_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK block = {"",0,{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL},{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ݤΰѹΥǡ (BLOCK) 񤭹 */
	block = *point->block;

	/* ѹǡ񤭹 */
	*point->block = *change_block;


	lpdiagram.block_point = point->block;
	diagram.block = block;

	undo_list_add_first(BLOCK_EDIT, lpdiagram, diagram);
	return point;
}





/* -------------------------------------------------------------------
 * ꥹȤĴ٤
 */
long block_list_num(BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	long i;

	p = p_block_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n ܤΥǡθ
 *	
 */
BLOCK_LIST *block_search_num(long search_number, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	long i;

	p = p_block_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n ܤΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * BLOCK Υǡθ
 *	
 *   BLOCK_LIST
 */
BLOCK_LIST *block_search_block(BLOCK *p_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	p = p_block_list_info->head;
	/*	*/
	while( p != NULL && p->block != p_block) {
		p = p->next;
	}

	/* p_block ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * BLOCK Υǡθ (name)
 *	
 *   BLOCK_LIST
 */
BLOCK_LIST *block_search_block_name(char *name, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;

	p = p_block_list_info->head;
	/*	*/
	while( p != NULL) {
		if (strstr(p->block->name, name) != NULL ) {
			break;
		}
		p = p->next;
	}

	/* p_block ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * BLOCK Υǡθ
 *	
 *   long
 */
long block_search_block_to_num(BLOCK *p_block, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	long i;

	i = 1;
	p = p_block_list_info->head;
	/*	*/
	while( p != NULL && p->block != p_block) {
		p = p->next;
		i++;
	}

	/* p_block ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return i;
	}
	/* ޤǥǡʤ */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 * BLOCK Data ꥹȤ
 */
int block_list_free(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p = NULL;
	BLOCK_LIST *pb = NULL;


	/* ǡƬǣĤ  */
	if (del_List == p_block_list_info->head && del_List->next == NULL) {
		p_block_list_info->head = NULL;
		p_block_list_info->tail = NULL;
		//g_print("ǡƬǣĤ\n");
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_block_list_info->head && del_List->next != NULL) {
		p_block_list_info->head = p_block_list_info->head->next;
		//g_print("ǡƬǣİʾ\n");
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_block_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}


		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_block_list_info->tail) {
				pb->next = NULL;
				p_block_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_block_list_info->head && del_List != p_block_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			//g_print("ꥹȤ BLOCK ǡǤϤʤ\n");
			return 0;
		}
	}

	cad_list_all_free(&del_List->block->cad_list_info);
	dimension_list_all_free(&del_List->block->dimension_list_info);
	polyline_list_all_free(&del_List->block->polyline_list_info);
	insert_list_all_free(&del_List->block->insert_list_info);
	ellipse_list_all_free(&del_List->block->ellipse_list_info);

	xfree(del_List->block);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 * ꥹȤ
 */
void block_list_all_free(BLOCK_LIST_INFO *p_block_list_info)
{
	while (p_block_list_info->head != NULL) {
		block_list_free(p_block_list_info->head, p_block_list_info);
	}
}





/* ---------------------------------------------------------
 * BLOCK_LIST Υǡ log
 *	
 */
void block_list_log(BLOCK_LIST_INFO *p_block_list_info)
{
	BLOCK_LIST *p;
	long i = 0;


	g_print("----- BLOCK ꥹȤɽ -----\n");
	p = p_block_list_info->head;
	while( p != NULL) {
		i++;
		g_print("%d : NAME [%s] : BLOCK adress = [%x] : Layer [%d]\n", (int)i, p->block->name, (int)p->block, p->block->layer);

		g_print("  CAD Data -> %d\n", (int)cad_list_num(&p->block->cad_list_info));
		cad_list_print(&p->block->cad_list_info);

		g_print("  DIMENSION Data -> %d\n", (int)dimension_list_num(&p->block->dimension_list_info));

		g_print("  POLYLINE Data -> %d\n", (int)polyline_list_num(&p->block->polyline_list_info));
		polyline_list_log(&p->block->polyline_list_info);

		g_print("  INSERT Data -> %d\n", (int)insert_list_num(&p->block->insert_list_info));
		g_print("  ELLIPSE Data -> %d\n", (int)ellipse_list_num(&p->block->ellipse_list_info));

		p = p->next;
	}
	g_print("-------------------------------\n");
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Block.c
 * ====================================================================
 */

