/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_polyline.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/05
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "types.h"
#include "List_Vertex.h"
#include "List_Undo.h"
#define _LIST_POLYLINE_
#include "List_PolyLine.h"





int init_polyline(POLYLINE *polyline)
{
	polyline->layer = 0;
	/* -------------------------------------------
	 *	8  : ݥ饤
	 * 16  : ץ饤
	 * 32  : ¥ץ饤
	 *(64) : ٥
	 */
	polyline->code = 1;
	/*  */
	polyline->style = 1;
	/*  */
	polyline->color = 0xffffff;
	/* ʬ */
	polyline->split = 7;
	/* ԥå */
	polyline->pitch = 0.05;
	/* ե饰 */
	polyline->frag = 0;
	/* ĺο */
	polyline->index = 0;
	/* ĺΥǡ */
	polyline->vertex_list_info.head = NULL;
	polyline->vertex_list_info.tail = NULL;
	return 1;
}





/* -------------------------------------------------------------------
 * POLYLINE Data ꥹȤκǽɲ
 *	
 * ǡ (vertex) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
POLYLINE_LIST *r_polyline_list_add_first(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;

	/* ǡ (LIST) 񤭹िΰݤ */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* ݤΰ˥ǡ (polyline) 񤭹 */
	p_polyline_list->polyline = add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_polyline_list_info->head;
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list->next = p;
	}

	return p_polyline_list_info->head;
}





/* -------------------------------------------------------------------
 * POLYLINE Data ꥹȤκǽɲ
 * 
 * ǡ (vertex) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
POLYLINE_LIST *polyline_list_add_first(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;

	/* ǡ (LIST) 񤭹िΰݤ */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* ǡ (polyline) 񤭹िΰݤ */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* ݤΰ˥ǡ (polyline) 񤭹 */
	*p_polyline_list->polyline = *add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_polyline_list_info->head;
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list->next = p;
	}

	return p_polyline_list_info->head;
}





/* ---------------------------------------------------------
 * POLYLINE Data ꥹȤκǽɲäơ Undo Baffer ˽
 *	
 * ǡ (vertex) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
POLYLINE_LIST *polyline_list_add_first_with_undo(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	POLYLINE polyline = {0,0,0,0,0,0,0,0,{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* ǡ (polyline) 񤭹िΰݤ */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* ݤΰ˥ǡ (polyline) 񤭹 */
	*p_polyline_list->polyline = *add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_polyline_list_info->head;
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list->next = p;
	}


	lpdiagram.polyline_point = p_polyline_list_info->head->polyline;
	diagram.polyline = polyline;

	/* Undo Buffa Write */
	undo_list_add_first(POLYLINE_NEW, lpdiagram, diagram);
	return p_polyline_list_info->head;
}





/* -------------------------------------------------------------------
 * POLYLINE Data ꥹȤκǸɲ
 * 
 * ǡ (vertex) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
POLYLINE_LIST *polyline_list_add_last(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* ǡ (polyline) 񤭹िΰݤ */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* ݤΰ˥ǡ (polyline) 񤭹 */
	*p_polyline_list->polyline = *add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_polyline_list_info->head != NULL 
				&& p_polyline_list_info->tail != NULL 
					&& p_polyline_list_info->head == p_polyline_list_info->tail) {
		p_polyline_list_info->head->next = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_polyline_list_info->tail;
		p_polyline_list_info->tail = p_polyline_list;
		p->next = p_polyline_list_info->tail;
	}

	/* ɥХåե˽ */
//	undo_list_add_first(11, p_polyline_list_info->tail, NULL);
	return p_polyline_list_info->tail;
}





/* ---------------------------------------------------------
 * POLYLINE Data ꥹȤκǸɲá Undo Baffer ˽
 *	
 * ǡ (vertex) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
POLYLINE_LIST *polyline_list_add_last_with_undo(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	POLYLINE polyline = {0,0,0,0,0,0,0,0,{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* ǡ (polyline) 񤭹िΰݤ */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* ݤΰ˥ǡ (polyline) 񤭹 */
	*p_polyline_list->polyline = *add_polyline;
	p_polyline_list->next = NULL;


	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (p_polyline_list_info->head == NULL && p_polyline_list_info->tail == NULL) {
		p_polyline_list_info->head = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (p_polyline_list_info->head != NULL 
				&& p_polyline_list_info->tail != NULL 
					&& p_polyline_list_info->head == p_polyline_list_info->tail) {
		p_polyline_list_info->head->next = p_polyline_list;
		p_polyline_list_info->tail = p_polyline_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = p_polyline_list_info->tail;
		p_polyline_list_info->tail = p_polyline_list;
		p->next = p_polyline_list_info->tail;
	}


	lpdiagram.polyline_point = p_polyline_list_info->tail->polyline;
	diagram.polyline = polyline;

	/* Undo Buffa Write */
	undo_list_add_first(POLYLINE_NEW, lpdiagram, diagram);
	return p_polyline_list_info->tail;
}





/* -------------------------------------------------------------------
 * POLYLINE Data κǽ (κǤϤʤ)
 * 
 */
int polyline_list_delete(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p = NULL;
	POLYLINE_LIST *pb = NULL;
	long i;

	/* -------------------------------------------
	 * ݥ󥿤ΥǡΤꤿΤǡ
	 * head (ꥹȤƬ) ݥ󥿤
	 * ĤޤǷ֤Υǡõ
	 */
	p = p_polyline_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL && p != del_List) {
		if (i == 0) i++;
		pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}


	/* Ĥä (p  NULL ǤϤʤȤ) */
	if(p != NULL){
		/* ƬΥǡ (i = 0 ΤȤ) */
		if (i == 0) {
			/* ƬΥǡĤʤ(ΥǡΥݥ󥿤 NULL) */
			if (p->next == NULL) {
				p_polyline_list_info->head = NULL;
				p_polyline_list_info->tail = NULL;
			}
			/* İʾǡȤ */
			else 
				p_polyline_list_info->head = p->next;
		}

		/* ǸΥǡΤȤ (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* ֤Υǡ (ξʳ) */
		else pb->next = p->next;
		polyline_list_free(del_List, p_polyline_list_info);
		return 1;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * POLYLINE Data κǽ (κǤϤʤUndo Buffer ذܤ)
 * 
 */
int polyline_list_delete_Undo(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p = NULL;
	POLYLINE_LIST *pb = NULL;
	long i;

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* -------------------------------------------
	 * ݥ󥿤ΥǡΤꤿΤǡ
	 * head (ꥹȤƬ) ݥ󥿤
	 * ĤޤǷ֤Υǡõ
	 */
	p = p_polyline_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL && p != del_List) {
		i++;
		pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}


	/* Ĥä (p  NULL ǤϤʤȤ) */
	if(p != NULL){
		/* ƬΥǡ (i = 0 ΤȤ) */
		if (i == 0) {
			/* ƬΥǡĤʤ(ΥǡΥݥ󥿤 NULL) */
			if (p->next == NULL) {
				p_polyline_list_info->head = NULL;
				p_polyline_list_info->tail = NULL;
			}
			/* İʾǡȤ */
			else 
				p_polyline_list_info->head = p->next;
		}

		/* ǸΥǡΤȤ (p->next = NULL) */
		else if (p->next == NULL) pb->next = NULL;

		/* ֤Υǡ (ξʳ) */
		else pb->next = p->next;

		lpdiagram.polyline_point = del_List->polyline;
		diagram.polyline = *del_List->polyline;

		undo_list_add_first(POLYLINE_DEL, lpdiagram, diagram);
		xfree(del_List);
//		polyline_list_free(del_List);
		return 1;
	}
	return 0;
}





/* ---------------------------------------------------------
 * POLYLINE Υݥ󥿤Υǡ Undo ХåեԽˤơ
 * ξ˿ǡ롣
 * 
 * ͡ΥǡΥɥ쥹
 * 
 * ǡ (vertex) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
POLYLINE_LIST *polyline_list_edit(POLYLINE_LIST *point, POLYLINE *change_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	/* ǡ (LIST) 񤭹िΰݤ */
	p_polyline_list = (POLYLINE_LIST *)xmalloc(sizeof(POLYLINE_LIST));

	/* ǡ (polyline) 񤭹िΰݤ */
	p_polyline_list->polyline = (POLYLINE *)xmalloc(sizeof(POLYLINE));

	/* ݤΰѹΥǡ (polyline) 񤭹 */
	*p_polyline_list->polyline = *point->polyline;
//	p_polyline_list->next = point;

	/* ѹǡ񤭹 */
	*point->polyline = *change_polyline;

//	undo_list_add_first(13, p_polyline_list, NULL);
	return p_polyline_list;
}





/* ---------------------------------------------------------
 * POLYLINE ѹΥǡ(point) Undo ХåեԽˤơ
 * ξ˿ǡ(change_polyline)졢Undo Baffer ˽
 *	
 * ͡ΥǡΥɥ쥹
 *	
 * ǡ (vertex) 񤭹िΰϡ
 * ݤƤΤǲƳݤɬפʤ
 */
POLYLINE_LIST *polyline_list_edit_with_undo(POLYLINE_LIST *point, POLYLINE *change_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE polyline = {0,0,0,0,0,0,0,0,{NULL,NULL}};

	DIAGRAM diagram;
	LPDIAGRAM lpdiagram;


	/* ݤΰѹΥǡ (POLYLINE) 񤭹 */
	polyline = *point->polyline;

	/* ѹǡ񤭹 */
	*point->polyline = *change_polyline;


	lpdiagram.polyline_point = point->polyline;
	diagram.polyline = polyline;

	undo_list_add_first(POLYLINE_EDIT, lpdiagram, diagram);
	return point;
}





/* -------------------------------------------------------------------
 * ꥹȤĴ٤
 */
long polyline_list_num(POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	long i;

	p = p_polyline_list_info->head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n ܤΥǡθ
 *	
 */
POLYLINE_LIST *polyline_search_num(long search_number, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	long i;

	p = p_polyline_list_info->head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n ܤΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * POLYLINE Υǡθ
 *	
 *   POLYLINE_LIST
 */
POLYLINE_LIST *polyline_search_polyline(POLYLINE *p_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;

	p = p_polyline_list_info->head;
	/*	*/
	while( p != NULL && p->polyline != p_polyline) {
		p = p->next;
	}

	/* p_polyline ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * POLYLINE Υǡθ
 *	
 *   long
 */
long polyline_search_polyline_to_num(POLYLINE *p_polyline, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p;
	long i;

	i = 1;
	p = p_polyline_list_info->head;
	/*	*/
	while( p != NULL && p->polyline != p_polyline) {
		p = p->next;
		i++;
	}

	/* p_polyline ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return i;
	}
	/* ޤǥǡʤ */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 * POLYLINE Data ꥹȤ
 */
int polyline_list_free(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info)
{
	POLYLINE_LIST *p = NULL;
	POLYLINE_LIST *pb = NULL;


	if (del_List == PolyLineStartData) {
		PolyLineStartData = NULL;
		//g_print ("List_PolyLine.c : polyline_list_free() : del_List = PolyLineStartData\n");
	}

	/* ǡƬǣĤ  */
	if (del_List == p_polyline_list_info->head && del_List->next == NULL) {
		p_polyline_list_info->head = NULL;
		p_polyline_list_info->tail = NULL;
		//g_print("ǡƬǣĤ\n");
	}
	/* ǡƬǣİʾ  */
	else if (del_List == p_polyline_list_info->head && del_List->next != NULL) {
		p_polyline_list_info->head = p_polyline_list_info->head->next;
		//g_print("ǡƬǣİʾ\n");
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = p_polyline_list_info->head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}


		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == p_polyline_list_info->tail) {
				pb->next = NULL;
				p_polyline_list_info->tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != p_polyline_list_info->head && del_List != p_polyline_list_info->tail) {
				pb->next = p->next;
			}
		}
		else {
			//g_print("ꥹȤ POLYLINE ǡǤϤʤ\n");
			return 0;
		}
	}
	vertex_list_all_free(&del_List->polyline->vertex_list_info);
//	xfree(del_List->polyline->vertex);
	xfree(del_List->polyline);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 * ꥹȤ
 */
void polyline_list_all_free(POLYLINE_LIST_INFO *p_polyline_list_info)
{
	while (p_polyline_list_info->head != NULL) {
		polyline_list_free(p_polyline_list_info->head, p_polyline_list_info);
	}
}





/* ---------------------------------------------------------
 * POLYLINE_LIST Υǡ log
 *	
 */
void polyline_list_log(POLYLINE_LIST_INFO *p_polyline_list_info)
{
#ifdef TEST
	int j = 0;
	VERTEX_LIST *v;
#endif
	POLYLINE_LIST *p;
	long i = 0;

	g_print("----- POLYLINE ꥹȤɽ -----\n");
	p = p_polyline_list_info->head;
	while( p != NULL) {
		i++;
		g_print("POLYLINE LIST %d : POLYLINE adress = [%x]\n", (int)i, (int)p->polyline);
		g_print("layer [%d]  code [%d]  style [%d]  color [0x%x]  split [%d]  pitch [%f]  index [%d]\n", 
				p->polyline->layer, p->polyline->code, 
				p->polyline->style, (int)p->polyline->color, 
				p->polyline->split, p->polyline->pitch, 
				(int) vertex_list_num(&p->polyline->vertex_list_info) );

		vertex_list_print(&p->polyline->vertex_list_info);

		p = p->next;
	}
	g_print("-------------------------------\n");
}



/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_polyline.c
 * ====================================================================
 */
