/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_cam.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <stdlib.h>
#include "MemoryLeak.h"
#include "etc.h"
#define _LIST_CAM_
#include "List_cam.h"





/* -------------------------------------------------------------------
 * CAM Data ꥹȤκǽɲ
 * 
 */
CAM_LIST *cam_list_add_first(CAM *add_cam)
{
	CAM_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_cam_list = (CAM_LIST *)xmalloc(sizeof(CAM_LIST));
	/* ǡ (cam) 񤭹िΰݤ */
	p_cam_list->cam = (CAM *)xmalloc(sizeof(CAM));
	/* ݤΰ˥ǡ (cam) 񤭹 */
	*p_cam_list->cam = *add_cam;
	p_cam_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (cam_list_info.head == NULL && cam_list_info.tail == NULL) {
		cam_list_info.head = p_cam_list;
		cam_list_info.tail = p_cam_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = cam_list_info.head;
		cam_list_info.head = p_cam_list;
		p_cam_list->next = p;
	}

	return cam_list_info.head;
}





/* -------------------------------------------------------------------
 * CAM Data ꥹȤκǸɲ
 * 
 */
CAM_LIST *cam_list_add_last(CAM *add_cam)
{
	CAM_LIST *p;


	/* ǡ (LIST) 񤭹िΰݤ */
	p_cam_list = (CAM_LIST *)xmalloc(sizeof(CAM_LIST));
	/* ǡ (cam) 񤭹िΰݤ */
	p_cam_list->cam = (CAM *)xmalloc(sizeof(CAM));
	/* ݤΰ˥ǡ (cam) 񤭹 */
	*p_cam_list->cam = *add_cam;
	p_cam_list->next = NULL;

	/* -----------------------------------------------------
	 * head & tail ξ NULL ΤȤϡĤǡʤ 
	 */
	if (cam_list_info.head == NULL && cam_list_info.tail == NULL) {
		cam_list_info.head = p_cam_list;
		cam_list_info.tail = p_cam_list;
	}

	/* -----------------------------------------------------
	 * head = tail  NULL ǤϤʤȤϡĤǡ
	 */
	else if (cam_list_info.head != NULL 
				&& cam_list_info.tail != NULL 
					&& cam_list_info.head == cam_list_info.tail) {
		cam_list_info.head->next = p_cam_list;
		cam_list_info.tail = p_cam_list;
	}

	/* -----------------------------------------------------
	 * ǡİʾ夢
	 */
	else {
		p = cam_list_info.tail;
		cam_list_info.tail = p_cam_list;
		p->next = cam_list_info.tail;
	}

	/* ɥХåե˽ */
//	undo_list_add_first(11, cam_list_info.tail, NULL);
	return cam_list_info.tail;
}





/* -------------------------------------------------------------------
 * ꥹȤĴ٤
 */
long cam_list_num(void)
{
	CAM_LIST *p;
	long i;

	p = cam_list_info.head;
	i = 0;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL) {
		i++;
		p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
	}
	return i;
}





/* -------------------------------------------------------------------
 * n ܤΥǡθ
 * 
 */
CAM_LIST *cam_search_num(long search_number)
{
	CAM_LIST *p;
	long i;

	p = cam_list_info.head;
	i = 1;
	/*	*/
	while( p != NULL && i != search_number) {
		i++;
		p = p->next;
	}

	/* n ܤΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * CAM Υǡθ
 * 
 *   CAM_LIST
 */
CAM_LIST *cam_search_cam(CAM *p_cam)
{
	CAM_LIST *p;

	p = cam_list_info.head;
	/*	*/
	while( p != NULL && p->cam != p_cam) {
		p = p->next;
	}

	/* p_cam ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return p;
	}
	/* ޤǥǡʤ */
	else {
		return NULL;
	}
}





/* -------------------------------------------------------------------
 * CAM Υǡθ
 * 
 *   long
 */
long cam_search_cam_to_num(CAM *p_cam)
{
	CAM_LIST *p;
	long i;

	i = 1;
	p = cam_list_info.head;
	/*	*/
	while( p != NULL && p->cam != p_cam) {
		p = p->next;
		i++;
	}

	/* p_cam ΥǡΥɥ쥹֤ */
	if (p != NULL) {
		return i;
	}
	/* ޤǥǡʤ */
	else {
		return 0;
	}
}





/* -------------------------------------------------------------------
 *	CAM Data ꥹȤ
 */
int cam_list_free(CAM_LIST *del_List)
{
	CAM_LIST *p;
	CAM_LIST *pb = NULL;


	/* ǡƬǣĤ  */
	if (del_List == cam_list_info.head && del_List->next == NULL) {
		cam_list_info.head = NULL;
		cam_list_info.tail = NULL;
		//g_print("ǡƬǣĤ\n");
	}
	/* ǡƬǣİʾ  */
	else if (del_List == cam_list_info.head && del_List->next != NULL) {
		cam_list_info.head = cam_list_info.head->next;
		//g_print("ǡƬǣİʾ\n");
	}
	else {
		/* -------------------------------------------
		 * ݥ󥿤ΥǡΤꤿΤǡ
		 * head (ꥹȤƬ) ݥ󥿤
		 * ĤޤǷ֤Υǡõ
		 */
		p = cam_list_info.head;
		/* -------------------------------------------
		 * ǸޤǸĤʤ硢 p  NULL  
		 * äƥ롼פȴ롣
		 */
		while(p != NULL && p != del_List) {
			pb = p;			/* ΥǡΥݥ󥿤Ȥ¸Ƥ */
			p = p->next;	/* ݥ󥿤򼡤Υǡ˰ܤ */
		}


		if(p != NULL){
			/* ǸΥǡ */
			if (del_List == cam_list_info.tail) {
				pb->next = NULL;
				cam_list_info.tail = pb;
			}
			/* ֤Υǡ */
			else if (del_List != cam_list_info.head && del_List != cam_list_info.tail) {
				pb->next = p->next;
			}
		}
		else {
			//g_print("ꥹȤ CAM ǡǤϤʤ\n");
			return 0;
		}
	}
	xfree(del_List->cam);
	xfree(del_List);
	return 1;
}





/* -------------------------------------------------------------------
 * ꥹȤ
 */
void cam_list_all_free(void)
{
	while(cam_list_info.head != NULL) {
		cam_list_free(cam_list_info.head);
	}
}





/* ---------------------------------------------------------
 * CAM_LIST Υǡ log
 *	
 */
void cam_list_log(void)
{
	CAM_LIST *p;
	long i = 0;
	char str[256];

	sprintf(str, "----- CAM ꥹȤɽ -----\n");
	OneShotLog(str);
	p = cam_list_info.head;
	while( p != NULL) {
		i++;
		sprintf(str, "CAM LIST %d : CAM adress = [%x]   gcode = [%d]\n", (int)i, (int)p->cam, p->cam->gcode);
		OneShotLog(str);
		sprintf(str, "            : sx = [%f]   sy = [%f]   ex = [%f]   ey = [%f]\n", p->cam->sx, p->cam->sy, p->cam->ex, p->cam->ey);
		OneShotLog(str);
		p = p->next;
	}
	sprintf(str, "-------------------------------\n");
	OneShotLog(str);
}



/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_cam.c
 * ====================================================================
 */
